<?php
/**
 * Template part for displaying a 404 page.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 */
?>

<?php 
$search_bar_switch = \KeyDesign\Utils::get_option( 'error_search_bar' );
keydesign_entry_before(); ?>

<section class="block block-error-404">

    <?php keydesign_entry_top(); ?>

    <div class="container">
        <div class="content">

            <h1 id="content"><?php esc_html_e( '404', 'landpress' ); ?></h1>
            <h3 aria-hidden="true"><?php echo apply_filters( '404_page_title_hook', esc_html__( 'Page not found.', 'landpress' ) ); ?></h3>
            <p><?php echo apply_filters( '404_page_subtitle_hook', __( 'The reason might be mistyped or expired URL.<br /> Try searching for something else.', 'landpress' ) ); ?></p>

            <?php if ( $search_bar_switch ) : ?>
                <div class="search-container">
                    <?php the_widget( 'WP_Widget_Search' ); ?>
                </div>
            <?php endif; ?>


        </div>
    </div>

    <?php keydesign_entry_bottom(); ?>

</section>

<?php keydesign_entry_after(); ?>
