<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 */

defined( 'ABSPATH' ) || exit;

get_header();

$is_elementor_theme_exist = function_exists( 'elementor_theme_do_location' );

if ( is_singular() ) {
    if ( ! $is_elementor_theme_exist || ! elementor_theme_do_location( 'single' ) ) {
        if ( is_single() ) {
            keydesign_content_top();
            ?>
            <div id="primary" <?php keydesign_primary_class(); ?> data-attr="single-post">
                <?php
                    keydesign_content_primary_top();
                    keydesign_content_single();
                    keydesign_content_primary_bottom();
                ?>
            </div><!-- #primary -->
            <?php
            get_sidebar();
            keydesign_content_bottom();
        } elseif ( is_page() ) {
            keydesign_content_top();
            ?>
            <div id="primary" <?php keydesign_primary_class(); ?> data-attr="single-page">
                <?php
                    keydesign_content_primary_top();
                    keydesign_content_page();
                    keydesign_content_primary_bottom();
                ?>
            </div><!-- #primary -->
            <?php
            keydesign_content_bottom();
        }
    }

} elseif ( is_archive() || is_home() || is_search() ) {
    if ( ! $is_elementor_theme_exist || ! elementor_theme_do_location( 'archive' ) ) {
        keydesign_content_top();
        ?>
        <div id="primary" <?php keydesign_primary_class(); ?>>
            <?php
                keydesign_content_primary_top();
                keydesign_content_loop();
                the_posts_pagination();
                keydesign_content_primary_bottom();
            ?>
        </div><!-- #primary -->

        <?php get_sidebar();
        keydesign_content_bottom();
    }

} else {
    if ( ! $is_elementor_theme_exist || ! elementor_theme_do_location( 'single' ) ) {
        keydesign_content_top();
        ?>
        <div id="primary" <?php keydesign_primary_class(); ?>>
            <?php
                keydesign_content_primary_top();
                keydesign_content_404_page();
                keydesign_content_primary_bottom();
            ?>
        </div><!-- #primary -->
        <?php
        keydesign_content_bottom();
    }
}

get_footer();