<?php
namespace KeyDesign\Compatibility;
use KeyDesign\Utils;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class KeyDesign_WooCommerce {

	private static $instance;

	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	public function __construct() {

		add_action( 'wp_enqueue_scripts', function () {
			wp_enqueue_style(
				'keydesign-woocommerce',
				KEYDESIGN_ASSETS_URL . 'css/keydesign-woocommerce.css',
				[],
				KEYDESIGN_VERSION
			);
		}, 120 );
		
		add_action( 'wp', [ $this, 'wc_social_sharing' ] );
		add_action( 'init', [ $this, 'disable_woocommerce_features' ] );

		// Product category image field
		add_action( 'product_cat_edit_form_fields', [ $this, 'add_category_header_image_field' ] );
		add_action( 'edited_product_cat', [ $this, 'save_category_header_field' ] );
	}
	
	public static function get_social_sharing_markup() {
		include_once KEYDESIGN_PATH . 'includes/theme-features/social-sharing.php';
	}

	public function wc_social_sharing() {
		if ( is_product() ) {
			if ( Utils::get_option( 'woo_single_social' ) ) {
				add_action( 'woocommerce_before_main_content', [ $this, 'get_social_sharing_markup' ], 20 );
			}
		}
	}

	public function disable_woocommerce_features() {
		// Remove duplicate category/archive description
		remove_action( 'woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10 );
	}

	public function add_category_header_image_field( $term ) {
		$header_image_id = get_term_meta( $term->term_id, 'header_image_id', true );
		$image_url = $header_image_id ? wp_get_attachment_url( $header_image_id ) : '';

		?>
		<tr class="form-field">
			<th scope="row" valign="top"><label for="header_image_id"><?php esc_html_e( 'Header Image', 'keydesign' ); ?></label></th>
			<td>
				<div id="header-image-preview" style="margin-bottom: 10px;">
					<?php if ( $image_url ) : ?>
						<img src="<?php echo esc_url( $image_url ); ?>" style="max-width: 300px;" />
					<?php endif; ?>
				</div>
				<input type="hidden" name="header_image_id" id="header_image_id" value="<?php echo esc_attr( $header_image_id ); ?>" />
				<button class="button upload-header-image"><?php esc_html_e( 'Upload/Add Image', 'keydesign' ); ?></button>
				<button class="button remove-header-image"><?php esc_html_e( 'Remove Image', 'keydesign' ); ?></button>

				<script>
				jQuery(document).ready(function($) {
					let frame;
					$('.upload-header-image').on('click', function(e) {
						e.preventDefault();
						if (frame) {
							frame.open();
							return;
						}
						frame = wp.media({
							title: '<?php esc_html_e( 'Select or Upload Header Image', 'keydesign' ); ?>',
							button: {
								text: '<?php esc_html_e( 'Use this image', 'keydesign' ); ?>'
							},
							multiple: false
						});
						frame.on('select', function() {
							const attachment = frame.state().get('selection').first().toJSON();
							$('#header_image_id').val(attachment.id);
							$('#header-image-preview').html('<img src="' + attachment.url + '" style="max-width: 300px;" />');
						});
						frame.open();
					});
					$('.remove-header-image').on('click', function(e) {
						e.preventDefault();
						$('#header_image_id').val('');
						$('#header-image-preview').html('');
					});
				});
				</script>
			</td>
		</tr>
		<?php
	}

	public function save_category_header_field( $term_id ) {
		if ( isset( $_POST['header_image_id'] ) ) {
			update_term_meta( $term_id, 'header_image_id', absint( $_POST['header_image_id'] ) );
		}
	}
}
KeyDesign_WooCommerce::instance();
