<?php

class PxlTextMarquee_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_text_marquee';
    protected $title = 'Case Text Marquee';
    protected $icon = 'eicon-wordart';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_text_marquee_content","label":"Content","tab":"content","controls":[{"name":"text","type":"wysiwyg","default":"Farming . Organic . Natural . Vegetables . Agriculture","description":"Highlight text width shortcode: [highlight text=\"...\"]"},{"name":"duplicate","label":"Duplicate","type":"switcher","separator":"before","default":"true"},{"name":"direction","label":"Direction","type":"select","options":{"rtl":"Right to Left","ltr":"Left to Right"},"default":"rtl"},{"name":"duration","label":"Duration(s)","type":"number","default":20,"selectors":{"{{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-marquee-item":"--pxl-duration: {{VALUE}}s;"}},{"name":"gap","label":"Gap","type":"slider","size_units":["px","%"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-text-marquee-wrapper":"--pxl-spacing-inline: {{SIZE}}{{UNIT}};"}}]},{"name":"tab_text_marquee_style","label":"Text Marquee","tab":"style","controls":[{"name":"text_controls","control_type":"tab","tabs":[{"name":"text_normal","label":"Normal","type":"tab","controls":[{"name":"text_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-marquee-item":"color: {{VALUE}}"}},{"name":"text_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-marquee-item"},{"name":"text_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-marquee-item"},{"name":"text_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-marquee-item"}]},{"name":"text_highlight","label":"Highlight","type":"tab","controls":[{"name":"svg_size","label":"SVG Size","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-marquee-item .pxl-svg-highlight svg":"width: {{SIZE}}{{UNIT}}; height:auto;"}},{"name":"text_hl_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-marquee-item .pxl-text-highlight,\r\n                                                {{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-marquee-item .pxl-svg-highlight,\r\n                                                {{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-marquee-item .pxl-svg-hightlight":"color: {{VALUE}}"}},{"name":"text_hl_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-marquee-item .pxl-text-highlight"},{"name":"text_hl_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-marquee-item .pxl-text-highlight,\r\n                                            {{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-marquee-item .pxl-svg-highlight"},{"name":"text_hl_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-marquee-item .pxl-text-highlight,\r\n                                            {{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-marquee-item .pxl-svg-highlight"}]}]}]},{"name":"tab_link_style","label":"Link","tab":"style","controls":[{"name":"link_typography","type":"typography","selector":"{{WRAPPER}} .pxl-text-marquee-wrapper a","control_type":"group"},{"name":"link_controls","control_type":"tab","tabs":[{"name":"link_normal","label":"Normal","type":"tab","controls":[{"name":"link_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-text-marquee-wrapper a":"color: {{VALUE}};"}},{"name":"link_highlight_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-highlight"},{"name":"link_highlight_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-text-marquee-wrapper .pxl-text-highlight"}]},{"name":"link_hover","label":"Hover","type":"tab","controls":[{"name":"link_hover_style","label":"Style","type":"select","options":{"link-hover-default":"Default","link-hover-underline-slide":"Underline Slide"},"default":"link-hover-default","condition":{"link_style!":"link-underline"}},{"name":"link_color_hover","label":"Color Hover","type":"color","selectors":{"{{WRAPPER}} .pxl-text-marquee-wrapper a:hover":"color: {{VALUE}};"}},{"name":"link_highlight_stroke_hover","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-text-marquee-wrapper a:hover"},{"name":"link_highlight_shadow_hover","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-text-marquee-wrapper a:hover"}]}]}]},{"name":"pxl_motion_effects","tab":"style","label":"Motion Effects","controls":[{"name":"entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":[]},{"name":"anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-text-marquee-wrapper":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"entrance_anim!":["text-animated",""]}},{"name":"anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-text-marquee-wrapper":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"entrance_anim!":["text-animated",""]}}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}