<?php

class PxlTextEditor_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_text_editor';
    protected $title = 'Case Text Editor';
    protected $icon = 'eicon-text';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_text_editor_content","label":"Text Editor","tab":"content","controls":[{"name":"text_style","label":"Text Style","type":"select","options":{"text-default":"Default","text-custom":"Custom"},"default":"text-default"},{"name":"text","type":"wysiwyg","default":"Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.","description":"Highlight text width shortcode: [highlight text=\"...\"]"},{"name":"text_align","label":"Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"},"justify":{"title":"Justified","icon":"eicon-text-align-justify"}},"selectors":{"{{WRAPPER}} .pxl-text-editor":"text-align: {{VALUE}};"}},{"name":"max_width","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}}":"max-width: {{SIZE}}{{UNIT}} !important;"}}]},{"name":"tab_text_style","label":"Text","tab":"style","controls":[{"name":"text_controls","control_type":"tab","tabs":[{"name":"text_normal","label":"Normal","type":"tab","controls":[{"name":"text_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-text-editor":"color: {{VALUE}};"}},{"name":"text_typography","type":"typography","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-text-editor"},{"name":"text_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-text-editor"},{"name":"text_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-text-editor"}]},{"name":"text_highlight","label":"Highlight","type":"tab","controls":[{"name":"text_highlight_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-text-editor .pxl-text-highlight":"color: {{VALUE}};"}},{"name":"text_highlight_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-text-editor .pxl-text-highlight"},{"name":"text_highlgiht_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-text-editor"},{"name":"text_highlight_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-text-editor .pxl-text-highlight"}]}]}]},{"name":"tab_link_style","label":"Link","tab":"style","controls":[{"name":"link_typography","type":"typography","selector":"{{WRAPPER}} .pxl-text-editor a","control_type":"group"},{"name":"link_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-text-editor a"},{"name":"link_controls","control_type":"tab","tabs":[{"name":"link_normal","label":"Normal","type":"tab","controls":[{"name":"link_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-text-editor a":"color: {{VALUE}};"}},{"name":"link_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-text-editor a"}]},{"name":"link_hover","label":"Hover","type":"tab","controls":[{"name":"link_hover_style","label":"Style","type":"select","options":{"hover-default":"Default","hover-underline-slide":"Underline Slide"},"default":"hover-default"},{"name":"link_hover_color","label":"Color Hover","type":"color","selectors":{"{{WRAPPER}} .pxl-text-editor a:hover":"color: {{VALUE}};"}},{"name":"link_hover_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-text-editor a:hover"}]}]}]},{"name":"pxl_moution_effects","label":"Motion Effects","tab":"style","controls":[{"name":"entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}},{"label":"Gsap Animate","options":{"text-animated text-fade-in":"Fade In","text-animated text-fade-in-up":"Fade In Up","text-animated text-fade-in-right":"Fade In Right","text-animated text-fade-in-down":"Fade In Down","text-animated text-fade-in-left":"Fade In Left","text-animated text-explosion":"Explosion","text-animated text-zigzag-zoom":"Zigzag Zoom","text-animated text-flip-x":"Flip X","text-animated text-flip-y":"Flip Y","text-animated text-zoom-in":"Zoom In"}}],"default":"","condition":[]},{"name":"anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-text-editor":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"entrance_anim!":["text-animated",""]}},{"name":"anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-text-editor":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"entrance_anim!":["text-animated",""]}},{"name":"split_type","label":"Animation On","type":"select","options":{"lines":"Lines","words":"Words","chars":"Chars"},"default":"chars","condition":[],"description":"This option only applies to gsap animate"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'agron-animated' );
}