<?php

class PxlTeam_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_team';
    protected $title = 'Case Team';
    protected $icon = 'eicon-person';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_team_layout","label":"Layout","tab":"layout","controls":[{"name":"post_type","type":"hidden","default":"team"},{"name":"layout_type","label":"Layout Type","type":"select","options":{"grid":"Grid","carousel":"Carousel"},"default":"grid"},{"name":"layout_team","label":"Select Template of Team","type":"layoutcontrol","default":"team-1","options":{"team-1":{"label":"Team 1","image":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/team-1.webp"},"team-2":{"label":"Team 2","image":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/team-2.webp"}},"condition":{"post_type":["team"]}}]},{"name":"tab_source","label":"Source","tab":"settings","controls":[{"name":"select_post_by","label":"Select posts by","type":"select","multiple":true,"options":{"term_selected":"Terms selected","post_selected":"Posts selected "},"default":"term_selected"},{"name":"source_team","label":"Select Term of Team","type":"select2","multiple":true,"options":[],"condition":{"post_type":["team"],"select_post_by":"term_selected"}},{"name":"source_team_post_ids","label":"Select posts","type":"select2","multiple":true,"options":{"620":"Leslie Alexander","1224":"Isabella Camila","1225":"Alexander Ethan","1226":"James Benjamin","1227":"Jessica Brown","1228":"Olivia Bennett","1230":"Chloe Morgan","7944":"Jack Strongfield","7945":"Ethan Ironwood","7946":"Caleb Stonehart","7947":"William Oakridge"},"condition":{"post_type":["team"],"select_post_by":"post_selected"}},{"name":"orderby","label":"Order By","type":"select","default":"date","options":{"date":"Date","ID":"ID","author":"Author","title":"Title","rand":"Random"}},{"name":"order","label":"Sort Order","type":"select","default":"desc","options":{"desc":"Descending","asc":"Ascending"}},{"name":"limit","label":"View Posts","type":"number","default":6}]},{"name":"tab_display_opts","label":"Display","tab":"settings","controls":[{"name":"img_dimension","label":"Image Dimension","type":"select","options":{"":"Default","thumbnail":"Thumbnail","thumb":"Thumb (Alias of Thumbnail)","medium":"Medium","medium_large":"Medium Large","large":"Large","full":"Full (Original)","custom":"Custom"},"default":"","condition":[]},{"name":"custom_img_dimension","label":"Dimension Custom","type":"image_dimensions","description":"Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.","condition":{"img_dimension":"custom"}},{"name":"title_tag","label":"Title HTML Tag","type":"select","seperator":"before","options":{"":"Default","h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","p":"p","span":"span"},"default":""},{"name":"show_position","label":"Show Position","type":"switcher","default":"true"},{"name":"show_social","label":"Show Social Share","type":"switcher","default":"true"}]},{"name":"tab_grid_add_opts","label":"Additional Options","tab":"settings","condition":{"layout_type":"grid"},"controls":[{"name":"grid_controls","control_type":"tab","tabs":[{"name":"grid_options","label":"Options","type":"tab","controls":[{"name":"grid_justify_content","label":"Justify Content","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"selectors":{"{{WRAPPER}} .grid .grid-inner":"justify-content: {{VALUE}};"}},{"name":"grid_spacing_inline","label":"Column Spacing(px)","type":"slider","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .grid .grid-inner":"--pxl-spacing-inline: {{SIZE}}{{UNIT}};"}},{"name":"grid_spacing_block","label":"Row Spacing(px)","type":"slider","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .grid .grid-inner":"--pxl-spacing-block: {{SIZE}}{{UNIT}};"}},{"name":"grid_pagination","label":"Pagination","type":"select","separator":"before","default":"","options":{"":"Disable","pagination":"Pagination","loadmore":"Loadmore"}},{"name":"grid_pagination_justify_content","label":"Justify Content","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"selectors":{"{{WRAPPER}} .grid .grid-pagination":"justify-content: {{VALUE}};"},"condition":{"grid_pagination":"pagination"}},{"name":"grid_pagination_gap","label":"Gap","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .grid .grid-pagination":"gap: {{SIZE}}{{UNIT}};"},"condition":{"grid_pagination":"pagination"}},{"name":"grid_pagination_spacing_top","label":"Spacing Top","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-pagination":"margin-top: {{SIZE}}{{UNIT}};"},"condition":{"grid_pagination":"pagination"}},{"name":"load_more_style","label":"Load More Style","type":"select","options":{"load-more-button-default":"Default","pxl-btn-split":"Split Button"},"default":"load-more-button-default","condition":{"grid_pagination":"loadmore"}},{"name":"btn_load_more_justify_content","label":"Justify Content","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"condition":{"grid_pagination":"loadmore"},"selectors":{"{{WRAPPER}} .pxl-button-wrapper":"justify-content: {{VALUE}};"}},{"name":"load_more_icon","label":"Load More Icon","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/uploads\/2025\/02\/arrow-long-down.svg","id":10135},"library":"svg"},"condition":{"grid_pagination":"loadmore"}},{"name":"load_more_text","type":"text","label":"Load More Text","condition":{"grid_pagination":"loadmore","loadmore_style":"pxl-btn-split"}},{"name":"loadmore_spacing","label":"Load More Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-load-more-wrapper":"margin-top: {{SIZE}}{{UNIT}};"},"condition":{"grid_pagination":"loadmore"}}]},{"name":"grid_responsive","label":"Responsive","type":"tab","condition":{"layout_type":"grid"},"controls":[{"name":"columns","label":"Columns","type":"select","control_type":"responsive","default":"","options":{"":"Default","100%":"1","50%":"2","33.3333333%":"3","25%":"4","20%":"5","16.666666666%":"6"},"selectors":{"{{WRAPPER}} .grid .grid-inner .grid-item":"--pxl-width: {{VALUE}};"}},{"name":"grid_items","label":"Columns Custom","type":"repeater","controls":[{"name":"grid_item_width","label":"Width","type":"slider","control_type":"responsive","size_units":["%","custom"],"range":{"px":{"min":0,"max":1000}},"default":{"unit":"%"},"selectors":{"{{WRAPPER}} .grid .grid-inner .grid-item{{CURRENT_ITEM}}":"--pxl-width: {{SIZE}}{{UNIT}};"}},{"name":"grid_item_height","label":"Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .grid .grid-inner .grid-item{{CURRENT_ITEM}}":"height: {{SIZE}}{{UNIT}};"}},{"name":"grid_item_img_dimension","label":"Image Dimension","type":"select","options":{"":"Default","thumbnail":"Thumbnail","thumb":"Thumb (Alias of Thumbnail)","medium":"Medium","medium_large":"Medium Large","large":"Large","full":"Full (Original)","custom":"Custom"},"default":""},{"name":"grid_item_img_dimension_custom","label":"Image Dimension Custom","type":"image_dimensions","separator":"before","description":"Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.","condition":{"grid_item_img_dimension":"custom"}}]}]}]}]},{"name":"tab_carousel_add_opts","label":"Additional Options","tab":"settings","condition":{"layout_type":"carousel"},"controls":[{"name":"swiper_controls","control_type":"tab","tabs":[{"name":"swiper_options","label":"Options","type":"tab","condition":{"layout_type":"carousel"},"controls":[{"name":"slide_boxshadow","label":"Slide with Box Shadow","type":"select","options":{"":"Default","swiper-normal":"No","swiper-boxshadow":"Yes"},"default":""},{"name":"effect","label":"Effect","type":"select","options":{"slide":"Slide","fade":"Fade"},"default":"slide"},{"name":"swiper_divider","type":"divider"},{"name":"allow_touch_move","label":"Allow Touch Move","type":"switcher","default":"true"},{"name":"autoplay","label":"Autoplay","type":"switcher","default":""},{"name":"disable_on_interaction","label":"Pause on Interaction","type":"switcher","default":"","condition":{"autoplay!":""}},{"name":"delay","label":"Delay","type":"number","default":3000,"condition":{"autoplay!":""}},{"name":"loop","label":"Infinite Loop","type":"switcher","default":""},{"name":"speed","label":"Animation Speed","type":"number","default":300,"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-container-fade":"--pxl-spacing-inline: {{VALUE}}ms;"}},{"name":"space_between","label":"Space Between(px)","type":"number","control_type":"responsive","condition":{"effect!":"fade"},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner":"--pxl-spacing-inline: {{VALUE}}px;"}},{"name":"swiper_pagination","type":"select","label":"Pagination","separator":"before","options":{"":"None","bullets":"Bullets","progressbar":"Progressbar","fraction":"Fraction"}},{"name":"swiper_navigation","label":"Navigation","type":"switcher","default":""},{"name":"use_swiper_nav_widget","label":"Use Navigation Widget","type":"switcher","default":"","condition":{"swiper_navigation!":""}},{"name":"nav_widget_id","type":"text","label":"Enter ID Your Widget Navigation","condition":{"swiper_navigation!":"","use_swiper_nav_widget!":""},"label_block":true,"description":"You need to enter the unique ID you created from the navigation carousel widget, and the navigation with this ID will function as a navigation carousel."},{"name":"nav_btn_icon_prev","label":"Button Icon Prev","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/uploads\/2025\/06\/arrow-left.svg","id":3614},"library":"svg"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}},{"name":"nav_btn_icon_next","label":"Button Icon Next","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/uploads\/2025\/06\/arrow-right.svg","id":3615},"library":"svg"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}},{"name":"nav_spacing_top","label":"Spacing Top","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation":"marrgin-top: {{SIZE}}{{UNIT}};"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}}]},{"name":"swiper_responsive","label":"Responsive","type":"tab","controls":[{"name":"custom_slides","label":"Custom Slides","type":"switcher","default":""},{"name":"slides_per_view_xs","label":"Slides Per View(&lt;576px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_sm","label":"Slides Per View(\u2265576px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_md","label":"Slides Per View(\u2265768px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_lg","label":"Slides Per View(\u2265992px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_xl","label":"Slides Per View(\u22651200px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"slides_per_view_xxl","label":"Slides Per View(\u22651400px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"slides","label":"Slides Per View Custom","type":"repeater","condition":{"custom_slides!":""},"controls":[{"name":"slide_width","label":"Width","type":"slider","control_type":"responsive","size_units":["%","custom"],"range":{"px":{"min":0,"max":1000}},"default":{"unit":"%"},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-slide{{CURRENT_ITEM}}":"flex: 0 1 {{SIZE}}{{UNIT}};"}},{"name":"slide_height","label":"Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-slide{{CURRENT_ITEM}}":"height: {{SIZE}}{{UNIT}};"}},{"name":"slide_img_dimension","label":"Image Dimension","type":"select","options":{"":"Default","thumbnail":"Thumbnail","thumb":"Thumb (Alias of Thumbnail)","medium":"Medium","medium_large":"Medium Large","large":"Large","full":"Full (Original)","custom":"Custom"},"default":""},{"name":"slide_img_dimension_custom","label":"Image Dimension Custom","type":"image_dimensions","separator":"before","description":"Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.","condition":{"slide_img_dimension":"custom"}}]}]}]}]},{"name":"tab_general_style","label":"General","tab":"style","controls":[{"name":"title_spacing","label":"Title Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-title":"margin-top: {{SIZE}}{{UNIT}};"}},{"name":"featured_spacing","label":"Featured Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-featured":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"social_icon_spacing","label":"Social Icon Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials":"gap: {{SIZE}}{{UNIT}};"}},{"name":"social_item_spacing","label":"Social Item Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-item + .pxl-social-item":"padding-top: {{SIZE}}{{UNIT}};"}}]},{"name":"tab_box_style","label":"Box","tab":"style","controls":[{"name":"box_controls","control_type":"tab","tabs":[{"name":"box_normal","label":"Normal","type":"tab","controls":[{"name":"box_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-team .pxl-post-item"},{"name":"box_border","type":"border","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-item"},{"name":"box_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-item"},{"name":"box_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-item":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"box_hover","label":"Hover","type":"tabs","controls":[{"name":"box_hover_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-team .pxl-post-item:hover"},{"name":"_box_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-item:hover":"border-color: {{VALUE}};"}},{"name":"box_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-item:hover"},{"name":"box_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-item:hover"},{"name":"box_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-item:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_featured_style","label":"Featured","tab":"style","controls":[{"name":"featured_controls","control_type":"tab","tabs":[{"name":"featured_normal","label":"Normal","type":"tab","controls":[{"name":"featured_opacity","label":"Opacity","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-featured img":"opacity: {{SIZE}};"}},{"name":"featured_css_filters","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-featured img"},{"name":"featured_border","type":"border","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-team .pxl-post-featured > a"},{"name":"featured_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-featured > a"},{"name":"featured_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-featured > a":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"featured_hover","label":"Hover","type":"tabs","controls":[{"name":"featured_hover_style","label":"Hover Style","type":"select","options":{"":"None","hover-image-default":"Default","hover-image-parallax":"Parallax"},"default":""},{"name":"featured_hover_opacity","label":"Opacity","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-item:hover .pxl-post-featured img":"opacity: {{SIZE}};"}},{"name":"featured_hover_css_filters","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-item:hover .pxl-post-featured img"},{"name":"featured_hover_border","type":"border","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-team .pxl-post-item:hover .pxl-post-featured > a"},{"name":"featured_hover_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-item:hover .pxl-post-featured > a"},{"name":"featured_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-item:hover .pxl-post-featured > a":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_content_style","label":"Content","tab":"style","controls":[{"name":"content_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-team .pxl-post-content"},{"name":"content_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-content"},{"name":"content_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-content"},{"name":"content_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-content":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"content_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-content":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"tab_title_style","label":"Title","tab":"style","controls":[{"name":"title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-title"},{"name":"title_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-title"},{"name":"title_controls","control_type":"tab","tabs":[{"name":"title_normal","label":"Normal","type":"tab","controls":[{"name":"title_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-title":"color: {{VALUE}};"}}]},{"name":"title_hover","label":"Hover","type":"tab","controls":[{"name":"title_hover_style","label":"Hover Style","type":"select","groups":[{"label":"Default","options":{"hover-text-default":"Default"}},{"label":"Underline","options":{"hover-text-underline":"Underline","hover-text-underline--slide-ltr":"Slide LTR","hover-text-underline--slide-rtl":"Slide RTL"}}],"default":"hover-text-default"},{"name":"title_underline_h","label":"Underline Weight(px)","type":"slider","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-item .pxl-post-title":"--pxl-height: {{SIZE}}{{UNIT}};"},"condition":{"title_hover_style":["hover-text-underline","hover-text-underline--slide-ltr","hover-text-underline--slide-rtl"]}},{"name":"title_divider","type":"divider"},{"name":"title_hover_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-title:hover":"color: {{VALUE}};"}}]}]}]},{"name":"tab_position_style","label":"Position","tab":"style","controls":[{"name":"position_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-position":"color: {{VALUE}};"}},{"name":"position_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-position"},{"name":"position_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-position"}]},{"name":"tab_social_icon_style","label":"Social Icon","tab":"style","controls":[{"name":"social_icon_box_size","label":"Box Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"px":{"min":0,"max":2000},"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link":"--pxl-box-size: {{SIZE}}{{UNIT}};"}},{"name":"social_icon_size","label":"Icon Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"px":{"min":0,"max":2000},"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link svg":"height: {{SIZE}}{{UNIT}}; width: auto;","{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"social_icon_controls","control_type":"tab","tabs":[{"name":"social_icon_normal","label":"Normal","type":"tab","controls":[{"name":"social_icon_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link":"color: {{VALUE}};"}},{"name":"social_icon_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link"},{"name":"social_icon_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link"},{"name":"social_icon_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link"},{"name":"social_icon_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"social_icon_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"social_icon_hover","label":"Hover","type":"tab","controls":[{"name":"social_icon_hover_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link:hover":"color: {{VALUE}};"}},{"name":"social_icon_hover_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link:hover"},{"name":"social_icon_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link:hover"},{"name":"social_icon_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link:hover"},{"name":"social_icon_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"social_icon_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link:hover":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"social_icon_transition","label":"Transition(s)","type":"slider","size_units":["s"],"range":{"s":{"min":0,"max":20}},"default":{"unit":"s"},"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-link":"transition: all {{SIZE}}{{UNIT}} linear;"}}]}]}]},{"name":"tab_social_share_style","label":"Social Share","tab":"style","controls":[{"name":"social_share_box_size","label":"Box Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"px":{"min":0,"max":2000},"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon":"--pxl-box-size: {{SIZE}}{{UNIT}};"}},{"name":"social_share_size","label":"Icon Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"px":{"min":0,"max":2000},"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon svg":"height: {{SIZE}}{{UNIT}}; width: auto;","{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"social_share_border_inset","label":"Border Inset","type":"slider","control_type":"responsive","size_units":["px","custom"],"px":{"min":0,"max":2000},"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon:before":"inset: {{SIZE}}{{UNIT}};"}},{"name":"social_share_controls","control_type":"tab","tabs":[{"name":"social_share_normal","label":"Normal","type":"tab","controls":[{"name":"social_share_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon":"color: {{VALUE}};"}},{"name":"social_share_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon"},{"name":"social_share_border_inset_bg","type":"background","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon:hover:before"},{"name":"social_share_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon:before"},{"name":"social_share_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon"},{"name":"social_share_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"social_share_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"social_share_hover","label":"Hover","type":"tab","controls":[{"name":"social_share_hover_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon:hover":"color: {{VALUE}};"}},{"name":"social_share_hover_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon:hover"},{"name":"social_share_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon:hover:before"},{"name":"social_share_hover_border_inset_bg","type":"background","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon:hover:before"},{"name":"social_share_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon:hover"},{"name":"social_share_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"social_share_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon:hover":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"social_share_transition","label":"Transition(s)","type":"slider","size_units":["s"],"range":{"s":{"min":0,"max":20}},"default":{"unit":"s"},"selectors":{"{{WRAPPER}} .pxl-team .pxl-post-socials .pxl-social-icon":"transition: all {{SIZE}}{{UNIT}} linear;"}}]}]}]},{"name":"pxl_motion_effects","tab":"style","label":"Motion Effects","controls":[{"name":"entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":[]},{"name":"anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .grid .grid-item, {{WRAPPER}} .pxl-swiper .swiper-slide":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"entrance_anim!":["text-animated",""]}},{"name":"anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .grid .grid-item, {{WRAPPER}} .pxl-swiper .swiper-slide":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"entrance_anim!":["text-animated",""]}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'imagesloaded','pxl-post-grid','agron-effects' );
}