<?php

class PxlSlider_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_slider';
    protected $title = 'Case Slider';
    protected $icon = 'eicon-slides';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_slider_layout","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Layout","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/slider-1.webp"},"2":{"label":"Layout 2","image":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/slider-2.webp"},"3":{"label":"Layout 3","image":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/slider-3.webp"},"4":{"label":"Layout 4","image":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/slider-4.webp"}}}]},{"name":"tab_slider_content","label":"Slides","tab":"content","controls":[{"name":"slides","label":"Slides","type":"repeater","controls":[{"name":"slide_layout","label":"Slide Layout","type":"select","options":{"":"Select Layout","1":"1","2":"2","3":"3","4":"4"}},{"name":"slide_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-slider .swiper-slide{{CURRENT_ITEM}} .slide-background","fields_options":{"background":{"label":"Background Slide"}}},{"name":"overlay_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-slider .swiper-slide{{CURRENT_ITEM}} .slide-background::before","fields_options":{"background":{"label":"Background Overlay"}}},{"name":"badge_image","label":"Badge Image","type":"media","condition":{"slide_layout!":["1","2"]}},{"name":"subtitle","label":"Subtitle","type":"textarea","default":"Subtitle","separator":"before","rows":2,"description":"Highlight use shortcode: [highlight text=&quot;...&quot;] or [highlight_image img_id=&quot;25&quot;] or [highlight_svg id=&quot;26&quot;]","condition":{"slide_layout!":["2"]}},{"name":"description","label":"Description","type":"textarea","rows":3,"condition":{"slide_layout!":["1","2"]}},{"name":"title","label":"Title","type":"textarea","rows":5,"default":"Heading Title","label_block":true,"description":"Highlight use shortcode: [highlight text=&quot;...&quot;] or [highlight_image img_id=&quot;123&quot;]"},{"name":"title_tag","label":"Title HTML Tag","type":"select","options":{"h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","p":"p","span":"span"},"default":"h1","condition":{"title!":""}},{"name":"button_first_heading","type":"heading","label":"Button First","separator":"before"},{"name":"button_first_icon","label":"Button Icon","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/uploads\/2025\/05\/arrow-up-right.svg","id":61},"library":"svg"}},{"name":"button_first_text","label":"Button Text","type":"text","default":"Click Here"},{"name":"button_first_link","label":"Link URL","type":"url","default":{"url":"#"}},{"name":"button_second_heading","type":"heading","label":"Button Second","separator":"before","condition":{"slide_layout!":["2"]}},{"name":"button_second_icon","label":"Button Icon","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/uploads\/2025\/05\/arrow-up-right.svg","id":61},"library":"svg"},"condition":{"slide_layout!":["2"]}},{"name":"button_second_text","label":"Button Text","type":"text","default":"Click Here","condition":{"slide_layout!":["2"]}},{"name":"button_second_link","label":"Link URL","type":"url","default":{"url":"#"},"condition":{"slide_layout!":["2"]}},{"name":"slider_item_container","label":"Container","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide{{CURRENT_ITEM}} .slide-container":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"slider_container_padding","label":"Container Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide{{CURRENT_ITEM}} .slide-container":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"slide_item_inner_max_width","label":"Inner Max Width","type":"slider","separator":"before","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide{{CURRENT_ITEM}} .slide-inner":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"slide_item_inner_position","label":"Content Position","type":"choose","control_type":"responsive","options":{"right":{"title":"Left","icon":"eicon-h-align-left"},"":{"title":"Center","icon":"eicon-h-align-center"},"left":{"title":"Right","icon":"eicon-h-align-right"}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide{{CURRENT_ITEM}} .slide-inner":"margin-{{VALUE}}: auto;"}},{"name":"slide_item_inner_align_items_column","label":"Align Items","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-align-start-h"},"center":{"title":"Center","icon":"eicon-align-center-h"},"end":{"title":"End","icon":"eicon-align-end-h"},"stretch":{"title":"Stretch","icon":"eicon-align-stretch-h"}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide{{CURRENT_ITEM}} .slide-inner":"align-items: {{VALUE}};"}},{"name":"slide_item_inner_text_align","label":"Text Alignment","type":"choose","control_type":"responsive","separator":"before","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"},"justify":{"title":"Justify","icon":"eicon-text-align-justify"}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide{{CURRENT_ITEM}} .slide-container":"text-align: {{VALUE}};"}}],"title_field":"{{{ title }}}","default":[{"subtitle":"Subtitle","title":"Heading Title","button_first_icon":{"value":{"url":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/uploads\/2025\/05\/arrow-up-right.svg","id":61},"library":"svg"},"button_first_text":"Click here","button_first_link":"#","button_second_icon":{"value":{"url":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/uploads\/2025\/05\/arrow-up-right.svg","id":61},"library":"svg"},"button_second_text":"Click here","button_second_link":"#"}]}]},{"name":"tab_slider_add_opts","label":"Additional Options","tab":"settings","controls":[{"name":"allow_touch_move","label":"Allow Touch Move","type":"switcher","default":"true"},{"name":"autoplay","label":"Autoplay","type":"switcher","default":""},{"name":"disable_on_interaction","label":"Pause on Interaction","type":"switcher","default":"","condition":{"autoplay!":""}},{"name":"delay","label":"Delay","type":"number","default":3000,"condition":{"autoplay!":""},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-container":"--pxl-duration: {{VALUE}}ms;"}},{"name":"loop","label":"Infinite Loop","type":"switcher","default":""},{"name":"speed","label":"Animation Speed","type":"number","default":300,"selectors":{"{{WRAPPER}} .pxl-slider .swiper-container":"--pxl-transition-duration: {{VALUE}}ms;"}},{"name":"space_between","label":"Space Between(px)","type":"number","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-container-fade":"--pxl-spacing-inline: {{VALUE}}ms;"}},{"name":"swiper_pagination","type":"select","label":"Pagination","separator":"before","options":{"":"None","bullets":"Bullets","progressbar":"Progressbar","fraction":"Fraction"}},{"name":"swiper_navigation","label":"Navigation","type":"switcher","default":""},{"name":"nav_btn_icon_prev","label":"Button Icon Prev","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/uploads\/2025\/06\/arrow-left.svg","id":3614},"library":"svg"},"condition":{"swiper_navigation!":""}},{"name":"nav_btn_icon_next","label":"Button Icon Next","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/uploads\/2025\/06\/arrow-right.svg","id":3615},"library":"svg"},"condition":{"swiper_navigation!":""}}]},{"name":"tab_slider_animated","label":"Animated","tab":"settings","controls":[{"name":"title_anim_heading","type":"heading","separator":"before","label":"Title Animation"},{"name":"title_entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}},{"label":"Gsap Animate","options":{"text1":"Effect 1","text2":"Effect 2","text3":"Effect 3","text4":"Effect 4"}}],"default":"","condition":[]},{"name":"title_anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-slider .title-text":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"title_entrance_anim!":["text-animated",""]}},{"name":"title_anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-slider .title-text":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"title_entrance_anim!":["text-animated",""]}},{"name":"button_first_anim_heading","type":"heading","label":"Button First Animation"},{"name":"button_first_entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":[]},{"name":"button_first_anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-slider .slide-button-first":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"button_first_entrance_anim!":["text-animated",""]}},{"name":"button_first_anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-slider .slide-button-first":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"button_first_entrance_anim!":["text-animated",""]}},{"name":"button_second_anim_heading","type":"heading","separator":"before","label":"Button Second Animation","condition":{"layout!":["2"]}},{"name":"button_second_entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":{"layout!":["2"]}},{"name":"button_second_anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-slider .slide-button-second":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"layout!":["2"],"button_second_entrance_anim!":["text-animated",""]}},{"name":"button_second_anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-slider .slide-button-second":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"layout!":["2"],"button_second_entrance_anim!":["text-animated",""]}},{"name":"description_anim_heading","type":"heading","separator":"before","label":"Description Animation","condition":{"layout":["3"]}},{"name":"description_entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":{"layout":["3"]}},{"name":"description_anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-slider .slide-description":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"layout":["3"],"description_entrance_anim!":["text-animated",""]}},{"name":"description_anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-slider .slide-description":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"layout":["3"],"description_entrance_anim!":["text-animated",""]}},{"name":"badge_anim_heading","type":"heading","separator":"before","label":"Badge Animation","condition":{"layout":["3"]}},{"name":"badge_entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":{"layout":["3"]}},{"name":"badge_anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-slider .slide-badge":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"layout":["3"],"badge_entrance_anim!":["text-animated",""]}},{"name":"badge_anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-slider .slide-badge":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"layout":["3"],"badge_entrance_anim!":["text-animated",""]}}]},{"name":"tab_general_style","label":"General","tab":"style","controls":[{"name":"slider_inner_align_items_column","label":"Align Items","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-align-start-h"},"center":{"title":"Center","icon":"eicon-align-center-h"},"end":{"title":"End","icon":"eicon-align-end-h"},"stretch":{"title":"Stretch","icon":"eicon-align-stretch-h"}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .slide-inner":"align-items: {{VALUE}};"}},{"name":"inner_text_align","label":"Text Alignment","type":"choose","control_type":"responsive","separator":"before","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"},"justify":{"title":"Justify","icon":"eicon-text-align-justify"}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .slide-container":"text-align: {{VALUE}};"}},{"name":"slider_min_height","label":"Min Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .slide-inner":"min-height: {{SIZE}}{{UNIT}};"}},{"name":"slider_inner_padding","label":"Inner Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .slide-inner":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"slider_inner_max_w","label":"Inner Max Width","type":"slider","separator":"before","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .slide-inner":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"slider_container","label":"Container","type":"slider","separator":"before","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .slide-container":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"slider_container_padding","label":"Container Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .slide-container":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"slider_container_margin","label":"Container Margin","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .slide-container":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"subtitle_spacing_bottom","label":"Subtitle Spacing","type":"slider","separator":"before","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .heading-subtitle":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"title_hl_spacing","label":"Title Highlight Spacing","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .heading-title .pxl-text-highlight":"margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"title_spacing_bottom","label":"Title Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .heading-title":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"title_max_width","label":"Title Max Width","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .heading-title":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"button_gr_spacing","label":"Button Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .slide-button-group":"gap: {{SIZE}}{{UNIT}};"}}]},{"name":"tab_title_style","label":"Title","tab":"style","controls":[{"name":"title_controls","control_type":"tab","tabs":[{"name":"title_normal","label":"Normal","type":"tab","controls":[{"name":"title_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .heading-title":"color: {{VALUE}};"}},{"name":"title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .swiper-slide .heading-title"},{"name":"title_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .swiper-slide .heading-title"}]},{"name":"title_highlight","label":"Highlight","type":"tab","controls":[{"name":"title_hl_block","type":"choose","label":"Width","options":{"auto":{"title":"Auto","icon":"eicon-arrow-right"},"100%":{"title":"100%","icon":"eicon-arrow-down"}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .heading-title .pxl-text-highlight":"display: {{VALUE}}"}},{"name":"title_hl_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .heading-title .pxl-text-highlight":"color: {{VALUE}};"}},{"name":"title_hl_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .swiper-slide .heading-title .pxl-text-highlight"},{"name":"title_hl_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .swiper-slide .heading-title .pxl-text-highlight"}]}]}]},{"name":"tab_subtitle_style","label":"Subtitle","tab":"style","controls":[{"name":"subtitle_controls","control_type":"tab","tabs":[{"name":"subtitle_normal","label":"Normal","type":"tab","controls":[{"name":"subtitle_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .heading-subtitle":"color: {{VALUE}};"}},{"name":"subtitle_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .swiper-slide .heading-subtitle"},{"name":"subtitle_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .swiper-slide .heading-subtitle"}]},{"name":"subtitle_highlight","label":"Highlight","type":"tab","controls":[{"name":"subtitle_hl_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .heading-subtitle .pxl-text-highlight,\r\n                                                {{WRAPPER}} .pxl-slider .swiper-slide .heading-subtitle .pxl-svg-highlight":"color: {{VALUE}};"}},{"name":"subtitle_hl_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .swiper-slide .heading-subtitle .pxl-text-highlight"},{"name":"subtitle_hl_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .swiper-slide .heading-subtitle .pxl-text-highlight"},{"name":"subtitle_svg_size","label":"SVG Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .heading-subtitle .pxl-svg-highlight":"width: {{SIZE}}{{UNIT}}; height: auto;"}},{"name":"subtitle_img_width","label":"Image Width","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .heading-subtitle img":"width: {{SIZE}}{{UNIT}};"}},{"name":"subtitle_img_height","label":"Image Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-slider .swiper-slide .heading-subtitle img":"height: {{SIZE}}{{UNIT}};"}}]}]}]},{"name":"tab_button_first_style","label":"Button First","tab":"style","controls":[{"name":"button_first_width","label":"Width","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-slider .slide-button-first":"width: {{SIZE}}{{UNIT}};"}},{"name":"button_first_height","label":"Height","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-slider .slide-button-first":"height: {{SIZE}}{{UNIT}};"}},{"name":"button_first_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .slide-button-first"},{"name":"divider1","type":"divider"},{"name":"button_first_controls","control_type":"tab","tabs":[{"name":"button_first_normal","label":"Normal","type":"tab","controls":[{"name":"button_first_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-slider .slide-button-first":"color: {{VALUE}};"}},{"name":"button_first_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-slider .slide-button-first"},{"name":"button_first_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .slide-button-first"},{"name":"button_first_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .slide-button-first"},{"name":"button_first_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-slider .slide-button-first":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"button_first_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-slider .slide-button-first":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"button_first_hover","label":"Hover","type":"tab","controls":[{"name":"button_first_hover_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-slider .slide-button-first:hover":"color: {{VALUE}};"}},{"name":"button_first_hover_background","type":"background","control_type":"group","types":["classic"],"selector":"{{WRAPPER}} .pxl-slider .slide-button-first:hover"},{"name":"button_first_transition","label":"Transition(s)","type":"slider","size_units":["s"],"range":{"s":{"min":0,"max":20}},"default":{"unit":"s"},"selectors":{"{{WRAPPER}} .pxl-slider .slide-button-first":"transition: all {{SIZE}}{{UNIT}} linear;"}},{"name":"button_first_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .slide-button-first:hover"},{"name":"button_first_hover_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .slide-button-first:hover"},{"name":"button_first_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-slider .slide-button-first:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"button_first_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-slider .slide-button-first:hover":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_button_second_style","label":"Button Second","tab":"style","controls":[{"name":"button_second_width","label":"Width","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-slider .slide-button-second":"width: {{SIZE}}{{UNIT}};"}},{"name":"button_second_height","label":"Height","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-slider .slide-button-second":"height: {{SIZE}}{{UNIT}};"}},{"name":"button_second_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .slide-button-second"},{"name":"divider2","type":"divider"},{"name":"button_second_controls","control_type":"tab","tabs":[{"name":"button_second_normal","label":"Normal","type":"tab","controls":[{"name":"button_second_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-slider .slide-button-second":"color: {{VALUE}};"}},{"name":"button_second_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-slider .slide-button-second"},{"name":"button_second_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .slide-button-second"},{"name":"button_second_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .slide-button-second"},{"name":"button_second_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-slider .slide-button-second":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"button_second_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-slider .slide-button-second":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"button_second_hover","label":"Hover","type":"tab","controls":[{"name":"button_second_hover_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-slider .slide-button-second:hover":"color: {{VALUE}};"}},{"name":"button_second_hover_background","type":"background","control_type":"group","types":["classic"],"selector":"{{WRAPPER}} .pxl-slider .slide-button-second:hover"},{"name":"button_second_transition","label":"Transition(s)","type":"slider","size_units":["s"],"range":{"s":{"min":0,"max":20}},"default":{"unit":"s"},"selectors":{"{{WRAPPER}} .pxl-slider .slide-button-second":"transition: all {{SIZE}}{{UNIT}} linear;"}},{"name":"button_second_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .slide-button-second:hover"},{"name":"button_second_hover_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-slider .slide-button-second:hover"},{"name":"button_second_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-slider .slide-button-second:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"button_second_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-slider .slide-button-second:hover":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_swiper_bullets_pagination_style","label":"Pagination Bullets","tab":"style","condition":{"swiper_pagination":"bullets"},"controls":[{"name":"bullet_size","label":"Bullet Size","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet":"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};"}},{"name":"bullet_dot_size","label":"Dot Inset","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:before":"inset: {{SIZE}}{{UNIT}};"}},{"name":"divider_bullet_1","type":"divider"},{"name":"bullet_controls","control_type":"tab","tabs":[{"name":"bullet_normal","label":"Normal","type":"tab","controls":[{"name":"bullet_color","label":"Bullet Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet":"color: {{VALUE}};"}},{"name":"bullet_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet"},{"name":"bullet_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet"},{"name":"bullet_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet"},{"name":"bullet_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"bullet_hover","label":"Hover\/Active","type":"tabs","controls":[{"name":"bullet_hove_color","label":"Bullet Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover":"color: {{VALUE}};"}},{"name":"_bullet_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover":"border-color: {{VALUE}};"}},{"name":"bullet_hover_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover"},{"name":"bullet_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover"},{"name":"bullet_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover"},{"name":"bullet_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_swiper_nav_btn_style","tab":"style","label":"Navigation Button","condition":{"swiper_navigation!":""},"controls":[{"name":"nav_btn_box_size","label":"Box Size","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, \n                    {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button":"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}};"}},{"name":"nav_btn_icon_size","label":"Icon Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button,\n                    {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button":"font-size: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button svg,\n                    {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button svg":"width: {{SIZE}}{{UNIT}}; height : auto;"}},{"name":"nav_btn_controls","control_type":"tab","tabs":[{"name":"nav_btn_normal","label":"Normal","type":"tab","controls":[{"name":"nav_btn_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button":"color: {{VALUE}};"}},{"name":"nav_btn_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button"},{"name":"nav_btn_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button"},{"name":"nav_btn_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button"},{"name":"nav_btn_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"nav_btn_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"nav_btn_hover","label":"Hover","type":"tabs","controls":[{"name":"nav_btn_hover_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover":"color: {{VALUE}};"}},{"name":"_nav_btn_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover":"border-color: {{VALUE}};"}},{"name":"nav_btn_hover_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover"},{"name":"nav_btn_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover"},{"name":"nav_btn_hover_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover"},{"name":"nav_btn_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"nav_btn_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'agron-swiper' );
}