<?php

class PxlPost_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_post';
    protected $title = 'Case Post';
    protected $icon = 'eicon-post';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_post_layout","label":"Layout","tab":"layout","controls":[{"name":"post_type","type":"hidden","default":"post"},{"name":"layout_type","label":"Layout Type","type":"select","options":{"grid":"Grid","carousel":"Carousel"},"default":"grid","condition":{"layout_post!":["post-1"]}},{"name":"layout2_style","label":"Layout Style","type":"select","options":{"default":"Default","style1":"Style 1"},"default":"default","condition":{"layout_post":["post-2"]}},{"name":"layout_post","label":"Select Template of Entrada","type":"layoutcontrol","default":"post-1","options":{"post-1":{"label":"Post 1","image":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/post-1.webp"},"post-2":{"label":"Post 2","image":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/post-2.webp"},"post-3":{"label":"Post 3","image":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/post-3.webp"},"post-4":{"label":"Post 4","image":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/post-4.webp"},"post-5":{"label":"Post 5","image":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/post-5.webp"},"post-6":{"label":"Post 6","image":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/post-6.webp"},"post-7":{"label":"Post 7","image":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/themes\/agron\/elements\/assets\/img-layouts\/post-7.webp"}},"condition":{"post_type":["post"]}}]},{"name":"tab_source","label":"Source","tab":"settings","controls":[{"name":"select_post_by","label":"Select posts by","type":"select","multiple":true,"options":{"term_selected":"Terms selected","post_selected":"Posts selected "},"default":"term_selected"},{"name":"source_post","label":"Select Term of Entrada","type":"select2","multiple":true,"options":{"agricultural|category":"Agricultural","farm|category":"Farm","farming|category":"Farming","fruit|category":"Fruit","plants|category":"Plants"},"condition":{"post_type":["post"],"select_post_by":"term_selected"}},{"name":"source_post_post_ids","label":"Select posts","type":"select2","multiple":true,"options":{"1709":"The whimsically named Egg Canvas brainchild","1840":"Helping Farmers Navigate Insurance Options","1841":"Best Feeding Practices for Quality Beef","1842":"Easy Access to Farm Insurance for Small Growers","1966":"How to Care for Cows to have the Best Quality Meat","1965":"Breaking Down Barriers to Crop Insurance","1964":"Minuter highest technic clothes trainer observe that","1843":"Bright Citrus Groves That Capture the Essence","1838":"A Golden Harvest Under the Sunset Skies in field","1839":"Exploring the Misty Green Fields of Northern","3236":"How Can You Growing Your Agriculture Products","3235":"Holistic Healing: Exploring Health Coaching Techniques","4407":"Which type of farming is more prevalent today?","4406":"Minuter highest technic clothes trainer observe country.","5417":"Rooted in Growth: Nurturing the Future of Agriculture","4612":"The Farmers Sentiment Darkens Hopes Fade","4611":"Farmer prepares fresh rice bundles for harvest","5416":"Sustainable Farming: Bringing Nature\u2019s Best to Your Table","7992":"The Growers\' Outlook Wanes as Dreams Wither","7991":"Breaking Down Barriers to Crop Agricultural Products","7990":"The Potential of Virtual Reality in Agrifood","8545":"From Field to Basket: The Journey of Natural Goodness","8544":"Sustainable Farming: Feeding the Future Responsibly","8543":"Fresh Harvest: Growing Quality from the Ground Up"},"condition":{"post_type":["post"],"select_post_by":"post_selected"}},{"name":"orderby","label":"Order By","type":"select","default":"date","options":{"date":"Date","ID":"ID","author":"Author","title":"Title","rand":"Random"}},{"name":"order","label":"Sort Order","type":"select","default":"desc","options":{"desc":"Descending","asc":"Ascending"}},{"name":"limit","label":"View Posts","type":"number","default":6}]},{"name":"tab_display_opts","label":"Display","tab":"settings","controls":[{"name":"img_dimension","label":"Image Dimension","type":"select","options":{"":"Default","thumbnail":"Thumbnail","thumb":"Thumb (Alias of Thumbnail)","medium":"Medium","medium_large":"Medium Large","large":"Large","full":"Full (Original)","custom":"Custom"},"default":"","condition":[]},{"name":"custom_img_dimension","label":"Dimension Custom","type":"image_dimensions","description":"Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.","condition":{"img_dimension":"custom"}},{"name":"title_tag","label":"Title HTML Tag","type":"select","seperator":"before","options":{"":"Default","h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","p":"p","span":"span"},"default":""},{"name":"show_author","label":"Show Author","type":"switcher","default":"true","condition":{"layout_post":["post-1","post-3","post-6"]}},{"name":"show_comment","label":"Show Comment","type":"switcher","default":"true","condition":{"layout_post":["post-1","post-3","post-6"]}},{"name":"show_reading_time","label":"Show Reading Time","type":"switcher","default":"true","condition":{"layout_post":["post-1"]}},{"name":"show_date","label":"Show Date","type":"switcher","default":"true","condition":{"layout_post":["post-2","post-4","post-5","post-6"]}},{"name":"show_category","label":"Show Category","type":"switcher","default":"true","condition":{"layout_post":["post-2","post-4","post-5","post-6"]}},{"name":"category_separator","label":"Category Separator","type":"text","default":", ","condition":{"show_category!":"","layout_post":["post-2","post-4","post-5","post-6"]}},{"name":"show_excerpt","label":"Show Excerpt","type":"switcher","default":"true","condition":{"layout_post":["post-1","post-2","post-5"]}},{"name":"num_of_words","label":"Number of Words","type":"number","condition":{"show_excerpt!":"","layout_post":["post-1","post-2","post-5"]}},{"name":"show_button","label":"Show Button","type":"switcher","default":"true"},{"name":"button_text","label":"Button Text","type":"text","placeholder":"More Details...","condition":{"show_button!":"","layout_post!":["post-6"]}}]},{"name":"tab_grid_add_opts","label":"Additional Options","tab":"settings","condition":{"layout_type":"grid","layout_post!":["post-1"]},"controls":[{"name":"grid_controls","control_type":"tab","tabs":[{"name":"grid_options","label":"Options","type":"tab","controls":[{"name":"grid_justify_content","label":"Justify Content","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"selectors":{"{{WRAPPER}} .grid .grid-inner":"justify-content: {{VALUE}};"}},{"name":"grid_spacing_inline","label":"Column Spacing(px)","type":"slider","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .grid .grid-inner":"--pxl-spacing-inline: {{SIZE}}{{UNIT}};"}},{"name":"grid_spacing_block","label":"Row Spacing(px)","type":"slider","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .grid .grid-inner":"--pxl-spacing-block: {{SIZE}}{{UNIT}};"}},{"name":"grid_pagination","label":"Pagination","type":"select","separator":"before","default":"","options":{"":"Disable","pagination":"Pagination","loadmore":"Loadmore"}},{"name":"grid_pagination_justify_content","label":"Justify Content","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"selectors":{"{{WRAPPER}} .grid .grid-pagination":"justify-content: {{VALUE}};"},"condition":{"grid_pagination":"pagination"}},{"name":"grid_pagination_gap","label":"Gap","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .grid .grid-pagination":"gap: {{SIZE}}{{UNIT}};"},"condition":{"grid_pagination":"pagination"}},{"name":"grid_pagination_spacing_top","label":"Spacing Top","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-pagination":"margin-top: {{SIZE}}{{UNIT}};"},"condition":{"grid_pagination":"pagination"}},{"name":"load_more_style","label":"Load More Style","type":"select","options":{"load-more-button-default":"Default","pxl-btn-split":"Split Button"},"default":"load-more-button-default","condition":{"grid_pagination":"loadmore"}},{"name":"btn_load_more_justify_content","label":"Justify Content","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"condition":{"grid_pagination":"loadmore"},"selectors":{"{{WRAPPER}} .pxl-button-wrapper":"justify-content: {{VALUE}};"}},{"name":"load_more_icon","label":"Load More Icon","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/uploads\/2025\/02\/arrow-long-down.svg","id":10135},"library":"svg"},"condition":{"grid_pagination":"loadmore"}},{"name":"load_more_text","type":"text","label":"Load More Text","condition":{"grid_pagination":"loadmore","loadmore_style":"pxl-btn-split"}},{"name":"loadmore_spacing","label":"Load More Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-load-more-wrapper":"margin-top: {{SIZE}}{{UNIT}};"},"condition":{"grid_pagination":"loadmore"}}]},{"name":"grid_responsive","label":"Responsive","type":"tab","condition":{"layout_type":"grid"},"controls":[{"name":"columns","label":"Columns","type":"select","control_type":"responsive","default":"","options":{"":"Default","100%":"1","50%":"2","33.3333333%":"3","25%":"4","20%":"5","16.666666666%":"6"},"selectors":{"{{WRAPPER}} .grid .grid-inner .grid-item":"--pxl-width: {{VALUE}};"}},{"name":"grid_items","label":"Columns Custom","type":"repeater","controls":[{"name":"grid_item_width","label":"Width","type":"slider","control_type":"responsive","size_units":["%","custom"],"range":{"px":{"min":0,"max":1000}},"default":{"unit":"%"},"selectors":{"{{WRAPPER}} .grid .grid-inner .grid-item{{CURRENT_ITEM}}":"--pxl-width: {{SIZE}}{{UNIT}};"}},{"name":"grid_item_height","label":"Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .grid .grid-inner .grid-item{{CURRENT_ITEM}}":"height: {{SIZE}}{{UNIT}};"}},{"name":"grid_item_img_dimension","label":"Image Dimension","type":"select","options":{"":"Default","thumbnail":"Thumbnail","thumb":"Thumb (Alias of Thumbnail)","medium":"Medium","medium_large":"Medium Large","large":"Large","full":"Full (Original)","custom":"Custom"},"default":""},{"name":"grid_item_img_dimension_custom","label":"Image Dimension Custom","type":"image_dimensions","separator":"before","description":"Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.","condition":{"grid_item_img_dimension":"custom"}}]}]}]}]},{"name":"tab_carousel_add_opts","label":"Additional Options","tab":"settings","condition":{"layout_type":"carousel","layout_post!":["post-1"]},"controls":[{"name":"swiper_controls","control_type":"tab","tabs":[{"name":"swiper_options","label":"Options","type":"tab","condition":{"layout_type":"carousel"},"controls":[{"name":"slide_boxshadow","label":"Slide with Box Shadow","type":"select","options":{"":"Default","swiper-normal":"No","swiper-boxshadow":"Yes"},"default":""},{"name":"effect","label":"Effect","type":"select","options":{"slide":"Slide","fade":"Fade"},"default":"slide"},{"name":"swiper_divider","type":"divider"},{"name":"allow_touch_move","label":"Allow Touch Move","type":"switcher","default":"true"},{"name":"autoplay","label":"Autoplay","type":"switcher","default":""},{"name":"disable_on_interaction","label":"Pause on Interaction","type":"switcher","default":"","condition":{"autoplay!":""}},{"name":"delay","label":"Delay","type":"number","default":3000,"condition":{"autoplay!":""}},{"name":"loop","label":"Infinite Loop","type":"switcher","default":""},{"name":"speed","label":"Animation Speed","type":"number","default":300,"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-container-fade":"--pxl-spacing-inline: {{VALUE}}ms;"}},{"name":"space_between","label":"Space Between(px)","type":"number","control_type":"responsive","condition":{"effect!":"fade"},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner":"--pxl-spacing-inline: {{VALUE}}px;"}},{"name":"swiper_pagination","type":"select","label":"Pagination","separator":"before","options":{"":"None","bullets":"Bullets","progressbar":"Progressbar","fraction":"Fraction"}},{"name":"swiper_navigation","label":"Navigation","type":"switcher","default":""},{"name":"use_swiper_nav_widget","label":"Use Navigation Widget","type":"switcher","default":"","condition":{"swiper_navigation!":""}},{"name":"nav_widget_id","type":"text","label":"Enter ID Your Widget Navigation","condition":{"swiper_navigation!":"","use_swiper_nav_widget!":""},"label_block":true,"description":"You need to enter the unique ID you created from the navigation carousel widget, and the navigation with this ID will function as a navigation carousel."},{"name":"nav_btn_icon_prev","label":"Button Icon Prev","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/uploads\/2025\/06\/arrow-left.svg","id":3614},"library":"svg"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}},{"name":"nav_btn_icon_next","label":"Button Icon Next","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/uploads\/2025\/06\/arrow-right.svg","id":3615},"library":"svg"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}},{"name":"nav_spacing_top","label":"Spacing Top","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation":"marrgin-top: {{SIZE}}{{UNIT}};"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}}]},{"name":"swiper_responsive","label":"Responsive","type":"tab","controls":[{"name":"custom_slides","label":"Custom Slides","type":"switcher","default":""},{"name":"slides_per_view_xs","label":"Slides Per View(&lt;576px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_sm","label":"Slides Per View(\u2265576px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_md","label":"Slides Per View(\u2265768px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_lg","label":"Slides Per View(\u2265992px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_xl","label":"Slides Per View(\u22651200px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"slides_per_view_xxl","label":"Slides Per View(\u22651400px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"slides","label":"Slides Per View Custom","type":"repeater","condition":{"custom_slides!":""},"controls":[{"name":"slide_width","label":"Width","type":"slider","control_type":"responsive","size_units":["%","custom"],"range":{"px":{"min":0,"max":1000}},"default":{"unit":"%"},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-slide{{CURRENT_ITEM}}":"flex: 0 1 {{SIZE}}{{UNIT}};"}},{"name":"slide_height","label":"Height","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-inner .swiper-slide{{CURRENT_ITEM}}":"height: {{SIZE}}{{UNIT}};"}},{"name":"slide_img_dimension","label":"Image Dimension","type":"select","options":{"":"Default","thumbnail":"Thumbnail","thumb":"Thumb (Alias of Thumbnail)","medium":"Medium","medium_large":"Medium Large","large":"Large","full":"Full (Original)","custom":"Custom"},"default":""},{"name":"slide_img_dimension_custom","label":"Image Dimension Custom","type":"image_dimensions","separator":"before","description":"Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.","condition":{"slide_img_dimension":"custom"}}]}]}]}]},{"name":"tab_general_style","label":"General","tab":"style","controls":[{"name":"feature_item_width","label":"Feature Item Width","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature":"flex:0 1 {{SIZE}}{{UNIT}};"},"condition":{"layout_post":["post-5"]}},{"name":"layout_width","label":"Layout Width","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-container":"flex:0 1 {{SIZE}}{{UNIT}};"},"condition":{"layout_type":"carousel","layout_post":["post-5"]}},{"name":"featured_spacing","label":"Featured Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-featured":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"title_spacing","label":"Title Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-title":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"category_spacing","label":"Category Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-category":"margin-bottom: {{SIZE}}{{UNIT}};"},"condition":{"show_category!":"","layout_post":["post-2"]}},{"name":"excerpt_spacing","label":"Excerpt Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-excerpt":"margin-bottom: {{SIZE}}{{UNIT}};"},"condition":{"show_excerpt!":"","layout_post":["post-1","post-2","post-5"]}},{"name":"meta_spacing","label":"Meta Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-meta":"margin-bottom: {{SIZE}}{{UNIT}};"},"condition":{"layout_post":["post-1","post-3","post-4","post-5"]}},{"name":"meta_gap","label":"Meta Gap","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-meta":"gap: {{SIZE}}{{UNIT}};"},"condition":{"layout_post":["post-1","post-3","post-4","post-5"]}},{"name":"meta_dot_size","label":"Meta Dot Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-meta svg":"width: {{SIZE}}{{UNIT}}; height: auto;"},"condition":{"layout_post":["post-1","post-4","post-5"]}},{"name":"meta_dot_color","label":"Meta Dot Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-meta svg":"color: {{VALUE}};"},"condition":{"layout_post":["post-1","post-4","post-5"]}},{"name":"feature_general_heading","type":"heading","label":"Feature Item","separator":"before","condition":{"layout_post":["post-5"]}},{"name":"feature_overlay","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-inner::before","condition":{"layout_post":["post-5"]}},{"name":"feature_date_spacing","label":"Date Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-date":"margin-bottom: {{SIZE}}{{UNIT}};"},"condition":{"layout_post":["post-5"]}},{"name":"feature_title_spacing","label":"Title Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-title":"margin-bottom: {{SIZE}}{{UNIT}};"},"condition":{"layout_post":["post-5"]}}]},{"name":"tab_box_style","label":"Box Item","tab":"style","controls":[{"name":"box_controls","control_type":"tab","tabs":[{"name":"box_normal","label":"Normal","type":"tab","controls":[{"name":"box_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-post .pxl-post-item"},{"name":"box_border","type":"border","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-post .pxl-post-item"},{"name":"box_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-item"},{"name":"box_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-item":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"box_hover","label":"Hover","type":"tabs","controls":[{"name":"box_hover_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-post .pxl-post-item:hover"},{"name":"_box_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-item:hover":"border-color: {{VALUE}};"}},{"name":"box_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-item:hover"},{"name":"box_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-item:hover"},{"name":"box_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-item:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]},{"name":"box_item_feature","label":"Item Feature","type":"heading","separator":"before","condition":{"layout_post":["post-5"]}},{"name":"box_feature_controls","control_type":"tab","condition":{"layout_post":["post-5"]},"tabs":[{"name":"box_feature_normal","label":"Normal","type":"tab","controls":[{"name":"box_feature_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-inner","condition":{"layout_post":["post-5"]}},{"name":"box_feature_border","type":"border","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-inner","condition":{"layout_post":["post-5"]}},{"name":"box_feature_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-inner","condition":{"layout_post":["post-5"]}},{"name":"box_feature_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"condition":{"layout_post":["post-5"]},"selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-inner":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"box_feature_hover","label":"Hover","type":"tabs","controls":[{"name":"box_feature_hover_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-inner:hover","condition":{"layout_post":["post-5"]}},{"name":"_box_feature_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-inner:hover":"border-color: {{VALUE}};"},"condition":{"layout_post":["post-5"]}},{"name":"box_feature_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-inner:hover","condition":{"layout_post":["post-5"]}},{"name":"box_feature_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-inner:hover","condition":{"layout_post":["post-5"]}},{"name":"box_feature_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"condition":{"layout_post":["post-5"]},"selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-inner:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_featured_style","label":"Post Featured","tab":"style","controls":[{"name":"featured_controls","control_type":"tab","tabs":[{"name":"featured_normal","label":"Normal","type":"tab","controls":[{"name":"featured_opacity","label":"Opacity","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-featured img":"opacity: {{SIZE}};"}},{"name":"featured_css_filters","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-featured img"},{"name":"featured_border","type":"border","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-post .pxl-post-featured"},{"name":"featured_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-featured"},{"name":"featured_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-featured":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"featured_hover","label":"Hover","type":"tabs","controls":[{"name":"featured_hover_style","label":"Hover Style","type":"select","options":{"hover-image-default":"Default","hover-image-parallax":"Parallax","hover-image-overlay-fade--x":"Overlay Fade X","hover-image-overlay-fade--y":"Overlay Fade Y","hover-image-flashing":"Flashing","hover-image-overlay-shine":"Shine"},"default":"hover-image-default"},{"name":"featured_hover_opacity","label":"Opacity","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-item:hover .pxl-post-featured img":"opacity: {{SIZE}};"}},{"name":"featured_hover_css_filters","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-item:hover .pxl-post-featured img"},{"name":"featured_hover_border","type":"border","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-post .pxl-post-item:hover .pxl-post-featured"},{"name":"featured_hover_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-item:hover .pxl-post-featured"},{"name":"featured_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-item:hover .pxl-post-featured":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_content_style","label":"Box Content","tab":"style","controls":[{"name":"box_content_heading","type":"heading","label":"Normal","condition":{"layout_post":["post-5"]}},{"name":"content_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-post .pxl-post-content"},{"name":"content_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-content"},{"name":"content_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-content"},{"name":"content_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-content":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"content_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-content":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"box_content_feature_heading","type":"heading","label":"Box Content Feature","separator":"before","condition":{"layout_post":["post-5"]}},{"name":"content_feature_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-content","condition":{"layout_post":["post-5"]}},{"name":"content_feature_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-content","condition":{"layout_post":["post-5"]}},{"name":"content_feature_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-content","condition":{"layout_post":["post-5"]}},{"name":"content_feature_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-content":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"condition":{"layout_post":["post-5"]}},{"name":"content_feature_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-content":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"condition":{"layout_post":["post-5"]}}]},{"name":"tab_title_style","label":"Post Title","tab":"style","controls":[{"name":"title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-title"},{"name":"title_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-title"},{"name":"title_controls","control_type":"tab","tabs":[{"name":"title_normal","label":"Normal","type":"tab","controls":[{"name":"title_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-title":"color: {{VALUE}};"}}]},{"name":"title_hover","label":"Hover","type":"tab","controls":[{"name":"title_hover_style","label":"Hover Style","type":"select","groups":[{"label":"Default","options":{"":"Default"}},{"label":"Underline","options":{"hover-text-underline":"Underline","hover-text-underline--slide-ltr":"Slide LTR","hover-text-underline--slide-rtl":"Slide RTL","hover-text-underline--expland":"Expand","hover-text-fill":"Fill"}}],"default":""},{"name":"title_underline_h","label":"Underline Weight(px)","type":"slider","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-item .pxl-post-title":"--pxl-height: {{SIZE}}{{UNIT}};"},"condition":{"title_hover_style":["hover-text-underline","hover-text-underline--slide-ltr","hover-text-underline--slide-rtl","hover-text-underline--expland"]}},{"name":"title_divider","type":"divider"},{"name":"title_hover_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-title:hover:not(.hover-text-fill)":"color: {{VALUE}};","{{WRAPPER}} .pxl-post .pxl-post-title.hover-text-fill":"--link-color-hover: {{VALUE}};"}}]}]},{"name":"feature_title_heading","type":"heading","label":"Feature Title","separator":"before","condition":{"layout_post":["post-5"]}},{"name":"feature_title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-title","condition":{"layout_post":["post-5"]}},{"name":"feature_title_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-title","condition":{"layout_post":["post-5"]}},{"name":"feature_title_controls","control_type":"tab","tabs":[{"name":"feature_title_normal","label":"Normal","type":"tab","controls":[{"name":"feature_title_color","label":"Text Color","type":"color","condition":{"layout_post":["post-5"]},"selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-title":"color: {{VALUE}};"}}]},{"name":"feature_title_hover","label":"Hover","type":"tab","controls":[{"name":"feature_title_hover_style","label":"Hover Style","type":"select","condition":{"layout_post":["post-5"]},"groups":[{"label":"Default","options":{"":"Default"}},{"label":"Underline","options":{"hover-text-underline":"Underline","hover-text-underline--slide-ltr":"Slide LTR","hover-text-underline--slide-rtl":"Slide RTL","hover-text-underline--expland":"Expand","hover-text-fill":"Fill"}}],"default":""},{"name":"feature_title_underline_h","label":"Underline Weight(px)","type":"slider","size_units":["px"],"condition":{"feature_title_hover_style":["hover-text-underline","hover-text-underline--slide-ltr","hover-text-underline--slide-rtl","hover-text-underline--expland"]},"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-item .pxl-post-title":"--pxl-height: {{SIZE}}{{UNIT}};"}},{"name":"feature_title_divider","type":"divider","condition":{"layout_post":["post-5"]}},{"name":"feature_title_hover_color","label":"Text Color","type":"color","condition":{"layout_post":["post-5"]},"selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-title:hover:not(.hover-text-fill)":"color: {{VALUE}};","{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-title.hover-text-fill":"--link-color-hover: {{VALUE}};"}}]}]}]},{"name":"tab_category_style","label":"Post Category","tab":"style","condition":{"show_category!":"","layout_post":["post-2","post-4","post-5","post-6","post-7"]},"controls":[{"name":"category_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-category > a"},{"name":"category_controls","control_type":"tab","tabs":[{"name":"category_normal","label":"Normal","type":"tab","controls":[{"name":"category_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-category > a":"color: {{VALUE}};"}},{"name":"category_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-post .pxl-post-category > a"},{"name":"category_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-category > a"},{"name":"category_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-category > a"},{"name":"category_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-category > a":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"category_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-category > a":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"category_hover","label":"Hover","type":"tab","controls":[{"name":"category_hover_color","label":"Link Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-category > a:hover":"color: {{VALUE}};"}},{"name":"category_hover_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-post .pxl-post-category > a:hover"},{"name":"category_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-category > a:hover"},{"name":"category_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-category > a:hover"},{"name":"category_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-category > a:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"category_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-category > a:hover":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_excerpt_style","label":"Post Excerpt","tab":"style","condition":{"show_excerpt!":"","layout_post":["post-1","post-2","post-5"]},"controls":[{"name":"excerpt_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-excerpt"},{"name":"excerpt_controls","control_type":"tab","tabs":[{"name":"excerpt_normal","label":"Normal","type":"tab","controls":[{"name":"excerpt_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-excerpt":"color: {{VALUE}};"}}]},{"name":"excerpt_hover","label":"Hover","type":"tab","controls":[{"name":"excerpt_hover_color","label":"Link Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-item:hover .pxl-post-excerpt":"color: {{VALUE}};"}}]}]}]},{"name":"tab_btn_style","label":"Post Button","tab":"style","controls":[{"name":"btn_h","label":"Height","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-button":"height: {{SIZE}}{{UNIT}};"}},{"name":"btn_controls","control_type":"tab","tabs":[{"name":"btn_normal","label":"Normal","type":"tab","controls":[{"name":"btn_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-button":"color: {{VALUE}};"}},{"name":"btn_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-post .pxl-post-button"},{"name":"btn_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-button"},{"name":"btn_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-button"},{"name":"btn_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-button":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"btn_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-button":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"btn_hover","label":"Hover","type":"tab","controls":[{"name":"btn_hover_style","label":"Hover Style","type":"select","default":"","options":{"":"Default","hover-underline-ltr":"Underline Slide LTR","hover-underline-rtl":"Underline Slide RTL","hover-underline-expand":"Underline Expand","hover-underline-split":"Underline Split"},"condition":{"layout_post":["post-2","post-3","post-4","post-5"]}},{"name":"btn_hover_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-button:hover":"color: {{VALUE}};"}},{"name":"btn_hover_background","type":"background","control_type":"group","types":["classic"],"selector":"{{WRAPPER}} .pxl-post .pxl-post-button:hover"},{"name":"btn_transition","label":"Transition(s)","type":"slider","size_units":["s"],"range":{"s":{"min":0,"max":20}},"default":{"unit":"s"},"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-button":"transition: all {{SIZE}}{{UNIT}} linear;"}},{"name":"btn_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-button:hover"},{"name":"btn_hover_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-button:hover"},{"name":"btn_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-button:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"btn_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-button:hover":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]},{"name":"feature_btn_heading","label":"Feature Button","type":"heading","separator":"before","condition":{"layout_post":["post-5"]}},{"name":"feature_btn_h","label":"Height","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-button":"height: {{SIZE}}{{UNIT}};"},"condition":{"layout_post":["post-5"]}},{"name":"feature_btn_controls","control_type":"tab","condition":{"layout_post":["post-5"]},"tabs":[{"name":"feature_btn_normal","label":"Normal","type":"tab","controls":[{"name":"feature_btn_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-button":"color: {{VALUE}};"}},{"name":"feature_btn_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-button"},{"name":"feature_btn_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-button"},{"name":"feature_btn_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-button"},{"name":"feature_btn_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-button":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"feature_btn_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-button":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"feature_btn_hover","label":"Hover","type":"tab","controls":[{"name":"feature_btn_hover_style","label":"Hover Style","type":"select","default":"","options":{"":"Default","hover-underline-ltr":"Underline Slide LTR","hover-underline-rtl":"Underline Slide RTL","hover-underline-expand":"Underline Expand","hover-underline-split":"Underline Split"},"condition":{"layout_post":["post-2","post-3","post-4","post-5"]}},{"name":"feature_btn_hover_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-button:hover":"color: {{VALUE}};"}},{"name":"feature_btn_hover_background","type":"background","control_type":"group","types":["classic"],"selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-button:hover"},{"name":"feature_btn_transition","label":"Transition(s)","type":"slider","size_units":["s"],"range":{"s":{"min":0,"max":20}},"default":{"unit":"s"},"selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-button":"transition: all {{SIZE}}{{UNIT}} linear;"}},{"name":"feature_btn_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-button:hover"},{"name":"feature_btn_hover_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-button:hover"},{"name":"feature_btn_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-button:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"feature_btn_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-button:hover":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_date_style","label":"Post Date","tab":"style","condition":{"show_date!":"","layout_post":["post-4","post-5","post-6","post-7"]},"controls":[{"name":"date_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-date"},{"name":"date_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-post-date":"color: {{VALUE}};"}},{"name":"date_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-post .pxl-post-date"},{"name":"date_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-date"},{"name":"date_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-post-date"},{"name":"date_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-date":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"date_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-post .pxl-post-date":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"date_day_typography","type":"typography","field_options":{"typography":{"label":"Day Typography"}},"control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-day"},{"name":"date_day_color","label":"Day Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-day":"color: {{VALUE}};"}},{"name":"date_month_typography","type":"typography","field_options":{"typography":{"label":"Month Typography"}},"control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-month"},{"name":"date_month_color","label":"Month Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-month":"color: {{VALUE}};"}},{"name":"feature_item_date_heading","type":"heading","label":"Feature Date","separator":"before"},{"name":"feature_date_box_size","label":"Box Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-date":"width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};"}},{"name":"feature_date_day_typography","type":"typography","field_options":{"typography":{"label":"Day Typography"}},"control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-date"},{"name":"feature_date_day_color","label":"Day Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-date .pxl-day":"color: {{VALUE}};"}},{"name":"feature_date_month_typography","type":"typography","field_options":{"typography":{"label":"Month Typography"}},"control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-month"},{"name":"feature_date_month_color","label":"Month Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-date":"color: {{VALUE}};"}},{"name":"feature_date_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-date"},{"name":"feature_date_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-date"},{"name":"feature_date_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-date"},{"name":"feature_date_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-date":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"feature_date_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-post .pxl-item-feature .pxl-item-date":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"tab_swiper_bullets_pagination_style","label":"Pagination Bullets","tab":"style","condition":{"swiper_pagination":"bullets"},"controls":[{"name":"bullet_size","label":"Bullet Size","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet":"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};"}},{"name":"bullet_dot_size","label":"Dot Inset","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:before":"inset: {{SIZE}}{{UNIT}};"}},{"name":"divider_bullet_1","type":"divider"},{"name":"bullet_controls","control_type":"tab","tabs":[{"name":"bullet_normal","label":"Normal","type":"tab","controls":[{"name":"bullet_color","label":"Bullet Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet":"color: {{VALUE}};"}},{"name":"bullet_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet"},{"name":"bullet_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet"},{"name":"bullet_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet"},{"name":"bullet_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"bullet_hover","label":"Hover\/Active","type":"tabs","controls":[{"name":"bullet_hove_color","label":"Bullet Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover":"color: {{VALUE}};"}},{"name":"_bullet_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover":"border-color: {{VALUE}};"}},{"name":"bullet_hover_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover"},{"name":"bullet_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover"},{"name":"bullet_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover"},{"name":"bullet_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_swiper_nav_btn_style","tab":"style","label":"Navigation Button","condition":{"swiper_navigation!":""},"controls":[{"name":"nav_btn_box_size","label":"Box Size","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, \n                    {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button":"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}};"}},{"name":"nav_btn_icon_size","label":"Icon Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button,\n                    {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button":"font-size: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button svg,\n                    {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button svg":"width: {{SIZE}}{{UNIT}}; height : auto;"}},{"name":"nav_btn_controls","control_type":"tab","tabs":[{"name":"nav_btn_normal","label":"Normal","type":"tab","controls":[{"name":"nav_btn_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button":"color: {{VALUE}};"}},{"name":"nav_btn_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button"},{"name":"nav_btn_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button"},{"name":"nav_btn_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button"},{"name":"nav_btn_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"nav_btn_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"nav_btn_hover","label":"Hover","type":"tabs","controls":[{"name":"nav_btn_hover_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover":"color: {{VALUE}};"}},{"name":"_nav_btn_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover":"border-color: {{VALUE}};"}},{"name":"nav_btn_hover_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover"},{"name":"nav_btn_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover"},{"name":"nav_btn_hover_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover"},{"name":"nav_btn_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"nav_btn_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-navigation .pxl-swiper-button:hover, {{WRAPPER}} .pxl-slider .swiper-navigation .pxl-swiper-button:hover":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"pxl_motion_effects","tab":"style","label":"Motion Effects","controls":[{"name":"entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":[]},{"name":"anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .grid .grid-item, {{WRAPPER}} .pxl-swiper .swiper-slide":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"entrance_anim!":["text-animated",""]}},{"name":"anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .grid .grid-item, {{WRAPPER}} .pxl-swiper .swiper-slide":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"entrance_anim!":["text-animated",""]}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'imagesloaded','pxl-post-grid','agron-effects' );
}