<?php

class PxlList_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_list';
    protected $title = 'Case List';
    protected $icon = 'eicon-editor-list-ul';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_list_content","label":"List","tab":"content","controls":[{"name":"_icon","label":"Icon","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"https:\/\/imagina.gb.net\/demo\/OMLPeru\/wp-content\/uploads\/2025\/05\/check.svg","id":357},"library":"svg"}},{"name":"items","label":"Items","type":"repeater","controls":[{"name":"text","label":"Text","type":"text","label_block":true}],"default":[{"text":"Lorem ipsum dolor sit"},{"text":"Lorem ipsum dolor sit"},{"text":"Lorem ipsum dolor sit"}],"title_field":"{{{text}}}"}]},{"name":"tab_list_style","label":"List","tab":"style","controls":[{"name":"flex_direction","label":"Direction","type":"choose","control_type":"responsive","options":{"row":{"title":"Row","icon":"eicon-arrow-right"},"column":{"title":"Column","icon":"eicon-arrow-down"}},"selectors":{"{{WRAPPER}} .pxl-list-wrapper":"flex-direction: {{VALUE}};"}},{"name":"flex_wrap","label":"Wrap","type":"choose","control_type":"responsive","options":{"wrap":{"title":"Wrap","icon":"eicon-wrap"},"nowrap":{"title":"Nowrap","icon":"eicon-nowrap"}},"selectors":{"{{WRAPPER}} .pxl-list-wrapper":"flex-wrap: {{VALUE}};"},"condition":{"flex_direction":"row"}},{"name":"justify_content_row","label":"Justify Content","type":"choose","separator":"before","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"selectors":{"{{WRAPPER}} .pxl-list-wrapper":"justify-content: {{VALUE}};"},"condition":{"flex_direction":"row"}},{"name":"item_align_items","label":"Item Vertical Align","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-align-start-v"},"center":{"title":"Center","icon":"eicon-align-center-v"},"end":{"title":"End","icon":"eicon-align-end-v"}},"selectors":{"{{WRAPPER}} .pxl-list-wrapper .pxl-list-item":"align-items: {{VALUE}};"}},{"name":"item_spacing","label":"Item Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-list-wrapper":"gap: {{SIZE}}{{UNIT}};"}},{"name":"icon_spacing","label":"Icon Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-list-wrapper .pxl-list-item":"gap: {{SIZE}}{{UNIT}};"}},{"name":"list_controls","control_type":"tab","tabs":[{"name":"text_normal","label":"Text","type":"tab","controls":[{"name":"text_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-list-wrapper .pxl-list-item":"color: {{VALUE}};"}},{"name":"typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-list-wrapper .pxl-list-item"}]},{"name":"icon_normal","label":"Icon","type":"tab","controls":[{"name":"icon_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-list-wrapper .pxl-list-item .pxl-item-icon":"color: {{VALUE}};"}},{"name":"icon_box_size","label":"Box Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"px":{"min":0,"max":2000},"selectors":{"{{WRAPPER}} .pxl-list-wrapper .pxl-list-item .pxl-item-icon":"width: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};"}},{"name":"icon_size","label":"Icon Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-list-wrapper .pxl-list-item svg":"height: {{SIZE}}{{UNIT}}; width: auto;","{{WRAPPER}} .pxl-list-wrapper .pxl-list-item .pxl-item-icon":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"icon_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-list-wrapper .pxl-list-item .pxl-item-icon"},{"name":"icon_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-list-wrapper .pxl-list-item .pxl-item-icon"},{"name":"icon_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-list-wrapper .pxl-list-item .pxl-item-icon"},{"name":"icon_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-list-wrapper .pxl-list-item .pxl-item-icon":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"icon_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-list-wrapper .pxl-list-item .pxl-item-icon":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"pxl_motion_effetcs","label":"Motion Effects","tab":"style","controls":[{"name":"entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":[]},{"name":"anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-list-wrapper .pxl-list-item":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"entrance_anim!":["text-animated",""]}},{"name":"anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-list-wrapper .pxl-list-item":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"entrance_anim!":["text-animated",""]}}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}