<?php

class PxlImageParallax_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_image_parallax';
    protected $title = 'Case Image Parallax';
    protected $icon = 'eicon-parallax';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_img_content","label":"Image","tab":"content","controls":[{"name":"img","label":"Choose Image","type":"media"},{"name":"img_size","label":"Image Size","type":"text","description":"Ex: &quot;thumbnail&quot;, &quot;medium&quot;, &quot;large&quot;, &quot;full&quot;...Alternatively enter size in pixels. Ex: 200x100 - Width x Height."},{"name":"link_url","label":"Link URL","type":"url"}]},{"name":"tab_img_style","label":"Image","tab":"style","controls":[{"name":"img_align","label":"Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"fa fa-align-left"},"center":{"title":"Center","icon":"fa fa-align-center"},"right":{"title":"Right","icon":"fa fa-align-right"}},"selectors":{"{{WRAPPER}} .pxl-image-wrapper":"text-align: {{VALUE}};"}},{"name":"img_w","label":"Width","type":"slider","control_type":"responsive","size_units":["px","%","custom"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-image-wrapper .pxl-image-item":"width: {{SIZE}}{{UNIT}};"}},{"name":"img_max_w","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","%","custom"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-image-wrapper .pxl-image-item:not(.scroll-parallax-item)":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"img_h","label":"Height","type":"slider","control_type":"responsive","size_units":["px","%","custom"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-image-wrapper .pxl-image-item:not(.scroll-parallax-item) img,\r\n                                {{WRAPPER}} .pxl-image-wrapper":"height: {{SIZE}}{{UNIT}};"}},{"name":"img_control","control_type":"tab","tabs":[{"name":"img_normal","label":"Normal","type":"tab","controls":[{"name":"img_opacity","label":"Opacity","type":"slider","control_type":"responsive","size_units":[""],"range":{"":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-image-wrapper .pxl-image-item":"opacity: {{SIZE}}{{UNIT}};"}},{"name":"img_css_filter","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-image-wrapper .pxl-image-item"},{"name":"img_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-image-wrapper .pxl-image-item"},{"name":"img_border","type":"border","control_type":"group","selector":"{{WRAPPER}} .pxl-image-wrapper .pxl-image-item"},{"name":"img_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-image-wrapper .pxl-image-item":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"img_padding","label":"Padding","type":"dimensions","size_units":["px","%"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-image-wrapper .pxl-image-item":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"img_hover","label":"Hover","type":"tab","controls":[{"name":"img_hover_opacity","label":"Opacity","type":"slider","control_type":"responsive","size_units":[""],"range":{"":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-image-wrapper .pxl-image-item":"opacity: {{SIZE}}{{UNIT}};"}},{"name":"img_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-image-wrapper .pxl-image-item:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_img_effect","label":"Effect","tab":"style","controls":[{"name":"img_effect","label":"Effect","type":"select","default":"","options":{"":"None","scroll-parallax":"Scroll Parallax"}},{"name":"parallax_opcity","label":"Opacity","type":"number","min":0,"max":1,"step":0.1,"condition":{"img_effect":"scroll-parallax"}},{"name":"parallax_translate_dir","label":"Translate Direction","type":"select","options":{"x":"X","y":"Y"},"default":"y"},{"name":"parallax_x","label":"TranslateX","type":"slider","size_units":["px"],"range":{"px":{"min":-1000,"max":1000}},"condition":{"parallax_translate_dir":"x"}},{"name":"parallax_y","label":"TranslateY","type":"slider","size_units":["px"],"range":{"px":{"min":-1000,"max":1000}},"condition":{"parallax_translate_dir":"y"}},{"name":"parallax_rotate","label":"Rotate","type":"number","min":-360,"max":360,"placeholder":"Ex: 50"},{"name":"parallax_scale","label":"Scale","type":"number","min":-2,"max":2,"step":0.1,"placeholder":"Ex: 1.2"}]},{"name":"tab_img_animation","label":"Animation","tab":"style","controls":[{"name":"entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Sliding","options":{"wow slideUp":"Slide Up","wow slideRight":"Slide Right","wow slideDown":"Slide Down","wow slideLeft":"Slide Left"}},{"label":"Rotating","options":{"wow rotateIn":"Rotate In","wow rotateInUp":"Rotate In Up","wow rotateInRight":"Rotate In Right","wow rotateInDown":"Rotate In Down","wow rotateInLeft":"Rotate In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal"}},{"label":"Reveal Image","options":{"wow revealImageIn":"Reveal In","wow revealImageInUp":"Reveal In Up","wow revealImageInRight":"Reveal In Right","wow revealImageInDown":"Reveal In Down","wow revealImageInLeft":"Reveal In Left","wow revealImageInVertical":"Reveal In Vertical","wow revealImageInHorizontal":"Reveal In Horizontal"}},{"label":"Rolling","options":{"wow rollingInTop":"Rolling In Top","wow rollingInRight":"Rolling In Right","wow rollingInBottom":"Rolling In Bottom","wow rollingInLeft":"Rolling In Left"}},{"label":"Rolling Bounce","options":{"wow rollingBounce ttb":"Rolling Bouce TTB","wow rollingBounce rtl":"Rolling Bouce RTL","wow rollingBounce btt":"Rolling Bouce BTT","wow rollingBounce ltr":"Rolling Bouce LTR","wow rollingIn right":"Rolling Right","wow rollingIn left":"Rolling Left"}}],"default":"","condition":[]},{"name":"anim_duration","label":"Animation Duration(ms)","type":"number","condition":{"entrance_anim!":""},"selectors":{"":"animation-duration: {{VALUE}}ms; --webkit-animation-duration: {{VALUE}}ms;"}},{"name":"anim_delay","label":"Animation Delay(ms)","type":"number","condition":{"entrance_anim!":""},"selectors":{"":"animation-delay: {{VALUE}}ms; --webkit-animation-delay: {{VALUE}}ms;"}}]},{"name":"tab_style_overlay","label":"Overlay","tab":"style","controls":[{"name":"show_overlay","label":"Overlay","type":"switcher","default":""},{"name":"overlay_bg","type":"background","types":["classic","gradient"],"control_type":"group","selector":"{{WRAPPER}} .pxl-image-single .pxl-item-overlay","condition":{"show_overlay!":""}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'parallax' );
}