<?php

class PxlIcon_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_icon';
    protected $title = 'Case Icon';
    protected $icon = 'eicon-favorite';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_icon_content","label":"Icon","tab":"content","controls":[{"name":"_icon","label":"Icon","type":"icons","fa4compatibility":"icon","default":{"value":"fas fa-star","library":"Font Awesome 5 Free"}},{"name":"icon_link","label":"Link","type":"url","label_block":true},{"name":"justify_content_row","label":"Justify Content","type":"choose","separator":"before","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"selectors":{"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item":"justify-content: {{VALUE}};"}}]},{"name":"tab_style_icon","label":"Icon","tab":"style","controls":[{"name":"box_size","label":"Box Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"px":{"min":0,"max":2000},"selectors":{"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item":"width: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};"}},{"name":"icon_size","label":"Icon Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"px":{"min":0,"max":2000},"selectors":{"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item svg":"width: {{SIZE}}{{UNIT}}; height: auto;","{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item ":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"icon_controls","control_type":"tab","tabs":[{"name":"icon_normal","label":"Normal","type":"tab","controls":[{"name":"icon_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item":"color: {{VALUE}};"}},{"name":"icon_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item"},{"name":"icon_opacity","label":"Opacity","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item":"opacity: {{SIZE}};"}},{"name":"icon_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item"},{"name":"icon_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item"},{"name":"icon_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"icon_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"icon_hover","label":"Hover","type":"tab","controls":[{"name":"icon_hover_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item:hover":"color: {{VALUE}};"}},{"name":"icon_hover_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item:hover"},{"name":"hover_animation","label":"Animation","type":"hover_animation"},{"name":"icon_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item:hover"},{"name":"icon_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item:hover"},{"name":"icon_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"icon_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item:hover":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"icon_hover_opacity","label":"Opacity","type":"slider","control_type":"responsive","separator":"before","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item:hover":"opacity: {{SIZE}};"}},{"name":"icon_transition","label":"Transition(s)","type":"slider","size_units":["s"],"range":{"s":{"min":0,"max":20}},"default":{"unit":"s"},"selectors":{"{{WRAPPER}} .pxl-icon-wrapper .pxl-icon-item":"transition: all {{SIZE}}{{UNIT}} linear;"}}]}]}]},{"name":"pxl_motion_effects","tab":"style","label":"Motion Effects","controls":[{"name":"entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":[]},{"name":"anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-icon-wrapper":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"entrance_anim!":["text-animated",""]}},{"name":"anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-icon-wrapper":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"entrance_anim!":["text-animated",""]}}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}