<?php

class PxlIconText_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_icon_text';
    protected $title = 'Case Icon Text';
    protected $icon = 'eicon-call-to-action';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_icon_content","label":"Icon Text","tab":"content","controls":[{"name":"_icon","label":"Icon","type":"icons","fa4compatibility":"icon","default":{"value":"fas fa-star","library":"Font Awesome 5 Free"}},{"name":"text","label":"Text","type":"text","label_block":true,"default":"lorem@dolorsit.com"},{"name":"link","label":"Link","type":"url","label_block":true},{"name":"icon_position","label":"Icon Position","type":"choose","control_type":"responsive","options":{"row-reverse":{"title":"Left","icon":"eicon-arrow-left"},"column":{"title":"Up","icon":"eicon-arrow-up"},"row":{"title":"Right","icon":"eicon-arrow-right"},"column-reverse":{"title":"Down","icon":"eicon-arrow-down"}},"selectors":{"{{WRAPPER}} .pxl-icon-text":"flex-direction: {{VALUE}};"}},{"name":"justify_content_row","label":"Justify Content","type":"choose","separator":"before","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"selectors":{"{{WRAPPER}} .pxl-icon-text":"justify-content: {{VALUE}};"}},{"name":"align_items_row","label":"Align Items","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-align-start-v"},"center":{"title":"Center","icon":"eicon-align-center-v"},"end":{"title":"End","icon":"eicon-align-end-v"}},"selectors":{"{{WRAPPER}} .pxl-icon-text":"align-items: {{VALUE}};"}},{"name":"text_align","label":"Alignment","type":"choose","control_type":"responsive","separator":"before","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"},"justify":{"title":"Justify","icon":"eicon-text-align-justify"}},"selectors":{"{{WRAPPER}} .pxl-icon-text":"text-align: {{VALUE}};"}}]},{"name":"tab_general_style","label":"General","tab":"style","controls":[{"name":"text_truncate","label":"Text Truncate","type":"switcher","default":"","description":"set max width for truncate to work"},{"name":"text_max_width","label":"Text Max Width","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-icon-text .pxl-text":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"icon_spacing","label":"Icon Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-icon-text":"gap: {{SIZE}}{{UNIT}};"}},{"name":"max_width","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-icon-text":"max-width: {{SIZE}}{{UNIT}};"}}]},{"name":"tab_box_style","label":"Box","tab":"style","controls":[{"name":"box_controls","control_type":"tab","tabs":[{"name":"box_normal","label":"Normal","type":"tab","controls":[{"name":"box_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-icon-text"},{"name":"box_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-text"},{"name":"box_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-text"},{"name":"box_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-icon-text":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"box_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-icon-text":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"box_hover","label":"Hover","type":"tab","controls":[{"name":"box_hover_background","type":"background","control_type":"group","types":["classic"],"selector":"{{WRAPPER}} .pxl-icon-text:hover"},{"name":"box_transition","label":"Transition(s)","type":"slider","size_units":["s"],"range":{"s":{"min":0,"max":20}},"default":{"unit":"s"},"selectors":{"{{WRAPPER}} .pxl-icon-text":"transition: all {{SIZE}}{{UNIT}} linear;"}},{"name":"box_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-text:hover"},{"name":"box_hover_box_shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-text:hover"},{"name":"box_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-icon-text:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"box_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-icon-text:hover":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_text_style","label":"Text","tab":"style","controls":[{"name":"text_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-text"},{"name":"text_controls","control_type":"tab","tabs":[{"name":"text_normal","label":"Normal","type":"tab","controls":[{"name":"text_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-icon-text":"color: {{VALUE}};"}}]},{"name":"text_hover","label":"Hover","type":"tab","controls":[{"name":"text_hover_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-icon-text:hover":"color: {{VALUE}};"}}]}]}]},{"name":"tab_icon_style","label":"Icon","tab":"style","controls":[{"name":"icon_sz","label":"Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-icon-text .pxl-icon":"font-size: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-icon-text .pxl-icon svg":"height: {{SIZE}}{{UNIT}}; width: auto;"}},{"name":"icon_box_sz","label":"Box Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-icon-text .pxl-icon":"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; min-width: {{SIZE}}{{UNIT}};"}},{"name":"icon_divider","type":"divider"},{"name":"icon_controls","control_type":"tab","tabs":[{"name":"icon_normal","label":"Normal","type":"tab","controls":[{"name":"icon_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-icon-text .pxl-icon":"color: {{VALUE}};"}},{"name":"icon_bg","type":"background","control_type":"group","types":["classic"],"exclude":["image"],"selector":"{{WRAPPER}} .pxl-icon-text .pxl-icon"},{"name":"icon_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-text .pxl-icon"},{"name":"icon_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-text .pxl-icon"},{"name":"icon_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-icon-text .pxl-icon":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"icon_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-icon-text .pxl-icon":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"icon_hover","label":"Hover","type":"tab","controls":[{"name":"icon_hover_animation","label":"Hover Animation","type":"select","options":{"":"None","hover-animation-flipX":"Flip X","hover-animation-flipY":"Flip Y","hover-animation-rotate-zoom-in":"Rotate Zoom","hover-animation-shrink-expand":"Shrink Expand","hover-animation-grow-normalize":"Grow Normalize"},"default":""},{"name":"icon_hover_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-icon-text:hover .pxl-icon":"color: {{VALUE}};"}},{"name":"icon_hover_bg","type":"background","control_type":"group","types":["classic"],"selector":"{{WRAPPER}} .pxl-icon-text:hover .pxl-icon"},{"name":"icon_box_transition","label":"Transition(s)","type":"slider","size_units":["s"],"range":{"s":{"min":0,"max":20}},"default":{"unit":"s"},"selectors":{"{{WRAPPER}} .pxl-icon-text .pxl-icon":"transition: all {{SIZE}}{{UNIT}} linear;"}},{"name":"icon_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-text:hover .pxl-icon"},{"name":"icon_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-icon-text:hover .pxl-icon"},{"name":"icon_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-icon-text:hover .pxl-icon":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"icon_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-icon-text:hover .pxl-icon":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"pxl_motion_effects","tab":"style","label":"Motion Effects","controls":[{"name":"entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":[]},{"name":"anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-icon-text":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"entrance_anim!":["text-animated",""]}},{"name":"anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-icon-text":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"entrance_anim!":["text-animated",""]}}]}]}';
    protected $styles = array(  );
    protected $scripts = array(  );
}