<?php

class PxlAccordion_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_accordion';
    protected $title = 'Case Accordion';
    protected $icon = 'eicon-accordion';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_accordion_content","label":"Accordion","tab":"content","controls":[{"name":"active","label":"Active","type":"number","min":1,"default":1},{"name":"title_tag","label":"Title HTML Tag","type":"select","default":"h6","options":{"h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","p":"p","span":"span"}},{"name":"items","label":"Items","type":"repeater","controls":[{"name":"title","label":"Title","type":"textarea","label_block":true,"rows":2,"default":"Accordion Title"},{"name":"content","type":"wysiwyg","default":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris tempus nisl vitae magna pulvinar laoreet nu llam erat ipsum, mattis nec mollis ac, accumsan a enim.","description":"Highlight text width shortcode: [highlight text=\"...\"]"}],"title_field":"{{{title}}}","default":[{"title":"Accordion Title","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris tempus nisl vitae magna pulvinar laoreet nu llam erat ipsum, mattis nec mollis ac, accumsan a enim."},{"title":"Accordion Title","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris tempus nisl vitae magna pulvinar laoreet nu llam erat ipsum, mattis nec mollis ac, accumsan a enim."},{"title":"Accordion Title","content":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris tempus nisl vitae magna pulvinar laoreet nu llam erat ipsum, mattis nec mollis ac, accumsan a enim."}]},{"name":"item_spacing","label":"Item Spacing","type":"slider","control_type":"responsive","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-item + .pxl-accordion-item":"margin-top: {{SIZE}}{{UNIT}};"}},{"name":"content_max_width","label":"Content Max Width","type":"slider","size_units":["px","custom"],"range":{"px":{"max":100}},"selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-content":"max-width: {{SIZE}}{{UNIT}};"}}]},{"name":"tab_box_item_style","label":"Box Item","tab":"style","controls":[{"name":"box_item_controls","control_type":"tab","tabs":[{"name":"box_item_normal","label":"Normal","type":"tab","controls":[{"name":"box_item_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-item"},{"name":"box_item_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-item"},{"name":"box_item_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-item"},{"name":"box_item_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-item":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"box_item_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-item":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"box_item_hover_active","label":"Hover\/Active","type":"tabs","controls":[{"name":"box_item_hover_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-item:hover, \r\n                                            {{WRAPPER}} .pxl-accordion .pxl-accordion-item.active"},{"name":"_box_item_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-item:hover, \r\n                                                {{WRAPPER}} .pxl-accordion .pxl-accordion-item.active":"border-color: {{VALUE}};"}},{"name":"box_item_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-item:hover, \r\n                                            {{WRAPPER}} .pxl-accordion .pxl-accordion-item.active"},{"name":"box_item_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-item:hover, \r\n                                            {{WRAPPER}} .pxl-accordion .pxl-accordion-item.active"},{"name":"box_item_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-item:hover, \r\n                                                {{WRAPPER}} .pxl-accordion .pxl-accordion-item.active":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"box_item_hover_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-item:hover, \r\n                                                {{WRAPPER}} .pxl-accordion .pxl-accordion-item.active":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_header_style","label":"Header","tab":"style","controls":[{"name":"header_controls","control_type":"tab","tabs":[{"name":"header_normal","label":"Normal","type":"tab","controls":[{"name":"header_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-item .pxl-accordion-header"},{"name":"header_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-item .pxl-accordion-header"},{"name":"header_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-item .pxl-accordion-header"},{"name":"header_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-item .pxl-accordion-header":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"header_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-item .pxl-accordion-header":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"header_hover_active","label":"Hover\/Active","type":"tabs","controls":[{"name":"header_hover_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-item:hover .pxl-accordion-header, \r\n                                            {{WRAPPER}} .pxl-accordion .pxl-accordion-item.active .pxl-accordion-header"},{"name":"_header_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-item:hover .pxl-accordion-header, \r\n                                                {{WRAPPER}} .pxl-accordion .pxl-accordion-item.active .pxl-accordion-header":"border-color: {{VALUE}};"}},{"name":"header_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-item:hover .pxl-accordion-header, \r\n                                            {{WRAPPER}} .pxl-accordion .pxl-accordion-item.active .pxl-accordion-header"},{"name":"header_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-item:hover .pxl-accordion-header, \r\n                                            {{WRAPPER}} .pxl-accordion .pxl-accordion-item.active .pxl-accordion-header"},{"name":"header_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-item:hover .pxl-accordion-header, \r\n                                                {{WRAPPER}} .pxl-accordion .pxl-accordion-item.active .pxl-accordion-header":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"header_hover_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-item:hover .pxl-accordion-header, \r\n                                                {{WRAPPER}} .pxl-accordion .pxl-accordion-item.active .pxl-accordion-header":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_title_style","label":"Accordion Title","tab":"style","controls":[{"name":"title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-header .pxl-accordion-title"},{"name":"title_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-header .pxl-accordion-title"},{"name":"title_controls","control_type":"tab","tabs":[{"name":"title_normal","label":"Normal","type":"tab","controls":[{"name":"title_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-header .pxl-accordion-title":"color: {{VALUE}};"}}]},{"name":"title_hover","label":"Hover\/Active","type":"tab","controls":[{"name":"title_hover_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-item.active .pxl-accordion-title,\r\n                                                {{WRAPPER}} .pxl-accordion .pxl-accordion-item:hover .pxl-accordion-title":"color: {{VALUE}};"}}]}]}]},{"name":"tab_icon_style","label":"Accordion Icon","tab":"style","controls":[{"name":"icon_size","label":"Icon Size","type":"slider","size_units":["px","custom"],"range":{"px":{"max":100}},"selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-header .pxl-accordion-icon":"height: {{SIZE}}{{UNIT}}; width: auto;"}},{"name":"icon_controls","control_type":"tab","tabs":[{"name":"icon_normal","label":"Normal","type":"tab","controls":[{"name":"icon_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-header .pxl-accordion-icon":"color: {{VALUE}};"}}]},{"name":"icon_hover","label":"Hover\/Active","type":"tab","controls":[{"name":"icon_hover_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-item.active .pxl-accordion-icon,\r\n                                                {{WRAPPER}} .pxl-accordion .pxl-accordion-item:hover .pxl-accordion-icon":"color: {{VALUE}};"}}]}]}]},{"name":"tab_content_style","label":"Content","tab":"style","controls":[{"name":"content_color","label":"Text Color","type":"color","separator":"before","selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-content p":"color: {{VALUE}};"}},{"name":"content_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-content p"},{"name":"content_background","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-accordion .pxl-accordion-content p"},{"name":"content_border_radius","label":"Border Radius","type":"dimensions","separator":"before","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-content p":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"content_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-content p":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"pxl_motion_effects","tab":"style","label":"Motion Effects","controls":[{"name":"entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}}],"default":"","condition":[]},{"name":"anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-item":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"entrance_anim!":["text-animated",""]}},{"name":"anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-accordion .pxl-accordion-item":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"entrance_anim!":["text-animated",""]}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'agron-accordion' );
}