<?php

if (!class_exists('Agron_Blog')) {

    class Agron_Blog
    {
        public function get_socials_share() { 
            $img_url = [0 => ''];
            if (has_post_thumbnail() && wp_get_attachment_image_src(get_post_thumbnail_id(), false)) {
                $img_url = wp_get_attachment_image_src(get_post_thumbnail_id(), false);
            }
            $single_post_social_vimeo = (bool)agron()->get_theme_opt( 'single_post_social_vimeo', true );
            $single_post_social_facebook = (bool)agron()->get_theme_opt( 'single_post_social_facebook', true );
            $single_post_social_instagram = (bool)agron()->get_theme_opt( 'single_post_social_instagram', true );
            $single_post_social_twitter = (bool)agron()->get_theme_opt( 'single_post_social_twitter', true );
            ?>
            <div class="pxl-post-socials">
                <h6 class="pxl-social-label"><?php echo esc_html__('Share:', 'agron'); ?></h6>
                <div class="pxl-social-list">
                    <?php if($single_post_social_vimeo) : ?>
                        <a class="pxl-social-item" title="<?php echo esc_attr__('Vimeo', 'agron'); ?>" target="_blank" href="https://vimeo.com/share?url=<?php echo urlencode(get_permalink()); ?>">
                            <svg width="13" height="11" viewBox="0 0 13 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M12.0003 0.979304C11.8891 0.852293 11.7542 0.757035 11.5954 0.693529C11.4525 0.614147 11.2938 0.55858 11.1191 0.526827C10.9445 0.495074 10.7698 0.487136 10.5952 0.503013C10.4206 0.503013 10.2539 0.510951 10.0951 0.526827C9.98395 0.542703 9.80138 0.606209 9.54735 0.717344C9.30921 0.828478 9.04725 0.987242 8.76147 1.19363C8.49157 1.40003 8.22961 1.66199 7.97559 1.97952C7.72157 2.28117 7.52312 2.65426 7.38023 3.0988C7.63425 3.08292 7.85652 3.08292 8.04704 3.0988C8.23755 3.11468 8.38838 3.16231 8.49951 3.24169C8.62652 3.32107 8.71384 3.44808 8.76147 3.62272C8.82498 3.78148 8.84085 3.99582 8.8091 4.26571C8.79323 4.37685 8.76941 4.49592 8.73766 4.62293C8.70591 4.73407 8.66621 4.85314 8.61859 4.98015C8.57096 5.10716 8.51539 5.23417 8.45188 5.36118C8.40425 5.47232 8.34869 5.59139 8.28518 5.7184C8.2058 5.86129 8.11054 6.02005 7.99941 6.19469C7.90415 6.36933 7.78508 6.52016 7.64219 6.64717C7.51518 6.77418 7.36435 6.84562 7.18971 6.8615C7.03095 6.87738 6.86425 6.78212 6.68961 6.57573C6.51497 6.40109 6.38002 6.19469 6.28476 5.95655C6.20538 5.70253 6.14187 5.44057 6.09424 5.17067C6.06249 4.90077 6.03074 4.63087 5.99898 4.36097C5.98311 4.0752 5.95929 3.82118 5.92754 3.59891C5.89579 3.47189 5.86403 3.34488 5.83228 3.21787C5.8164 3.07499 5.79259 2.9321 5.76084 2.78921C5.74496 2.64632 5.72115 2.50344 5.68939 2.36055C5.65764 2.21766 5.61795 2.07477 5.57032 1.93189C5.53857 1.82075 5.49094 1.70962 5.42743 1.59848C5.3798 1.47147 5.3163 1.36034 5.23692 1.26508C5.15754 1.16982 5.07022 1.0825 4.97496 1.00312C4.89557 0.923736 4.80825 0.868169 4.713 0.836416C4.60186 0.804664 4.48279 0.796725 4.35578 0.812602C4.24464 0.812602 4.12557 0.828478 3.99856 0.860231C3.88743 0.876107 3.77629 0.90786 3.66516 0.955489C3.5699 1.00312 3.48258 1.05075 3.4032 1.09838C3.16505 1.24126 2.93484 1.40003 2.71257 1.57467C2.50618 1.74931 2.29979 1.93189 2.09339 2.1224C1.887 2.29704 1.67267 2.47962 1.4504 2.67014C1.24401 2.84478 1.02174 3.01942 0.783594 3.19406V3.2655C0.862975 3.31313 0.918543 3.36076 0.950295 3.40839C0.997925 3.45602 1.02968 3.50365 1.04555 3.55128C1.07731 3.59891 1.10112 3.6386 1.117 3.67035C1.14875 3.7021 1.19638 3.72592 1.25988 3.74179C1.41865 3.75767 1.56947 3.74179 1.71236 3.69416C1.85525 3.64654 1.9902 3.60684 2.11721 3.57509C2.24422 3.54334 2.36329 3.54334 2.47443 3.57509C2.60144 3.59097 2.72051 3.67829 2.83165 3.83705C2.89515 3.94819 2.94278 4.05932 2.97453 4.17046C3.02216 4.26571 3.06185 4.36891 3.09361 4.48004C3.12536 4.59118 3.15711 4.70231 3.18886 4.81345C3.22062 4.92458 3.25237 5.03572 3.28412 5.14685C3.34763 5.28974 3.39526 5.44057 3.42701 5.59933C3.47464 5.74222 3.52227 5.89304 3.5699 6.05181C3.61753 6.21057 3.65722 6.37727 3.68897 6.55191C3.7366 6.71068 3.78423 6.86944 3.83186 7.0282C3.89536 7.31398 3.96681 7.63151 4.04619 7.98079C4.14145 8.31419 4.25258 8.63966 4.37959 8.95718C4.5066 9.25883 4.64949 9.53667 4.80825 9.79069C4.9829 10.0288 5.19723 10.1955 5.45125 10.2908C5.57826 10.3543 5.71321 10.3861 5.8561 10.3861C6.01486 10.3702 6.16569 10.3464 6.30857 10.3146C6.46734 10.2829 6.61022 10.2352 6.73723 10.1717C6.88012 10.1082 6.99919 10.0527 7.09445 10.005C7.34848 9.84626 7.58662 9.67956 7.80889 9.50492C8.04704 9.3144 8.2693 9.11595 8.4757 8.90955C8.69797 8.70316 8.89642 8.48883 9.07106 8.26656C9.26158 8.04429 9.44416 7.82202 9.6188 7.59975C10.0157 7.05996 10.365 6.52016 10.6666 5.98036C10.9842 5.42469 11.2461 4.90871 11.4525 4.43242C11.6748 3.94025 11.8494 3.51159 11.9764 3.14643C12.1034 2.78127 12.1828 2.51137 12.2146 2.33673C12.2305 2.20972 12.2384 2.09065 12.2384 1.97952C12.2543 1.8525 12.2543 1.73343 12.2384 1.6223C12.2384 1.51116 12.2146 1.40003 12.167 1.28889C12.1193 1.17776 12.0638 1.07456 12.0003 0.979304Z" fill="currentcolor"/>
                            </svg>
                        </a>
                    <?php endif; ?>
                    <?php if($single_post_social_facebook) : ?>
                        <a class="pxl-social-item" title="<?php echo esc_attr__('Facebook', 'agron'); ?>" target="_blank" href="http://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>">
                            <svg width="7" height="13" viewBox="0 0 7 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M6.23515 4.33719L6.02082 6.43287H4.32998V12.5294H1.82945V6.43287H0.567283V4.33719H1.80564V3.07502C1.80564 2.64636 1.84533 2.26532 1.92471 1.93192C2.01997 1.58264 2.17874 1.29686 2.401 1.07459C2.62327 0.836449 2.90111 0.653871 3.23451 0.52686C3.58379 0.399848 4.01246 0.336343 4.5205 0.336343H6.21133V2.43202H5.16349C4.9571 2.43202 4.79834 2.45584 4.6872 2.50347C4.57607 2.53522 4.48875 2.59079 4.42524 2.67017C4.37761 2.73368 4.34586 2.821 4.32998 2.93213C4.31411 3.02739 4.30617 3.14646 4.30617 3.28935V4.33719H6.21133H6.23515Z" fill="currentcolor"/>
                            </svg>
                        </a>
                    <?php endif; ?>
                    <?php if($single_post_social_instagram) : ?>
                        <a class="pxl-social-item" title="<?php echo esc_attr__('Instagram', 'agron'); ?>" target="_blank" href="https://www.instagram.com/?url=<?php the_permalink(); ?>">
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M9.48819 9.87816C9.9881 9.37825 10.2381 8.77503 10.2381 8.0685C10.2381 7.36197 9.9881 6.75875 9.48819 6.25885C8.98829 5.75894 8.38507 5.50899 7.67854 5.50899C6.97201 5.50899 6.36879 5.75894 5.86888 6.25885C5.36898 6.75875 5.11903 7.36197 5.11903 8.0685C5.11903 8.77503 5.36898 9.37825 5.86888 9.87816C6.36879 10.3781 6.97201 10.628 7.67854 10.628C8.38507 10.628 8.98829 10.3781 9.48819 9.87816ZM10.468 5.27903C11.2345 6.04555 11.6178 6.97538 11.6178 8.0685C11.6178 9.16163 11.2345 10.0915 10.468 10.858C9.70149 11.6245 8.77166 12.0078 7.67854 12.0078C6.58541 12.0078 5.65559 11.6245 4.88907 10.858C4.12255 10.0915 3.73929 9.16163 3.73929 8.0685C3.73929 6.97538 4.12255 6.04555 4.88907 5.27903C5.65559 4.51251 6.58541 4.12925 7.67854 4.12925C8.77166 4.12925 9.70149 4.51251 10.468 5.27903ZM12.4276 3.31941C12.6076 3.49937 12.6976 3.716 12.6976 3.96928C12.6976 4.22257 12.6076 4.43919 12.4276 4.61916C12.2477 4.79912 12.031 4.88911 11.7778 4.88911C11.5245 4.88911 11.3078 4.79912 11.1279 4.61916C10.9479 4.43919 10.8579 4.22257 10.8579 3.96928C10.8579 3.716 10.9479 3.49937 11.1279 3.31941C11.3078 3.13944 11.5245 3.04946 11.7778 3.04946C12.031 3.04946 12.2477 3.13944 12.4276 3.31941ZM8.43839 1.7697C7.97848 1.7697 7.7252 1.7697 7.67854 1.7697C7.63188 1.7697 7.37526 1.7697 6.90869 1.7697C6.44877 1.76304 6.09884 1.76304 5.85888 1.7697C5.61893 1.7697 5.29566 1.7797 4.88907 1.7997C4.48915 1.81303 4.14588 1.84635 3.85927 1.89968C3.57932 1.94633 3.3427 2.00632 3.1494 2.07964C2.81613 2.21295 2.52285 2.40625 2.26957 2.65953C2.01628 2.91282 1.82299 3.20609 1.68968 3.53936C1.61636 3.73266 1.55304 3.97262 1.49971 4.25923C1.45306 4.53917 1.41973 4.88244 1.39973 5.28903C1.3864 5.68896 1.3764 6.00889 1.36974 6.24885C1.36974 6.4888 1.36974 6.84207 1.36974 7.30865C1.3764 7.76856 1.37974 8.02185 1.37974 8.0685C1.37974 8.11516 1.3764 8.37178 1.36974 8.83836C1.36974 9.29827 1.36974 9.6482 1.36974 9.88816C1.3764 10.1281 1.3864 10.4514 1.39973 10.858C1.41973 11.2579 1.45306 11.6012 1.49971 11.8878C1.55304 12.1677 1.61636 12.4043 1.68968 12.5976C1.82299 12.9309 2.01628 13.2242 2.26957 13.4775C2.52285 13.7308 2.81613 13.9241 3.1494 14.0574C3.3427 14.1307 3.57932 14.194 3.85927 14.2473C4.14588 14.294 4.48915 14.3273 4.88907 14.3473C5.29566 14.3606 5.61893 14.3706 5.85888 14.3773C6.09884 14.3773 6.44877 14.3773 6.90869 14.3773C7.37526 14.3706 7.63188 14.3673 7.67854 14.3673C7.7252 14.3673 7.97848 14.3706 8.43839 14.3773C8.90497 14.3773 9.25824 14.3773 9.49819 14.3773C9.73815 14.3706 10.0581 14.3606 10.458 14.3473C10.8646 14.3273 11.2079 14.294 11.4878 14.2473C11.7744 14.194 12.0144 14.1307 12.2077 14.0574C12.5409 13.9241 12.8342 13.7308 13.0875 13.4775C13.3408 13.2242 13.5341 12.9309 13.6674 12.5976C13.7407 12.4043 13.8007 12.1677 13.8474 11.8878C13.9007 11.6012 13.934 11.2579 13.9473 10.858C13.9673 10.4514 13.9773 10.1281 13.9773 9.88816C13.984 9.6482 13.984 9.29827 13.9773 8.83836C13.9773 8.37178 13.9773 8.11516 13.9773 8.0685C13.9773 8.02185 13.9773 7.76856 13.9773 7.30865C13.984 6.84207 13.984 6.4888 13.9773 6.24885C13.9773 6.00889 13.9673 5.68896 13.9473 5.28903C13.934 4.88244 13.9007 4.53917 13.8474 4.25923C13.8007 3.97262 13.7407 3.73266 13.6674 3.53936C13.5341 3.20609 13.3408 2.91282 13.0875 2.65953C12.8342 2.40625 12.5409 2.21295 12.2077 2.07964C12.0144 2.00632 11.7744 1.94633 11.4878 1.89968C11.2079 1.84635 10.8646 1.81303 10.458 1.7997C10.0581 1.7797 9.73815 1.7697 9.49819 1.7697C9.25824 1.76304 8.90497 1.76304 8.43839 1.7697ZM15.3071 4.89911C15.3404 5.48566 15.3571 6.54213 15.3571 8.0685C15.3571 9.59488 15.3404 10.6513 15.3071 11.2379C15.2404 12.6243 14.8272 13.6974 14.0673 14.4573C13.3075 15.2171 12.2343 15.6304 10.8479 15.6971C10.2614 15.7304 9.20491 15.747 7.67854 15.747C6.15216 15.747 5.0957 15.7304 4.50914 15.6971C3.12274 15.6304 2.04961 15.2171 1.28975 14.4573C0.529899 13.6974 0.116644 12.6243 0.0499905 11.2379C0.0166635 10.6513 0 9.59488 0 8.0685C0 6.54213 0.0166635 5.48566 0.0499905 4.89911C0.116644 3.5127 0.529899 2.43957 1.28975 1.67972C2.04961 0.919863 3.12274 0.506608 4.50914 0.439955C5.0957 0.406628 6.15216 0.389964 7.67854 0.389964C9.20491 0.389964 10.2614 0.406628 10.8479 0.439955C12.2343 0.506608 13.3075 0.919863 14.0673 1.67972C14.8272 2.43957 15.2404 3.5127 15.3071 4.89911Z" fill="currentcolor"/>
                            </svg>
                        </a>
                    <?php endif; ?>
                    <?php if($single_post_social_twitter) : ?>
                        <a class="pxl-social-item" title="<?php echo esc_attr__('Twitter', 'agron'); ?>" target="_blank" href="https://twitter.com/intent/tweet?url=<?php echo urlencode(get_permalink()); ?>&text=<?php echo urlencode(get_the_title()); ?>">
                            <svg width="13" height="11" viewBox="0 0 13 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M11.1463 2.95591C11.1463 2.98767 11.1463 3.01942 11.1463 3.05117C11.1622 3.06705 11.1622 3.09086 11.1463 3.12261C11.1463 3.15437 11.1463 3.18612 11.1463 3.21787C11.1622 3.23375 11.1622 3.25756 11.1463 3.28932C11.1622 4.09901 11.0114 4.93252 10.6938 5.78985C10.3763 6.64717 9.9159 7.41717 9.3126 8.09986C8.72518 8.76667 7.98692 9.32234 7.09785 9.76688C6.20877 10.1955 5.19268 10.4019 4.04958 10.3861C3.68443 10.4019 3.33515 10.3861 3.00174 10.3384C2.66834 10.2749 2.33493 10.2035 2.00153 10.1241C1.66813 10.0288 1.3506 9.90977 1.04895 9.76688C0.763173 9.60811 0.477398 9.44935 0.191623 9.29059C0.255128 9.27471 0.302758 9.27471 0.33451 9.29059C0.382139 9.30646 0.437707 9.3144 0.501212 9.3144C0.564718 9.29853 0.612347 9.29853 0.6441 9.3144C0.691729 9.3144 0.747296 9.30646 0.810802 9.29059C1.09658 9.30646 1.38235 9.29059 1.66813 9.24296C1.9539 9.17945 2.2238 9.10801 2.47782 9.02863C2.73184 8.94924 2.97793 8.83811 3.21607 8.69522C3.47009 8.55234 3.7003 8.40151 3.9067 8.24275C3.6368 8.22687 3.37484 8.17924 3.12081 8.09986C2.86679 8.02048 2.63658 7.9014 2.43019 7.74264C2.23968 7.568 2.06504 7.38542 1.90627 7.19491C1.76338 6.98851 1.66019 6.75037 1.59668 6.48047C1.61256 6.51222 1.64431 6.5281 1.69194 6.5281C1.73957 6.51222 1.77926 6.51222 1.81101 6.5281C1.84277 6.54397 1.88246 6.55191 1.93009 6.55191C1.97772 6.53604 2.00947 6.53604 2.02534 6.55191C2.10473 6.53604 2.16823 6.53604 2.21586 6.55191C2.26349 6.55191 2.31906 6.54397 2.38256 6.5281C2.44607 6.51222 2.50164 6.50428 2.54926 6.50428C2.59689 6.48841 2.65246 6.47253 2.71597 6.45665C2.41432 6.40902 2.14442 6.30583 1.90627 6.14706C1.66813 5.9883 1.45379 5.80572 1.26328 5.59933C1.08864 5.39294 0.953689 5.15479 0.858431 4.88489C0.763173 4.59912 0.707605 4.31334 0.691729 4.02757C0.707605 3.99582 0.707605 3.98788 0.691729 4.00375C0.707605 3.98788 0.707605 3.97994 0.691729 3.97994C0.691729 3.97994 0.699667 3.972 0.715543 3.95612C0.779049 4.01963 0.858431 4.06726 0.953689 4.09901C1.04895 4.13076 1.13627 4.16252 1.21565 4.19427C1.31091 4.22602 1.4141 4.24984 1.52524 4.26571C1.63637 4.26571 1.73163 4.28159 1.81101 4.31334C1.66813 4.18633 1.5173 4.05138 1.35854 3.9085C1.21565 3.76561 1.09658 3.59891 1.00132 3.40839C0.921936 3.21787 0.850493 3.02736 0.786987 2.83684C0.723482 2.64632 0.699667 2.43199 0.715543 2.19385C0.699667 2.09859 0.699667 1.99539 0.715543 1.88426C0.747296 1.75725 0.771111 1.64611 0.786987 1.55085C0.81874 1.4556 0.858431 1.3524 0.90606 1.24126C0.953689 1.13013 1.00132 1.03487 1.04895 0.955489C1.36647 1.32065 1.70782 1.66199 2.07297 1.97952C2.45401 2.29704 2.86679 2.56694 3.31133 2.78921C3.75587 3.01148 4.21628 3.19406 4.69258 3.33695C5.16887 3.46396 5.67691 3.5354 6.21671 3.55128C6.18496 3.51952 6.16908 3.47983 6.16908 3.4322C6.18496 3.3687 6.18496 3.32107 6.16908 3.28932C6.1532 3.24169 6.14526 3.19406 6.14526 3.14643C6.14526 3.08292 6.13733 3.03529 6.12145 3.00354C6.13733 2.63839 6.20877 2.31292 6.33578 2.02714C6.46279 1.72549 6.63743 1.46353 6.8597 1.24126C7.09785 1.00312 7.36775 0.82054 7.6694 0.693529C7.97105 0.566518 8.29651 0.495074 8.64579 0.479198C8.82043 0.495074 8.99507 0.518889 9.16971 0.550642C9.34435 0.582394 9.50312 0.637962 9.64601 0.717344C9.80477 0.780849 9.95559 0.860231 10.0985 0.955489C10.2414 1.05075 10.3604 1.16188 10.4557 1.28889C10.6145 1.25714 10.7574 1.22539 10.8844 1.19363C11.0114 1.16188 11.1463 1.11425 11.2892 1.05075C11.4321 0.987242 11.5591 0.931675 11.6702 0.884046C11.7973 0.82054 11.9322 0.749096 12.0751 0.669714C12.0116 0.828478 11.9481 0.971366 11.8846 1.09838C11.8211 1.22539 11.7337 1.3524 11.6226 1.47941C11.5274 1.59054 11.4242 1.69374 11.313 1.789C11.2178 1.88426 11.0987 1.97952 10.9558 2.07477C11.0828 2.04302 11.2019 2.01921 11.313 2.00333C11.44 1.98745 11.567 1.96364 11.6941 1.93189C11.8211 1.88426 11.9401 1.84457 12.0513 1.81281C12.1624 1.78106 12.2815 1.72549 12.4085 1.64611C12.3132 1.789 12.218 1.91601 12.1227 2.02714C12.0433 2.13828 11.9401 2.25735 11.8131 2.38436C11.702 2.4955 11.5909 2.59869 11.4797 2.69395C11.3845 2.77333 11.2654 2.86859 11.1225 2.97973L11.1463 2.95591Z" fill="currentcolor"/>
                            </svg>
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <?php
        }

        public function get_tags() {
            ?>
            <div class="pxl-post-tags">
                <h6 class="pxl-tag-label">
                    <?php echo esc_html__('Tag:', 'agron'); ?>
                </h6>
                <div class="pxl-tag-list">
                    <?php echo wp_kses_post(get_the_tag_list()); ?>
                </div>
            </div>
            <?php
        }
    }
}
