<?php

class PxlPortfolio_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_portfolio';
    protected $title = 'Case Portfolio';
    protected $icon = 'eicon-post';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_layout","label":"Layout","tab":"layout","controls":[{"name":"post_type","label":"Current Post","type":"select","options":{"portfolio":"Portfolio"},"default":"portfolio"},{"name":"layout_type","label":"Layout Type","type":"select","options":{"grid":"Grid","carousel":"Carousel"},"default":"grid"},{"name":"layout1_style","label":"Layout Style","type":"select","options":{"layout-portfolio-default":"Default","layout-portfolio-style1":"Style 1"},"default":"layout-portfolio-default","condition":{"layout_portfolio":"portfolio-1"}},{"name":"layout_portfolio","label":"Select Template of Portfolio","type":"layoutcontrol","default":"portfolio-1","options":{"portfolio-1":{"label":"Layout 1","image":"http:\/\/agron.local\/wp-content\/themes\/agron\/elements\/templates\/pxl_portfolio\/img-layout\/portfolio-1.webp"},"portfolio-2":{"label":"Layout 2","image":"http:\/\/agron.local\/wp-content\/themes\/agron\/elements\/templates\/pxl_portfolio\/img-layout\/portfolio-2.webp"},"portfolio-3":{"label":"Layout 3","image":"http:\/\/agron.local\/wp-content\/themes\/agron\/elements\/templates\/pxl_portfolio\/img-layout\/portfolio-3.webp"},"portfolio-4":{"label":"Layout 4","image":"http:\/\/agron.local\/wp-content\/themes\/agron\/elements\/templates\/pxl_portfolio\/img-layout\/portfolio-4.webp"},"portfolio-5":{"label":"Layout 5","image":"http:\/\/agron.local\/wp-content\/themes\/agron\/elements\/templates\/pxl_portfolio\/img-layout\/portfolio-5.webp"}},"condition":{"post_type":["portfolio"]}}]},{"name":"tab_source","label":"Source","tab":"settings","controls":[{"name":"select_post_by","label":"Select posts by","type":"select","multiple":true,"options":{"term_selected":"Terms selected","post_selected":"Posts selected "},"default":"term_selected","description":"If using filter you need to Select posts by terms."},{"name":"source_portfolio","label":"Select Term of Portfolio","type":"select2","multiple":true,"options":[],"condition":{"post_type":["portfolio"],"select_post_by":"term_selected"}},{"name":"source_portfolio_post_ids","label":"Select posts","type":"select2","multiple":true,"options":[],"condition":{"post_type":["portfolio"],"select_post_by":"post_selected"}},{"name":"orderby","label":"Order By","type":"select","default":"date","options":{"date":"Date","ID":"ID","author":"Author","title":"Title","rand":"Random"}},{"name":"order","label":"Sort Order","type":"select","default":"desc","options":{"desc":"Descending","asc":"Ascending"}},{"name":"limit","label":"View Posts","type":"number","default":6}]},{"name":"tab_display_opts","label":"Display","tab":"settings","controls":[{"name":"img_dimension","label":"Image Dimension","type":"select","options":{"":"Default","thumbnail":"Thumbnail","thumb":"Thumb (Alias of Thumbnail)","medium":"Medium","medium_large":"Medium Large","large":"Large","full":"Full (Original)","custom":"Custom"},"default":"","condition":[]},{"name":"custom_img_dimension","label":"Dimension Custom","type":"image_dimensions","description":"Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.","condition":{"img_dimension":"custom"}},{"name":"title_tag","label":"Title HTML Tag","type":"select","options":{"":"Default","h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","p":"p","span":"span"},"default":""},{"name":"item_active","label":"Item Active","type":"number","condition":{"layout_portfolio":["portfolio-3"]}},{"name":"show_excerpt","label":"Show Excerpt","type":"switcher","separator":"before","default":"true","condition":{"layout_portfolio!":["portfolio-4","portfolio-1","portfolio-5"]}},{"name":"num_words","label":"Number of Words","type":"number","condition":{"show_excerpt!":"","layout_portfolio!":["portfolio-4","portfolio-1","portfolio-5"]}},{"name":"show_btn","label":"Show Button","type":"switcher","separator":"before","default":"true","condition":{"show_excerpt!":"","layout_portfolio!":["portfolio-1","portfolio-5"]}},{"name":"btn_text","label":"Button Text","type":"text","condition":{"show_btn!":"","layout_portfolio!":["portfolio-1","portfolio-4","portfolio-5"]}},{"name":"show_category","label":"Show Category","type":"switcher","separator":"before","default":"true","condition":{"layout_portfolio!":["portfolio-3"]}},{"name":"show_index","label":"Show Index","type":"switcher","default":"true","condition":{"layout_portfolio":["portfolio-2","portfolio-3"]}},{"name":"show_order","label":"Show Order","type":"switcher","default":"true","condition":{"layout_portfolio":["portfolio-2"]}}]},{"name":"tab_grid_add_opts","label":"Additional Options","tab":"settings","condition":{"layout_type":"grid"},"controls":[{"name":"grid_masonry","label":"Grid Masonry","type":"select","default":"","options":{"":"None","masonry":"Mansory","fitRows":"Fit Rows"},"description":"Use fit rows for layouts with the same height but different width"},{"name":"grid_sizer_width","label":"Grid Sizer Width","type":"slider","separator":"before","control_type":"responsive","size_units":["%","custom"],"default":{"size":"50","unit":"%"},"range":{"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-inner .grid-sizer":"flex: 0 0 {{SIZE}}{{UNIT}}; max-width: {{SIZE}}{{UNIT}};"},"condition":{"grid_masonry":"fitRows"}},{"name":"masonry_items","label":"Masonry Items","type":"repeater","condition":{"grid_masonry!":""},"controls":[{"name":"img_dimension_m","label":"Image Dimension","type":"select","options":{"thumbnail":"Thumbnail","thumb":"Thumb (Alias of Thumbnail)","medium":"Medium","medium_large":"Medium Large","large":"Large","full":"Full (Original)","custom":"Custom"},"default":"full"},{"name":"custom_img_dimension_m","label":"Dimension Custom","type":"image_dimensions","description":"Crop the original image size to any custom size. Set custom width or height to keep the original size ratio.","condition":{"img_dimension_m":"custom"}},{"name":"column_masonry","label":"Columm","type":"slider","separator":"before","control_type":"responsive","size_units":["%","px","custom"],"default":{"size":"50","unit":"%"},"range":{"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-item{{CURRENT_ITEM}}":"flex: 0 0 {{SIZE}}{{UNIT}}; max-width: {{SIZE}}{{UNIT}};"}},{"name":"height_masonry","label":"Height","type":"slider","separator":"before","control_type":"responsive","size_units":["%","px","custom"],"default":{"size":"auto","unit":"custom"},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-item{{CURRENT_ITEM}}":"height: {{SIZE}}{{UNIT}};"}}]},{"name":"divider_grid_1","type":"divider"},{"name":"filter","label":"Filter","type":"select","default":"disable","options":{"enable":"Enable","disable":"Disable"}},{"name":"filter_type","label":"Filter Type","type":"select","default":"normal","options":{"normal":"Normal","ajax":"Ajax"},"condition":{"filter":"enable"}},{"name":"filter_divider","type":"divider"},{"name":"grid_controls","control_type":"tab","tabs":[{"name":"grid_options","label":"Options","type":"tab","controls":[{"name":"grid_justify_content","label":"Justify Content","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-inner":"justify-content: {{VALUE}};"}},{"name":"spacing_inline","label":"Spacing Inline(px)","type":"slider","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-inner":"--pxl-spacing-inline: {{SIZE}}{{UNIT}};"}},{"name":"spacing_block","label":"Spacing Block(px)","type":"slider","control_type":"responsive","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-inner":"--pxl-spacing-block: {{SIZE}}{{UNIT}};"}},{"name":"grid_pagination","label":"Pagination","type":"select","separator":"before","default":"","options":{"":"Disable","pagination":"Pagination","loadmore":"Loadmore"}},{"name":"pagination_justify_content","label":"Justify Content","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-pagination .pxl-pagination-wrap":"justify-content: {{VALUE}};"},"condition":{"grid_pagination":"pagination"}},{"name":"pagination_gap","label":"Gap","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-pagination .pxl-pagination-wrap":"gap: {{SIZE}}{{UNIT}};"},"condition":{"grid_pagination":"pagination"}},{"name":"pagination_spacing","label":"Spacing Top","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-pagination":"margin-top: {{SIZE}}{{UNIT}};"},"condition":{"grid_pagination":"pagination"}},{"name":"load_more_style","label":"Load More Style","type":"select","options":{"load-more-button-default":"Default","pxl-btn-split":"Split Button"},"default":"load-more-button-default","condition":{"grid_pagination":"loadmore"}},{"name":"btn_load_more_justify_content","label":"Justify Content","type":"choose","control_type":"responsive","options":{"start":{"title":"Start","icon":"eicon-justify-start-h"},"center":{"title":"Center","icon":"eicon-justify-center-h"},"end":{"title":"End","icon":"eicon-justify-end-h"}},"condition":{"grid_pagination":"loadmore"},"selectors":{"{{WRAPPER}} .pxl-button-wrapper":"justify-content: {{VALUE}};"}},{"name":"load_more_icon","label":"Load More Icon","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"http:\/\/agron.local\/wp-content\/uploads\/2025\/02\/arrow-long-down.svg","id":10135},"library":"svg"},"condition":{"grid_pagination":"loadmore"}},{"name":"load_more_text","type":"text","label":"Load More Text","condition":{"grid_pagination":"loadmore","loadmore_style":"pxl-btn-split"}},{"name":"loadmore_spacing","label":"Load More Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-load-more-wrapper":"margin-top: {{SIZE}}{{UNIT}};"},"condition":{"grid_pagination":"loadmore"}},{"name":"show_divider_el","label":"Divider","type":"switcher","separator":"before","default":"","condition":{"grid_pagination":"loadmore"}},{"name":"divider_el_color","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-grid .pxl-load-more-wrapper:before, {{WRAPPER}} .pxl-grid .pxl-load-more-wrapper:after","condition":{"show_divider_el!":"","grid_pagination":"loadmore"}}]},{"name":"grid_responsive","label":"Responsive","type":"tab","condition":{"layout_type":"grid"},"controls":[{"name":"column_xs","label":"Column(&lt;576px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"column_sm","label":"Column(\u2265576px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"column_md","label":"Column(\u2265768px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"column_lg","label":"Column(\u2265992px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"column_xl","label":"Column(\u22651200px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"column_xxl","label":"Column(\u22651400px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}}]}]}]},{"name":"tab_swiper_add_otps","label":"Addtional Options","tab":"settings","condition":{"layout_type":"carousel"},"controls":[{"name":"swiper_controls","control_type":"tab","tabs":[{"name":"swiper_options","label":"Options","type":"tab","condition":{"layout_type":"carousel"},"controls":[{"name":"effect","label":"Effect","type":"select","options":{"slide":"Slide","fade":"Fade","cube":"Cube","coverflow":"Coverflow","flip":"Flip"},"default":"slide"},{"name":"swiper_divider","type":"divider"},{"name":"allow_touch_move","label":"Allow Touch Move","type":"switcher","default":"true"},{"name":"mousewheel","label":"Mousewheel","type":"switcher","default":""},{"name":"autoplay","label":"Autoplay","type":"switcher","default":""},{"name":"disable_on_interaction","label":"Pause on Interaction","type":"switcher","default":"","condition":{"autoplay!":""}},{"name":"delay","label":"Delay","type":"number","default":3000,"condition":{"autoplay!":""}},{"name":"loop","label":"Infinite Loop","type":"switcher","default":""},{"name":"speed","label":"Animation Speed","type":"number","default":300},{"name":"space_between","label":"Space Between","type":"number","default":0,"condition":{"effect!":"fade"}},{"name":"swiper_pagination","type":"select","label":"Pagination","separator":"before","options":{"":"None","bullets":"Bullets","progressbar":"Progressbar","fraction":"Fraction"}},{"name":"swiper_navigation","label":"Navigation","type":"switcher","default":""},{"name":"use_swiper_nav_widget","label":"Use Navigation Widget","type":"switcher","default":"","condition":{"swiper_navigation!":""}},{"name":"nav_id","type":"text","label":"Enter ID Your Navigation","condition":{"swiper_navigation!":"","use_swiper_nav_widget!":""},"description":"You need to enter the unique ID you created from the navigation carousel widget, and the navigation with this ID will function as a navigation carousel."},{"name":"swiper_nav_spacing","label":"Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .swiper-navigation":"margin-top: {{SIZE}}{{UNIT}};"}},{"name":"nav_btn_style","label":"Button Style","type":"select","options":{"swiper-button-default":"Default","swiper-button-primary":"Primary"},"default":"swiper-button-default","condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}},{"name":"nav_btn_icon_prev","label":"Button Icon Prev","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"http:\/\/agron.local\/wp-content\/uploads\/2024\/11\/arrow-long-left.svg","id":1046},"library":"svg"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}},{"name":"nav_btn_icon_next","label":"Button Icon Next","type":"icons","fa4compatibility":"icon","default":{"value":{"url":"http:\/\/agron.local\/wp-content\/uploads\/2024\/11\/arrow-long-right.svg","id":1047},"library":"svg"},"condition":{"swiper_navigation!":"","use_swiper_nav_widget":""}}]},{"name":"swiper_responsive","label":"Responsive","type":"tab","controls":[{"name":"slides_per_view","label":"Slides Per View","type":"select","default":"","options":{"":"Auto","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_xs","label":"Slides Per View(&lt;576px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_sm","label":"Slides Per View(\u2265576px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_md","label":"Slides Per View(\u2265768px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_lg","label":"Slides Per View(\u2265992px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","6":"6"}},{"name":"slides_per_view_xl","label":"Slides Per View(\u22651200px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}},{"name":"slides_per_view_xxl","label":"Slides Per View(\u22651400px)","type":"select","default":"","options":{"":"Default","1":"1","2":"2","3":"3","4":"4","5":"5","6":"6"}}]}]}]},{"name":"tab_general_style","label":"General","tab":"style","controls":[{"name":"title_spacing","label":"Title Spacing","type":"slider","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-title":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"featured_spacing","label":"Featured Spacing","type":"slider","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid:not(.pxl-layout-portfolio4) .pxl-post-content":"padding-bottom: {{SIZE}}{{UNIT}};"}}]},{"name":"tab_box_style","label":"Box","tab":"style","controls":[{"name":"box_height","label":"Height","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-layout-portfolio .pxl-post-item":"height: {{SIZE}}{{UNIT}};"}},{"name":"box_controls","control_type":"tab","tabs":[{"name":"box_normal","label":"Normal","type":"tab","controls":[{"name":"box_bg","type":"background","control_type":"group","types":["classic","gradient"],"fields_options":{"background":{"label":"Background"}},"selector":"{{WRAPPER}} .pxl-grid .pxl-post-item"},{"name":"box_backdrop_filter_blur","label":"Background Blur","type":"slider","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-item":"backdrop-filter: blur({{SIZE}}{{UNIT}});"}},{"name":"box_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-item"},{"name":"box_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-item"},{"name":"box_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-item":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"box_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-item":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"box_hover","label":"Hover\/Active","type":"tabs","controls":[{"name":"is_btn_as_cursor","type":"switcher","label":"Set button as mouse cursor","default":"","condition":{"layout_portfolio":["portfolio-4"]}},{"name":"box_content_follow_cursor","type":"switcher","label":"Box content follow cursor","default":"","condition":{"layout_portfolio":["portfolio-1","portfolio-5"]}},{"name":"box_hover_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-grid .pxl-post-item::before","fields_options":{"background":{"label":"Background"},"color":{"selectors":{"{{WRAPPER}} .pxl-layout-portfolio .pxl-post-item:hover, {{WRAPPER}} .pxl-layout-portfolio .pxl-post-item.active":"background-color: {{VALUE}};"}}}},{"name":"_box_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-item:hover, {{WRAPPER}} .pxl-grid .pxl-post-item.active":"border-color: {{VALUE}};"}},{"name":"box_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-item:hover, {{WRAPPER}} .pxl-grid .pxl-post-item.active"},{"name":"box_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-item:hover, {{WRAPPER}} .pxl-grid .pxl-post-item.active"},{"name":"box_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%","custom"],"selectors":{"{{WRAPPER}} .pxl-grid:not(.pxl-layout-portfolio3) .pxl-post-item:hover, {{WRAPPER}} .pxl-grid .pxl-post-item.active":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"box_hover_padding","label":"Padding","type":"dimensions","size_units":["px","%","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-item:hover, {{WRAPPER}} .pxl-grid .pxl-post-item.active":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_featured_style","label":"Featured","tab":"style","controls":[{"name":"featured_w","label":"Width","type":"slider","control_type":"responsive","size_units":["px","%","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-featured":"width: {{SIZE}}{{UNIT}};"}},{"name":"featured_max_w","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","%","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-featured":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"featured_h","label":"Height","type":"slider","control_type":"responsive","size_units":["px","%","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-featured":"height: {{SIZE}}{{UNIT}};"}},{"name":"featured_max_h","label":"Max Height","type":"slider","control_type":"responsive","size_units":["px","%","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-featured":"max-height: {{SIZE}}{{UNIT}};"}},{"name":"featured_divider","type":"divider"},{"name":"featured_controls","control_type":"tab","tabs":[{"name":"featured_normal","label":"Normal","type":"tab","controls":[{"name":"featured_opacity","label":"Opacity","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-featured":"opacity: {{SIZE}};"}},{"name":"featured_css_filter","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-featured"},{"name":"featured_border","type":"border","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-grid .pxl-post-featured"},{"name":"featured_box_shadow","type":"box-shadow","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-grid .pxl-post-featured"},{"name":"featured_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-featured":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"featured_padding","label":"Padding","type":"dimensions","size_units":["px","%"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-featured":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"featured_hover","label":"Hover\/Active","type":"tab","controls":[{"name":"featured_hover_style","label":"Hover Style","type":"select","options":{"hover-image-default":"Default","hover-image-zoom-in":"Zoom In","hover-tilt":"Tilt","hover-image-distortion-transition":"Distortion Transition","hover-image-distortion-warp":"Distortion Warp","hover-image-distortion-wave":"Distortion Wave","hover-image-parallax":"Parallax"},"default":"hover-image-default"},{"name":"displacement_img","label":"Displacement Image","type":"media","default":{"url":"http:\/\/agron.local\/wp-content\/uploads\/2025\/01\/displacement-4.webp","id":9031},"condition":{"featured_hover_style":"hover-image-distortion-transition"}},{"name":"featured_zoom_in_val","label":"Zoom Value","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":1,"max":3,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-featured":"--pxl-scale: {{SIZE}};"},"condition":{"featured_hover_style":"hover-image-zoom-in"}},{"name":"featured_hover_h","label":"Height","type":"slider","size_units":["px","custom"],"separator":"before","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-featured, \r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-featured":"height: {{SIZE}}{{UNIT}};"}},{"name":"featured_hover_max_w","label":"Max Width","type":"slider","size_units":["px","%","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-featured, \r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-featured":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"featured_hover_opacity","label":"Opacity","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":1,"step":0.01}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-featured, {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-featured":"opacity: {{SIZE}};"}},{"name":"featured_hover_css_filter","type":"css-filter","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-featured, {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-featured"},{"name":"featured_hover_border","type":"border","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-featured, {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-featured"},{"name":"featured_hover_box_shadow","type":"box-shadow","control_type":"group","separator":"before","selector":"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-featured, {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-featured"},{"name":"featured_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-grid:not(.pxl-layout-portfolio4) .pxl-post-item:hover .pxl-post-featured, \r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-featured":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"featured_hover_padding","label":"Padding","type":"dimensions","size_units":["px","%"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-featured, {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-featured":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_title_style","label":"Title","tab":"style","controls":[{"name":"title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-title"},{"name":"title_controls","control_type":"tab","tabs":[{"name":"title_normal","label":"Normal","type":"tab","controls":[{"name":"title_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-title, \r\n                                                    {{WRAPPER}} .pxl-grid .pxl-post-title.hover-3d-cube-flip:before":"color: {{VALUE}};"}},{"name":"title_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-title"},{"name":"title_text_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-title"}]},{"name":"title_hover","label":"Hover\/Active","type":"tab","controls":[{"name":"title_hover_style","label":"Hover Style","type":"select","groups":[{"label":"Default","options":{"hover-text-default":"Default"}},{"label":"Underline","options":{"hover-text-underline":"Underline","hover-text-underline--slide-ltr":"Slide LTR","hover-text-underline--slide-rtl":"Slide RTL"}},{"label":"Other","options":{"hover-3d-cube-flip":"3D Flip","hover-text-fill":"Text Fill"}}],"default":"hover-text-default"},{"name":"underline_h","label":"Underline Weight(px)","type":"slider","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-title":"--pxl-height: {{SIZE}}{{UNIT}};"},"condition":{"title_hover_style":["hover-text-underline"]}},{"name":"title_divider","type":"divider"},{"name":"title_hover_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-title:not(.hover-3d-cube-flip):not(.hover-text-fill),\r\n                                                    {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-title:not(.hover-3d-cube-flip):not(.hover-text-fill),\r\n                                                    {{WRAPPER}} .pxl-grid .pxl-post-title.hover-3d-cube-flip:after":"color: {{VALUE}};","{{WRAPPER}} .pxl-grid .pxl-post-item .hover-text-fill":"--link-color-hover: {{VALUE}};"}},{"name":"title_hover_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-title,\r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-title"},{"name":"title_hover_text_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-title,\r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-title"}]}]}]},{"name":"tab_excerpt_style","label":"Excerpt","tab":"style","condition":{"show_excerpt!":"","layout_portfolio!":["portfolio-4","portfolio-1","portfolio-5"]},"controls":[{"name":"excerpt_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-excerpt"},{"name":"excerpt_controls","control_type":"tab","tabs":[{"name":"excerpt_normal","label":"Normal","type":"tab","controls":[{"name":"excerpt_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-excerpt":"color: {{VALUE}};"}},{"name":"excerpt_text_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-excerpt"}]},{"name":"excerpt_hover","label":"Hover\/Active","type":"tab","controls":[{"name":"excerpt_hover_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-excerpt, \r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-excerpt":"color: {{VALUE}};"}},{"name":"excerpt_hover_text_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-excerpt, \r\n                                            {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-excerpt"}]}]}]},{"name":"tab_index_style","label":"Index","tab":"style","condition":{"show_index!":"","layout_portfolio!":["portfolio-4","portfolio-1","portfolio-5"]},"controls":[{"name":"index_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-index"},{"name":"index_controls","control_type":"tab","tabs":[{"name":"index_normal","label":"Normal","type":"tab","controls":[{"name":"index_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-index":"color: {{VALUE}};"}},{"name":"index_text_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-index"}]},{"name":"index_hover","label":"Hover\/Active","type":"tab","controls":[{"name":"index_hover_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-index, \r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-index":"color: {{VALUE}};"}},{"name":"index_hover_text_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-index, \r\n                                            {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-index"}]}]}]},{"name":"tab_order_style","label":"Order","tab":"style","condition":{"show_order!":"","layout_portfolio!":["portfolio-4","portfolio-3","portfolio-1","portfolio-5"]},"controls":[{"name":"order_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-order"},{"name":"order_controls","control_type":"tab","tabs":[{"name":"order_normal","label":"Normal","type":"tab","controls":[{"name":"order_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-order":"color: {{VALUE}};"}},{"name":"order_text_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-order"}]},{"name":"order_hover","label":"Hover\/Active","type":"tab","controls":[{"name":"order_hover_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-order, \r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-order":"color: {{VALUE}};"}},{"name":"order_hover_text_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-item:hover .pxl-post-order, \r\n                                            {{WRAPPER}} .pxl-grid .pxl-post-item.active .pxl-post-order"}]}]}]},{"name":"tab_category_style","label":"Category","tab":"style","condition":{"show_category!":"","layout_portfolio!":["portfolio-3"]},"controls":[{"name":"category_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-category"},{"name":"category_text_shadow","label":"Text Shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-category"},{"name":"category_controls","control_type":"tab","tabs":[{"name":"category_normal","label":"Normal","type":"tab","controls":[{"name":"category_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-category > a":"color: {{VALUE}};"}},{"name":"category_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-grid .pxl-post-category > a"},{"name":"cateogry_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-category > a"},{"name":"cateogry_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-category > a"},{"name":"cateogry_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%"],"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-category > a":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"cateogry_padding","label":"Padding","type":"dimensions","size_units":["px","%"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-category > a":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"category_hover","label":"Hover","type":"tab","controls":[{"name":"category_hover_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-category > a:hover,\r\n                                                {{WRAPPER}} .pxl-grid .hover-parent:hover .pxl-post-category > a":"color: {{VALUE}};"}},{"name":"category_hover_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-grid .pxl-post-category > a:hover,\r\n                                                {{WRAPPER}} .pxl-grid .hover-parent:hover .pxl-post-category > a"},{"name":"category_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-category > a:hover,\r\n                                                {{WRAPPER}} .pxl-grid .hover-parent:hover .pxl-post-category > a"},{"name":"category_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-category > a:hover,\r\n                                                {{WRAPPER}} .pxl-grid .hover-parent:hover .pxl-post-category > a"},{"name":"category_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%"],"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-category > a:hover,\r\n                                                {{WRAPPER}} .pxl-grid .hover-parent:hover .pxl-post-category > a":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"category_hover_padding","label":"Padding","type":"dimensions","size_units":["px","%"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-category > a:hover,\r\n                                                {{WRAPPER}} .pxl-grid .hover-parent:hover .pxl-post-category > a":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_btn_style","label":"Button","tab":"style","condition":{"show_btn!":"","layout_portfolio!":["portfolio-1","portfolio-5"]},"controls":[{"name":"btn_box_size","label":"Box Size","type":"slider","size_units":["px","custom"],"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-btn":"--pxl-box-size: {{SIZE}}{{UNIT}};"},"condition":{"layout_portfolio":["portfolio-4"]}},{"name":"btn_h","label":"Height","type":"slider","size_units":["px","%","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"condition":{"layout_portfolio!":["portfolio-4"]},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-btn":"height: {{SIZE}}{{UNIT}};--pxl-height: {{SIZE}}{{UNIT}};"}},{"name":"btn_icon_sz","label":"Icon Size","type":"slider","size_units":["px","%","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-btn i ":"font-size: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-grid .pxl-post-btn svg":"width: {{SIZE}}{{UNIT}}; height: auto;"}},{"name":"btn_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-btn"},{"name":"btn_text_shadow","label":"Text Shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-btn"},{"name":"btn_control","control_type":"tab","tabs":[{"name":"btn_normal","label":"Normal","type":"tab","controls":[{"name":"btn_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-btn":"color: {{VALUE}};"}},{"name":"btn_icon_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-btn .pxl-btn-icon":"color: {{VALUE}};"}},{"name":"btn_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-grid .pxl-post-btn:not(.pxl-btn-split), \r\n                                            {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split .pxl-btn-icon, \r\n                                            {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split .pxl-btn-text"},{"name":"btn_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-btn:not(.pxl-btn-split), \r\n                                            {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split .pxl-btn-icon, \r\n                                            {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split .pxl-btn-text"},{"name":"btn_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-btn:not(.pxl-btn-split),\r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split .pxl-btn-text,\r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split .pxl-btn-icon"},{"name":"btn_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%"],"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-btn:not(.pxl-btn-split),\r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split .pxl-btn-text,\r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split .pxl-btn-icon":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"btn_padding","label":"Padding","type":"dimensions","size_units":["px","%"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-btn:not(.pxl-btn-split), \r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split .pxl-btn-text":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"btn_hover","label":"Hover","type":"tab","controls":[{"name":"btn_hover_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-btn:hover, \r\n                                                {{WRAPPER}} .pxl-grid:not(.pxl-layout-portfolio) .hover-parent:hover .pxl-post-btn":"color: {{VALUE}};"}},{"name":"btn_hover_icon_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-btn:hover .pxl-btn-icon":"color: {{VALUE}};"}},{"name":"_btn_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-btn:not(.pxl-btn-split):hover,\r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split:hover .pxl-btn-icon, \r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split:hover .pxl-btn-text":"border-color: {{VALUE}};"}},{"name":"btn_hover_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-grid .pxl-post-btn:not(.pxl-btn-split):hover, \r\n                                            {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split:hover .pxl-btn-icon, \r\n                                            {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split:hover .pxl-btn-text"},{"name":"btn_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-btn:not(.pxl-btn-split):hover, \r\n                                            {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split:hover .pxl-btn-icon, \r\n                                            {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split:hover .pxl-btn-text"},{"name":"btn_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-post-btn:not(.pxl-btn-split):hover, \r\n                                            {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split:hover .pxl-btn-icon, \r\n                                            {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split:hover .pxl-btn-text"},{"name":"btn_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","%"],"selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-btn:not(.pxl-btn-split):hover, \r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split:hover .pxl-btn-icon, \r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split:hover .pxl-btn-text":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"btn_hover_padding","label":"Padding","type":"dimensions","size_units":["px","%"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-grid .pxl-post-btn:not(.pxl-btn-split):hover, \r\n                                                {{WRAPPER}} .pxl-grid .pxl-post-btn.pxl-btn-split:hover .pxl-btn-text":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_load_more_btn_style","tab":"style","label":"Load More","condition":{"grid_pagination":"loadmore"},"controls":[{"name":"btn_load_more_icon_translate_y","label":"Icon Translate Y","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"condition":{"load_more_style":["load-more-button-default"]},"selectors":{"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button":"--pxl-translate-y: {{SIZE}}{{UNIT}};"}},{"name":"btn_load_more_icon_sz","label":"Icon Size","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":1000}},"selectors":{"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button .pxl-btn-icon":"font-size: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button .pxl-btn-icon svg":"height: {{SIZE}}{{UNIT}}; width : auto;"}},{"name":"btn_load_more_h","label":"Height","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"condition":{"load_more_style":["pxl-btn-split"]},"selectors":{"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button":"height: {{SIZE}}{{UNIT}};--pxl-height: {{SIZE}}{{UNIT}};"}},{"name":"btn_load_more_box_size","label":"Box Size","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":1000}},"condition":{"load_more_style":["load-more-button-default"]},"selectors":{"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button":"--pxl-box-size: {{SIZE}}{{UNIT}};"}},{"name":"btn_load_more_divider2","type":"divider"},{"name":"btn_load_more_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button"},{"name":"btn_load_more_text_shadow","label":"Text Shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button"},{"name":"btn_load_more_controls","control_type":"tab","tabs":[{"name":"btn_load_more_normal","label":"Normal","type":"tab","controls":[{"name":"btn_load_more_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button":"color: {{VALUE}};"}},{"name":"btn_load_more_icon_border_style","label":"Border Style","type":"select","default":"","options":{"":"Default","none":"None","solid":"Solid","dashed":"Dashed","dotted":"Dotted","double":"Double"},"condition":{"load_more_style":["load-more-button-default"]},"selectors":{"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button":"border-style: {{VALUE}};"}},{"name":"btn_load_more_border_color","label":"Border Color","type":"color","condition":{"load_more_style":["load-more-button-default"]},"selectors":{"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button":"border-top-color: {{VALUE}};border-right-color: {{VALUE}};"}},{"name":"btn_load_more_border_inner_color","label":"Border Inner Color","type":"color","condition":{"load_more_style":["load-more-button-default"]},"selectors":{"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button:before":"border-color: {{VALUE}};"}},{"name":"btn_load_more_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button:not(.pxl-btn-split),\n                                {{WRAPPER}} .pxl-load-more-wrapper .btn.pxl-btn-split .pxl-btn-icon, \n                                {{WRAPPER}} .pxl-load-more-wrapper .btn.pxl-btn-split .pxl-btn-text"},{"name":"_btn_load_more_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button:not(.pxl-btn-split),\n                                {{WRAPPER}} .pxl-load-more-wrapper .btn.pxl-btn-split .pxl-btn-icon, \n                                {{WRAPPER}} .pxl-load-more-wrapper .btn.pxl-btn-split .pxl-btn-text"},{"name":"btn_load_more_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button:not(.pxl-btn-split),\n                                {{WRAPPER}} .pxl-load-more-wrapper .btn.pxl-btn-split .pxl-btn-icon, \n                                {{WRAPPER}} .pxl-load-more-wrapper .btn.pxl-btn-split .pxl-btn-text"},{"name":"btn_load_more_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button:not(.pxl-btn-split),\n                                    {{WRAPPER}} .pxl-load-more-wrapper .btn.pxl-btn-split .pxl-btn-icon, \n                                    {{WRAPPER}} .pxl-load-more-wrapper .btn.pxl-btn-split .pxl-btn-text":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"btn_load_more_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button:not(.pxl-btn-split),\n                                    {{WRAPPER}} .pxl-load-more-wrapper .btn.pxl-btn-split .pxl-btn-text":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"btn_load_more_hover","label":"Hover","type":"tabs","controls":[{"name":"btn_load_more_hover_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button:hover":"color: {{VALUE}};"}},{"name":"btn_load_more_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-load-more-wrapper .load-more-button-default:hover":"border-top-color: {{VALUE}};border-right-color: {{VALUE}};"}},{"name":"btn_load_more_hover_border_inner_color","label":"Border Inner Color","type":"color","condition":{"load_more_style":["load-more-button-default"]},"selectors":{"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button:hover:before":"border-color: {{VALUE}};"}},{"name":"btn_load_more_hover_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button:hover"},{"name":"btn_load_more_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button:hover"},{"name":"btn_load_more_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}},{"name":"btn_load_more_hover_padding","label":"Padding","type":"dimensions","size_units":["px","custom"],"control_type":"responsive","separator":"before","selectors":{"{{WRAPPER}} .pxl-load-more-wrapper .pxl-load-more-button:hover":"padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_grid_pagination_style","label":"Pagination","tab":"style","condition":{"grid_pagination":"pagination"},"controls":[{"name":"pagination_box_sz","label":"Box Size","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-pagination .pxl-pagination-wrap .page-numbers":"--pxl-box-size: {{SIZE}}{{UNIT}};"}},{"name":"pagination_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-grid-pagination .pxl-pagination-wrap .page-numbers"},{"name":"divider_pagination_1","type":"divider"},{"name":"pagination_controls","control_type":"tab","tabs":[{"name":"pagination_normal","label":"Normal","type":"tab","controls":[{"name":"pagination_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-pagination .pxl-pagination-wrap .page-numbers":"color: {{VALUE}};"}},{"name":"pagination_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-grid .pxl-grid-pagination .pxl-pagination-wrap .page-numbers"},{"name":"pagination_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-grid-pagination .pxl-pagination-wrap .page-numbers"},{"name":"pagination_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-grid-pagination .pxl-pagination-wrap .page-numbers"},{"name":"pagination_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-pagination .pxl-pagination-wrap .page-numbers":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"pagination_hover","label":"Hover\/Current","type":"tabs","controls":[{"name":"pagination_hove_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-pagination .pxl-pagination-wrap .page-numbers:hover":"color: {{VALUE}};"}},{"name":"_pagination_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-pagination .pxl-pagination-wrap .page-numbers:hover":"border-color: {{VALUE}};"}},{"name":"pagination_hover_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-grid .pxl-grid-pagination .pxl-pagination-wrap .page-numbers:hover"},{"name":"pagination_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-grid-pagination .pxl-pagination-wrap .page-numbers:hover"},{"name":"pagination_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-grid .pxl-grid-pagination .pxl-pagination-wrap .page-numbers:hover"},{"name":"pagination_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-pagination .pxl-pagination-wrap .page-numbers:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_bullets_pagination_style","label":"Bullets","tab":"style","condition":{"swiper_pagination":"bullets"},"controls":[{"name":"bullet_w","label":"Width","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet":"width: {{SIZE}}{{UNIT}};"}},{"name":"bullet_h","label":"Height","type":"slider","size_units":["px","custom"],"control_type":"responsive","range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet":"height: {{SIZE}}{{UNIT}};"}},{"name":"divider_bullet_1","type":"divider"},{"name":"bullet_controls","control_type":"tab","tabs":[{"name":"bullet_normal","label":"Normal","type":"tab","controls":[{"name":"bullet_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet":"color: {{VALUE}};"}},{"name":"bullet_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet"},{"name":"bullet_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet"},{"name":"bullet_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet"},{"name":"bullet_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]},{"name":"bullet_hover","label":"Hover\/Current","type":"tabs","controls":[{"name":"bullet_hove_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover":"color: {{VALUE}};"}},{"name":"_bullet_hover_border_color","label":"Border Color","type":"color","selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover":"border-color: {{VALUE}};"}},{"name":"bullet_hover_bg","type":"background","control_type":"group","types":["classic","gradient"],"selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover"},{"name":"bullet_hover_border","type":"border","separator":"before","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover"},{"name":"bullet_hover_box_shadow","label":"Box Shadow","type":"box-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover"},{"name":"bullet_hover_border_radius","label":"Border Radius","type":"dimensions","size_units":["px","custom"],"selectors":{"{{WRAPPER}} .pxl-swiper .swiper-pagination.swiper-pagination-bullets .swiper-pagination-bullet:hover":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"}}]}]}]},{"name":"tab_motion_effects","label":"Motion Effects","tab":"style","controls":[{"name":"scrolling_effects","label":"Scrolling Effects","type":"select","options":{"":"None","parallax":"Parallax"},"default":"","condition":{"layout_portfolio":"portfolio-1"}},{"name":"divider_scroll","type":"divider","condition":{"layout_portfolio":"portfolio-1"}},{"name":"entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Sliding","options":{"wow slideUp":"Slide Up","wow slideRight":"Slide Right","wow slideDown":"Slide Down","wow slideLeft":"Slide Left"}},{"label":"Rotating","options":{"wow rotateIn":"Rotate In","wow rotateInUp":"Rotate In Up","wow rotateInRight":"Rotate In Right","wow rotateInDown":"Rotate In Down","wow rotateInLeft":"Rotate In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal"}},{"label":"Reveal Image","options":{"wow revealImageIn":"Reveal In","wow revealImageInUp":"Reveal In Up","wow revealImageInRight":"Reveal In Right","wow revealImageInDown":"Reveal In Down","wow revealImageInLeft":"Reveal In Left","wow revealImageInVertical":"Reveal In Vertical","wow revealImageInHorizontal":"Reveal In Horizontal"}},{"label":"Rolling","options":{"wow rollingInTop":"Rolling In Top","wow rollingInRight":"Rolling In Right","wow rollingInBottom":"Rolling In Bottom","wow rollingInLeft":"Rolling In Left"}},{"label":"Rolling Bounce","options":{"wow rollingBounce ttb":"Rolling Bouce TTB","wow rollingBounce rtl":"Rolling Bouce RTL","wow rollingBounce btt":"Rolling Bouce BTT","wow rollingBounce ltr":"Rolling Bouce LTR","wow rollingIn right":"Rolling Right","wow rollingIn left":"Rolling Left"}}],"default":""},{"name":"anim_duration","label":"Animation Duration(ms)","type":"number","selectors":{"{{WRAPPER}} .pxl-grid .pxl-grid-item, \r\n                                    {{WRAPPER}} .pxl-swiper .pxl-swiper-slide":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"}},{"name":"anim_delay","label":"Animation Delay(ms)","type":"number","default":0}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'tilt','imagesloaded','pxl-post-grid','swiper','pxl-swiper','curtainsjs','agron-effects','agron-parallax' );
}