<?php

class PxlHeading_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_heading';
    protected $title = 'Case Heading';
    protected $icon = 'eicon-heading';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_heading_content","label":"Title","tab":"content","controls":[{"name":"subtitle","label":"Subtitle","type":"textarea","default":"Subtitle","rows":2,"description":"Highlight use shortcode: [highlight text=&quot;...&quot;] or [highlight_image img_id=&quot;123&quot;]"},{"name":"subtitle_style","label":"Subtitle Style","type":"select","options":{"heading-subtitle-default":"Default","heading-subtitle-custom":"Custom"},"default":"heading-subtitle-default","condition":{"subtitle!":""}},{"name":"title","label":"Title","type":"textarea","separator":"before","rows":10,"default":"Heading Title","label_block":true,"description":"Highlight use shortcode: [highlight text=&quot;...&quot;] or [highlight_image img_id=&quot;123&quot;]"},{"name":"title_tag","label":"Title HTML Tag","type":"select","options":{"h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","p":"p","span":"span"},"default":"h2","condition":{"title!":""}},{"name":"title_style","label":"Title Style","type":"select","options":{"heading-title-default":"Default","heading-title-custom":"Custom","text-image":"Clip Image","text-vertical":"Text Vertical"},"default":"heading-title-default","condition":{"title!":""}},{"name":"title_text_background","type":"background","control_type":"group","types":["classic"],"selector":"{{WRAPPER}} .pxl-heading .pxl-heading-title","condition":{"title_style":"text-image"}},{"name":"title_wrap","label":"Title Wrap","type":"choose","control_type":"responsive","options":{"wrap":{"title":"Wrap","icon":"eicon-wrap"},"nowrap":{"title":"Nowrap","icon":"eicon-nowrap"}},"selectors":{"{{WRAPPER}} .pxl-heading .pxl-heading-title":"white-space: {{VALUE}};"}},{"name":"text_align","label":"Alignment","type":"choose","control_type":"responsive","separator":"before","options":{"left":{"title":"Left","icon":"eicon-text-align-left"},"center":{"title":"Center","icon":"eicon-text-align-center"},"right":{"title":"Right","icon":"eicon-text-align-right"},"justify":{"title":"Justify","icon":"eicon-text-align-justify"}},"selectors":{"{{WRAPPER}} .pxl-heading":"text-align: {{VALUE}};"}},{"name":"subtitle_spacing","label":"Subtitle Spacing","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}} .pxl-heading .pxl-heading-subtitle":"margin-bottom: {{SIZE}}{{UNIT}};"},"condition":{"subtitle!":""}},{"name":"heading_max_w","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":500}},"selectors":{"{{WRAPPER}}":"max-width: {{SIZE}}{{UNIT}} !important;"}}]},{"name":"tab_title_style","label":"Title","tab":"style","condition":{"title!":""},"controls":[{"name":"title_controls","control_type":"tab","tabs":[{"name":"title_normal","label":"Normal","type":"tab","controls":[{"name":"title_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-heading .pxl-heading-title":"color: {{VALUE}};"}},{"name":"title_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-heading .pxl-heading-title"},{"name":"title_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-heading .pxl-heading-title"},{"name":"title_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-heading .pxl-heading-title"}]},{"name":"title_highlight","label":"Highlight","type":"tab","controls":[{"name":"title_hl_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-heading .pxl-heading-title .pxl-text-highlight":"color: {{VALUE}};-webkit-text-stroke-color:{{VALUE}};"}},{"name":"title_hl_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-heading .pxl-heading-title .pxl-text-highlight"},{"name":"title_hl_line_weight","label":"Line Weight","type":"slider","control_type":"responsive","size_units":["px","custom"],"range":{"px":{"min":0,"max":50}},"selectors":{"{{WRAPPER}} .pxl-heading .pxl-heading-title .pxl-text-highlight":"text-decoration-thickness: {{SIZE}}{{UNIT}};"}},{"name":"title_hl_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-heading .pxl-heading-title .pxl-text-highlight"},{"name":"title_hl_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-heading .pxl-heading-title .pxl-text-highlight"}]}]}]},{"name":"tab_subtitle_style","label":"Subtitle","tab":"style","condition":{"subtitle!":""},"controls":[{"name":"subtitle_color","label":"Text Color","type":"color","selectors":{"{{WRAPPER}} .pxl-heading .pxl-heading-subtitle":"color: {{VALUE}};"}},{"name":"subtitle_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-heading .pxl-heading-subtitle"},{"name":"subtitle_stroke","type":"text-stroke","control_type":"group","selector":"{{WRAPPER}} .pxl-heading .pxl-heading-subtitle"},{"name":"subtitle_shadow","type":"text-shadow","control_type":"group","selector":"{{WRAPPER}} .pxl-heading .pxl-heading-subtitle"}]},{"name":"pxl_moution_effects","label":"Motion Effects","tab":"style","controls":[{"name":"title_anim_heading","type":"heading","label":"Title Animation","condition":{"title!":""}},{"name":"title_entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}},{"label":"Gsap Animate","options":{"text-animated text-fade-in":"Fade In","text-animated text-fade-in-up":"Fade In Up","text-animated text-fade-in-right":"Fade In Right","text-animated text-fade-in-down":"Fade In Down","text-animated text-fade-in-left":"Fade In Left","text-animated text-explosion":"Explosion","text-animated text-zigzag-zoom":"Zigzag Zoom","text-animated text-flip-x":"Flip X","text-animated text-flip-y":"Flip Y","text-animated text-zoom-in":"Zoom In"}}],"default":"","condition":{"title!":""}},{"name":"title_anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-heading .pxl-heading-title":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"title!":"","title_entrance_anim!":["text-animated",""]}},{"name":"title_anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-heading .pxl-heading-title":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"title!":"","title_entrance_anim!":["text-animated",""]}},{"name":"title_split_type","label":"Animation On","type":"select","options":{"lines":"Lines","words":"Words","chars":"Chars"},"default":"chars","condition":{"title!":""},"description":"This option only applies to gsap animate"},{"name":"subtitle_anim_heading","type":"heading","separator":"before","label":"Subtitle Animation","condition":{"subtitle!":""}},{"name":"subtitle_entrance_anim","label":"Entrance Animation","type":"select","groups":[{"label":"None","options":{"":"None"}},{"label":"Fading","options":{"wow fadeIn":"Fade In","wow fadeInUp":"Fade In Up","wow fadeInRight":"Fade In Right","wow fadeInDown":"Fade In Down","wow fadeInLeft":"Fade In Left"}},{"label":"Zooming","options":{"wow zoomIn":"Zoom In","wow zoomInUp":"Zoom In Up","wow zoomInRight":"Zoom In Right","wow zoomInDown":"Zoom In Down","wow zoomInLeft":"Zoom In Left","wow zoomInUpLeft":"Zoom In Up Left","wow zoomInUpRight":"Zoom In Up Right","wow zoomInDownLeft":"Zoom In Down Left","wow zoomInDownRight":"Zoom In Down Right"}},{"label":"Bouncing","options":{"wow bounceIn":"Bounce In","wow bounceInUp":"Bounce In Up","wow bounceInRight":"Bounce In Right","wow bounceInDown":"Bounce In Down","wow bounceInLeft":"Bounce In Left"}},{"label":"Reveal","options":{"wow revealIn":"Reveal In","wow revealInUp":"Reveal In Up","wow revealInRight":"Reveal In Right","wow revealInDown":"Reveal In Down","wow revealInLeft":"Reveal In Left","wow revealInVertical":"Reveal In Vertical","wow revealInHorizontal":"Reveal In Horizontal","wow revealCircle":"Reveal Circle"}},{"label":"Gsap Animate","options":{"text-animated text-fade-in":"Fade In","text-animated text-fade-in-up":"Fade In Up","text-animated text-fade-in-right":"Fade In Right","text-animated text-fade-in-down":"Fade In Down","text-animated text-fade-in-left":"Fade In Left","text-animated text-explosion":"Explosion","text-animated text-zigzag-zoom":"Zigzag Zoom","text-animated text-flip-x":"Flip X","text-animated text-flip-y":"Flip Y","text-animated text-zoom-in":"Zoom In"}}],"default":"","condition":{"subtitle!":""}},{"name":"subtitle_anim_duration","label":"Animation Duration(ms)","type":"number","default":1000,"selectors":{"{{WRAPPER}} .pxl-heading .pxl-heading-subtitle":"animation-duration: {{VALUE}}ms;-webkit-animation-duration: {{VALUE}}ms;"},"control_type":"responsive","condition":{"subtitle!":"","subtitle_entrance_anim!":["text-animated",""]}},{"name":"subtitle_anim_delay","label":"Animation Delay(ms)","type":"number","control_type":"responsive","default":0,"selectors":{"{{WRAPPER}} .pxl-heading .pxl-heading-subtitle":"animation-delay: {{VALUE}}ms;-webkit-animation-delay: {{VALUE}}ms;"},"condition":{"subtitle!":"","subtitle_entrance_anim!":["text-animated",""]}},{"name":"subtitle_split_type","label":"Animation On","type":"select","options":{"lines":"Lines","words":"Words","chars":"Chars"},"default":"chars","condition":{"subtitle!":""},"description":"This option only applies to gsap animate"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'agron-animated' );
}