<?php
if (!defined( 'ABSPATH' )) {
    exit;
}
if (!class_exists( 'OSF_Customize_Elementor' )){

    class OSF_Customize_Elementor {

        public function __construct() {
            add_action( 'customize_register', array( $this, 'customize_register' ) );

            $load_first = get_theme_mod('osf_elementor_main_load', false);
            if ($load_first) {
                add_action('wp_enqueue_scripts', [$this, 'enqueue_main_style'], 1);
            }
            else {
                add_action('elementor/frontend/after_enqueue_scripts', [$this, 'enqueue_main_style']);
            }
        }

        function enqueue_main_style() {
            $rtl      = is_rtl() ? '-rtl' : '';
            $dev_mode = get_theme_mod('osf_dev_mode', false);
    
            if (osf_is_elementor_activated() && !$dev_mode) {
                wp_enqueue_style('osf-elementor-addons', trailingslashit(MEDILAZAR_CORE_PLUGIN_URL) . "assets/css/elementor/style{$rtl}.css", array('medilazar-style'), MEDILAZAR_CORE_VERSION, 'all');
            }
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         */
        public function customize_register($wp_customize) {

            $this->init_osf_elementor( $wp_customize );
    
            do_action( 'osf_customize_elementor_register', $wp_customize );
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */
        public function init_osf_elementor($wp_customize){
        
            $wp_customize->add_section( 'osf_elementor', array(
                'title'          => 'Elementor',
                'capability'     => 'edit_theme_options',
                'panel'          => '', 
                'priority'       => 1, 
            ) );

            // =========================================
            // Elementor Mode
            // =========================================
            if(class_exists('OSF_Customize_Control_Heading')){
                $wp_customize->add_setting( 'osf_elementor_settings', array(
                    'sanitize_callback' => 'sanitize_text_field',
                ) );
                $wp_customize->add_control( new OSF_Customize_Control_Heading( $wp_customize, 'osf_elementor_settings', array(
                    'section' => 'osf_elementor',
                    'label' => __( 'Elementor Settings', 'medilazar-core' ),
                ) ) );
            }

            // =========================================
            // Preload Elementor main style
            // =========================================
            if(class_exists('OSF_Customize_Control_Button_Switch')){
                $wp_customize->add_setting( 'osf_elementor_main_load', array(
                    'transport'         => 'postMessage',
                    'default'           => '1',
                    'sanitize_callback' => 'osf_sanitize_button_switch',
                ) );
                $wp_customize->add_control( new OSF_Customize_Control_Button_Switch( $wp_customize, 'osf_elementor_main_load', array(
                    'section' => 'osf_elementor',
                    'label' => __( 'Preload Elementor main style', 'medilazar-core' ),
                ) ) );
            }

            // $wp_customize->selective_refresh->add_partial( 'osf_elementor', array(
            //     'selector'        => '#masthead',
            //     'render_callback' => 'osf_customize_partial_header_content',
            // ) );

        }
    }
}

new OSF_Customize_Elementor();
