<?php
/**
 * Theme functions and definitions.
 * This child theme was generated by TemplateMela.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 */

/*
 * If your child theme has more than one .css file (eg. ie.css, style.css, main.css) then
 * you will have to make sure to maintain all of the parent theme dependencies.
 *
 * Make sure you're using the correct handle for loading the parent theme's styles.
 * Failure to use the proper tag will result in a CSS file needlessly being loaded twice.
 * This will usually not affect the site appearance, but it's inefficient and extends your page's loading time.
 *
 * @link https://codex.wordpress.org/Child_Themes
 */
function wooti_child_enqueue_styles() {
    wp_enqueue_style( 'wooti-style' , get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'wooti-child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array( 'wooti-style' ),
        wp_get_theme()->get('Version')
    );
}

add_action(  'wp_enqueue_scripts', 'wooti_child_enqueue_styles' );

/**
 * Setup Child Theme Defaults
 *
 * @param array  registered option defaults with base theme.
 * @return array
 */
function wooti_child_change_option_defaults( $defaults ) {
    $new_defaults = '{
        "post_content_style": "unboxed"
    }';
    $new_defaults = json_decode( $new_defaults, true );
    return wp_parse_args( $new_defaults, $defaults );
}
//add_filter( 'base_theme_options_defaults', 'wooti_child_change_option_defaults', 20 );