<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Theme
 * @since 1.0
 */

$default_options = array(
	// container 
	'content_width'   => array(
		'size' => 1710,
		'unit' => 'px',
	),
	// Sidebar.
	'sidebar_width'   => array(
		'size' => 285,
		'unit' => 'px',
	),
	'sidebar_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 16,
		),
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'sidebar_link_style' => 'plain',
	// scroll up
	'scroll_up_icon'          => 'chevron-up',
	'scroll_up_padding' => array(
		'size'   => array( 
			'desktop' => array( 8, 8, 8, 8 ),
		),
		'unit'   => array(
			'desktop' => 'px',
		),
	),
	'scroll_up_icon_size'   => array(
		'size' => array(
			'mobile'  => 16,
			'desktop' =>  20,
		),
		'unit' => array(
			'mobile'  => 'px',
			'desktop' => 'px',
		),
	),
	'scroll_up_color'                     => array(
		'color'  => 'palette9',
		'hover'  => 'palette9',
	),
	'scroll_up_background'                     => array(
		'color'  => 'palette1',
		'hover'  => 'palette2',
	),
	'scroll_up_border_colors'         => array(
		'color'  => 'palette1',
		'hover'  => 'palette2',
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.7,
		),
		'letterSpacing' => array(
			'desktop' => 0.15,
		),
		'spacingType'=> 'px',
		'family'  => 'Roboto',
		'google'  => true,	
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette4',
	),
	'heading_font' => array(
		'family' => 'Roboto',
	),
	'h1_font' => array(
		'size' => array(
			'mobile' => 26,
			'desktop' => 32,
		),
		'lineHeight' => array(
			'mobile' => 1.3,
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => false,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'desktop' => 28,
			'tablet' => 26,
			'mobile' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.35,
			'mobile' => 1.33,
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'desktop' => 24,
			'tablet' => 22,
			'mobile' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.38,
			'mobile' => 1.4,
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'desktop' => 22,
			'tablet' => 20,
			'mobile' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
			'mobile' => 1.3,	
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'mobile' => 18,
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
			'mobile' => 1.3,	
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
			'mobile' => 1.3,	
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'title_above_breadcrumb_font' => array(
		'color'   => 'palette3',
	),
	// Buttons.
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => 5,
		),
	),
	'buttons_typography'    => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 2,
		),
		'transform' => 'capitalize',
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'=> 'px',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'buttons_padding'        => array(
		'size'   => array( 
			'desktop' => array( 9, 27, 9, 27 ),
			'tablet' => array( 9, 22, 9, 22 ),
			'mobile' => array( 5 , 20 , 5 , 20 ),
		),
	),
	// Header.
	'header_desktop_items'       => array(
		'top' => array(
			'top_left'         => array( 'navigation-2' ),
			'top_center'       => array( 'html' ),
			'top_right'        => array( 'html2' ),
		),
		'main' => array(
			'main_left'         => array( 'logo', 'search-advanced'),
			'main_right'        => array('contact', 'divider', 'account', 'divider2', 'cart'),
		),
		'bottom' => array(
			'bottom_left'         => array( 'vertical-menu' , 'divider3', 'navigation'),
			'bottom_right'        => array('toggle-widget'),
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_center' => array( 'mobile-html' ),
		),
		'main' => array(
			'main_left'   => array( 'popup-toggle', 'mobile-logo'),
			'main_right'  => array('mobile-account', 'mobile-cart'),
		),
		'bottom' => array(
			'bottom_center'   => array('search-advanced'),
		),
	),
	'header_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette2',
		),
	),
	// Header Top.
	'header_top_height'       => array(
		'size' => array(
			'mobile' => 30,
			'desktop' => 40,
		),
	),
	'header_top_background'    => array(
		'desktop' => array(
			'color' => 'palette2',
		),
	),
	'header_top_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'rgba(255,255,255,0.1)',
		),
	),
	// Header Main.
	'header_main_height' => array(
		'size' => array(
			'mobile'  => 50,
			'tablet'  => 80,
			'desktop' => 90,
		),
	),
	'header_main_top_border'    => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'rgba(255,255,255,0.1)',
		),
	),
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	),
	// Header Bottom.
	'header_bottom_height'       => array(
		'size' => array(
			'desktop' => 60,
			'mobile' => 50,
		),
	),
	'header_bottom_background'    => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	// Mobile Trigger.
	'mobile_trigger_icon_size'   => array(
		'size' => 22,
		'unit' => 'px',
	),
	'mobile_trigger_color'              => array(
		'color' => '#fff',
		'hover' => 'palette1',
	),
	// Header HTML.
	'header_html_content'    =>  __( 'Save up to 20% on all Toys & Accessories with “FLAT26OFF” code', 'templatemela-theme-wooti' ),
	'header_html_typography' => array(
		'color'   => '#ffffff',
	),
	'header_html_wpautop' => false,
	// html 2 
	'header_html2_content'    =>  __( 'Free Shipping on orders over $100!', 'templatemela-theme-wooti' ),
	'header_html2_typography' => array(
		'color'   => '#ffffff'
	),
	// Mobile Header HTML.
	'mobile_html_content'    => __( 'Free shipping on orders over $100!', 'templatemela-theme-wooti' ),
	'mobile_html_typography' => array(
		'color'   => '#ffffff',
	),
	'mobile_html_wpautop' => false,
	// Header Cart.
	'header_cart_title' =>  __( 'Cart', 'templatemela-theme-wooti' ),
	'header_cart_label' =>  __( 'Item', 'templatemela-theme-wooti' ),
	'header_cart_icon' => 'shopping-cart',
	'header_cart_icon_size'   => array(
		'size' => 25,
		'unit' => 'px',
	),
	'header_cart_color'              => array(
		'color' => '#ffffff',
		'hover' => 'palette1',
	),
	'header_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_cart_total_background'              => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	'header_cart_title_typography'            => array(
		'size' => array(
			'desktop' => 13,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
	),
	'header_cart_typography'            => array(
		'size' => array(
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'weight'  => '600',
	),
	'header_cart_title_color'              => array(
		'color' => '#fff',
	),
	// Mobile Header Cart.
	'header_mobile_cart_icon' => 'shopping-cart',
	'header_mobile_cart_icon_size'   => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_cart_color'              => array(
		'color' => '#fff',
		'hover' => 'palette1',
	),
	'header_mobile_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_mobile_cart_total_background'              => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	// logo 
	'logo_layout'     => array(
		'include' => array(
			'mobile'  => 'logo_only',
			'tablet'  => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	// Navigation.
	'primary_navigation_typography'            => array(
		'size' => array(
			'desktop' => 15,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'primary_navigation_spacing'            => array(
		'size' => 40,
		'unit' => 'px',
	),
	'primary_navigation_vertical_spacing'   => array(
		'size' => 18,
		'unit' => 'px',
	),
	'primary_navigation_color'   => array(
		'color'  => 'palette9',
		'hover'  => 'palette9',
		'active' => 'palette9',
	),
	// Secondary Navigation.
	'secondary_navigation_typography'            => array(
		'size' => array(
			'desktop' => 14,
		),
		'color'   => '#ffffff',
	),
	'secondary_navigation_spacing'            => array(
		'size' => 36,
		'unit' => 'px',
	),
	'secondary_navigation_color'   => array(
		'color'  => '#ffffff',
		'hover'  => 'palette1',
		'active' => 'palette1',
	),
	// Dropdown.
	'dropdown_navigation_typography'            => array(
		'size' => array(
			'desktop' => 14,
		),
	),
	'dropdown_navigation_color'              => array(
		'color'  => 'palette4',
		'hover'  => 'palette1',
		'active' => 'palette1',
	),
	// mobile navigation 
	'mobile_navigation_color'              => array(
		'color'  => 'palette3',
		'hover'  => 'palette3',
		'active' => 'palette3',
	),
	// Footer.
	'footer_items'       => array(
		'top' => array(
			'top_1' => array('footer-widget1'),
		),
		'middle' => array(
			'middle_1' => array('footer-widget2'),
			'middle_2' => array('footer-widget3' , 'footer-widget4'),
			'middle_3' => array('footer-widget5'),
		),
		'bottom' => array(
			'bottom_1' => array('footer-html'),
			'bottom_2' => array('footer-widget6'),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette2',
		),
	),
	// Footer Widget 1.
	'footer_widget1_vertical_align'         => array(
		'desktop' => 'middle',
	),
	// Footer Widget 6.
	'footer_widget6_align'         => array(
		'mobile'  => 'center',
		'tablet'  => 'center',
		'desktop' => 'right',
	),
	'footer_widget6_vertical_align'         => array(
		'desktop' => 'middle',
	),
	// Footer Top.
	'footer_top_columns' => '1',
	'footer_top_background' => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	'footer_top_top_spacing' => array(
		'size' => array(
			'desktop' => 20,
		),
	),
	'footer_top_bottom_spacing' => array(
		'size' => array(
			'desktop' => 20,
		),
	),
	'footer_top_widget_title'  => array(
		'size' => array(
			'desktop' => 24,
			'tablet' => 22,
			'mobile' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.45,
			'mobile' => 1.3,
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => '#fff',
	),
	'footer_top_link_colors' => array( 
		'color' => '#fff',
		'hover' => 'palette2',
	),
	'footer_top_widget_content' => array(
		'lineHeight' => array(
			'desktop' => 1.8,
			'tablet' => 1.6,
			'mobile' => 1.5,
		),
		'color'   => '#fff',
	),
	// footer middle 
	'footer_middle_column_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'rgba(255,255,255,0.2)',
		),
	),
	'footer_middle_direction'         => array(
		'desktop' => 'row',
		'mobile' => 'row',
	),
	'footer_middle_layout'  => array(
		'mobile'  => 'row',
		'tablet'  => 'row',
		'desktop' => 'equal',
	),
	'footer_middle_background' => array(
		'desktop' => array(
			'color' => '#232f3e',
		),
	),
	'footer_middle_widget_spacing' => array(
		'size' => array(
			'desktop' => 0,
		),
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'desktop' => 130,
			'tablet' => 40,
			'mobile' => 30,
		),
	),
	'footer_middle_top_spacing' => array(
		'size' => array(
			'desktop' => 60,
			'tablet'  => 50,
			'mobile'  => 30,
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'desktop' => 60,
			'tablet'  => 50,
			'mobile'  => 30,
		),
	),
	'footer_middle_columns' => '3',
	'footer_middle_widget_title'  => array(
		'size' => array(
			'desktop' => 18,
			'mobile' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'google'  => true,
		'weight'  => '700',
		'variant' => '700',
		'color'   => '#ffffff',
	),
	'footer_middle_widget_content' => array(
		'lineHeight' => array(
			'mobile' => 1.6,
			'desktop' => 2,
		),
		'color'   => '#dddddd',
	),
	'footer_middle_link_colors' => array( 
		'color' => '#dddddd',
		'hover' => 'palette1',
	),
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'rgba(255,255,255,0.1)',
		),
	),
	'footer_middle_link_style' => 'noline',
	// Footer Bottom.
	'footer_bottom_background' => array(
		'desktop' => array(
			'color' => '#232f3e',
		),
	),
	'footer_bottom_columns' => '2',
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'desktop' => 10,
			'tablet' => 15,
		),
	),
	'footer_bottom_top_spacing' => array(
		'size' => array(
			'desktop' => 20,
		),
	),
	'footer_bottom_link_style' => 'noline',
	// footer html 
	'footer_html_typography' => array(
		'color'   => '#dddddd',
	),
	'footer_html_link_color'              => array(
		'color' => '#dddddd',
		'hover' => 'palette1',
	),
	'footer_html_align'         => array(
		'tablet'  => 'center',
	),
	'footer_html_vertical_align'         => array(
		'desktop' => 'middle',
	),
	'footer_html_margin' => array(
		'size'   => array(0,0,0,0 ),
		'unit'   => 'px',
		'locked' => false,
	),
	// footer widget7
	'footer_widget7_align'         => array(
		'desktop'  => 'right',
		'tablet'  => 'center',
	),
	'footer_widget7_vertical_align'         => array(
		'desktop' => 'middle',
	),
	// Product
	'product_archive_sidebar_id'         => 'sidebar-woocommerce-shop',
	// product 
	'product_title_font'   => array(
		'size' => array(
			'tablet' => 18,
			'tablet' => 20,
			'desktop' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'lineType' => 'em',
	),
	// product archive 
	'product_above_title_font'   => array(
		'size' => array(
			'desktop' => 25,
		),
		'lineHeight' => array(
			'desktop' => 1.36,
		),
		'lineType' => 'em',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	'product_archive_button_style'       => 'button',
	'product_archive_title_font'   => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'lineType' => 'em',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'product_archive_price_font'   => array(
		'size' => array(
			'desktop' => 20,
			'tablet' => 18,
			'mobile' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.33,
			'mobile' => 1.53,
		),
		'lineType'=> 'em',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'product_related_columns'    => '6',
	'product_upsell_columns'    => '6',
	// Archive Product Button.
	'product_archive_button_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette9',
	),
	'product_archive_button_background'              => array(
		'color' => 'palette7',
		'hover' => 'palette1',
	),
	'search_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'page_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);

$header_addons = array(
	// Header Divider.
	'header_divider_border' => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
		'color'  => 'rgba(255,255,255,0.1)',
	),
	'header_divider_margin' => array(
		'size'   => array( 0, 5, 0, 5 ),
		'unit'   => 'px',
		'locked' => false,
	),
	// Header Divider2.
	'header_divider2_border' => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
		'color'  => 'rgba(255,255,255,0.1)',
	),
	'header_divider2_margin' => array(
		'size'   => array( 0, 5, 0, 5 ),
		'unit'   => 'px',
		'locked' => false,
	),
	// Header Divider3.
	'header_divider3_border' => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
		'color'  => 'rgba(255,255,255,0.1)',
	),
	'header_divider3_margin' => array(
		'size'   => array( 0, 5, 0, 5 ),
		'unit'   => 'px',
		'locked' => false,
	),
	// header account
	'header_account_style'                   => 'icon_title_label',
	'header_account_title'                   => __( 'My Account', 'templatemela-theme-wooti' ),
	'header_account_label'                   => __( 'Log In', 'templatemela-theme-wooti' ),
	'header_account_icon_size'               => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette1',
	),
	'header_account_title_typography' => array(
		'size' => array(
			'desktop' => 13,
		),
		'lineHeight' => array(
			'desktop' => 1.1,
		),
	),
	'header_account_title_typography_color' => array(
		'color' => '#ffffff',
	),
	'header_account_typography' => array(
		'size' => array(
			'desktop' => 16,
		),
		'weight'  => '600',
	),
	'header_account_typography_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette1',
	),
	// hedare account in 
	'header_account_in_style'                   => 'icon_title_label',
	'header_account_in_title'                   => __( 'My Account', 'templatemela-theme-wooti' ),
	'header_account_in_label'                   => __( 'Log Out', 'templatemela-theme-wooti' ),
	'header_account_in_icon_size'               => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette1',
	),
	'header_account_in_title_typography' => array(
		'size' => array(
			'desktop' => 13,
		),
		'lineHeight' => array(
			'desktop' => 1.1,
		),
	),
	'header_account_in_title_typography_color' => array(
		'color' => '#ffffff',
	),
	'header_account_in_typography' => array(
		'size' => array(
			'desktop' => 16,
		),
		'weight'  => '600',
	),
	'header_account_in_typography_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette1',
	),
	// header mobile account 
	'header_mobile_account_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_account_color' => array(
		'color' => '#fff',
		'hover' => 'palette1',
	),
	// header mobile account in 
	'header_mobile_account_in_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_account_in_color' => array(
		'color' => '#fff',
		'hover' => 'palette1',
	),
	// Header Contact.
	'header_contact_items' => array(
		'items' => array(
			array(
				'id' => 'phone',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'link' => '',
				'icon' => 'phoneAlt2',
				'title' => 'Need Help?',
				'label' => __( '+00 123-456-789', 'templatemela-theme-wooti' ),
			),
		),
	),
	'header_contact_icon_size' => array(
		'size' => 25,
		'unit' => 'px',
	),
	'header_contact_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette1',
	),
	'header_contact_typography' => array(
		'size' => array(
			'desktop' => 16,
		),
		'weight'  => '600',
	),
	// Widget Toggle.
	'header_toggle_widget_label'  => 'Top Offers!',
	'header_toggle_widget_color'              => array(
		'color' => 'palette9',
		'hover' => 'palette9',
	),
	'header_toggle_widget_typography'            => array(
		'weight'  => 500,
	),
	'header_toggle_widget_close_color'  => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_toggle_widget_padding' => array(
		'size'   => array( 0, 0, 0, 0 ),
		'unit'   => 'em',
		'locked' => false,
	),
	// Header toggle Widget Area.
	'header_widget2_link_colors'       => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
	),
	'header_toggle_widget_pop_background' => array(
		'desktop' => array(
			'color' => 'palette9',
		),
	),
	'header_widget2_title'        => array(
		'size' => array(
			'desktop' => 20,
		),
		'color'   => 'palette3',
	),
	'header_widget2_content'        => array(
		'size' => array(
			'desktop' => 15,
		),
		'weight'  => '500',
		'color'   => 'palette3',
	),
);
$more_addons = array(
	// Vertical Navigation.
	'vertical_navigation_item_border' => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
		'color' => 'var(--global-gray-400)',
	),
	'vertical_navigation_border' => array(
		'width' => 2,
		'unit'  => 'px',
		'style' => 'solid',
		'color' => 'palette1',
	),
	'vertical_heading_color'            => array(
		'color'  => 'palette9',
		'hover'  => 'palette9',
		'active' => 'palette9',
	),
	'vertical_heading_background'       => array(
		'color'  => 'transparent',
	),
	'vertical_navigation_color'            => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
		'active' => 'palette1',
	),
	'vertical_navigation_background'       => array(
		'color'  => 'transparent',
	),
	'vertical_navigation_typography'        => array(
		'lineHeight' => array(
			'desktop' => 1.75,
		),
	),
	'vertical_navigation_spacing'          => array(
		'size' => 2.2,
		'unit' => 'em',
	),
	'vertical_navigation_vertical_spacing' => array(
		'size' => 8,
		'unit' => 'px',
	),
	// Header Search Advanced.
	'header_search_advanced_background'       => array(
		'color'  => 'palette9',
	),
	'header_search_advanced_width' => array(
		'size' => array(
			'mobile'  => 510,
			'tablet'  => '',
			'desktop' => 620,
		),
	),
	// Search-Box
	'header_search_advanced_border' => array(
		'width' => 0,
		'unit'  => 'px',
		'style' => 'solid',
	),
	'header_search_advanced_border_radius' => array(
		'size'   => array( 5,5,5,5 ),
		'unit'   => 'px',
		'locked' => true,
	),
	'header_search_advanced_category_color' => array(
		'color'  => 'palette3',
		'hover'  => 'palette3',
	),
	// Category-Box
	'header_search_advanced_category_typography' => array(
		'size' => array(
			'desktop' => 14,
		),
	),
	// Input
	'header_search_advanced_color'       => array(
		'color'  => 'palette3',
		'hover'  => 'palette3',
	),
	'header_search_advanced_typography'        => array(
		'size' => array(
			'desktop' => 14,
		),
	),
	// Button
	'header_search_advanced_buttons_background' => array(
		'color'  => 'palette1',
		'hover'  => 'palette1',
	),
	'header_search_advanced_button_typography'        => array(
		'size' => array(
			'desktop' => 20,
		),
	),
	'header_search_advanced_button_padding' => array(
		'size'   => array( 10, 13, 10, 13 ),
		'unit'   => 'px',
		'locked' => false,
	),
	'header_search_advanced_button_radius' => array(
		'size'   => array( 0 , 5 , 5 , 0 ),
		'unit'   => 'px',
		'locked' => true,
	),
);
$woo_addons = array(
	'product_filter_widget_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);


$dark_mode_addons = array(
	'dark_mode_custom_logo'        => true,
 );