<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Theme
 * @since 1.0
 */

 $default_options = array(
	'content_width' => array(
		'size' => 1470,
		'unit' => 'px',
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'=> 'px',
		'family' => 'Lato',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette4',
	),
	'heading_font' => array(
		'family' => 'Poppins',
	),
	'h1_font' => array(
		'size' => array(
			'tablet' => 30,
			'desktop' => 42,
		),
		'lineHeight' => array(
			'desktop' => 1.1,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'mobile' => 22,
			'tablet' => 28,
			'desktop' => 32,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'family' => 'Poppins',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'desktop' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'desktop' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'mobile' => 18,
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'mobile' => 16,
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	'title_above_font' => array(
		'size' => array(
			'mobile' => 30,
			'tablet' => 35,
			'desktop' => 40,
		),
	),
	'title_above_breadcrumb_font' => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 16,
		),
	),
	'page_title_height'       => array(
		'size' => array(
			'mobile'  => 95,
			'tablet'  => 120,
			'desktop' => 130,
		),
	),
	'search_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	), 
	// Buttons.
	'buttons_color' => array(
		'color' => 'palette9',
		'hover' => 'palette3',
	),
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => 25,
		),
	),
	'buttons_typography' => array(
		'size' => array(
			'mobile' => 13,
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.8,
		),
		'transform' => 'uppercase',
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
	),
	'buttons_padding' => array(
		'size' => array( 
			'mobile' => array( 8, 16, 8, 16 ),
			'desktop' => array( 9, 25, 9, 25 ),
		),
	),
	// Header.
	'header_desktop_items' => array(
		'top' => array(
			'top_left' => array( 'contact' ),
			'top_right' => array( 'navigation-2' ),
		),
		'main' => array(
			'main_left' => array( 'navigation' ),
			'main_center' => array( 'logo' ),
			'main_right' => array( 'search' , 'account' , 'cart' ),
		),
		'bottom' => array(
			'bottom_left' => array(),
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_center' => array( 'mobile-html' ),
		),
		'main' => array(
			'main_left' => array( 'popup-toggle', 'mobile-logo' ),
			'main_right' => array( 'search' , 'account' , 'cart' ),
		),
		'bottom' => array(
			'bottom_left' => array(),
		),
	),
	//logo
	'logo_layout' => array(
		'include' => array(
			'mobile' => 'logo',
			'tablet' => 'logo',
			'desktop' => 'logo_only',
		),
	),
	// Header Top.
	'header_top_height' => array(
		'size' => array(
			'tablet' => 35,
			'desktop' => 45,
		),
	),
	'header_top_layout' => array(
		'desktop' => 'fullwidth',
	),
	'header_top_padding' => array(
		'size' => array( 
			'tablet' => array( 0, 15, 0, 15 ),
			'desktop' => array( 0, 40, 0, 40 ),
		),
	),
	'header_top_background' => array(
		'desktop' => array(
			'color' => 'palette2',
		),
	),
	// Header Main.
	'header_main_height' => array(
		'size' => array(
			'mobile' => 60,
			'tablet' => 90,
			'desktop' => 112,
		),
	),
	'header_main_layout' => array(
		'desktop' => 'fullwidth',
	),
	'header_main_padding' => array(
		'size' => array( 
			'tablet' => array( 0, 15, 0, 15 ),
			'desktop' => array( 0, 40, 0, 40 ),
		),
	),
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	),
	'header_main_background' => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	// Header HTML.
	'header_html_content' => __( 'Free shipping on orders over $49', 'templatemela-theme-wooti' ),
	'header_html_typography' => array(
		'color' => '#000000',
	),
	// Navigation.
	'primary_navigation_typography' => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.7,
		),
		'transform' => 'uppercase',
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
	),
	'primary_navigation_spacing' => array(
		'size' => 40,
		'unit' => 'px',
	),
	'primary_navigation_color' => array(
		'color' => 'palette9',
		'hover' => 'palette2',
		'active' => 'palette2',
	),
	'primary_navigation_vertical_spacing' => array(
		'size' => 44,
		'unit' => 'px',
	),
	//secondary navigation
	'secondary_navigation_color'   => array(
		'color'  => '#000000',
		'hover'  => '#000000',
		'active' => '#000000',
	),
	//search
	'header_search_icon_size' => array(
		'size' => array(
			'mobile' => 20,
			'desktop' => 22,
		),
	),
	'header_search_color' => array(
		'color' => 'palette9',
		'hover' => 'palette2',
	),
	//cart
	'header_cart_icon_size' => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_cart_color' => array(
		'color' => 'palette9',
		'hover' => 'palette2',
	),
	'header_cart_total_color' => array(
		'color' => '#000000',
		'hover' => '#000000',
	),
	'header_cart_total_background' => array(
		'color' => 'palette2',
		'hover' => 'palette2',
	),
	//mobile trigger
	'mobile_trigger_color' => array(
		'color' => 'palette9',
		'hover' => 'palette2',
	),
	'mobile_trigger_icon_size' => array(
		'size' => 22,
		'unit' => 'px',
	),
	//mobile html
	'mobile_html_typography' => array(
		'color'   => '#000000',
	),
	'mobile_html_wpautop' => false,
	// Footer.
	'footer_items' => array(
		'top' => array(
			'top_1' => array(),
		),
		'middle' => array(
			'middle_1' => array( 'footer-widget1' ,'footer-social' ),
			'middle_2' => array( 'footer-widget2' ),
			'middle_3' => array( 'footer-widget3' ),
			'middle_4' => array( 'footer-widget4' ),
		),
		'bottom' => array(
			'bottom_1' => array( 'footer-html' ),
			'bottom_2' => array( 'footer-widget5' ),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	//footer middle
	'footer_middle_layout' => array(
		'mobile' => 'row',
		'tablet' => 'two-grid',
		'desktop' => 'equal',
	),
	'footer_middle_direction' => array(
		'desktop' => 'column',
	),
	'footer_middle_widget_title' => array(
		'size' => array(
			'tablet' => 18,
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => '#ffffff',
	),
	'footer_middle_widget_content' => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => '#ffffff',
	),
	'footer_middle_link_colors' => array(
		'color' => '#ffffff',
		'hover' => 'palette2',
	),
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit' => 'px',
			'style' => 'solid',
			'color' => 'rgba(255,255,255,0.1)',
		),
	),
	'footer_middle_columns' => '4',
	'footer_middle_link_style' => 'noline',
	'footer_middle_top_spacing' => array(
		'size' => array(
			'mobile' => 40,
			'tablet' => 70,
			'desktop' => 115,
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'mobile' => 40,
			'tablet' => 70,
			'desktop' => 115,
		),
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'mobile' => 30,
			'tablet' => 50,
			'desktop' => 30,
		),
	),	
	//footer bottom
	'footer_bottom_columns' => '2',
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'tablet' => 10,
		),
	),
	'footer_bottom_link_style' => 'noline',
	//footer html
	'footer_html_typography' => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => '#ffffff',
	),
	'footer_html_link_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette2',
	),
	'footer_html_align' => array(
		'tablet' => 'center',
	),
	// Footer Widget 5
	'footer_widget5_align' => array(
		'tablet' => 'center',
		'desktop' => 'right',
	),
	'footer_widget5_vertical_align' => array(
		'desktop' => 'middle',
	),
	// Footer Social.
	'footer_social_items' => array(
		'items' => array(
			array(
				'id' => 'facebook',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'facebookAlt2',
				'label' => __( 'facebook', 'templatemela-theme-wooti' ),
			),
			array(
				'id' => 'twitter',
				'enabled' => true,
				'source' => 'svg',
				'svg' => '<svg id="Layer_1" data-name="Layer 1"  xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500.08 511.77"><path fill="currentColor" d="M10.22,512.77c11.62-13.7,23.17-27.46,34.88-41.08q78.33-91.1,156.74-182.15c1.08-1.25,2.09-2.57,3.31-4.08L9.92,1.42c1.92-.14,3.15-.31,4.38-.31q70.2,0,140.42-.1c3.33,0,5,1.24,6.76,3.8Q223,94.6,284.75,184.27c1,1.48,2.09,2.92,3.46,4.83l25.3-29.35Q379.81,82.68,446,5.54A11.69,11.69,0,0,1,456.22,1c12.25.27,24.52.09,37.95.09L307.77,217.76l29,42.16Q422,384,507.25,508.1c1,1.48,1.84,3.11,2.75,4.67H361.07c-.67-1.14-1.28-2.32-2-3.41q-65.88-95.82-131.8-191.62c-.72-1.05-1.61-2-2.61-3.2-1.78,2-3.35,3.71-4.86,5.46q-52.6,61.13-105.19,122.25Q84.34,477.47,54.2,512.77Z" transform="translate(-9.92 -1)"/></svg>',
				'imageid' => '',
				'width' => 12,
				'icon' => 'twitterAlt',
				'label' => __( 'X formerly Twitter', 'templatemela-theme-wooti' ),
			),
			array(
				'id' => 'instagram',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'instagram',
				'label' => __( 'instagram', 'templatemela-theme-wooti' ),
			),
			array(
				'id'      => 'youtube',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'youtube',
				'label'   => __('YouTube', 'templatemela-theme-wooti' ),
			),
		),
	),
	'footer_social_align' => array(
		'desktop' => 'left',
	),
	'footer_social_style' => 'filled',
	'footer_social_icon_size' => array(
		'size' => 16,
		'unit' => 'px',
	),
	'footer_social_color' => array(
		'color' => 'palette9',
		'hover' => 'palette2',
	),
	'footer_social_background' => array(
		'color' => '#bac5b826',
	),
	'footer_social_border_radius' => array(
		'size' => 30,
		'unit' => 'px',
	),
	'footer_social_margin' => array(
		'size' => array( 15, 0, 0, 0 ),
		'unit' => 'px',
		'locked' => false,
	),
	'footer_social_item_spacing' => array(
		'size' => 10,
		'unit' => 'px',	
	),
	//product archive
	'product_archive_title_font' => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'lineType' => 'em',
		'family' => 'Poppins',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => 'palette3',
	),
	'product_archive_price_font' => array(
		'size' => array(
			'mobile' => 15,
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'product_archive_button_style' => 'button',
	'product_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 95,
			'tablet'  => 120,
			'desktop' => 130,
		),
	),
	//product
	'product_title_font' => array(
		'size' => array(
			'mobile' => 22,
			'tablet' => 25,
			'desktop' => 30,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => 'palette3',
	),
	'product_title_height'       => array(
		'size' => array(
			'mobile'  => 95,
			'tablet'  => 120,
			'desktop' => 130,
		),
	),
	'product_related_columns'    => '4',
	'product_upsell_columns'    => '4',
	//post arvhice
	'post_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 95,
			'tablet'  => 120,
			'desktop' => 130,
		),
	),
	'post_archive_item_title_font'   => array(
		'size' => array(
			'desktop' => 24,
			'tablet' => 22,
			'mobile' => 20,
		),
	),
	//post
	'post_title_height'       => array(
		'size' => array(
			'desktop' => 130,
		),
	),
	'post_title_font'   => array(
		'size' => array(
			'mobile' => 19,
			'desktop' => 24,
		),
	),	
	//sidebar
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'Poppins',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => 'palette3',
	),
	'sidebar_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'sidebar_width' => array(
		'size' => 270,
		'unit' => 'px',
	),
	'sidebar_link_style' => 'plain',
	// Links.
	'link_color'                     => array(
		'highlight'      => 'palette1',
		'highlight-alt'  => 'palette3',
		'highlight-alt2' => 'palette9',
		'style'          => 'no-underline',
	),
	//dropdown
	'dropdown_navigation_color'              => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
		'active' => 'palette1',
	),
	'dropdown_navigation_typography'            => array(
		'size' => array(
			'desktop' => 15,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'transform' => 'capitalize',
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);
$header_addons = array(
	// Header Contact.
	'header_contact_items' => array(
		'items' => array(
			array(
				'id' => 'hours',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'link' => 'Mon - Fri: 8AM - 5PM',
				'icon' => '',
				'title' => '',
				'label' => __( 'Mon - Fri: 8AM - 5PM', 'templatemela-theme-wooti' ),
			),
			array(
				'id' => 'phone',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'link' => '(987) 654-3210',
				'icon' => '',
				'title' => '',
				'label' => __( 'Order by phone: (987) 654-3210', 'templatemela-theme-wooti' ),
			),
		),
	),
	'header_contact_color' => array(
		'color' => '#000000',
		'hover' => '#000000',
	),
	'header_contact_item_spacing' => array(
		'size' => 40,
		'unit' => 'px',
	),
	//header account
	'header_account_icon_size' => array(
		'size' => 23,
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => 'palette9',
		'hover' => 'palette2',
	),
	//header in account
	'header_account_in_icon_size' => array(
		'size' => 23,
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => 'palette9',
		'hover' => 'palette2',
	),
);
$more_addons = array();
$woo_addons = array(
	'product_filter_widget_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
);
$dark_mode_addons = array(
	'dark_mode_custom_logo' => true,
);