<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Theme
 * @since 1.0
 */

$default_options = array(
	'content_width'   => array(
		'size' => 1430,
		'unit' => 'px',
	),
	//Logo
	'logo_layout' => array(
		'include' => array(
			'mobile' => 'logo_only',
			'tablet' => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	// scroll up
	'scroll_up_icon'          => 'chevron-up',
	'scroll_up_padding' => array(
		'size'   => array( 
			'desktop' => array( 8, 8, 8, 8 ),
		),
		'unit'   => array(
			'desktop' => 'px',
		),
	),
	'scroll_up_icon_size'   => array(
		'size' => array(
			'mobile'  => 16,
			'desktop' =>  20,
		),
		'unit' => array(
			'mobile'  => 'px',
			'desktop' => 'px',
		),
	),
	'scroll_up_radius' => array(
		'size'   => array( 0, 0, 0, 0 ),
		'unit'   => 'px',
		'locked' => true,
	),
	'scroll_up_color'                     => array(
		'color'  => 'palette9',
		'hover'  => 'palette9',
	),
	'scroll_up_background'                     => array(
		'color'  => 'palette2',
		'hover'  => 'palette1',
	),
	'scroll_up_border_colors'         => array(
		'color'  => 'palette2',
		'hover'  => 'palette1',
	),
	// Sidebar.
	'sidebar_width' => array(
		'size' => 330,
		'unit' => 'px',
	),
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'Sarabun',
		'google' => true,
		'weight' => '700',
		'variant' => '700',
		'color' => 'palette3',
	),
	'sidebar_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette2',
	),
	'sidebar_link_style' => 'plain',
	// Typography.
	'base_font' => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 15,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'family' => 'Sarabun',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette4',
	),
	'heading_font' => array(
		'family' => 'Lora',
	),
	'h1_font' => array(
		'size' => array(
			'mobile' => 30,
			'tablet' => 40,
			'desktop' => 48,
		),
		'lineHeight' => array(	
			'desktop' => 1,
		),
		'family' => 'Lora',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'desktop' => 28,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'family' => 'Lora',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'tablet' => 22,
			'desktop' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'family' => 'Lora',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'desktop' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'mobile' => 14,
			'tablet' => 15,
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1,
		),
		'family' => 'Lora',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	'title_above_font' => array(
		'size' => array(
			'mobile' => 25,
			'tablet' => 32,
			'desktop' => 40,
		),
		'color' => '#ffffff',
	),
	'title_above_breadcrumb_font' => array(
		'size' => array(
			'desktop' => 14,
		),
		'color' => '#ffffff',
	),
	// Buttons.
	'buttons_color' => array(
		'color' => 'palette9',
		'hover' => 'palette9',
	),
	'buttons_background' => array(
		'color'  => 'palette2',
		'hover'  => 'palette1',
	),
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => 0,
		),
	),
	'buttons_typography' => array(
		'size' => array(
			'tablet' => 14,
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.8,
			'tablet' => 1.9,
		),
		'transform' => 'capitalize',
		'family' => 'Lora',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
	),
	'buttons_padding' => array(
		'size' => array( 
			'desktop' => array( 7, 38, 7, 38 ),
			'tablet' => array( 8, 25, 8, 25 ),
			'mobile' => array( 5, 16, 5, 16 ),
		),
	),
	// Links.
	'link_color'                     => array(
		'highlight'      => 'palette3',
		'highlight-alt'  => 'palette2',
		'highlight-alt2' => 'palette9',
		'style'          => 'no-underline',
	),
	// Header.
	'header_desktop_items' => array(
		'top' => array(
			'top_center' => array('html'),
		),
		'main' => array(
			'main_left' => array( 'logo' ),
			'main_center' => array( 'navigation' ) ,
			'main_right' => array( 'search' , 'account' , 'cart' ),
		),
		'bottom' => array(
			'bottom_left' => array() ,
		),
	),
	//header top
	'header_top_height' => array(
		'size' => array(
			'mobile' => 30,
			'desktop' => 40,
		),
	),
	'header_top_background' => array(
		'desktop' => array(
			'color' => 'palette2',
		),
	),
	// Header Main.
	'header_main_height' => array(
		'size' => array(
			'tablet' => 70,
			'desktop' => 106,
		),
	),
	'header_main_layout' => array(
		'desktop' => 'fullwidth',
	),
	'header_main_padding' => array(
		'size' => array( 
			'desktop' => array( 0, 50, 0, 50 ),
		),
	),
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	 ),
	// Header HTML.
	'header_html_content'    => __( '10% off 1st purchase + Free shipping over Rs 999.   *   Buy our product with Maximum Quality Minimum Price', 'templatemeal-theme-wooti' ),
	'header_html_typography' => array(
		'color'   => 'palette9',
	),
	'header_html_wpautop' => false,
	// Mobile Header HTML.
	'mobile_html_content'    => __( 'Free shipping on orders over $100!', 'avanam' ),
	'mobile_html_typography' => array(
		'color'   => 'palette9',
	),
	'mobile_html_wpautop' => false,
	// Navigation.
	'primary_navigation_typography' => array(
		'size' => array(
			'desktop' => 17,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'Lora',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
	),
	'primary_navigation_spacing' => array(
		'size' => 50,
		'unit' => 'px',
	),
	'primary_navigation_vertical_spacing' => array(
		'size' => 40,
		'unit' => 'px',
	),
	'primary_navigation_color' => array(
		'color' => 'palette3',
		'hover' => 'palette2',
		'active' => 'palette2',
	),
	//header search
	'header_search_icon_size' => array(
		'size' => array(
			'desktop' => 24,
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_search_color' => array(
		'color' => 'palette3',
		'hover' => 'palette2',
	),
	'header_search_padding' => array(
		'size' => array( 0, 5, 0, 0 ),
		'unit' => 'px',
		'locked' => false,
	),
	//header cart
	'header_cart_icon_size' => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_cart_color' => array(
		'color' => 'palette3',
		'hover' => 'palette2',
	),
	'header_cart_total_color' => array(
		'color' => 'palette9',
		'hover' => 'palette9',
	),
	'header_cart_total_background' => array(
		'color' => 'palette2',
		'hover' => 'palette2',
	),
	//dropdown
	'dropdown_navigation_color'              => array(
		'color'  => 'palette4',
		'hover'  => 'palette2',
		'active' => 'palette2',
	),
	'dropdown_navigation_typography'            => array(
		'size' => array(
			'desktop' => '16',
		),
		'lineHeight' => array(
			'desktop' => '1.4',
		),
		'family'  => 'Sarabun',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_center' => array( 'mobile-html' ),
		),
		'main' => array(
			'main_left' => array('popup-toggle', 'mobile-logo' ),
			'main_right' => array( 'search' , 'account' , 'cart' ),
		),
		'bottom' => array(
			'bottom_left' => array(),
		),
	),
	//mobile trigger
	'mobile_trigger_icon_size' => array(
		'size' => 24,
		'unit' => 'px',
	),
	'mobile_trigger_color' => array(
		'color' => 'palette9',
		'hover' => 'palette9',
	),
	'mobile_trigger_background' => array(
		'color' => 'palette2',
		'hover' => 'palette2',
	),
	// Footer.
	'footer_items' => array(
		'top' => array(
			'top_1' => array(),
		),
		'middle' => array(
			'middle_1' => array( 'footer-widget1' ),
			'middle_2' => array( 'footer-widget2' ),
			'middle_3' => array( 'footer-widget3' ),
			'middle_4' => array( 'footer-widget4' ),
		),
		'bottom' => array(
			'bottom_1' => array( 'footer-html' ),
			'bottom_2' => array( 'footer-widget5' ),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette-footer-bg',
		),
	),	
	//footer middle
	'footer_middle_columns' => '4',
	'footer_middle_layout' => array(
		'mobile' => 'row',
		'tablet' => 'two-grid',
		'desktop' => 'left-forty',
	),
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit' => 'px',
			'style' => 'solid',
			'color' => 'rgba(255,255,255,0.1)',
		),
	),
	'footer_middle_widget_title' => array(
		'size' => array(
			'mobile' => 20,
			'desktop' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'family' => 'Lora',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => '#ffffff',
	),
	'footer_middle_widget_content' => array(
		'color' => '#ffffff',
	),
	'footer_middle_link_colors' => array(
		'color' => '#ffffff',
		'hover' => 'palette2',
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'mobile' => 30,
			'tablet' => 40,
			'desktop' => 15,
		),
	),
	'footer_middle_top_spacing' => array(
		'size' => array(
			'mobile' => 40,
			'tablet' => 70,
			'desktop' => 100,
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'mobile' => 40,
			'tablet' => 70,
			'desktop' => 100,
		),
	),
	'footer_middle_link_style' => 'noline',
	//footer bottom
	'footer_bottom_columns' => '2',
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'tablet' => 10,
		),
	),
	'footer_bottom_link_style' => 'noline',
	//Footer HTML.
	'footer_html_typography' => array(
		'color' => '#ffffff',
	),
	'footer_html_link_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette2',
	),
	'footer_html_align' => array(
		'tablet' => 'center',
	),
	//Footer Widget5
	'footer_widget5_align' => array(
		'tablet' => 'center',
		'desktop' => 'right',
	),
	'footer_widget5_vertical_align' => array(
		'desktop' => 'middle',
	),
	//product archive
	'product_archive_title_font' => array(
		'size' => array(
			'mobile' => 14,
			'tablet' => 18,
			'desktop' => 20,
		),
		'lineHeight' => array(
			'tablet' => 1.4,
			'desktop' => 1.5,
		),
		'lineType' => 'em',
		'family' => 'Lora',
		'google' => true,
		'weight' => '700',
		'variant' => '700',
		'color' => 'palette3',
	),
	'product_archive_price_font' => array(
		'size' => array(
			'mobile' => 15,
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'lineType' => 'em',
		'family' => 'inherit',
		'google' => true,
		'weight' => '700',
		'variant' => '700',
		'color' => 'palette4',
	),
	'product_archive_button_style' => 'button',
	'product_related_columns'    => '4',
	'product_upsell_columns'    => '4',
	'product_title_font' => array(
		'size' => array(
			'mobile' => 20,
			'tablet' => 26,
			'desktop' => 30,
		),
		'lineHeight' => array(
			'mobile' => 1.4,
			'desktop' => 1.5,
		),
		'lineType' => 'em',
		'family' => 'inherit',
		'google' => true,
		'weight' => '700',
		'variant' => '700',
		'color' => 'palette3',
	),
	// breadcrumb height 
	'search_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette9',
		'hover' => 'palette1',
	),
	'page_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette9',
		'hover' => 'palette1',
	),
	'post_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette9',
		'hover' => 'palette1',
	),
	'post_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette9',
		'hover' => 'palette1',
	),
	'product_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette9',
		'hover' => 'palette1',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette9',
		'hover' => 'palette1',
	),
	// breadcrumb banner
	'page_title_background'   => array(
		'desktop' => array(
			'color' => 'palette1',
			'image' => array(
				'url' => __(TMTHEME_URL.'layouts/organic/img/breadcrumb.jpg'),
				'size'=> 'cover',
				'repeat'=> 'no-repeat',
				'attachment' => 'fixed',
			),
			'type' => 'image',
		),
	),
	'product_archive_title_background' => array(
		'desktop' => array(
			'color' => 'palette1',
			'image' => array(
				'url' => __(TMTHEME_URL.'layouts/organic/img/breadcrumb.jpg'),
				'size'=> 'cover',
				'repeat'=> 'no-repeat',
				'attachment' => 'fixed',
			),
			'type' => 'image',
		),
	),
	//product
	'product_title_background' => array(
		'desktop' => array(
			'color' => 'palette1',
			'image' => array(
				'url' => __(TMTHEME_URL.'layouts/organic/img/breadcrumb.jpg'),
				'size'=> 'cover',
				'repeat'=> 'no-repeat',
				'attachment' => 'fixed',
			),
			'type' => 'image',
		),
	),
	//post archive
	'post_archive_title_background' => array(
		'desktop' => array(
			'color' => 'palette1',
			'image' => array(
				'url' => __(TMTHEME_URL.'layouts/organic/img/breadcrumb.jpg'),
				'size'=> 'cover',
				'repeat'=> 'no-repeat',
				'attachment' => 'fixed',
			),
			'type' => 'image',
		),
	),
	//post archive
	'post_title_background' => array(
		'desktop' => array(
			'color' => 'palette1',
			'image' => array(
				'url' => __(TMTHEME_URL.'layouts/organic/img/breadcrumb.jpg'),
				'size'=> 'cover',
				'repeat'=> 'no-repeat',
				'attachment' => 'fixed',
			),
			'type' => 'image',
		),
	),
	'search_archive_title_background'    => array(
		'desktop' => array(
			'color' => 'palette1',
			'image' => array(
				'url' => __(TMTHEME_URL.'layouts/organic/img/breadcrumb.jpg'),
				'size'=> 'cover',
				'repeat'=> 'no-repeat',
				'attachment' => 'fixed',
			),
			'type' => 'image',
		),
	),
);

$header_addons = array(
	//header account
	'header_account_icon_size' => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette2',
	),
	'header_account_padding' => array(
		'size' => array( 0, 5, 0, 0 ),
		'unit' => 'px',
		'locked' => true,
	),
	//header in account
	'header_account_in_icon_size' => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette2',
	),
	'header_account_in_padding' => array(
		'size' => array( 0, 5, 0, 0 ),
		'unit' => 'px',
		'locked' => true,
	),
);
$more_addons = array(
	'product_filter_widget_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
);
$woo_addons = array();


$dark_mode_addons = array(
	'dark_mode_custom_logo'        => true,
 );