<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Theme
 * @since 1.0
 */

$default_options = array(
	'content_width' => array(
		'size' => 1430,
		'unit' => 'px',
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'desktop' => 15,
			'mobile' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'family' => 'Marcellus',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette4',
	),
	'heading_font' => array(
		'family' => 'inherit',
	),
	'h1_font' => array(
		'size' => array(
			'desktop' => 52,
			'tablet' => 40,
			'mobile' => 25,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'letterSpacing' => array(
			'desktop' => 0,
		),
		'spacingType' => 'px',
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'mobile' => 22,
			'desktop' => 28,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'desktop' => 24,
			'tablet' => 20,
			'mobile' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'letterSpacing' => array(
			'desktop' => 0.4,
		),
		'spacingType' => 'px',
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'desktop' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'title_above_font' => array(
		'size' => array(
			'desktop' => 30,
		),
	),
	'title_above_breadcrumb_font' => array(
		'size' => array(
			'desktop' => 15,
			'mobile' => 14,
		),
		'color' => 'palette3',
	),
	// Buttons.
	'buttons_color' => array(
		'color' => 'palette3',
		'hover' => 'palette9',
	),
	'buttons_background' => array(
		'color' => 'transparent',
		'hover' => 'palette2',
	),
	'buttons_border_colors' => array(
		'color' => 'palette2',
		'hover' => 'palette2',
	),
	'buttons_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit' => 'px',
			'style' => 'solid',
			'color' => 'palette2',
		),
	),
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => 0,
		),
	),
	'buttons_typography' => array(
		'size' => array(
			'desktop' => 14,
			'mobile' => 13,
		),
		'lineHeight' => array(
			'desktop' => 1.8,
		),
		'transform' => 'uppercase',
		'family' => 'inherit',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
	),
	'buttons_padding' => array(
		'size' => array( 
			'desktop' => array( 8, 25, 8, 25 ),
			'tablet' => array( 8, 20, 8, 20 ),
			'mobile' => array( 7, 15, 7, 15 ),
		),
	),
	// Logo
	'logo_layout' => array(
		'include' => array(
			'mobile' => 'logo_only',
			'tablet' => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	// Header.
	'header_desktop_items' => array(
		'top' => array(
			'top_left' => array( 'html' ),
			'top_right' => array( 'contact' ),
		),
		'main' => array(
			'main_left' => array( 'logo' ),
			'main_center' => array( 'navigation' ),
			'main_right' => array( 'search' , 'account' , 'cart' ),
		),
		'bottom' => array(
			'bottom_left' => array( ),
		),
	),
	'header_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette7',
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_center' => array( 'mobile-html' ),
		),
		'main' => array(
			'main_left' => array( 'popup-toggle', 'mobile-logo' ),
			'main_right' => array( 'search', 'mobile-account', 'mobile-cart' ),
		),
		'bottom' => array(
			'bottom_left' => array(),
		),
	),
	//header top
	'header_top_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit' => 'px',
			'style' => 'solid',
			'color' => '#cdcbc5',
		),
	),
	'header_top_height' => array(
		'size' => array(
			'desktop' => 45,
			'tablet' => 35,
		),
	),
	'header_top_layout' => array(
		'desktop' => 'fullwidth',
	),
	'header_top_padding' => array(
		'size' => array( 
			'desktop' => array( 0, 60, 0, 60 ),
		),
	),
	'header_top_background' => array(
		'desktop' => array(
			'color' => 'palette7',
		),
	),
	//header main
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	),
	'header_main_height' => array(
		'size' => array(
			'desktop' => 85,
			'tablet' => 70,
		),
	),
	'header_main_layout' => array(
		'desktop' => 'fullwidth',
	),
	'header_main_padding' => array(
		'size' => array( 
			'desktop' => array( 0, 60, 0, 60 ),
		),
	),
	// Header HTML.
	'header_html_content' => __( '<img src="'.TMTHEME_URL.'layouts/museum/img/special-offer.svg" alt="Free Shipping">The Museum Is Open Today 10 Am - 5 Pm', 'templatemela-theme-wooti' ),
	'header_html_typography' => array(
		'color' => 'palette3',
	),
	// Navigation.
	'primary_navigation_typography' => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'transform' => 'uppercase',
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
	),
	'primary_navigation_spacing' => array(
		'size' => 50,
		'unit' => 'px',
	),
	'primary_navigation_vertical_spacing' => array(
		'size' => 32,
		'unit' => 'px',
	),
	'primary_navigation_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
		'active' => 'palette1',
	),
	//header cart
	'header_cart_icon_size' => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_cart_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_cart_total_color' => array(
		'color' => 'palette9',
		'hover' => 'palette9',
	),
	'header_cart_total_background' => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	//header search
	'header_search_icon_size' => array(
		'size' => array(
			'desktop' => 22,
			'tablet' => 20,
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_search_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//mobile html
	'mobile_html_typography' => array(
		'color' => 'palette3',
	),
	'mobile_html_wpautop' => false,
	//mobile trigger
	'mobile_trigger_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//mobile cart
	'header_mobile_cart_icon_size' => array(
		'size' => 20,
		'unit' => 'px',
	),
	'header_mobile_cart_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_mobile_cart_total_color' => array(
		'color' => 'palette9',
		'hover' => 'palette9',
	),
	'header_mobile_cart_total_background' => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	//dropdown
	'dropdown_navigation_typography' => array(
		'size' => array(
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'transform' => 'capitalize',
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
	),
	// Footer.
	'footer_items' => array(
		'top' => array(
			'top_1' => array(),
		),
		'middle' => array(
			'middle_1' => array( 'footer-widget1' ),
			'middle_2' => array( 'footer-widget2' ),
			'middle_3' => array( 'footer-widget3' ),
			'middle_4' => array( 'footer-widget4' ),
		),
		'bottom' => array(
			'bottom_1' => array( 'footer-html' ),
			'bottom_2' => array( 'footer-widget5' ),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => '#19140e',
		),
	),
	//footer middle
	'footer_middle_columns' => '4',
	'footer_middle_widget_title' => array(
		'size' => array(
			'desktop' => 22,
			'mobile' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => '#efede0',
	),
	'footer_middle_widget_content' => array(
		'color' => '#efede0',
	),
	'footer_middle_link_colors' => array(
		'color' => '#efede0',
		'hover' => 'palette1',
	),
	'footer_middle_link_style' => 'noline',
	'footer_middle_top_spacing' => array(
		'size' => array(
			'mobile' => 40,
			'tablet' => 50,
			'desktop' => 95,
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'mobile' => 40,
			'tablet' => 50,
			'desktop' => 95,
		),
	),
	'footer_middle_layout' => array(
		'mobile' => 'row',
		'tablet' => 'two-grid',
		'desktop' => 'center',
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'mobile' => 40,
			'tablet' => 50,
			'desktop' => 30,
		),
	),
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit' => 'px',
			'style' => 'solid',
			'color' => '#302c27',
		),
	),
	//footer bottom
	'footer_bottom_columns' => '2',
	'footer_bottom_link_style' => 'noline',
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'tablet' => 10,
			'desktop' => 30,
		),
	),
	//footer widget5
	'footer_widget5_align' => array(
		'tablet' => 'center',
		'desktop' => 'right',
	),
	'footer_widget5_vertical_align' => array(
		'desktop' => 'middle',
	),
	//footer html
	'footer_html_typography' => array(
		'color' => '#efede0',
	),
	'footer_html_link_color' => array(
		'color' => '#efede0',
		'hover' => 'palette1',
	),
	'footer_html_align' => array(
		'tablet' => 'center',
		'desktop' => 'left',
	),
	//product archive
	'product_archive_button_style' => 'button',
	'product_archive_title_font' => array(
		'size' => array(
			'desktop' => 20,
			'tablet' => 18,
			'mobile' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'lineType' => 'em',
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'product_archive_price_font' => array(
		'size' => array(
			'desktop' => 16,
			'mobile' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette1',
	),
	'product_archive_button_border_colors' => array(
		'color' => 'palette2',
		'hover' => 'palette2',
	),
	'product_archive_button_border' => array(
		'width' => 1,
		'unit' => 'px',
		'style' => 'solid',
	),
	'product_title_font' => array(
		'size' => array(
			'mobile' => 23,
			'tablet' => 25,
			'desktop' => 30,
		),
	),
	'product_related_columns' => '4',
	'product_upsell_columns' => '4',
	//post archive
	'post_archive_item_title_font' => array(
		'size' => array(
			'desktop' => 24,
			'tablet' => 22,
			'mobile' => 20,
		),
	),
	// Breadcrumbs
	'product_archive_title_height' => array(
		'size' => array(
			'mobile' => 70,
			'tablet' => 100,
			'desktop' => 130,
		),
	),
	'product_archive_title_background' => array(
		'desktop' => array(
			'color' => 'palette8',
		),
	),
	'product_title_background' => array(
		'desktop' => array(
			'color' => 'palette8',
		),
	),
	'page_title_height' => array(
		'size' => array(
			'mobile' => 70,
			'tablet' => 100,
			'desktop' => 130,
		),
	),
	'page_title_background' => array(
		'desktop' => array(
			'color' => 'palette8',
		),
	),
	'post_title_height' => array(
		'size' => array(
			'desktop' => 130,
		),
	),
	'post_title_background' => array(
		'desktop' => array(
			'color' => 'palette8',
		),
	),
	'post_archive_title_height' => array(
		'size' => array(
			'mobile' => 70,
			'tablet' => 100,
			'desktop' => 130,
		),
	),
	'post_archive_title_background' => array(
		'desktop' => array(
			'color' => 'palette8',
		),
	),
	'search_archive_title_height' => array(
		'size' => array(
			'mobile' => 70,
			'tablet' => 100,
			'desktop' => 130,
		),
	),
	'search_archive_title_background' => array(
		'desktop' => array(
			'color' => 'palette8',
		),
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// Sidebar.
	'sidebar_width' => array(
		'size' => 270,
		'unit' => 'px',
	),
	'sidebar_link_style' => 'plain',
);
$header_addons = array(
	// Header Contact.
	'header_contact_items' => array(
		'items' => array(
			array(
				'id' => 'phone',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'link' => '#',
				'icon' => 'phone',
				'title' => '',
				'label' => 'Call us: 987-6543-210',
			),
			array(
				'id' => 'hours',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'link' => '#',
				'icon' => 'hours',
				'title' => '',
				'label' => '36th ave queens ny 11106',
			),
		),
	),
	'header_contact_item_spacing' => array(
		'size' => 40,
		'unit' => 'px',
	),
	'header_contact_icon_size' => array(
		'size' => 0,
		'unit' => 'em',
	),
	'header_contact_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//header account
	'header_account_in_icon_size' => array(
		'size' => 21,
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_account_icon_size' => array(
		'size' => 21,
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//mobile account
	'header_mobile_account_in_icon_size' => array(
		'size' => 19,
		'unit' => 'px',
	),
	'header_mobile_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_mobile_account_icon_size' => array(
		'size' => 19,
		'unit' => 'px',
	),
	'header_mobile_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);
$more_addons = array();
$woo_addons = array(
	'product_filter_widget_title' => array(
		'size' => array(
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => 'palette3',
	),
	'product_filter_widget_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
);
$dark_mode_addons = array(
	'dark_mode_custom_logo' => true,
 );