<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Theme
 * @since 1.0
 */

$default_options = array(
	'content_width' => array(
		'size' => 1830,
		'unit' => 'px',
	),
	// Logo
	'logo_layout'     => array(
		'include' => array(
			'mobile'  => 'logo',
			'tablet'  => 'logo',
			'desktop' => 'logo_only',
		),
	),
	'content_background'                => array(
		'desktop' => array(
			'color' => 'palette8',
		),
	),
	// Sidebar.
	'sidebar_link_style' => 'plain',
	'sidebar_width'   => array(
		'size' => '350',
		'unit' => 'px',
	),
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 16,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '700',
		'variant' => '700',
		'color'   => 'palette3',
	),
	'sidebar_widget_content'            => array(
		'size' => array(
			'mobile' => '14',
		),
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'mobile' => 1.5,
			'desktop' => 1.6,
		),
		'family'  => 'Open Sans',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color' => 'palette4'
	),
	'heading_font'        => array(
		'family' => 'Inherit',
	),
	'h1_font' => array (
		'size' => array(
			'mobile' => 22,
			'tablet' => 28,
			'desktop' => 32,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'h2_font' => array (
		'size' => array(
			'mobile' => 20,
			'tablet' => 24,
			'desktop' => 28,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h3_font' => array (
		'size' => array(
			'mobile' => 20,
			'tablet' => 22,
			'desktop' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h4_font' => array (
		'size' => array(
			'mobile' => 16,
			'tablet' => 20,
			'desktop' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h5_font' => array (
		'size' => array(
			'mobile' => 16,
			'tablet' => 18,
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h6_font' => array (
		'size' => array(
			'mobile' => 14,
			'tablet' => 16,
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'title_above_font' => array(
		'size' => array(
			'mobile' => 24,
			'tablet' => 26,
			'desktop' => 30,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'transform' => 'uppercase',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	// Button
	'buttons_padding'        => array(
		'size'   => array( 
			'desktop' => array( 8 , 18 , 8 , 18 ),
			'tablet' => array(  8 , 20 , 8 , 20 ),
			'mobile' => array(  5 , 18 , 5 , 18 ),
		),
	),
	'buttons_color'                     => array(
		'color'  => 'palette9',
		'hover'  => 'palette9',
	),
	'buttons_background' => array(
		'color'  => 'palette1',
		'hover'  => 'palette2',
	),
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => 5,
		),
	),
	'buttons_typography'    => array(
		'size' => array(
			'tablet' => 14,
			'desktop' => 15,
		),
		'lineHeight' => array(
			'desktop' => '1.8',
			'mobile' => '2',
		),
		'transform' => 'capitalize',
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'=> 'px',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
	),
	// Header.
	'header_desktop_items'       => array(
		'top' => array(
			'top_left'         => array( ),
		),
		'main' => array(
			'main_left'         => array( 'logo' ),
			'main_center'       => array( 'navigation' ),
			'main_right'        => array( 'search' , 'account' , 'cart'),
		),
		'bottom' => array(
			'bottom_left'         => array( ),
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation' ),
		),
		'top' => array(
			'top_left'   => array(),
		),
		'main' => array(
			'main_left'   => array( 'popup-toggle', 'mobile-logo' ),
			'main_right'  => array( 'search', 'mobile-account', 'mobile-cart' ),
		),
		'bottom' => array(
			'bottom_left'   => array(),
		),
	),
	// Header Main.
	'header_main_height' => array(
		'size' => array(
			'mobile'  => 80,
			'desktop' => 95,
		),
	),
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	 ),
	// Navigation.
	'primary_navigation_typography'            => array(
		'size' => array(
			'desktop' => 16,
		),
	),
	'primary_navigation_color'   => array(
		'color'  => 'palette4',
		'hover'  => 'palette1',
		'active'  => 'palette4',
	),
	'primary_navigation_vertical_spacing'   => array(
		'size' => 2.6,
		'unit' => 'em',
	),
	'primary_navigation_spacing'            => array(
		'size' => 50,
		'unit' => 'px',
	),
	// dropdown
	'dropdown_navigation_typography'            => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => '1.7',
		),
	),
	'dropdown_navigation_color'              => array(
		'color'  => 'palette4',
		'hover'  => 'palette1',
		'active' => 'palette1',
	),
	// Header Search.
	'header_search_icon_size' => array(
		'size' => array(
			'desktop'  => 26,
		),
		'unit' => array(
			'mobile'  => 'px',
			'tablet'  => 'px',
		),
	),
	'header_search_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// Header Cart.
	'header_cart_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_cart_icon_size'   => array(
		'size' => '25',
		'unit' => 'px',
	),
	'header_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_cart_total_background'              => array(
		'color' => 'palette3',
	),
	// Mobile Header Cart.
	'header_mobile_cart_icon_size'   => array(
		'size' => '24',
		'unit' => 'px',
	),
	'header_mobile_cart_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_mobile_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_mobile_cart_total_background'              => array(
		'color' => 'palette3',
	),
	// Mobile Trigger.
	'mobile_trigger_icon_size'   => array(
		'size' => 24,
		'unit' => 'px',
	),
	'mobile_trigger_color'              => array(
		'color' => 'palette3',
		'hover'  => 'palette1',
	),
	// Footer
	'footer_items'       => array(
		'top' => array(
			'top_1' => array(),
		),
		'middle' => array(
			'middle_1' => array('footer-widget1' , 'footer-social'),
			'middle_2' => array('footer-widget2'),
			'middle_3' => array('footer-widget3'),
			'middle_4' => array('footer-widget4'),
		),
		'bottom' => array(
			'bottom_1' => array( 'footer-html' ),
			'bottom_2' => array('footer-widget5'),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette8',
		),
	),
	// Footer Widget 5.
	'footer_widget5_align'         => array(
		'mobile' => 'center',
		'desktop' => 'right',
	),
	//footer_middle
	'footer_middle_columns' => '4',
	'footer_middle_layout'  => array(
		'mobile'  => 'row',
		'tablet'  => 'two-grid',
		'desktop' => 'column',
	),
	'footer_middle_widget_title'  => array(
		'size' => array(
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'footer_middle_widget_content' => array(
		'color'   => 'palette4',
	),
	'footer_middle_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'tablet' => '30',
			'desktop' => '30',

		),
	),
	'footer_middle_top_spacing' => array(
		'size' => array(
			'mobile'  => '20',
			'tablet'  => '20',
			'desktop' => '40',
		),
	),
	'footer_middle_direction'         => array(
		'mobile'  => 'column',
		'tablet'  => '',
		'desktop' => 'column',
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'mobile'  => '40',
			'tablet'  => '55',
			'desktop' => '60',
		),
	),
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'rgba(255,255,255,0.1)',
		),
	),
	'footer_middle_link_style' => 'noline',
	//footer_bottom
	'footer_bottom_columns' => '2',
	'footer_bottom_link_style' => 'noline',
	'footer_bottom_layout'  => array(
		'mobile'  => 'row',
		'tablet'  => 'equal',
		'desktop' => 'row',
	),
	'footer_bottom_direction'         => array(
		'tablet'  => 'column',
		'desktop' => 'row',
	),
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'mobile'  => '15',
			'tablet'  => '15',
			'desktop' => '30',
		),
		'unit' => array(
			'mobile'  => 'px',
			'tablet'  => 'px',
			'desktop' => 'px',
		),
	),
	'footer_bottom_bottom_spacing' => array(
		'size' => array(
			'mobile'  => '',
			'tablet'  => '80',
			'desktop' => '90',
		),
		'unit' => array(
			'mobile'  => 'px',
			'tablet'  => 'px',
			'desktop' => 'px',
		),
	),
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'mobile'  => '10',
		),
	),
	'footer_bottom_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette3',
	),
	'footer_bottom_top_spacing' => array(
		'size' => array(
			'mobile' => '15',
			'desktop' => '18',
		),
	),
	'footer_bottom_widget_content' => array(
		'color'   => 'palette4',
	),
	// Footer_html
	'footer_html_margin' => array(
		'size'   => array( '0', '', '0', '' ),
	),
	'footer_html_link_color'              => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
	'footer_html_align'         => array(
		'mobile' => 'center',
	),
	// Footer Social.
	'footer_social_items' => array(
		'items' => array(
			array(
				'id'      => 'facebook',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'facebookAlt2',
				'label'   =>  __( 'Facebook', 'templatemela-theme-wooti' ),
			),
			array(
				'id'      => 'twitter',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'twitterAlt2',
				'label'   =>  __( 'Twitter', 'templatemela-theme-wooti' ),
			),
			array(
				'id'      => 'instagram',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'instagramAlt',
				'label'   =>  __( 'Instagram', 'templatemela-theme-wooti' ),
			),
			array(
				'id'      => 'linkedin',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'linkedinAlt',
				'label'   =>  __( 'Linkedin', 'templatemela-theme-wooti' ),
			),
			array(
				'id'      => 'youtube',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'youtubeAlt',
				'label'   =>  __( 'YouTube', 'templatemela-theme-wooti' ),
			),
		),
	),
	'footer_social_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'footer_social_icon_size' => array(
		'size' => 1.2,
		'unit' => 'em',
	),
	'footer_social_align'         => array(
		'desktop' => 'left',
	),
	// Product
	'product_archive_title_font'   => array(
		'size' => array(
			'mobile' => 14,
			'tablet' => 18,
			'desktop' => 20,
		),
		'lineHeight' => array(
			'mobile' => 1.4,
			'desktop' => 1.5,
		),
		'lineType' => 'em',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'product_archive_price_font'   => array(
		'size' => array(
			'mobile' => 14,
			'tablet' => 16,
			'desktop' => 18,
		),
		'lineType' => 'em',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'product_title_font'   => array(
		'size' => array(
			'desktop' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
	),
	'product_archive_sidebar_id'         => 'sidebar-woocommerce-shop',
	'product_archive_button_style'      => 'button',
	// Breadcrumbs
	'search_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'page_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);

$header_addons = array(
	//header account
	'header_account_icon_size'               => array(
		'size' => 23,
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_account_in_icon_size'               => array(
		'size' => 23,
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//mobile account
	'header_mobile_account_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_mobile_account_in_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);
$more_addons = array();
$woo_addons = array(
	'product_filter_widget_link_colors'       => array(
		'color'  => 'palette4',
		'hover'  => 'palette1',
	),
	'product_filter_widget_content'        => array(
		'size' => array(
			'desktop' => 14,
		),
	),
	'product_filter_widget_title'        => array(
		'size' => array(
			'desktop' => 16,
		),
		'weight'  => '700',
		'variant' => '700',
		'color'   => 'palette3',
	),
);


$dark_mode_addons = array(
	'dark_mode_default'            => 'dark',
	'dark_mode_custom_logo'        => true,
);