<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Plugin
 * @since 1.0
 */

 $default_options = array(
	'content_width' => array(
		'size' => 1430,
		'unit' => 'px',
	),
	// Logo
	'logo_layout'     => array(
		'include' => array(
			'mobile'  => 'logo_only',
			'tablet'  => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	// Sidebar.
	'sidebar_width'   => array(
		'size' => '308',
		'unit' => 'px',
	),
	'sidebar_link_style' => 'plain',
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'Jost',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color' => 'palette4'
	),
	'heading_font'        => array(
		'family' => 'inherit',
	),
	'h1_font' => array (
		'size' => array(
			'mobile' => 24,
			'tablet' => 32,
			'desktop' => 36,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h2_font' => array (
		'size' => array(
			'desktop' => 30,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h3_font' => array (
		'size' => array(
			'tablet' => 18,
			'desktop' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h4_font' => array (
		'size' => array(
			'mobile' => 16,
			'tablet' => 18,
			'desktop' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h5_font' => array (
		'size' => array(
			'mobile' => 15,
			'tablet' => 16,
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h6_font' => array (
		'size' => array(
			'mobile' => 15,
			'tablet' => 16,
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'title_above_font' => array(
		'size' => array(
			'mobile' => 26,
			'desktop' => 30,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	// Buttons.
	'buttons_color' => array(
		'color'  => 'palette3',
		'hover'  => 'palette9',
	),
	'buttons_background' => array(
		'color'  => 'transparent',
		'hover'  => 'palette1',
	),
	'buttons_border_colors' => array(
		'color'  => 'palette1',
		'hover'  => 'palette1',
	),
	'buttons_border'        => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'palette1',
		),
	),
	'buttons_padding'        => array(
		'size'   => array( 
			'desktop' => array( 7 , 29 , 7 , 29 ),
		),
	),
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => 5,
		),
	),
	'buttons_typography'    => array(
		'size' => array(
			'mobile' => 15,
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.7,
		),
		'letterSpacing' => array(
			'desktop' => 0.4,
		),
		'transform' => 'capitalize',
		'spacingType'=> 'px',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	// Header.
	'header_desktop_items'       => array(
		'top' => array(
			'top_left'         => array('social'),
			'top_center'         => array('html'),
			'top_right'        => array('navigation-2'),
		),
		'main' => array(
			'main_left'         => array( 'navigation' ),
			'main_center'       => array( 'logo' ),
			'main_right' => array( 'search' , 'wishlist' , 'account' , 'cart' ),
		),
		'bottom' => array(
			'bottom_left'         => array(),
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation'),
		),
		'top' => array(
			'top_center' => array( 'mobile-html' ),
		),
		'main' => array(
			'main_left'   => array( 'popup-toggle', 'mobile-logo' ),
			'main_right'  => array( 'search', 'wishlist', 'mobile-account', 'mobile-cart' ),
		),
		'bottom' => array(
			'bottom_left'   => array(),
		),
	),
	// Header top.
	'header_top_height' => array(
		'size' => array(
			'desktop' => 40,
		),
	),
	'header_top_background' => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	'header_top_layout'         => array(
		'desktop' => 'fullwidth',
	),
	'header_top_padding' => array(
		'size'   => array( 
			'tablet' => array( '', 15, '', 15 ),
			'desktop' => array( '', 50, '', 50 ),
		),
	),
	// Header-main
	'header_main_height' => array(
		'size' => array(
			'mobile'  => 75,
			'desktop' => 92,
		),
	),
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	),
	'header_main_layout'         => array(
		'desktop' => 'fullwidth',
	),
	'header_main_padding' => array(
		'size'   => array( 
			'tablet' => array( '', 15, '', 15 ),
			'desktop' => array( '', 50, '', 50 ),
		),
	),
	// Header HTML.
	'header_html_content'    => __( 'Free Express Shipping on orders $ 100!', 'templatemela-plugin-wooti' ),
	'header_html_wpautop' => false,
	'header_html_typography' => array(
		'size' => array(
			'desktop' => 15,
		),
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette9',
	),
	// Header-mobile-html
	'mobile_html_wpautop'    => false,
	// Header Social.
	'header_social_items' => array(
		'items' => array(
			array(
				'id'      => 'facebook',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'facebookAlt',
				'label'   =>  __( 'Facebook', 'templatemela-plugin-wooti' ),
			),
			array(
				'id'      => 'twitter',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'twitterAlt2',
				'label'   =>  __( 'X', 'templatemela-plugin-wooti' ),
			),
			array(
				'id'      => 'instagram',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'instagramAlt',
				'label'   =>  __( 'Instagram', 'templatemela-plugin-wooti' ),
			),
			array(
				'id'      => 'linkedin',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'linkedinAlt',
				'label'   =>  __( 'Linkedin', 'templatemela-plugin-wooti' ),
			),
		),
	),
	'header_social_color' => array(
		'color' => 'palette9',
		'hover' => 'palette9',
	),
	// Navigation.
	'primary_navigation_color'   => array(
		'color'  => 'palette3',
		'hover'  => 'palette2',
		'active'  => 'palette3',
	),
	'primary_navigation_vertical_spacing'   => array(
		'size' => 2.6,
		'unit' => 'em',
	),
	'primary_navigation_spacing'            => array(
		'size' => 40,
		'unit' => 'px',
	),
	// Secondary Navigation.
	'secondary_navigation_typography'            => array(
		'size' => array(
			'desktop' => 15,
		),
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette9',
	),
	'secondary_navigation_spacing'            => array(
		'size' => 36,
		'unit' => 'px',
	),
	'secondary_navigation_color'   => array(
		'color'  => 'palette9',
		'hover'  => 'palette9',
		'active' => 'palette9',
	),
	// Header Search.
	'header_search_icon_size' => array(
		'size' => array(
			'tablet' => 24,
			'desktop' => 24,
		),
		'unit' => array(
			'tablet' => 'px',
			'desktop' => 'px',
		),
	),
	'header_search_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette2',
	),
	// Header Cart.
	'header_cart_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette2',
	),
	'header_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_cart_total_background'              => array(
		'color' => 'palette3',
	),
	'header_cart_icon_size'   => array(
		'size' => 23,
		'unit' => 'px',
	),
	// Mobile Header Cart.
	'header_mobile_cart_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette2',
	),
	'header_mobile_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_mobile_cart_total_background'              => array(
		'color' => 'palette3',
	),
	'header_mobile_cart_icon_size'   => array(
		'size' => 23,
		'unit' => 'px',
	),
	// Mobile Trigger.
	'mobile_trigger_icon_size'   => array(
		'size' => 1.7,
		'unit' => 'em',
	),
	'mobile_trigger_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette2',
	),
	// Footer.
	'footer_items' => array(
		'top' => array(
			'top_1' => array(),
		),
		'middle' => array(
			'middle_1' => array( 'footer-widget1' ),
			'middle_2' => array( 'footer-widget2','footer-widget3','footer-widget4' ),
			'middle_3' => array( 'footer-widget5' ),
		),
		'bottom' => array(
			'bottom_1' => array( 'footer-html' ),
			'bottom_2' => array( 'footer-widget6' ),
		),
	),
	//footer middle
	'footer_middle_widget_title' => array(
		'size' => array(
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'letterSpacing' => array(
			'desktop' => 0.1,
		),
		'transform' => 'uppercase',
		'spacingType' => 'px',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	'footer_middle_widget_content' => array(
		'color' => 'palette4',
	),
	'footer_middle_widget_content_color' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
	'footer_middle_link_style' => 'noline',
	'footer_middle_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
	'footer_middle_top_spacing' => array(
		'size' => array(
			'mobile' => 40,
			'tablet' => 60,
			'desktop' => 68,
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'mobile' => 40,
			'tablet' => 60,
			'desktop' => 68,
		),
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'mobile' => 30,
			'tablet' => 50,
			'desktop' => 30,
		),
	),
	//footer bottom
	'footer_bottom_columns' => '2',
	'footer_bottom_link_style' => 'noline',
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'tablet' => 15,
			'desktop' => 30,
		),
	),
	//footer html
	'footer_html_typography' => array(
		'color' => 'palette4',
	),
	'footer_html_align' => array(
		'desktop' => 'left',
		'tablet' => 'center',
	),
	'footer_html_link_color' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
	// Footer Widget 6.
	'footer_widget6_align' => array(
		'desktop' => 'right',
		'tablet' => 'center',
	),
	//product
	'product_archive_button_style' => 'button',
	'product_archive_sidebar_id'         => 'sidebar-woocommerce-shop',
	'product_related_columns'    => '4',
	'product_upsell_columns'    => '4',
	'product_archive_title_font' => array(
		'size' => array(
			'mobile' => 15,
			'tablet' => 16,
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'lineType' => 'em',
		'letterSpacing' => array(
			'desktop' => 0.4,
		),
		'spacingType'=> 'px',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'product_archive_price_font'   => array(
		'size' => array(
			'mobile' => 15,
			'tablet' => 17,
			'desktop' => 18,
		),
		'lineType' => 'em',
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'=> 'px',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'product_title_font'   => array(
		'size' => array(
			'desktop'  => 28,
			'tablet'  => 26,
			'mobile'  => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'lineType' => 'em',
		'weight'  => '400',
		'variant' => '400',
	),
	'product_archive_button_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette9',
	),
	'product_archive_button_background'              => array(
		'color' => 'palette9',
		'hover' => 'palette3',
	),
	'product_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	//post
	'post_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	//page
	'page_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	//search
	'search_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
);

$header_addons = array(
	'header_account_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette2',
	),
	// Acoount-in
	'header_account_in_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette2',
	),
	// Mobile Header Account.
	'header_mobile_account_icon_size'               => array(
		'size' => '22',
		'unit' => 'px',
	),
	'header_mobile_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette2',
	),
	'header_mobile_account_in_icon_size'               => array(
		'size' => '22',
		'unit' => 'px',
	),
	'header_mobile_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette2',
	),
);
$more_addons = array(
	//header wishlist
	'header_wishlist_icon_size' => array(
		'size' => array(
			'desktop' => 22,
			'tablet' => 20,
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_wishlist_color' => array(
		'color' => 'palette3',
		'hover' => 'palette2',
	),
	'header_wishlist_total_color' => array(
		'color' => 'palette9',
	),
	'header_wishlist_total_background' => array(
		'color' => 'palette3',
	),
);
$woo_addons = array(
	'product_filter_widget_link_colors'       => array(
		'color'  => 'palette4',
		'hover'  => 'palette1',
	),
	'product_filter_widget_content'        => array(
		'size' => array(
			'desktop' => 14,
		),
	),
	'product_filter_widget_title'        => array(
		'size' => array(
			'desktop' => 18,
		),
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
);


$dark_mode_addons = array(
	'dark_mode_custom_logo'        => true,
 );