<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Theme
 * @since 1.0
 */

$default_options = array(
	'content_width' => array(
		'size' => 1430,
		'unit' => 'px',
	),
	// Logo
	'logo_layout'     => array(
		'include' => array(
			'mobile'  => 'logo_only',
			'tablet'  => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'mobile' => 14,
			'tablet' => 15,
			'desktop' => 16,
		),
		'lineHeight' => array(
			'mobile' => 1.4,
			'desktop' => 1.6,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'family'  => 'Heebo',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette4',
	),
	'heading_font'        => array(
		'family' => 'Heebo',
	),
	'h1_font' => array(
		'size' => array(
			'mobile' => 23,
			'tablet' => 35,
			'desktop' => 48,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'letterSpacing' => array(
			'desktop' => 0,
		),
		'spacingType' => 'px',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'mobile' => 22,
			'desktop' => 28,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'desktop' => 24,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'desktop' => 22,
		),
		'color'   => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'desktop' => 20,
		),
		'color'   => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'desktop' => 18,
		),
		'color'   => 'palette3',
	),
	'title_above_font' => array(
		'size' => array(
			'mobile' => 20,
			'tablet' => 23,
			'desktop' => 28,
		),
	),
	'title_above_breadcrumb_font' => array(
		'size' => array(
			'mobile' => 14,
			'tablet' => 15,
			'desktop' => 16,
		),
	),
	// Buttons.
	'buttons_color'                     => array(
		'color'  => 'palette3',
		'hover'  => 'palette9',
	),
	'buttons_background' => array(
		'color'  => 'transparent',
		'hover'  => 'palette1',
	),
	'buttons_border_colors' => array(
		'color' => 'palette3',
		'hover'  => 'palette1',
	),
	'buttons_border'        => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
		),
	),
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => 5,
		),
	),
	'buttons_typography'    => array(
		'size' => array(
			'mobile' => 13,
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 2,
		),
		'letterSpacing' => array(
			'desktop' => 0,
		),
		'spacingType' => 'px',
		'transform'  => 'uppercase',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'buttons_padding'        => array(
		'size'   => array( 
			'mobile' => array( 6, 15, 6, 15 ),
			'desktop' => array( 8, 26, 8, 26 ),
		),
		'unit'   => array(
			'desktop' => 'px',
		),
		'locked' => array(
			'desktop' => false,
		),
	),
	// Header.
	'header_desktop_items'       => array(
		'top' => array(
			'top_left'         => array(),
		),
		'main' => array(
			'main_left'         => array( 'logo' ),
			'main_center'       => array( 'navigation' ),
			'main_right'        => array( 'search' , 'wishlist' , 'account' , 'cart' ),
		),
		'bottom' => array(
			'bottom_left'         => array(),
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_left'   => array(),
		),
		'main' => array(
			'main_left'   => array( 'popup-toggle', 'mobile-logo' ),
			'main_right'  => array( 'wishlist', 'mobile-account', 'mobile-cart' ),
		),
		'bottom' => array(
			'bottom_center' => array( 'search-advanced' ),
		),
	),
	'header_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	// Header Main.
	'header_main_height' => array(
		'size' => array(
			'mobile'  => 70,
			'desktop' => 90,
		),
	),
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
		'tablet' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'rgba(255,255,255,0.2)',
		),
	),
	// Navigation.
	'primary_navigation_typography'            => array(
		'size' => array(
			'desktop' => 14,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'transform' => 'uppercase',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	'primary_navigation_spacing'            => array(
		'size' => 45,
		'unit' => 'px',
	),
	'primary_navigation_vertical_spacing'   => array(
		'size' => 33,
		'unit' => 'px',
	),
	'primary_navigation_color'   => array(
		'color'  => '#fff',
		'hover'  => '#fff',
		'active' => '#fff',
	),
	//header search
	'header_search_icon_size' => array(
		'size' => array(
			'desktop' => 24,
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_search_color'              => array(
		'color' => '#fff',
		'hover' => '#fff',
	),
	//header cart
	'header_cart_icon_size'   => array(
		'size' => '24',
		'unit' => 'px',
	),
	'header_cart_color'              => array(
		'color' => '#fff',
		'hover' => '#fff',
	),
	'header_cart_total_color'              => array(
		'color' => '#000',
	),
	'header_cart_total_background'              => array(
		'color' => '#fff',
	),
	//header cart mobile
	'header_mobile_cart_color'       => array(
		'color' => '#fff',
		'hover'  => '#fff',
	),
	'header_mobile_cart_icon_size' => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_mobile_cart_total_color'              => array(
		'color' => '#000',
	),
	'header_mobile_cart_total_background'              => array(
		'color' => '#fff',
	),
	//mobile trigger
	'mobile_trigger_color' => array(
		'color' => '#fff',
		'hover'  => '#fff',
	),
	'mobile_trigger_icon_size'   => array(
		'size' => 24,
		'unit' => 'px',
	),
	// Footer.
	'footer_items'       => array(
		'top' => array(
			'top_1' => array( 'footer-widget1' ),
		),
		'middle' => array(
			'middle_1' => array( 'footer-widget2' ),
			'middle_2' => array( 'footer-widget3' ),
			'middle_3' => array( 'footer-widget4' ),
			'middle_4' => array( 'footer-widget5' , 'footer-social' ),
		),
		'bottom' => array(
			'bottom_1' => array( 'footer-html' ),
			'bottom_2' => array( 'footer-widget6' ),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	//footer top
	'footer_top_columns' => '1',
	'footer_top_top_spacing' => array(
		'size' => array(
			'mobile'  => '25',
			'tablet'  => '40',
			'desktop' => '60',
		),
	),
	'footer_top_bottom_spacing' => array(
		'size' => array(
			'mobile'  => '25',
			'tablet'  => '40',
			'desktop' => '50',
		),
	),
	'footer_top_widget_content' => array(
		'size' => array(
			'mobile' => 14,
			'tablet' => 16,
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'color'   => 'palette6',
	),
	//footer middle
	'footer_middle_columns' => '4',
	'footer_middle_top_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'rgba(255,255,255,0.1)',
		),
	),
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'rgba(255,255,255,0.1)',
		),
	),
	'footer_middle_top_spacing' => array(
		'size' => array(
			'mobile'  => '35',
			'tablet'  => '40',
			'desktop' => '95',
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'mobile'  => '35',
			'tablet'  => '40',
			'desktop' => '95',
		),
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'mobile'  => '30',
			'tablet'  => '50',
			'desktop' => '30',
		),
	),
	'footer_middle_layout'  => array(
		'mobile'  => 'row',
		'tablet'  => 'two-grid',
		'desktop' => 'center-half',
	),
	'footer_middle_direction'         => array(
		'desktop' => 'column',
	),
	'footer_middle_widget_title'  => array(
		'size' => array(
			'mobile' => 16,
			'tablet' => 18,
			'desktop' => 20,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => '#fff',
	),
	'footer_middle_widget_content' => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 15,
		),
		'color'   => 'palette6',
	),
	'footer_middle_link_colors' => array(
		'color' => 'palette6',
		'hover' => '#fff',
	),
	'footer_middle_link_style' => 'noline',
	// Footer bottom
	'footer_bottom_columns' => '2',
	'footer_bottom_bottom_spacing' => array(
		'size' => array(
			'tablet'  => '80',
			'desktop' => '90',
		),
	),
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'mobile'  => '10',
			'tablet'  => '15',
			'desktop' => '30',
		),
	),
	'footer_bottom_widget_content' => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 15,
		),
		'color'   => 'palette6',
	),
	'footer_bottom_link_colors' => array(
		'color' => 'palette6',
		'hover' => '#fff',
	),
	'footer_bottom_link_style' => 'noline',
	// Footer Widget 1.
	'footer_widget1_align'         => array(
		'desktop' => 'center',
	),
	// Footer Widget 6.
	'footer_widget6_align'         => array(
		'tablet'  => 'center',
		'desktop' => 'right',
	),
	//footer html
	'footer_html_margin' => array(
		'size'   => array( '0', '', '0', '' ),
	),
	'footer_html_align'         => array(
		'tablet'  => 'center',
	),
	// Footer Social.
	'footer_social_items' => array(
		'items' => array(
			array(
				'id'      => 'facebook',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'facebookAlt2',
				'label'   => 'Facebook',
			),
			array(
				'id' => 'twitter',
				'enabled' => true,
				'source' => 'svg',
				'svg' => '<svg id="Layer_1" data-name="Layer 1"  xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500.08 511.77"><path fill="currentColor" d="M10.22,512.77c11.62-13.7,23.17-27.46,34.88-41.08q78.33-91.1,156.74-182.15c1.08-1.25,2.09-2.57,3.31-4.08L9.92,1.42c1.92-.14,3.15-.31,4.38-.31q70.2,0,140.42-.1c3.33,0,5,1.24,6.76,3.8Q223,94.6,284.75,184.27c1,1.48,2.09,2.92,3.46,4.83l25.3-29.35Q379.81,82.68,446,5.54A11.69,11.69,0,0,1,456.22,1c12.25.27,24.52.09,37.95.09L307.77,217.76l29,42.16Q422,384,507.25,508.1c1,1.48,1.84,3.11,2.75,4.67H361.07c-.67-1.14-1.28-2.32-2-3.41q-65.88-95.82-131.8-191.62c-.72-1.05-1.61-2-2.61-3.2-1.78,2-3.35,3.71-4.86,5.46q-52.6,61.13-105.19,122.25Q84.34,477.47,54.2,512.77Z" transform="translate(-9.92 -1)"/></svg>',
				'imageid' => '',
				'width' => 12,
				'icon' => 'twitterAlt',
				'label' => 'X formerly Twitter',
			),
			array(
				'id'      => 'instagram',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'instagram',
				'label'   => 'Instagram',
			),
			array(
				'id'      => 'youtube',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'youtube',
				'label'   => 'YouTube',
			),
		),
	),
	'footer_social_item_spacing' => array(
		'size' => 7,
		'unit' => 'px',
	),
	'footer_social_icon_size' => array(
		'size' => 17,
		'unit' => 'px',
	),
	'footer_social_color' => array(
		'color' => '#fff',
		'hover' => '#fff',
	),
	'footer_social_margin' => array(
		'size'   => array( 20, '', '', '' ),
		'unit'   => 'px',
		'locked' => false,
	),
	'footer_social_align'         => array(
		'desktop' => 'left',
	),
	//sidebar
	'sidebar_link_style' => 'plain',
	'sidebar_width'   => array(
		'size' => 260,
		'unit' => 'px',
	),
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 20,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	//dropdown
	'dropdown_navigation_typography'        => array(
		'size' => array(
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'transform'  => 'capitalize',
		'weight'  => '400',
		'variant' => '400',
	),
	//product
	'product_archive_button_style' => 'button',
	'product_archive_button_border_colors'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_archive_button_border'              => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
	),
	'product_archive_title_font' => array(
		'size' => array(
			'mobile' => 13,
			'tablet' => 16,
			'desktop' => 18,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'lineType'=> 'em',
		'spacingType'=> 'px',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'product_archive_price_font'   => array(
		'size' => array(
			'mobile' => 15,
			'desktop' => 16,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'=> 'px',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color'   => 'palette4',
	),
	'product_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 95,
			'tablet'  => 120,
			'desktop' => 130,
		),
	),
	'product_title_font'   => array(
		'size' => array(
			'mobile'  => '20',
			'tablet' => '25',
			'desktop' => '28',
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	'product_related_columns'    => '4',
	'product_upsell_columns'    => '4',
	//post archive
	'post_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 100,
			'desktop' => 130,
		),
	),
	'post_archive_item_title_font'   => array(
		'size' => array(
			'mobile' => '18',
			'tablet' => '21',
			'desktop' => '24',
		),
	),
	//post
	'post_title_font'   => array(
		'size' => array(
			'mobile' => '16',
			'tablet' => '23',
		),
	),
	//page
	'page_title_height'       => array(
		'size' => array(
			'mobile'  => 95,
			'tablet'  => 120,
			'desktop' => 130,
		),
	),
	//search 
	'search_archive_title_height'       => array(
		'size' => array(
			'mobile'  => '95',
			'tablet'  => '120',
			'desktop' => '130',
		),
	),
	//links
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);
$header_addons = array(
	//header account
	'header_account_icon_size'               => array(
		'size' => '24',
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => '#fff',
		'hover' => '#fff',
	),
	//header account in
	'header_account_in_icon_size'               => array(
		'size' => '24',
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => '#fff',
		'hover' => '#fff',
	),
	//header mobile account
	'header_mobile_account_icon_size' => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_mobile_account_color' => array(
		'color' => '#fff',
		'hover'  => '#fff',
	),
	'header_mobile_account_in_icon_size' => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_mobile_account_in_color' => array(
		'color' => '#fff',
		'hover'  => '#fff',
	),
);
$more_addons = array(
	//header wishlist
	'header_wishlist_show_total' => false,
	'header_wishlist_icon_size'   => array(
		'size' => array(
			'desktop' => '24',
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_wishlist_color'              => array(
		'color' => '#fff',
		'hover' => '#fff',
	),
	//header search advanced
	'header_search_advanced_width' => array(
		'size' => array(
			'mobile'  => 280,
			'tablet'  => '',
			'desktop' => 450,
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_search_advanced_color'       => array(
		'color'  => '#fff',
		'hover'  => '#fff',
	),
	'header_search_advanced_background'       => array(
		'color'  => 'transparent',
	),
	'header_search_advanced_buttons_background' => array(
		'color'  => 'transparent',
		'hover'  => 'transparent',
	),
	'header_search_advanced_buttons_color' => array(
		'color'  => '#fff',
		'hover'  => '#fff',
	),
	'header_search_advanced_border' => array(
		'width' => '1',
		'unit'  => 'px',
		'style' => 'solid',
	),
	'header_search_advanced_border_color'       => array(
		'color'  => 'rgba(255,255,255,0.3)',
	),
	'header_search_advanced_border_radius' => array(
		'size'   => array( 0, 0, 0, 0 ),
		'unit'   => 'px',
		'locked' => true,
	),
	'header_search_advanced_button_radius' => array(
		'size'   => array( 0, 0, 0, 0 ),
		'unit'   => 'px',
		'locked' => true,
	),
	'header_search_advanced_button_typography'        => array(
		'size' => array(
			'desktop' => 20,
		),
	),
);
$woo_addons = array(
	'product_filter_widget_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_filter_widget_title' => array(
		'size' => array(
			'desktop' => 17,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	), 
);
$dark_mode_addons = array(
	'dark_mode_custom_logo'        => true,
 );