<?php
/**shoes
 * Layout functions and definitions.
 * by TemplateMela.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 */


use function Base\webapp;
 
/*
 * Import Default Layout Styles
 *
 */
function wooti_furniture02_enqueue_styles() {
    wp_enqueue_style( 'wooti-furniture02-style',
        TMTHEME_URL . 'layouts/furniture02/style.css',
        array(),
        TMTHEME_VERSION
    );
    wp_enqueue_script( 'wooti-furniture02-js',
        TMTHEME_URL . 'layouts/furniture02/custom.js',
        array(),
        TMTHEME_VERSION
    );
}

add_action(  'wp_enqueue_scripts', 'wooti_furniture02_enqueue_styles' , 9999 );

/**
 * Setup Layout Theme Defaults
 *
 * @param array  registered option defaults with base theme.
 * @return array
 */
function wooti_layout_change_option_defaults( $defaults ) {
    $new_defaults = '{
        "post_content_style": "unboxed"
    }';
    $new_defaults = json_decode( $new_defaults, true );
    return wp_parse_args( $new_defaults, $defaults );
}
//add_filter( 'base_theme_options_defaults', 'wooti_layout_change_option_defaults', 20 );

/*
 * Set Default Logo
 * Filter the output of logo to fix Googles Error about itemprop logo
 */
add_filter( 'base_custom_logo', 'wooti_set_default_logo', 10, 2 );
function wooti_set_default_logo( $html, $blog_id ) {

	$custom_logo_id = webapp()->option( 'custom_logo' );
    // if logo is uploaded then return
    if ( ! empty($custom_logo_id) ) {
        return $html;
    }
    
    $custom_logo_path = TMTHEME_URL . 'layouts/furniture02/img/';
	$html = sprintf( '<a href="%1$s" class="custom-logo-link" rel="home" itemprop="url">%2$s</a>',
        esc_url( home_url( '/' ) ),
        '<img decoding="async" width="110" height="72" src="' . $custom_logo_path . 'logo.svg"  class="logo" alt="' . get_bloginfo( 'name' ) . '" loading="lazy" srcset="' . $custom_logo_path . 'logo.svg 479w, ' . $custom_logo_path . 'logo.svg 200w" sizes="(max-width: 479px) 100vw, 479px" data-src="' . $custom_logo_path . 'logo.svg">');
        
        if ( webapp()->option( 'dark_mode_enable' ) && apply_filters( 'base_dark_mode_enable', true ) ) {
            $custom_logo_id = webapp()->option( 'dark_mode_logo' );
            // if dark logo is uploaded then return
            if ( ! empty($custom_logo_id) ) {
                return $html;
            }
            $html .= sprintf( '<a href="%1$s" class="brand" rel="home" itemprop="url">%2$s</a>',
            esc_url( home_url( '/' ) ),
            '<img decoding="async" width="110" height="72" src="' . $custom_logo_path . 'dark-logo.svg"  class="base-dark-mode-logo svg-logo-image logo" alt="' . get_bloginfo( 'name' ) . '" loading="lazy" srcset="' . $custom_logo_path . 'dark-logo.svg 479w, ' . $custom_logo_path . 'dark-logo.svg 200w" sizes="(max-width: 479px) 100vw, 479px" data-src="' . $custom_logo_path . 'dark-logo.svg">');

	    }
    return $html;	
}


// Override default theme icons
add_filter( 'base_svg_icon', 'wooti_override_theme_icons', 10, 4 );
function wooti_override_theme_icons( $output, $icon, $icon_title = '', $base = true, $aria = false ) {
    if ( 'shopping-cart' === $icon ) {
        return '<span class="base-svg-iconset"><svg class="thebase-svg-icon thebase-shopping-cart-svg" fill="currentColor" xmlns="http://www.w3.org/2000/svg" id="Layer_1" data-name="Layer 1" viewBox="0 0 442.92 512"><path d="M951,284h19c7.4,1.82,15,3.05,22.17,5.56a94.21,94.21,0,0,1,62.69,87.28c.11,5.92,0,11.85,0,18.12H1061c22,0,44,0,66,0,9.28,0,15.13,5.21,16.13,14.32,2.39,21.68,4.63,43.37,6.92,65.06q5.27,49.94,10.52,99.85T1171,674.08c3.47,33.11,6.68,66.26,10.57,99.33,1.21,10.27-.65,18.05-10.58,22.59H750c-9.39-4.61-12.48-12-10.39-22.15,1-5,1-10.26,1.57-15.39q9.81-92.87,19.64-185.71,8.53-80.94,17-161.88c1.15-11,6.64-15.88,17.73-15.9q32.48,0,65,0h5.7c0-6.29-.1-11.93,0-17.57.83-42.66,28.83-78.88,69.73-90.11C940.91,285.93,946,285.08,951,284ZM771.2,765.15h378.74Q1132.06,595,1114.28,425.67h-59.37v4.76c0,9.33.11,18.66,0,28-.15,9-6.43,15.51-14.79,15.71-8.7.2-15.24-6.11-15.75-15.27-.13-2.33,0-4.67,0-7V425.73H896.85v5.85c0,9.16.19,18.33-.08,27.49-.26,8.65-6.73,14.93-14.92,15.06-8.45.14-15-6.11-15.59-14.92-.16-2.49,0-5,0-7.5v-26.1H806.86Q789,595.44,771.2,765.15Zm253-370.43c0-6.35.27-12.47,0-18.56-1.3-25.33-13.34-44.22-36-55.15-23.28-11.23-46.12-8.68-66.71,7.11-22,16.87-27,40.32-24.07,66.6Z" transform="translate(-738.98 -284)"/></svg></span>';
    }
    if ( 'account' === $icon ) {
        return '<span class="base-svg-iconset"><svg class="thebase-svg-icon thebase-account-svg" fill="currentColor" xmlns="http://www.w3.org/2000/svg" id="Layer_1" data-name="Layer 1" viewBox="0 0 104.01 104.11"><path d="M940.71,543.31c-14.66-18.37-14.86-35.49-.79-47.82A30.68,30.68,0,0,1,982,497.28c9.56,9.68,14.42,29.4-3.12,45.91,1.73.69,3.18,1.21,4.57,1.84,16.9,7.7,26.23,20.9,28.44,39.25.15,1.31.54,3,0,3.92-.92,1.49-2.46,3.26-4,3.5-1,.17-3.13-1.8-3.6-3.19-.82-2.47-.6-5.27-1.1-7.87a38.7,38.7,0,0,0-40-31.29c-4.15.22-8.35-.16-12.45.33C931.21,552,917.46,566.56,916,586.21c-.35,4.75-3.18,7.3-5.84,5.07a7.5,7.5,0,0,1-2-5.6C909.66,566.6,919.2,553,936.65,545,938,544.42,939.3,543.9,940.71,543.31Zm19.49-2.26a22.43,22.43,0,0,0,22.51-22.49,22.7,22.7,0,0,0-45.39-.1C937.18,531.09,947.3,541.08,960.2,541.05Z" transform="translate(-908.13 -487.99)"/></svg></span>';
    }
    if ( 'header-wishlist' === $icon ) {
        return '<span class="base-svg-iconset"><svg class="thebase-svg-icon thebase-wishlist-svg" fill="currentColor" stroke-width="3" stroke="currentColor" xmlns="http://www.w3.org/2000/svg" id="Layer_1" data-name="Layer 1" viewBox="0 0 512 456.09"><path d="M1216,477c-1.76,10-3,20.07-5.4,29.89-6.32,26-19,48.92-34.87,70.17-24.47,32.79-54.22,60.51-84.93,87.23q-54.32,47.26-109,94.09c-14,12-29,12.57-42.44.9-47.45-41.16-95-82.19-141.9-124-23.78-21.21-45.13-44.87-62.6-71.76-16.49-25.38-27.52-52.73-30.14-83.14A26.34,26.34,0,0,0,704,477V454c.29-1.61.7-3.21.85-4.83,2.82-29.1,11.89-56,29.31-79.6,24.65-33.38,57.7-52.71,99.15-56.75,46.65-4.55,84.62,12.77,115.5,47.13,3.85,4.27,7.4,8.8,10.87,12.94,7.6-8.23,14.42-16.72,22.34-24,39-35.79,84.41-46,134.36-29.79,51.31,16.62,81.26,54.07,94.52,105.49,2.47,9.6,3.44,19.59,5.1,29.4ZM959.85,737.45c1.19-.94,2-1.53,2.73-2.17,37.72-32.55,75.57-64.95,113.12-97.69,26.9-23.47,52.83-48,74.52-76.51,17.14-22.55,30.47-47,34.18-75.55,5-38.74-2.82-74.24-28-104.91-36.81-44.81-111.93-56.58-159.62-3.9-7.89,8.72-14.4,18.7-21.54,28.1-8,10.47-22.43,10.56-30.33.1-2.11-2.78-3.91-5.8-5.85-8.7a139.85,139.85,0,0,0-31.92-34.17c-46.65-35.33-116.17-22.87-149.1,26-31.54,46.83-31.83,96.12-6,145.68,13.4,25.66,32.17,47.52,53.17,67.1,30.83,28.73,62.53,56.53,94.1,84.45C919.16,702.86,939.44,719.9,959.85,737.45Z" transform="translate(-704 -311.63)"/></svg></span>';
    }
    return $output;
}