<?php
/**
 * Layout functions and definitions.
 * by TemplateMela.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 */


use function Base\webapp;
 
/*
 * Import Default Layout Styles
 *
 */
function wooti_furniture_enqueue_styles() {
    wp_enqueue_style( 'wooti-furniture-style',
        TMTHEME_URL . 'layouts/furniture/style.css',
        array(),
        TMTHEME_VERSION
    );
    wp_enqueue_script( 'wooti-furniture-js',
        TMTHEME_URL . 'layouts/furniture/custom.js',
        array(),
        TMTHEME_VERSION
    );
}

add_action(  'wp_enqueue_scripts', 'wooti_furniture_enqueue_styles' , 9999 );

/**
 * Setup Layout Theme Defaults
 *
 * @param array  registered option defaults with base theme.
 * @return array
 */
function wooti_layout_change_option_defaults( $defaults ) {
    $new_defaults = '{
        "post_content_style": "unboxed"
    }';
    $new_defaults = json_decode( $new_defaults, true );
    return wp_parse_args( $new_defaults, $defaults );
}
//add_filter( 'base_theme_options_defaults', 'wooti_layout_change_option_defaults', 20 );

/*
 * Set Default Logo
 * Filter the output of logo to fix Googles Error about itemprop logo
 */
add_filter( 'base_custom_logo', 'wooti_set_default_logo', 10, 2 );
function wooti_set_default_logo( $html, $blog_id ) {

	$custom_logo_id = webapp()->option( 'custom_logo' );
    // if logo is uploaded then return
    if ( ! empty($custom_logo_id) ) {
        return $html;
    }
    
    $custom_logo_path = TMTHEME_URL . 'layouts/furniture/img/';
	$html = sprintf( '<a href="%1$s" class="custom-logo-link" rel="home" itemprop="url">%2$s</a>',
        esc_url( home_url( '/' ) ),
        '<img decoding="async" width="115" height="40" src="' . $custom_logo_path . 'logo.svg"  class="logo" alt="' . get_bloginfo( 'name' ) . '" loading="lazy" srcset="' . $custom_logo_path . 'logo.svg 479w, ' . $custom_logo_path . 'logo.svg 200w" sizes="(max-width: 479px) 100vw, 479px" data-src="' . $custom_logo_path . 'logo.svg">');
        
        if ( webapp()->option( 'dark_mode_enable' ) && apply_filters( 'base_dark_mode_enable', true ) ) {
            $custom_logo_id = webapp()->option( 'dark_mode_logo' );
            // if dark logo is uploaded then return
            if ( ! empty($custom_logo_id) ) {
                return $html;
            }
            $html .= sprintf( '<a href="%1$s" class="brand" rel="home" itemprop="url">%2$s</a>',
            esc_url( home_url( '/' ) ),
            '<img decoding="async" width="115" height="40" src="' . $custom_logo_path . 'dark-logo.svg"  class="svg-logo-image base-dark-mode-logo logo" alt="' . get_bloginfo( 'name' ) . '" loading="lazy" srcset="' . $custom_logo_path . 'dark-logo.svg 479w, ' . $custom_logo_path . 'dark-logo.svg 200w" sizes="(max-width: 479px) 100vw, 479px" data-src="' . $custom_logo_path . 'dark-logo.svg">');

	    }
    return $html;	
}


// Override default theme icons
add_filter( 'base_svg_icon', 'wooti_override_theme_icons', 10, 4 );
function wooti_override_theme_icons( $output, $icon, $icon_title = '', $base = true, $aria = false ) {
    if ( 'shopping-cart' === $icon ) {
        return '<span class="base-svg-iconset"><svg class="thebase-svg-icon thebase-shopping-cart-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="0.5" viewBox="0 0 480.000000 480.000000"><title>Shopping Cart</title><g transform="translate(0.000000,480.000000) scale(0.100000,-0.100000)"
        fill="currentColor" stroke="none">
        <path d="M112 4793 c-37 -7 -98 -75 -106 -117 -15 -77 20 -146 88 -177 36 -16
        68 -19 253 -19 255 0 291 -9 368 -91 87 -93 79 16 85 -1234 6 -1218 3 -1143
        67 -1304 60 -151 180 -305 308 -396 84 -60 213 -120 315 -147 l85 -23 1225 0
        c1350 0 1265 -4 1429 62 151 60 305 180 396 308 58 81 119 210 147 310 22 80
        23 83 26 985 3 1011 6 963 -66 1018 l-35 27 -1789 3 -1788 2 0 123 c0 229 -49
        358 -184 493 -62 62 -99 90 -158 118 -118 56 -180 66 -428 64 -118 0 -225 -3
        -238 -5z m4368 -1886 c0 -505 -4 -794 -11 -833 -38 -214 -233 -414 -446 -459
        -57 -12 -259 -15 -1219 -15 -773 0 -1170 4 -1210 11 -168 30 -335 159 -412
        319 -22 47 -45 112 -51 144 -7 39 -11 328 -11 833 l0 773 1680 0 1680 0 0
        -773z"/>
        <path d="M2352 3193 c-42 -8 -100 -76 -107 -125 -3 -24 -5 -232 -3 -464 l3
        -421 27 -35 c73 -95 220 -81 268 25 18 39 20 69 20 467 0 393 -2 428 -19 466
        -10 23 -32 51 -49 63 -31 21 -98 33 -140 24z"/>
        <path d="M3152 3193 c-42 -8 -100 -76 -107 -125 -3 -24 -5 -232 -3 -464 l3
        -421 27 -35 c73 -95 220 -81 268 25 18 39 20 69 20 467 0 393 -2 428 -19 466
        -10 23 -32 51 -49 63 -31 21 -98 33 -140 24z"/>
        <path d="M1562 1105 c-431 -98 -586 -625 -277 -939 179 -181 479 -215 691 -78
        169 109 259 273 259 472 0 198 -91 363 -259 472 -114 73 -282 103 -414 73z
        m223 -328 c88 -45 142 -145 132 -242 -6 -62 -25 -101 -68 -144 -43 -43 -82
        -62 -144 -68 -96 -10 -197 44 -242 131 -21 40 -27 123 -13 175 15 55 90 136
        145 157 49 18 148 13 190 -9z"/>
        <path d="M3802 1105 c-431 -98 -586 -625 -277 -939 179 -181 479 -215 691 -78
        169 109 259 273 259 472 0 198 -91 363 -259 472 -114 73 -282 103 -414 73z
        m223 -328 c88 -45 142 -145 132 -242 -6 -62 -25 -101 -68 -144 -43 -43 -82
        -62 -144 -68 -96 -10 -197 44 -242 131 -21 40 -27 123 -13 175 15 55 90 136
        145 157 49 18 148 13 190 -9z"/>
        </g>
        </svg></span>';
    }
    if ( 'account' === $icon ) {
        return '<span class="base-svg-iconset"><svg class="thebase-svg-icon thebase-account-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 340.79 408.79" stroke-width="3" stroke="currentColor"><title>Account</title>
        <path d="M-305.39,545.6c-4.77-1-9.62-1.73-14.29-3.08-29-8.38-47.18-30.68-48.46-61.12-1.32-31.6,2.14-62.73,14.15-92.32,7.75-19.09,19-35.61,37.87-45.71a74.74,74.74,0,0,1,37.18-8.92c4.12.08,8.46,2.16,12.22,4.21,6.05,3.29,11.67,7.39,17.55,11q51.29,31.67,102.57-.08c4.74-2.94,9.58-5.77,14-9.11,8.18-6.13,17.17-6.9,26.89-5.47,26.51,3.9,45.24,18.42,57.87,41.59,11.27,20.68,16.34,43.15,18.6,66.29a327.48,327.48,0,0,1,1.56,35.84c-.43,35.66-24.9,62.2-60.37,66.11a15.62,15.62,0,0,0-2.6.75Zm107.42-24v-.06c33.8,0,67.59.29,101.38-.1,28.08-.32,45.32-18.23,45.09-46.27a313.74,313.74,0,0,0-1.69-31.86c-2.12-18.95-6.05-37.51-15.24-54.54-9.54-17.67-23.35-29.11-44.15-30.26a10.41,10.41,0,0,0-5.55,1.37c-5.15,3-10.09,6.41-15.16,9.59-37.78,23.7-76.9,26.7-117.13,6.91-9.37-4.62-17.94-10.87-26.92-16.3-1.32-.8-2.9-1.78-4.31-1.72-12.92.58-24.51,4.64-33.8,14-7.71,7.76-13.09,17.07-17,27.19-10,25.87-12.46,53-11.8,80.35.36,15,6.82,27.21,20.12,35.07,8.86,5.23,18.67,6.64,28.78,6.64Z" transform="translate(368.4 -136.81)"/><path d="M-102,235.17c.17,54.31-43.5,98.1-98.3,98.57-54,.46-98.36-43.69-98.64-98.2a98.25,98.25,0,0,1,98.47-98.73A98.25,98.25,0,0,1-102,235.17Zm-98.49,74.62A74.29,74.29,0,0,0-126,235.28a74.23,74.23,0,0,0-74.51-74.52A74.17,74.17,0,0,0-275,235.25,74.26,74.26,0,0,0-200.52,309.79Z" transform="translate(368.4 -136.81)"/>
        </svg></span>';
    }
    if ( 'phoneAlt2' === $icon ) {
        return '<span class="base-svg-iconset"><svg class="thebase-svg-icon thebase-account-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 512.000000 512.000000"><title>phone</title>
        <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"
        fill="currentColor" stroke="none">
        <path d="M2771 5102 c-95 -48 -106 -182 -21 -244 14 -10 77 -29 140 -43 490
        -107 881 -317 1229 -658 352 -346 584 -764 686 -1237 30 -138 44 -172 79 -195
        67 -44 142 -36 194 19 27 30 32 43 32 86 0 93 -71 370 -141 551 -135 349 -343
        673 -608 942 -387 396 -860 656 -1401 772 -137 30 -145 30 -189 7z"/>
        <path d="M845 4800 c-75 -24 -124 -51 -196 -107 -75 -58 -457 -455 -507 -527
        -92 -131 -133 -282 -132 -491 0 -268 67 -537 223 -895 97 -225 197 -408 345
        -635 511 -784 1214 -1421 2008 -1818 440 -220 772 -318 1084 -321 170 -1 258
        18 400 86 l105 50 256 257 c200 199 265 271 297 326 59 101 75 167 70 284 -3
        83 -8 106 -36 165 -18 38 -57 99 -87 135 -84 103 -684 695 -740 730 -106 67
        -266 90 -386 55 -104 -31 -157 -70 -371 -282 l-206 -204 -99 51 c-421 218
        -1000 794 -1218 1214 l-57 108 138 132 c76 73 171 170 212 217 170 193 203
        377 105 580 -34 70 -61 99 -407 446 -364 365 -373 372 -458 414 -82 40 -94 43
        -185 47 -78 2 -110 -1 -158 -17z m213 -285 c25 -11 149 -128 375 -353 352
        -350 387 -393 387 -469 0 -75 -32 -118 -265 -348 -122 -121 -230 -235 -240
        -254 -13 -27 -16 -51 -13 -105 4 -63 12 -85 67 -194 269 -526 852 -1114 1393
        -1403 162 -87 203 -98 283 -75 56 17 69 28 289 245 127 126 246 236 265 246
        44 22 118 22 162 0 38 -19 652 -626 704 -695 63 -86 65 -172 5 -253 -16 -22
        -126 -138 -244 -258 -195 -197 -223 -222 -289 -253 -131 -63 -286 -71 -511
        -25 -395 79 -930 342 -1391 684 -817 607 -1492 1541 -1696 2350 -25 96 -32
        149 -36 265 -11 290 3 318 315 632 143 145 252 246 276 258 49 24 113 26 164
        5z"/>
        <path d="M2730 4173 c-91 -47 -107 -168 -31 -237 11 -10 77 -33 150 -52 284
        -72 491 -192 688 -398 180 -188 290 -396 355 -671 17 -72 27 -96 53 -122 81
        -81 223 -35 242 80 6 42 -42 245 -88 362 -191 497 -626 888 -1136 1020 -138
        36 -190 40 -233 18z"/>
        </g>
        </sv
        g></span>';
    }
    if ( 'search2' === $icon ) {
        return '<span class="base-svg-iconset"><svg aria-hidden="true" class="base-svg-icon base-search2-svg" fill="currentColor" stroke-width="0" stroke="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><title>Search</title><path d="M16.041 15.856c-0.034 0.026-0.067 0.055-0.099 0.087s-0.060 0.064-0.087 0.099c-1.258 1.213-2.969 1.958-4.855 1.958-1.933 0-3.682-0.782-4.95-2.050s-2.050-3.017-2.050-4.95 0.782-3.682 2.050-4.95 3.017-2.050 4.95-2.050 3.682 0.782 4.95 2.050 2.050 3.017 2.050 4.95c0 1.886-0.745 3.597-1.959 4.856zM21.707 20.293l-3.675-3.675c1.231-1.54 1.968-3.493 1.968-5.618 0-2.485-1.008-4.736-2.636-6.364s-3.879-2.636-6.364-2.636-4.736 1.008-6.364 2.636-2.636 3.879-2.636 6.364 1.008 4.736 2.636 6.364 3.879 2.636 6.364 2.636c2.125 0 4.078-0.737 5.618-1.968l3.675 3.675c0.391 0.391 1.024 0.391 1.414 0s0.391-1.024 0-1.414z"></path>
        </svg></span>';
    }
    return $output;
}