<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Theme
 * @since 1.0
 */

$default_options = array(
	'content_width' => array(
		'size' => 1430,
		'unit' => 'px',
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'desktop' => 16,
			'tablet' => 15,
		),
		'lineHeight' => array(
			'desktop' => 1.8,
		),
		'letterSpacing' => array(
			'desktop' => 0.2,
		),
		'spacingType' => 'px',
		'family' => 'Josefin Sans',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette4',
	),
	'heading_font' => array(
		'family' => 'EB Garamond',
	),
	'h1_font' => array(
		'size' => array(
			'desktop' => 48,
			'tablet' => 35,
			'mobile' => 25,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'mobile' => 22,
			'desktop' => 28,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'desktop' => 24,
			'tablet' => 22,
			'mobile' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'letterSpacing' => array(
			'desktop' => 0,
		),
		'spacingType' => 'px',
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'desktop' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'desktop' => 20,
			'tablet' => 18,
			'mobile' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'title_above_font' => array(
		'size' => array(
			'desktop' => 32,
		),
	),
	'title_above_breadcrumb_font' => array(
		'size' => array(
			'desktop' => 16,
			'tablet' => 15,
		),
		'color' => 'palette3',
	),
	// Buttons.
	'buttons_color' => array(
		'color' => 'palette3',
		'hover' => '#000000',
	),
	'buttons_background' => array(
		'color' => 'transparent',
		'hover' => 'palette1',
	),
	'buttons_border_colors' => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	'buttons_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit' => 'px',
			'style' => 'solid',
			'color' => 'palette1',
		),
	),
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => 0,
		),
	),
	'buttons_typography' => array(
		'size' => array(
			'desktop' => 14,
			'mobile' => 13,
		),
		'lineHeight' => array(
			'desktop' => 1.7,
			'tablet' => 1.8,
		),
		'transform' => 'uppercase',
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
	),
	'buttons_padding' => array(
		'size' => array( 
			'desktop' => array( 11, 25, 8, 25 ),
			'tablet' => array( 10, 20, 8, 20 ),
			'mobile' => array( 8, 15, 6, 15 ),
		),
	),
	// Logo
	'logo_layout' => array(
		'include' => array(
			'mobile' => 'logo_only',
			'tablet' => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	// Header.
	'header_desktop_items' => array(
		'top' => array(
			'top_left' => array( 'contact' ),
			'top_center' => array( 'html' ),
			'top_right' => array( 'html2' ),
		),
		'main' => array(
			'main_left' => array( 'logo' ),
			'main_center' => array( 'navigation' ),
			'main_right' => array( 'search' , 'wishlist' , 'account' , 'cart' ),
		),
		'bottom' => array(
			'bottom_left' => array( ),
		),
	),
	'header_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette8',
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_center' => array( 'mobile-html' ),
		),
		'main' => array(
			'main_left' => array( 'popup-toggle', 'mobile-logo' ),
			'main_right' => array( 'wishlist', 'mobile-account', 'mobile-cart' ),
		),
		'bottom' => array(
			'bottom_center' => array( 'search-advanced' ),
		),
	),
	// Header Top.
	'header_top_height' => array(
		'size' => array(
			'desktop' => 40,
		),
	),
	'header_top_background' => array(
		'desktop' => array(
			'color' => 'transparent',
		),
	),
	'header_top_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit' => 'px',
			'style' => 'solid',
			'color' => '#222e34',
		),
	),
	// Header Main.
	'header_main_height' => array(
		'size' => array(
			'desktop' => 120,
			'tablet' => 80,
			'mobile' => 70,
		),
	),
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
		'tablet' => array(
			'width' => 1,
			'unit' => 'px',
			'style' => 'solid',
			'color' => '#222e34',
		),
	),
	// Header HTML.
	'header_html_content' => __( 'We can help to find Best Food in Best Price!', 'templatemela-theme-wooti' ),
	'header_html_typography' => array(
		'color' => 'palette3',
	),
	// Navigation.
	'primary_navigation_typography' => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'transform' => 'uppercase',
		'family' => 'Josefin Sans',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
	),
	'primary_navigation_spacing' => array(
		'size' => 40,
		'unit' => 'px',
	),
	'primary_navigation_vertical_spacing' => array(
		'size' => 50,
		'unit' => 'px',
	),
	'primary_navigation_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
		'active' => 'palette1',
	),
	//cart
	'header_cart_icon_size' => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_cart_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_cart_total_color' => array(
		'color' => '#000000',
		'hover' => '#000000',
	),
	'header_cart_total_background' => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	//search
	'header_search_icon_size' => array(
		'size' => array(
			'desktop' => 23,
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_search_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//mobile html
	'mobile_html_wpautop' => false,
	'mobile_html_typography' => array(
		'color' => 'palette3',
	),
	//trigger
	'mobile_trigger_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//mobile cart
	'header_mobile_cart_icon_size' => array(
		'size' => 20,
		'unit' => 'px',
	),
	'header_mobile_cart_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_mobile_cart_total_color' => array(
		'color' => '#000000',
		'hover' => '#000000',
	),
	'header_mobile_cart_total_background' => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	//dropdown
	'dropdown_navigation_typography' => array(
		'size' => array(
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'transform' => 'capitalize',
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
	),
	// Footer.
	'footer_items' => array(
		'top' => array(
			'top_1' => array(),
		),
		'middle' => array(
			'middle_1' => array( 'footer-widget1' ),
			'middle_2' => array( 'footer-widget2' ),
			'middle_3' => array( 'footer-widget3' ),
			'middle_4' => array( 'footer-widget4','footer-social' ),
		),
		'bottom' => array(
			'bottom_1' => array( 'footer-html'),
			'bottom_2' => array( 'footer-widget5' ),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette8',
		),
	),
	//footer middle
	'footer_middle_columns' => '4',
	'footer_middle_direction' => array(
		'desktop' => 'column',
	),
	'footer_middle_widget_title' => array(
		'size' => array(
			'desktop' => 24,
			'mobile' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'EB Garamond',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'footer_middle_widget_content' => array(
		'family' => 'Josefin Sans',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette4',
	),
	'footer_middle_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
	'footer_middle_link_style' => 'noline',
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit' => 'px',
			'style' => 'solid',
			'color' => '#222e34',
		),
	),
	'footer_middle_top_spacing' => array(
		'size' => array(
			'mobile' => 40,
			'tablet' => 60,
			'desktop' => 70,
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'mobile' => 40,
			'tablet' => 60,
			'desktop' => 60,
		),
	),
	'footer_middle_layout' => array(
		'mobile' => 'row',
		'tablet' => 'two-grid',
		'desktop' => 'center',
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'mobile' => 30,
			'tablet' => 50,
			'desktop' => 30,
		),
	),
	//footer bottom
	'footer_bottom_columns' => '2',
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'tablet' => 10,
		),
	),
	'footer_bottom_link_style' => 'noline',
	//footer navigation
	'footer_navigation_align' => array(
		'desktop' => 'center',
	),
	'footer_navigation_vertical_align' => array(
		'desktop' => 'middle',
	),
	'footer_navigation_spacing' => array(
		'size' => 30,
		'unit' => 'px',
	),
	'footer_navigation_vertical_spacing' => array(
		'size' => 0,
		'unit' => 'px',
	),
	'footer_navigation_color' => array(
		'color' => '#bdbdbd',
		'hover' => 'palette1',
		'active' => 'palette1',
	),
	//footer widget5
	'footer_widget5_align' => array(
		'desktop' => 'right',
		'tablet' => 'center',
	),
	'footer_widget5_vertical_align' => array(
		'desktop' => 'middle',
	),
	//footer html
	'footer_html_typography' => array(
		'color' => 'palette3',
	),
	'footer_html_link_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'footer_html_align' => array(
		'desktop' => 'left',
		'tablet' => 'center',
	),
	//footer social
	'footer_social_items' => array(
		'items' => array(
			array(
				'id' => 'facebook',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'facebookAlt2',
				'label' => __( 'Facebook', 'templatemela-theme-wooti' ),
			),
			array(
				'id' => 'twitter',
				'enabled' => true,
				'source' => 'svg',
				'svg' => '<svg id="Layer_1" data-name="Layer 1"  xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500.08 511.77"><path fill="currentColor" d="M10.22,512.77c11.62-13.7,23.17-27.46,34.88-41.08q78.33-91.1,156.74-182.15c1.08-1.25,2.09-2.57,3.31-4.08L9.92,1.42c1.92-.14,3.15-.31,4.38-.31q70.2,0,140.42-.1c3.33,0,5,1.24,6.76,3.8Q223,94.6,284.75,184.27c1,1.48,2.09,2.92,3.46,4.83l25.3-29.35Q379.81,82.68,446,5.54A11.69,11.69,0,0,1,456.22,1c12.25.27,24.52.09,37.95.09L307.77,217.76l29,42.16Q422,384,507.25,508.1c1,1.48,1.84,3.11,2.75,4.67H361.07c-.67-1.14-1.28-2.32-2-3.41q-65.88-95.82-131.8-191.62c-.72-1.05-1.61-2-2.61-3.2-1.78,2-3.35,3.71-4.86,5.46q-52.6,61.13-105.19,122.25Q84.34,477.47,54.2,512.77Z" transform="translate(-9.92 -1)"/></svg>',
				'imageid' => '',
				'width' => 12,
				'icon' => 'twitterAlt',
				'label' => __( 'X formerly Twitter', 'templatemela-theme-wooti' ),
			),
			array(
				'id' => 'rss',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'rssAlt',
				'label' => __( 'Rss', 'templatemela-theme-wooti' ),
			),
			array(
				'id' => 'instagram',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'instagramAlt',
				'label' => __( 'Instagram', 'templatemela-theme-wooti' ),
			),
			array(
				'id' => 'whatsapp',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'whatsapp',
				'label' => __( 'whatsapp', 'templatemela-theme-wooti' ),
			),
		),
	),
	'footer_social_align' => array(
		'desktop' => 'left',
	),
	'footer_social_icon_size' => array(
		'size' => 16,
		'unit' => 'px',
	),
	'footer_social_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'footer_social_margin' => array(
		'size' => array( 25, 0, 0, 0 ),
		'unit' => 'px',
		'locked' => false,
	),
	//product archive
	'product_archive_button_style' => 'button',
	'product_archive_title_font' => array(
		'size' => array(
			'desktop' => 24,
			'tablet' => 22,
			'mobile' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'lineType' => 'em',
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette1',
	),
	'product_archive_price_font' => array(
		'size' => array(
			'desktop' => 18,
			'mobile' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'product_archive_button_border_colors' => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	'product_archive_button_border' => array(
		'width' => 1,
		'unit' => 'px',
		'style' => 'solid',
	),
	'product_title_font' => array(
		'size' => array(
			'mobile' => 24,
			'tablet' => 25,
			'desktop' => 30,
		),
	),
	'product_related_columns' => '4',
	'product_upsell_columns' => '4',
	// Breadcrumbs
	'product_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'page_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'search_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// Sidebar.
	'sidebar_width' => array(
		'size' => 270,
		'unit' => 'px',
	),
	'sidebar_link_style' => 'plain',
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
);
$header_addons = array(
	// Header Contact.
	'header_contact_items' => array(
		'items' => array(
			array(
				'id' => 'phone',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'link' => '#',
				'icon' => 'phone',
				'title' => 'Call us : ',
				'label' => '(+91) 123-456-789',
			),
		),
	),
	'header_contact_icon_size' => array(
		'size' => 0,
		'unit' => 'em',
	),
	'header_contact_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//header html2
	'header_html2_content' => __( 'Our Store : A-12, 5 Brown Ave, Weston', 'templatemela-theme-wooti' ),
	'header_html2_typography' => array(
		'color' => 'palette3',
	),
	//account
	'header_account_in_icon_size' => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_account_icon_size' => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//mobile account
	'header_mobile_account_in_icon_size' => array(
		'size' => 20,
		'unit' => 'px',
	),
	'header_mobile_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_mobile_account_icon_size' => array(
		'size' => 20,
		'unit' => 'px',
	),
	'header_mobile_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);
$more_addons = array(
	//wishlist
	'header_wishlist_icon_size' => array(
		'size' => array(
			'desktop' => 22,
			'tablet' => 20,
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_wishlist_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_wishlist_total_color' => array(
		'color' => '#000000',
		'hover' => '#000000',
	),
	'header_wishlist_total_background' => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	//search advanced
	'header_search_advanced_width' => array(
		'size' => array(
			'tablet' => 600,
			'mobile' => 500,
		),
	),
	'header_search_advanced_border_radius' => array(
		'size' => array( 0, 0, 0, 0 ),
		'unit' => 'px',
		'locked' => true,
	),
	'header_search_advanced_background' => array(
		'color' => 'palette9',
	),
	'header_search_advanced_button_typography' => array(
		'size' => array(
			'desktop' => 18,
		),
	),
	'header_search_advanced_input_padding' => array(
		'size' => array( 0, 50, 0, 15 ),
		'unit' => 'px',
		'locked' => false,
	),
	'header_search_advanced_button_padding' => array(
		'size'   => array( 10, 10, 10, 10 ),
		'unit'   => 'px',
		'locked' => false,
	),
	'header_search_advanced_button_radius' => array(
		'size'   => array( 0, 0, 0, 0 ),
		'unit'   => 'px',
		'locked' => true,
	),
);
$woo_addons = array(
	'product_filter_widget_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
	'product_filter_widget_title' => array(
		'size' => array(
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
);
$dark_mode_addons = array(
	'dark_mode_custom_logo' => true,
	'dark_mode_default' => 'dark',
 );