<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Theme
 * @since 1.0
 */

$default_options = array(
	'content_width' => array(
		'size' => 1430,
		'unit' => 'px',
	),
	// Logo
	'logo_layout'     => array(
		'include' => array(
			'mobile'  => 'logo_only',
			'tablet'  => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'tablet' => 14,
			'desktop' => 16,
		),
		'lineHeight' => array(
			'mobile' => 1.4,
			'desktop' => 1.6,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'  => 'px',
		'family'  => 'DM Sans',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette4',
	),
	'heading_font'        => array(
		'family' => 'EB Garamond',
	),
	'h1_font' => array(
		'size' => array(
			'mobile' => 22,
			'tablet' => 37,
			'desktop' => 48,
		),
		'lineHeight' => array(
			'desktop' => 1.02,
		),
		'letterSpacing' => array(
			'desktop' => 0,
		),
		'spacingType'  => 'px',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'mobile' => 21,
			'tablet' => 29,
			'desktop' => 38,
		),
		'lineHeight' => array(
			'mobile' => 1.15,
			'desktop' => 1.2,
		),
		'letterSpacing' => array(
			'desktop' => 0,
		),
		'spacingType'  => 'px',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'mobile' => 22,
			'tablet' => 25,
			'desktop' => 28,
		),
		'lineHeight' => array(
			'desktop' => 1.07,
		),
		'letterSpacing' => array(
			'desktop' => 0,
		),
		'spacingType'  => 'px',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'desktop' => 22,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'desktop' => 20,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'desktop' => 18,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'title_above_font' => array(
		'size' => array(
			'mobile' => 20,
			'tablet' => 23,
			'desktop' => 28,
		),
	),
	'title_above_breadcrumb_font' => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 16,
		),
	),
	// Buttons.
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => '0',
		),
	),
	'buttons_typography'    => array(
		'size' => array(
			'mobile' => 13,
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.8,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'  => 'px',
		'transform'  => 'uppercase',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	'buttons_padding'        => array(
		'size'   => array( 
			'mobile' => array( 7, 15, 7, 15 ),
			'desktop' => array( 11, 20, 11, 20 ),
		),
		'unit'   => array(
			'desktop' => 'px',
		),
		'locked' => array(
			'desktop' => false,
		),
	),
	// Header.
	'header_desktop_items'       => array(
		'top' => array(
			'top_left'         => array(),
		),
		'main' => array(
			'main_left'         => array( 'logo' ),
			'main_center'         => array( 'navigation' ),
			'main_right'        => array( 'search' , 'wishlist' , 'account' , 'cart' ),
		),
		'bottom' => array(
			'bottom_left'         => array(),
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_left' => array(),
		),
		'main' => array(
			'main_left'   => array( 'popup-toggle', 'mobile-logo' ),
			'main_right'  => array( 'search', 'mobile-account', 'mobile-cart' ),
		),
		'bottom' => array(
			'bottom_left'   => array(),
		),
	),
	// Header Main.
	'header_main_height' => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 90,
			'desktop' => 100,
		),
	),
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	),
	// Navigation.
	'primary_navigation_typography'            => array(
		'size' => array(
			'desktop' => 15,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'  => 'px',
		'transform'  => 'uppercase',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	'primary_navigation_spacing'            => array(
		'size' => 40,
		'unit' => 'px',
	),
	'primary_navigation_vertical_spacing'   => array(
		'size' => 38,
		'unit' => 'px',
	),
	'primary_navigation_color'   => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
		'active' => 'palette3',
	),
	//header search
	'header_search_icon_size' => array(
		'size' => array(
			'desktop' => 25,
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_search_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//header cart
	'header_cart_icon_size'   => array(
		'size' => '23',
		'unit' => 'px',
	),
	'header_cart_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_cart_total_background'              => array(
		'color' => 'palette1',
	),
	//mobile cart
	'header_mobile_cart_color'    => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_mobile_cart_icon_size'   => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_mobile_cart_total_background'              => array(
		'color' => 'palette1',
	),
	//trigger
	'mobile_trigger_icon_size'   => array(
		'size' => 24,
		'unit' => 'px',
	),
	'mobile_trigger_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// Footer.
	'footer_items'       => array(
		'top' => array(
			'top_1' => array(),
		),
		'middle' => array(
			'middle_1' => array( 'footer-widget1' ),
			'middle_2' => array( 'footer-widget2' ),
			'middle_3' => array( 'footer-widget3' ),
			'middle_4' => array( 'footer-widget4' ),
			'middle_5' => array( 'footer-widget5' ),
		),
		'bottom' => array(
			'bottom_1' => array( 'footer-html' ),
			'bottom_2' => array( 'footer-widget6' ),
		),
	),
	//footer middle
	'footer_middle_columns' => '5',
	'footer_middle_layout'  => array(
		'mobile'  => 'row',
		'tablet'  => 'equal',
		'desktop' => 'equal',
	),
	'footer_middle_top_spacing' => array(
		'size' => array(
			'mobile'  => '35',
			'tablet'  => '10',
			'desktop' => '45',
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'mobile'  => '35',
			'tablet'  => '10',
			'desktop' => '45',
		),
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'tablet'  => '15',
			'desktop' => '40',
		),
	),
	'footer_middle_widget_title'  => array(
		'size' => array(
			'mobile' => 21,
			'tablet' => 22,
			'desktop' => 28,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'footer_middle_widget_content' => array(
		'size' => array(
			'tablet' => 14,
			'desktop' => 16,
		),
		'color'   => 'palette4',
	),
	'footer_middle_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
	'footer_middle_link_style' => 'noline',
	// Footer bottom
	'footer_bottom_columns' => '2',
	'footer_bottom_bottom_spacing' => array(
		'size' => array(
			'tablet'  => '80',
			'desktop' => '90',
		),
	),
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'mobile'  => '10',
			'tablet'  => '15',
			'desktop' => '30',
		),
	),
	'footer_bottom_widget_content' => array(
		'size' => array(
			'tablet' => 14,
			'desktop' => 16,
		),
		'color'   => 'palette4',
	),
	'footer_bottom_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
	'footer_bottom_link_style' => 'noline',
	// Footer Widget 1.
	'footer_widget1_align'         => array(
		'mobile'  => 'center',
	),
	// Footer Widget 2.
	'footer_widget2_align'         => array(
		'mobile'  => 'center',
	),
	// Footer Widget 4.
	'footer_widget4_align'         => array(
		'mobile'  => 'center',
	),
	// Footer Widget 5.
	'footer_widget5_align'         => array(
		'mobile'  => 'center',
	),
	// Footer Widget 6.
	'footer_widget6_align'         => array(
		'tablet'  => 'center',
		'desktop' => 'right',
	),
	//footer html
	'footer_html_margin' => array(
		'size'   => array( '0', '', '0', '' ),
	),
	'footer_html_align'         => array(
		'tablet'  => 'center',
	),
	//sidebar
	'sidebar_width'   => array(
		'size' => 260,
		'unit' => 'px',
	),
	'sidebar_link_style' => 'plain',
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 20,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'  => 'px',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	//dropdown
	'dropdown_navigation_typography'        => array(
		'size' => array(
			'desktop' => 16,
		),
		'transform'  => 'capitalize',
		'weight'  => '400',
		'variant' => '400',
	),
	//product
	'product_archive_button_style'       => 'button',
	'product_archive_title_font'   => array(
		'size' => array(
			'mobile' => 18,
			'tablet' => 26,
			'desktop' => 28,
		),
		'letterSpacing' => array(
			'desktop' => 0,
		),
		'spacingType'  => 'px',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette2',
	),
	'product_archive_price_font'   => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 16,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'  => 'px',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette4',
	),
	'product_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 95,
			'tablet'  => 120,
			'desktop' => 130,
		),
	),
	'product_title_font'   => array(
		'size' => array(
			'mobile'  => '23',
			'tablet' => '25',
			'desktop' => '28',
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	'product_related_columns'    => '4',
	'product_upsell_columns'    => '4',
	//post archive
	'post_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 100,
			'tablet'  => '',
			'desktop' => 130,
		),
	),
	'post_archive_item_title_font'   => array(
		'size' => array(
			'mobile' => '20',
			'tablet' => '21',
			'desktop' => '24',
		),
	),
	//post
	'post_title_font'   => array(
		'size' => array(
			'mobile' => '16',
			'tablet' => '23',
		),
	),
	//page
	'page_title_height'       => array(
		'size' => array(
			'mobile'  => 95,
			'tablet'  => 120,
			'desktop' => 130,
		),
	),
	//search 
	'search_archive_title_height'       => array(
		'size' => array(
			'mobile'  => '95',
			'tablet'  => '120',
			'desktop' => '130',
		),
	),
	//links
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);
$header_addons = array(
	//header account
	'header_account_icon_size'               => array(
		'size' => '23',
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//header account in
	'header_account_in_icon_size'               => array(
		'size' => '23',
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//Mobile Header Account.
	'header_mobile_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_mobile_account_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_mobile_account_in_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
);
$more_addons = array(
	//header wishlist
	'header_wishlist_show_total' => false,
	'header_wishlist_icon_size'   => array(
		'size' => array(
			'desktop' => '23',
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_wishlist_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);
$woo_addons = array(
	'product_filter_widget_link_colors'       => array(
		'color'  => 'palette4',
		'hover'  => 'palette1',
	),
	'product_filter_widget_title'        => array(
		'size' => array(
			'desktop' => 18,
		),
		'family'  => 'DM Sans',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
);
$dark_mode_addons = array(
	'dark_mode_custom_logo'        => true,
);