<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
add_action( 'after_setup_theme', 'bt_variation_price_plugin_loaded' );

function bt_variation_price_plugin_loaded() {

	class bt_variation_price {

		public function __construct() {
			$shopkit_settings = get_option( 'bt_woo_extras' );
			if ( ! is_array( $shopkit_settings ) ) {
				$shopkit_settings = json_decode( $shopkit_settings, true );
			}
			if ( isset( $shopkit_settings['variation_price'] ) && $shopkit_settings['variation_price'] == 'lowprice' ) {
				add_filter('woocommerce_variable_price_html', array($this, 'bt_custom_variation_low_price'), 50, 2);
				add_filter( 'woocommerce_variable_sale_price_html',  array($this, 'bt_sale_custom_variation_low_price'), 50, 2 );
			} elseif(isset($shopkit_settings['variation_price']) && $shopkit_settings['variation_price'] == 'highprice') {
				add_filter('woocommerce_variable_price_html', array($this, 'bt_custom_variation_high_price'), 50, 2);
				add_filter( 'woocommerce_variable_sale_price_html',  array($this, 'bt_sale_custom_variation_high_price'), 50, 2 );
			}
		}

		public function bt_custom_variation_low_price( $price, $product ) {
			global $bt_woo_extras;
			if ( $product->get_variation_price( 'min', true ) !== $product->get_variation_price( 'max', true ) ) {
				if ( isset( $bt_woo_extras['before_variation_price'] ) && ! empty( $bt_woo_extras['before_variation_price'] ) ) {
					$before_text = $bt_woo_extras['before_variation_price'];
				} else {
					$before_text =  '';
				}
				if ( isset( $bt_woo_extras['after_variation_price'] ) && ! empty( $bt_woo_extras['after_variation_price'] ) ) {
					$after_text = $bt_woo_extras['after_variation_price'];
				} else {
					$after_text =  '';
				}
				$price = '<span class="bt-before-price-variation">'.$before_text.'</span> '.wc_price($product->get_variation_price( 'min', true ) ).' <span class="bt-after-price-variation">'.$after_text.'</span>';
			}

			return $price;
		}
		public function bt_sale_custom_variation_low_price( $price, $product ) {
			global $bt_woo_extras;
			if ( $product->get_variation_price( 'min', true ) !== $product->get_variation_price( 'max', true ) ) {
				if ( isset( $bt_woo_extras['before_variation_price'] ) && ! empty( $bt_woo_extras['before_variation_price'] ) ) { 
					$before_text = $bt_woo_extras['before_variation_price'];
				} else {
					$before_text =  '';
				}
				if ( isset( $bt_woo_extras['after_variation_price'] ) && ! empty( $bt_woo_extras['after_variation_price'] ) ) { 
					$after_text = $bt_woo_extras['after_variation_price'];
				} else {
					$after_text =  '';
				}
				$prices = $product->get_variation_prices( true );

				if ( $product->is_on_sale() ) {
					$min_regular_price = current( $prices['regular_price'] );
					$price = '<span class="bt-before-price-variation">'.$before_text.'</span> <del><span class="amount">'.wc_price( $min_regular_price ).'</span></del> <ins><span class="amount">'.wc_price( $product->get_price() ).'</span></ins> <span class="bt-after-price-variation">'.$after_text.'</span>';
				} else {
					$price = '<span class="bt-before-price-variation">'.$before_text.'</span> '. wc_price($product->get_variation_price( 'min', true ) ).' <span class="bt-after-price-variation">'.$after_text.'</span>';
				}
			}

			return $price;
		}
		public function bt_custom_variation_high_price( $price, $product ) {
			global $bt_woo_extras;
			if ( $product->get_variation_price( 'min', true ) !== $product->get_variation_price( 'max', true ) ) {
				if(isset($bt_woo_extras['before_variation_price']) && !empty($bt_woo_extras['before_variation_price'] ) ) { 
					$before_text = $bt_woo_extras['before_variation_price'];
				} else {
					$before_text =  '';
				}
				if(isset($bt_woo_extras['after_variation_price']) && !empty($bt_woo_extras['after_variation_price'] ) ) { 
					$after_text = $bt_woo_extras['after_variation_price'];
				} else {
					$after_text =  '';
				}
					$price = '<span class="bt-before-price-variation">'.$before_text.'</span> '.wc_price($product->get_variation_price( 'max', true )).' <span class="bt-after-price-variation">'.$after_text.'</span>';
			}

			return $price;
		}
		public function bt_sale_custom_variation_high_price( $price, $product ) {
			global $bt_woo_extras;
			if ( $product->get_variation_price( 'min', true ) !== $product->get_variation_price( 'max', true ) ) {
				if(isset($bt_woo_extras['before_variation_price']) && !empty($bt_woo_extras['before_variation_price'] ) ) { 
					$before_text = $bt_woo_extras['before_variation_price'];
				} else {
					$before_text =  '';
				}
				if(isset($bt_woo_extras['after_variation_price']) && !empty($bt_woo_extras['after_variation_price'] ) ) { 
					$after_text = $bt_woo_extras['after_variation_price'];
				} else {
					$after_text =  '';
				}
					$prices = $product->get_variation_prices( true );

					if ( $product->is_on_sale() ) {
						$max_regular_price = end( $prices['regular_price'] );
						$price = '<span class="bt-before-price-variation">'.$before_text.'</span> <del><span class="amount">'.wc_price( $max_regular_price ).'</span></del> <ins><span class="amount">'.wc_price($product->get_variation_price( 'max', true )).'</span></ins> <span class="bt-after-price-variation">'.$after_text.'</span>';
					} else {
						$price = '<span class="bt-before-price-variation">'.$before_text.'</span> '.wc_price($product->get_variation_price( 'max', true )).' <span class="bt-after-price-variation">'.$after_text.'</span>';
					}
			}
			return $price;
		}

	}
	$GLOBALS['bt_variation_price'] = new bt_variation_price();
}


