/* Global baseSettingsParams */
/**
 * Internal dependencies
 */
//  import HelpTab from './help';
//  import ChangelogTab from './changelog';
//  import ProSettings from './pro-extension';
//  import RecommendedTab from './recomended';
//  import StarterTab from './starter';
import InfoPanel from './panel';
import Notices from './notices';
import SaveOverlay from './overlay';
const {
	localStorage,
} = window;
const { apiFetch } = wp;
window.baseSettingsOptions = '';
 /**
 * Import Css
 */
import './editor.scss';
/**
 * WordPress dependencies
 */
const { __, sprintf } = wp.i18n;
import { dispatch } from '@wordpress/data';
import { Fragment, Component, RawHTML, render } from '@wordpress/element';
const { TabPanel, Panel, PanelBody, PanelRow, Button, Spinner } = wp.components;
import baseTryParseJSON from './components/common/try-parse';
class BaseSettingsDashboard extends Component {
	constructor() {
		super( ...arguments );
		this.saveSettings = this.saveSettings.bind( this );
		this.state = {
			settings: ( baseSettingsParams.settings ? baseTryParseJSON( baseSettingsParams.settings ) : {} ),
			sections: ( baseSettingsParams.sections ? baseTryParseJSON( baseSettingsParams.sections ) : {} ),
			tabs: ( baseSettingsParams.tabs ? baseTryParseJSON( baseSettingsParams.tabs ) : {} ),
			isSaving: false,
			opt_name: baseSettingsParams.opt_name,
		};
	}
	componentDidMount() {
		window.baseSettingsOptions = baseSettingsParams.settings;
	}
	saveSettings() {
		this.setState( { isSaving: true } );
		const settings = baseTryParseJSON( window.baseSettingsOptions );
		baseSettingsParams.settings = JSON.stringify( settings );
		apiFetch( {
			path: '/wp/v2/settings',
			method: 'POST',
			data: { [baseSettingsParams.opt_name]: JSON.stringify( settings ) },
		} ).then( ( response ) => {
			window.baseSettingsOptions = response[baseSettingsParams.opt_name];
			this.setState( {
				isSaving: false,
			} );
			this.state.isSaving = false;
			dispatch( 'core/notices' ).createNotice(
				'success',
				__( 'Settings Saved', 'base-settings' ),
				{ type: 'snackbar' },
			);
		} );
	}
	render() {
		const { sections, tabs } = this.state;
		const real_tabs = [];
		{ Object.keys( tabs ).map( function( key, index ) {
			real_tabs.push( {
				name: tabs[ key ].id,
				title: tabs[ key ].title,
				className: 'base-settings-tab-' + tabs[ key ].id,
			} );
		} ) }
		 const BaseDashTabPanel = () => (
			<TabPanel className="base-dashboard-tab-panel"
				 activeClass="active-tab"
				 tabs={ real_tabs }>
				 {
					 ( tab ) => {
						return (
							<Panel className="dashboard-section tab-section">
								<PanelBody
									opened={ true }
								>
									<div className="dashboard-modules-wrapper">
										<InfoPanel panel={ tab.name } sections={ sections } saveSettings={ () => this.saveSettings() } />
									</div>
								</PanelBody>
							</Panel>
						);
					 }
				 }
			 </TabPanel>
		 );
 
		 const MainPanel = () => (
			 <div className="tab-panel">
				{ real_tabs.length ?
					<BaseDashTabPanel />
				:
					<Panel className="dashboard-section tab-section">
						<PanelBody
							opened={ true }
						>
							<div className="dashboard-modules-wrapper">
								<InfoPanel panel={ 'settings' } sections={ sections } saveSettings={ () => this.saveSettings() } />
							</div>
						</PanelBody>
					</Panel>
				}
			 </div>
		 );
 
		 return (
			 <Fragment>
				<MainPanel />
				<SaveOverlay show={ this.state.isSaving } />
				<Notices />
			 </Fragment>
		 );
	 }
 }
 
 wp.domReady( () => {
	 render(
		 <BaseSettingsDashboard />,
		 document.querySelector( '.base_settings_dashboard_main' )
	 );
 } );
 