<?php
/**
 * Figure out what version to load.
 *
 * Written by Chris Jean for iThemes.com, adapted for Base.
 *
 * @package Base
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$base_registration_list_version   = '1.5.4';
$base_registration_list_library   = 'base_settings';
$base_registration_list_init_file = dirname( __FILE__ ) . '/init.php';

$GLOBALS['base_classes_registration_list'][ $base_registration_list_library ][ $base_registration_list_version ] = $base_registration_list_init_file;

if ( ! function_exists( 'base_registration_list_init' ) ) {
	/**
	 * Figure out which class to load.
	 */
	function base_registration_list_init() {

		$init_files = array();
		foreach ( (array) $GLOBALS['base_classes_registration_list'] as $library => $versions ) {
			$max_version = '-10000';
			$init_file = '';

			foreach ( (array) $versions as $version => $file ) {
				if ( version_compare( $version, $max_version, '>' ) ) {
					$max_version = $version;
					$init_file   = $file;
				}
			}

			if ( ! empty( $init_file ) ) {
				$init_files[] = $init_file;
			}
		}

		unset( $GLOBALS['base_classes_registration_list'] );

		foreach ( (array) $init_files as $init_file ) {
			require_once( $init_file );
		}

	}
	add_action( 'after_setup_theme', 'base_registration_list_init' );
}
