<?php
/**
 * Base_Woo Extras Settings Class
 *
 * @package Base Woo Extras
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Main Base_Woo_Extras_Settings class
 */
class Base_Woo_Extras_Settings {
	const OPT_NAME = 'bt_woo_extras';

	/**
	 * Action on init.
	 */
	public function __construct() {
		require_once TMCORE_WOO_PATH . 'inc/settings/load.php';
		// Need to load this with priority higher then 10 so class is loaded.
		add_action( 'after_setup_theme', array( $this, 'add_sections' ), 20 );
	}
	/**
	 * Add sections to settings.
	 */
	public function add_sections() {
		if ( ! class_exists( 'Base_Settings_Engine' ) ) {
			return;
		}
		$args = array(
			'opt_name'                         => self::OPT_NAME,
			'menu_icon'                        => 'dashicons-cart',
			'menu_title'                       => __( 'Settings', 'templatemela-core' ),
			'page_title'                       => __( 'Settings', 'templatemela-core' ),
			'page_slug'                        => 'base-shop-kit-settings',
			'page_permissions'                 => 'manage_options',
			'menu_type'                        => 'submenu',
			'page_parent'                      => ( apply_filters( 'base_shopkit_network', false ) ? 'templatemela' : 'templatemela' ),
			'page_priority'                    => null,
			'footer_credit'                    => '',
			'class'                            => '',
			'admin_bar'                        => false,
			'admin_bar_priority'               => 999,
			'admin_bar_icon'                   => '',
			'show_import_export'               => false,
			'version'                          => TMCORE_VERSION,
			'logo'                             => TMCORE_URL . 'admin/assets/images/templatemela-icon.png',
			'changelog'                        => TMCORE_WOO_PATH . 'changelog.txt',
			'network_admin'                    => apply_filters( 'base_shopkit_network', false ),
			'database'                         => ( apply_filters( 'base_shopkit_network', false ) ? 'network' : '' ),
		);
		$args['tabs'] = array(
			'settings' => array(
				'id' => 'settings',
				'title' => __( 'Settings', 'templatemela-core' ),
			),
			/* 'changelog' => array(
				'id' => 'changelog',
				'title' => __( 'Changelog', 'templatemela-core' ),
			), */
		);
		$args['sidebar'] = array(
			'facebook' => array(
				'title' => __( 'Web Creators Community', 'templatemela-core' ),
				'description' => __( 'Join our community of fellow base users creating effective websites! Share your site, ask a question and help others.', 'templatemela-core' ),
				'link' => 'https://www.facebook.com/groups/',
				'link_text' => __( 'Join our Facebook Group', 'templatemela-core' ),
			),
			'docs' => array(
				'title'       => __( 'Documentation', 'templatemela-core' ),
				'description' => __( 'Need help? We have a knowledge base full of articles to get you started.', 'templatemela-core' ),
				'link'        => 'https://avanam.org/wordpress#help-center/knowledge-base/base-shop-kit/',
				'link_text'   => __( 'Browse Docs', 'templatemela-core' ),
			),
			'support' => array(
				'title' => __( 'Support', 'templatemela-core' ),
				'description' => __( 'Have a question, we are happy to help! Get in touch with our support team.', 'templatemela-core' ),
				'link' => 'https://avanam.org/wordpress#premium-support-tickets/',
				'link_text' => __( 'Submit a Ticket', 'templatemela-core' ),
			),
		);
		Base_Settings_Engine::set_args( self::OPT_NAME, $args );
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_shop_page',
				'title' => __( 'Shop Page Settings', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'bt_products_per_row',
						'type' => 'text',
						'title' => __( 'Products Per Row', 'templatemela-core' ),
						'help' => __( 'Number of products to show in single row', 'templatemela-core' ),
						'default' => 4,
					),
					array(
						'id' => 'bt_products_per_page',
						'type' => 'text',
						'title' => __( 'Products Per Page', 'templatemela-core' ),
						'help' => __( 'Number of products to show per page', 'templatemela-core' ),
						'default' => 12,
					),
					array(
						'id' => 'product_sale_label_custom',
						'type' => 'switch',
						'title' => __( 'Use custom sale label style?', 'templatemela-core' ),
						'help' => __( 'This allows you to customize default sale label.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'product_sale_label',
						'type' => 'text',
						'title' => __( 'Sale Label', 'templatemela-core' ),
						'help' => __( 'Sale label to display on product catalog. Tags: {percentage} i.e {percentage} OFF', 'templatemela-core' ),
						'default' => __( '-{percentage}', 'templatemela-core' ),
						'required' => array( 'product_sale_label_custom', '=', '1' ),
					),
					array(
						'id' => 'product_custom_thumb_width_height',
						'type' => 'switch',
						'title' => __( 'Custom width and height for product card images', 'templatemela-core' ),
						'help' => __( 'This allows you to customize image width and height.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'product_thumb_image_width',
						'type' => 'text',
						'title' => __( 'Thumbnail width', 'templatemela-core' ),
						'help' => __( 'Image width used for products in the catalog.', 'templatemela-core' ),
						'default' => 300,
						'required' => array( 'product_custom_thumb_width_height', '=', '1' ),
					),
					array(
						'id' => 'product_thumb_image_height',
						'type' => 'text',
						'title' => __( 'Thumbnail height', 'templatemela-core' ),
						'help' => __( 'Image height used for products in the catalog.', 'templatemela-core' ),
						'default' => 300,
						'required' => array( 'product_custom_thumb_width_height', '=', '1' ),
					),
					array(
						'id' => 'product_thumb_image_crop',
						'type' => 'switch',
						'title' => __( 'Crop image for custom width and height for product card images', 'templatemela-core' ),
						'help' => __( 'This allows you to crop the customized image width and height.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'product_custom_thumb_width_height', '=', '1' ),
					),
					array(
						'id' => 'bt_product_action_info',
						'type' => 'info',
						'title' => __( 'The below settings allow you to show or hide action buttons on the product card.', 'templatemela-core' ),
					),
					array(
						'id' => 'product_add_to_cart',
						'type' => 'switch',
						'title' => __( 'Show add to cart button or text', 'templatemela-core' ),
						'help' => __( 'This allows you to show/hide add to cart button or text.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'product_quickview_with_cart',
						'type' => 'switch',
						'title' => __( 'Show quickview button with add to cart', 'templatemela-core' ),
						'help' => __( 'This allows you to show/hide quickview icon with add to cart.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'product_wishlist_with_cart',
						'type' => 'switch',
						'title' => __( 'Show wishlist icon with add to cart', 'templatemela-core' ),
						'help' => __( 'This allows you to show/hide wishlist icon with add to cart.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'product_compare_with_cart',
						'type' => 'switch',
						'title' => __( 'Show compare icon with add to cart', 'templatemela-core' ),
						'help' => __( 'This allows you to show/hide compare icon with add to cart.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'bt_product_hover_buttons',
						'type' => 'info',
						'title' => __( 'Bellow settings only works when Button Style = Button from the customizer Settings under Customizing ▸ WooCommerce ▸ Product Catalog', 'templatemela-core' ),
					),
					array(
						'id' => 'product_action_button_style',
						'type' => 'select',
						'title' => __( 'Choose a product action button style', 'templatemela-core' ),
						'options' => array(
							'default' => __( 'Default', 'templatemela-core' ),
							//'button_only' => __( 'Only Button', 'templatemela-core' ),
							'icon_only' => __( 'Only Icon', 'templatemela-core' ),
							'icon_button' => __( 'Icon + Button', 'templatemela-core' ),
						),
						'help' => __( 'You can choose hover style for button. If you want only text, you can do it from customzer settings from Customizing ▸ WooCommerce ▸ Product Catalog', 'templatemela-core' ),
						'default' => 'default',
					),
					/* array(
						'id' => 'bt_product_hover_settings',
						'type' => 'info',
						'title' => __( 'Product Hover Settings', 'templatemela-core' ),
					),
					array(
						'id' => 'product_hover_style',
						'type' => 'select',
						'title' => __( 'Choose a product hover style', 'templatemela-core' ),
						'options' => array(
							'style1' => __( 'Style 1', 'templatemela-core' ),
							'style2' => __( 'Style 2', 'templatemela-core' ),
							'style3' => __( 'Style 3', 'templatemela-core' ),
							'style4' => __( 'Style 4', 'templatemela-core' ),
							'style5' => __( 'Style 5', 'templatemela-core' ),
							'style6' => __( 'Style 6', 'templatemela-core' ),
						),
						'help' => __( 'You can choose product hover style', 'templatemela-core' ),
						'default' => 'style1',
					), */
					array(
						'id' => 'bt_product_image_hover_settings',
						'type' => 'info',
						'title' => __( 'Image Hover Settings', 'templatemela-core' ),
					),
					array(
						'id' => 'product_image_hover_position',
						'type' => 'select',
						'title' => __( 'Choose a image hover buttons position', 'templatemela-core' ),
						'options' => array(
							'top' => __( 'Top', 'templatemela-core' ),
							'right' => __( 'Right', 'templatemela-core' ),
							'bottom' => __( 'Bottom', 'templatemela-core' ),
							'left' => __( 'Left', 'templatemela-core' ),
							'center' => __( 'Center', 'templatemela-core' ),
						),
						'help' => __( 'You can choose image hover buttons position', 'templatemela-core' ),
						'default' => 'right',
					),
					array(
						'id' => 'bt_product_hover_info',
						'type' => 'info',
						'title' => __( 'Show or hide icons on image hover', 'templatemela-core' ),
					),
					array(
						'id' => 'product_addtocart_on_image_hover',
						'type' => 'switch',
						'title' => __( 'Show add to cart icon on image hover', 'templatemela-core' ),
						'help' => __( 'This allows you to show/hide add to cart icon on image hover.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'product_quickview_on_image_hover',
						'type' => 'switch',
						'title' => __( 'Show quickview icon on image hover', 'templatemela-core' ),
						'help' => __( 'This allows you to show/hide quickview icon on image hover.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'product_wishlist_on_image_hover',
						'type' => 'switch',
						'title' => __( 'Show wishlist icon on image hover', 'templatemela-core' ),
						'help' => __( 'This allows you to show/hide wishlist icon on image hover.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'product_compare_on_image_hover',
						'type' => 'switch',
						'title' => __( 'Show compare icon on image hover', 'templatemela-core' ),
						'help' => __( 'This allows you to show/hide compare icon on image hover.', 'templatemela-core' ),
						'default' => 0,
					),


				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_product_page',
				'title' => __( 'Product Page Settings', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'product_low_stock_bar',
						'type' => 'switch',
						'title' => __( 'Enable low stock progress bar', 'templatemela-core' ),
						'help' => __( 'This allows you to display low stock progress bar.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'bt_product_low_stock_bar_info',
						'type' => 'info',
						'title' => __( 'To set low stock threshold Got to Admin panel On the WooCommerce > Settings > Product > Inventory page, you can adjust both a low and out-of-stock threshold as well as how they display in your store.', 'templatemela-core' ),
						'required' => array( 'product_low_stock_bar', '=', '1' ),
					),
					array(
						'id' => 'bt_product_live_view_info',
						'type' => 'info',
						'title' => __( 'Product Live viewing settings', 'templatemela-core' ),
					),
					array(
						'id' => 'bt_product_live_view',
						'type' => 'switch',
						'title' => __( 'Enable live viewing visitors', 'templatemela-core' ),
						'help' => __( 'This allows you to display live view visitors.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'bt_product_live_view_min',
						'type' => 'text',
						'title' => __( 'Live viewing minimum count', 'templatemela-core' ),
						'help' => __( 'Minimum number of live viewers to show', 'templatemela-core' ),
						'default' => 10,
						'required' => array( 'bt_product_live_view', '=', '1' ),
					),
					array(
						'id' => 'bt_product_live_view_max',
						'type' => 'text',
						'title' => __( 'Live viewing maximum count', 'templatemela-core' ),
						'help' => __( 'Maximum number of live viewers to show', 'templatemela-core' ),
						'default' => 20,
						'required' => array( 'bt_product_live_view', '=', '1' ),
					),

					array(
						'id' => 'bt_product_sold_info',
						'type' => 'info',
						'title' => __( 'Products Sold and In Cart notification Settings', 'templatemela-core' ),
					),
					array(
						'id' => 'bt_product_sold_info_more',
						'type' => 'info',
						'title' => __( 'Products Sold and In Cart notification can be combined or separate', 'templatemela-core' ),
					),
					array(
						'id' => 'bt_product_sold',
						'type' => 'switch',
						'title' => __( 'Enable products sold notification', 'templatemela-core' ),
						'help' => __( 'This allows you to display products sold notification.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'bt_product_sold_min',
						'type' => 'text',
						'title' => __( 'Products sold minimum count', 'templatemela-core' ),
						'help' => __( 'Minimum number of products sold', 'templatemela-core' ),
						'default' => 1,
						'required' => array( 'bt_product_sold', '=', '1' ),
					),
					array(
						'id' => 'bt_product_sold_max',
						'type' => 'text',
						'title' => __( 'Products sold maximum count', 'templatemela-core' ),
						'help' => __( 'Maximum number of products sold', 'templatemela-core' ),
						'default' => 20,
						'required' => array( 'bt_product_sold', '=', '1' ),
					),
					array(
						'id' => 'bt_product_sold_time_min',
						'type' => 'text',
						'title' => __( 'Products sold hours minimum', 'templatemela-core' ),
						'help' => __( 'Minimum number of hours for products sold', 'templatemela-core' ),
						'default' => 1,
						'required' => array( 'bt_product_sold', '=', '1' ),
					),
					array(
						'id' => 'bt_product_sold_time_max',
						'type' => 'text',
						'title' => __( 'Products sold hours maximum', 'templatemela-core' ),
						'help' => __( 'Maximum number of hours for products sold', 'templatemela-core' ),
						'default' => 20,
						'required' => array( 'bt_product_sold', '=', '1' ),
					),
					array(
						'id' => 'bt_product_sold_live_time',
						'type' => 'text',
						'title' => __( 'Products in cart live time', 'templatemela-core' ),
						'help' => __( 'Live time for products in cart notification, after that numbers will change', 'templatemela-core' ),
						'default' => 36000,
						'required' => array( 'bt_product_sold', '=', '1' ),
					),
					array(
						'id' => 'bt_product_incart',
						'type' => 'switch',
						'title' => __( 'Enable products in cart notification', 'templatemela-core' ),
						'help' => __( 'This allows you to display in cart notification.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'bt_product_incart_min',
						'type' => 'text',
						'title' => __( 'Products in cart minimum count', 'templatemela-core' ),
						'help' => __( 'Minimum number of products sold', 'templatemela-core' ),
						'default' => 1,
						'required' => array( 'bt_product_incart', '=', '1' ),
					),
					array(
						'id' => 'bt_product_incart_max',
						'type' => 'text',
						'title' => __( 'Products in cart maximum count', 'templatemela-core' ),
						'help' => __( 'Maximum number of products in cart', 'templatemela-core' ),
						'default' => 20,
						'required' => array( 'bt_product_incart', '=', '1' ),
					),
					array(
						'id' => 'bt_product_incart_live_time',
						'type' => 'text',
						'title' => __( 'Products in cart live time', 'templatemela-core' ),
						'help' => __( 'Live time for products in cart notification, after that numbers will change', 'templatemela-core' ),
						'default' => 36000,
						'required' => array( 'bt_product_incart', '=', '1' ),
					),
					array(
						'id' => 'bt_product_sold_incart_combined',
						'type' => 'switch',
						'title' => __( 'Combined products sold and in cart notification', 'templatemela-core' ),
						'help' => __( 'This allows you to display both notification combined using scroll css.', 'templatemela-core' ),
						'default' => 1,
						'required' => array(
							array( 'bt_product_sold', '=', '1' ),
							array( 'bt_product_incart', '=', '1' ),
						),
					),
					array(
						'id' => 'bt_product_sold_info_more_2',
						'type' => 'info',
						'title' => __( 'NOTE: Updates will shows only after transit period or you should delete transits', 'templatemela-core' ),
					),
				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_welcome_popup_settings_page',
				'title' => __( 'Welcome Popup', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'welcome_popup',
						'type' => 'switch',
						'title' => __( 'Enable Welcome Popup', 'templatemela-core' ),
						'help' => __( 'This allows you to display welcome popup on website.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'welcome_popup_content',
						'type' => 'text',
						'title' => __( 'Enter elements shortcode', 'templatemela-core' ),
						'help' => __( 'This is element shortcode for the element you want to show in popup. i.e [base_element id="1"]', 'templatemela-core' ),
						'required' => array(
							array( 'welcome_popup', '=', '1' ),
						),
					),
					array(
						'id' => 'welcome_popup_delay',
						'type' => 'range',
						'title' => __( 'Popup Delay Time (in seconds)', 'templatemela-core' ),
						'help' => __( 'After this number of seconds show the popup.', 'templatemela-core' ),
						'default'   => '7',
						'min'       => '1',
						'step'      => '1',
						'max'       => '100',
						'required' => array(
							array( 'welcome_popup', '=', '1' ),
						),
					),
					array(
						'id' => 'welcome_popup_repeat',
						'type' => 'range',
						'title' => __( 'Popup Repeat on Page Reload', 'templatemela-core' ),
						'help' => __( 'This number of time show the popup on each page load, If cookies not set from user by clicking "Do not show again"', 'templatemela-core' ),
						'default'   => '3',
						'min'       => '1',
						'step'      => '1',
						'max'       => '50',
						'required' => array(
							array( 'welcome_popup', '=', '1' ),
						),
					),
					array(
						'id' => 'welcome_popup_expire',
						'type' => 'range',
						'title' => __( 'After number of days popup cookies expired', 'templatemela-core' ),
						'help' => __( 'Popup show again after this number of days. Cookies were set when use check "Do not show again"', 'templatemela-core' ),
						'default'   => '2',
						'min'       => '1',
						'step'      => '1',
						'max'       => '100',
						'required' => array(
							array( 'welcome_popup', '=', '1' ),
						),
					),
					/* array(
						'id' => 'welcome_popup_dismiss',
						'type' => 'text',
						'title' => __( 'Popup Dismiss Text', 'templatemela-core' ),
						'help' => __( "Standard: Don't show this popup again", 'templatemela-core' ),
						'default' => __( "Don't show this popup again", 'templatemela-core' ),
						'required' => array(
							array( 'welcome_popup', '=', '1' ),
						),
					), */
				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_exit_popup_settings_page',
				'title' => __( 'Exit Popup', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'exit_popup',
						'type' => 'switch',
						'title' => __( 'Enable Exit Popup', 'templatemela-core' ),
						'help' => __( 'This allows you to display exit popup on website.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'exit_popup_content',
						'type' => 'text',
						'title' => __( 'Enter elements shortcode', 'templatemela-core' ),
						'help' => __( 'This is element shortcode for the element you want to show in popup. i.e [base_element id="1"]', 'templatemela-core' ),
						'required' => array(
							array( 'exit_popup', '=', '1' ),
						),
					),
					array(
						'id' => 'exit_popup_repeat',
						'type' => 'range',
						'title' => __( 'Popup Repeat on Page Reload', 'templatemela-core' ),
						'help' => __( 'This number of time show the popup on each page load, If cookies not set from user by clicking "Do not show again"', 'templatemela-core' ),
						'default'   => '3',
						'min'       => '1',
						'step'      => '1',
						'max'       => '50',
						'required' => array(
							array( 'exit_popup', '=', '1' ),
						),
					),
					array(
						'id' => 'exit_popup_expire',
						'type' => 'range',
						'title' => __( 'After number of days popup cockies expired', 'templatemela-core' ),
						'help' => __( 'Popup show again after this number of days. Cookies were set when use check "Do not show again"', 'templatemela-core' ),
						'default'   => '2',
						'min'       => '1',
						'step'      => '1',
						'max'       => '100',
						'required' => array(
							array( 'exit_popup', '=', '1' ),
						),
					),
					/* array(
						'id' => 'exit_popup_dismiss',
						'type' => 'text',
						'title' => __( 'Popup Dismiss Text', 'templatemela-core' ),
						'help' => __( "Standard: Don't show this popup again", 'templatemela-core' ),
						'default' => __( "Don't show this popup again", 'templatemela-core' ),
						'required' => array(
							array( 'exit_popup', '=', '1' ),
						),
					), */
				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_cookie_popup_settings_page',
				'title' => __( 'Cookie Popup', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'cookie_popup',
						'type' => 'switch',
						'title' => __( 'Enable Cookie Popup', 'templatemela-core' ),
						'help' => __( 'This allows you to display cookie banner or popup on website.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'cookie_popup_content',
						'type' => 'text',
						'title' => __( 'Enter elements shortcode', 'templatemela-core' ),
						'help' => __( 'This is element shortcode for the element you want to show in popup. i.e [base_element id="1"]', 'templatemela-core' ),
						'required' => array(
							array( 'cookie_popup', '=', '1' ),
						),
					),
					array(
						'id' => 'cookie_popup_position',
						'type' => 'select',
						'title' => __( 'Choose a position for cookie popup', 'templatemela-core' ),
						'options' => array(
							'float_right' => __( 'Floating Right', 'templatemela-core' ),
							'float_left' => __( 'Floating Left', 'templatemela-core' ),
							'banner_top' => __( 'Banner Top', 'templatemela-core' ),
							'banner_bottom' => __( 'Banner Bottom', 'templatemela-core' ),
							'banner_left' => __( 'Banner Left', 'templatemela-core' ),
							'banner_right' => __( 'Banner Right', 'templatemela-core' ),
						),
						'help' => __( 'You can choose cookie popup position', 'templatemela-core' ),
						'default' => 'float_right',
						'required' => array( 'cookie_popup', '=', '1' ),
					),
					array(
						'id' => 'cookie_popup_expire',
						'type' => 'range',
						'title' => __( 'After number of days popup cookies expired', 'templatemela-core' ),
						'help' => __( 'Popup show again after this number of days. Default 30 days. Cookies were set when "Accept Cookies"', 'templatemela-core' ),
						'default'   => '2',
						'min'       => '1',
						'step'      => '1',
						'max'       => '100',
						'required' => array(
							array( 'cookie_popup', '=', '1' ),
						),
					),
					array(
						'id' => 'cookie_popup_button',
						'type' => 'text',
						'title' => __( 'Popup Button Text', 'templatemela-core' ),
						'help' => __( "Standard: Accept Cookies", 'templatemela-core' ),
						'default' => __( "Accept Cookies", 'templatemela-core' ),
						'required' => array(
							array( 'cookie_popup', '=', '1' ),
						),
					),
				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_notification_popup_settings_page',
				'title' => __( 'Notification Popup', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'notification_popup',
						'type' => 'switch',
						'title' => __( 'Enable Notification Popup', 'templatemela-core' ),
						'help' => __( 'This allows you to display notification popup on website.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'bt_notification_popup_info',
						'type' => 'info',
						'title' => __( 'Input the details you want to show on notification popups, separate for each card', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'bt_notification_popup_info_1',
						'type' => 'info',
						'title' => __( 'Popup card number: 1', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_product_1',
						'type' => 'text',
						'title' => __( 'Product ID', 'templatemela-core' ),
						'help' => __( 'Input the product id, you wanted to show : card 1', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_info_1',
						'type' => 'text',
						'title' => __( 'Mini Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display above product title. i.e Ben from New York, USA purchased', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_time_1',
						'type' => 'text',
						'title' => __( 'Time Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display below product title. i.e 2 day ago , 3 hours ago', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),

					array(
						'id' => 'bt_notification_popup_info_2',
						'type' => 'info',
						'title' => __( 'Popup card number: 2', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_product_2',
						'type' => 'text',
						'title' => __( 'Product ID', 'templatemela-core' ),
						'help' => __( 'Input the product id, you wanted to show : card 2', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_info_2',
						'type' => 'text',
						'title' => __( 'Mini Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display above product title. i.e Ben from New York, USA purchased', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_time_2',
						'type' => 'text',
						'title' => __( 'Time Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display below product title. i.e 2 day ago , 3 hours ago', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),


					array(
						'id' => 'bt_notification_popup_info_3',
						'type' => 'info',
						'title' => __( 'Popup card number: 3', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_product_3',
						'type' => 'text',
						'title' => __( 'Product ID', 'templatemela-core' ),
						'help' => __( 'Input the product id, you wanted to show : card 3', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_info_3',
						'type' => 'text',
						'title' => __( 'Mini Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display above product title. i.e Ben from New York, USA purchased', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_time_3',
						'type' => 'text',
						'title' => __( 'Time Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display below product title. i.e 2 day ago , 3 hours ago', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),


					array(
						'id' => 'bt_notification_popup_info_4',
						'type' => 'info',
						'title' => __( 'Popup card number: 4', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_product_4',
						'type' => 'text',
						'title' => __( 'Product ID', 'templatemela-core' ),
						'help' => __( 'Input the product id, you wanted to show : card 4', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_info_4',
						'type' => 'text',
						'title' => __( 'Mini Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display above product title. i.e Ben from New York, USA purchased', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_time_4',
						'type' => 'text',
						'title' => __( 'Time Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display below product title. i.e 2 day ago , 3 hours ago', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),


					array(
						'id' => 'bt_notification_popup_info_5',
						'type' => 'info',
						'title' => __( 'Popup card number: 5', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_product_5',
						'type' => 'text',
						'title' => __( 'Product ID', 'templatemela-core' ),
						'help' => __( 'Input the product id, you wanted to show : card 5', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_info_5',
						'type' => 'text',
						'title' => __( 'Mini Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display above product title. i.e Ben from New York, USA purchased', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_time_5',
						'type' => 'text',
						'title' => __( 'Time Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display below product title. i.e 2 day ago , 3 hours ago', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),

					


					array(
						'id' => 'bt_notification_popup_info_6',
						'type' => 'info',
						'title' => __( 'Popup card number: 6', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_product_6',
						'type' => 'text',
						'title' => __( 'Product ID', 'templatemela-core' ),
						'help' => __( 'Input the product id, you wanted to show : card 6', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_info_6',
						'type' => 'text',
						'title' => __( 'Mini Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display above product title. i.e Ben from New York, USA purchased', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_time_6',
						'type' => 'text',
						'title' => __( 'Time Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display below product title. i.e 2 day ago , 3 hours ago', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),


					array(
						'id' => 'bt_notification_popup_info_7',
						'type' => 'info',
						'title' => __( 'Popup card number: 7', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_product_7',
						'type' => 'text',
						'title' => __( 'Product ID', 'templatemela-core' ),
						'help' => __( 'Input the product id, you wanted to show : card 7', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_info_7',
						'type' => 'text',
						'title' => __( 'Mini Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display above product title. i.e Ben from New York, USA purchased', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_time_7',
						'type' => 'text',
						'title' => __( 'Time Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display below product title. i.e 2 day ago , 3 hours ago', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),

					array(
						'id' => 'bt_notification_popup_info_8',
						'type' => 'info',
						'title' => __( 'Popup card number: 8', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_product_8',
						'type' => 'text',
						'title' => __( 'Product ID', 'templatemela-core' ),
						'help' => __( 'Input the product id, you wanted to show : card 8', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_info_8',
						'type' => 'text',
						'title' => __( 'Mini Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display above product title. i.e Ben from New York, USA purchased', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_time_8',
						'type' => 'text',
						'title' => __( 'Time Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display below product title. i.e 2 day ago , 3 hours ago', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					
					
					array(
						'id' => 'bt_notification_popup_info_9',
						'type' => 'info',
						'title' => __( 'Popup card number: 9', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_product_9',
						'type' => 'text',
						'title' => __( 'Product ID', 'templatemela-core' ),
						'help' => __( 'Input the product id, you wanted to show : card 9', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_info_9',
						'type' => 'text',
						'title' => __( 'Mini Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display above product title. i.e Ben from New York, USA purchased', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					array(
						'id' => 'notification_popup_time_9',
						'type' => 'text',
						'title' => __( 'Time Information', 'templatemela-core' ),
						'help' => __( 'Input the text you want to display below product title. i.e 2 day ago , 3 hours ago', 'templatemela-core' ),
						'required' => array( 'notification_popup', '=', '1' ),
					),
					
				),
			)
		);

		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_cross_sell_settings_page',
				'title' => __( 'Cross Sell', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					/* array(
						'id' => 'cross_sell',
						'type' => 'switch',
						'title' => __( 'Enable cross sell products', 'templatemela-core' ),
						'help' => __( 'This allows you to display recommended products for products in cart to cross sell.', 'templatemela-core' ),
						'default' => 0,
					), */
					array(
						'id' => 'cross_sell_columns',
						'type' => 'select',
						'title' => __( 'Choose a number of columns in one row', 'templatemela-core' ),
						'help' => __( 'This is number of product show in one row.', 'templatemela-core' ),
						'options' => array(
							'2' => __( '2', 'templatemela-core' ),
							'3' => __( '3', 'templatemela-core' ),
							'4' => __( '4', 'templatemela-core' ),
							'5' => __( '5', 'templatemela-core' ),
							'6' => __( '6', 'templatemela-core' ),
						),
						'default' => '5',
						//'required' => array( 'cross_sell', '=', '1' ),
					),
					array(
						'id' => 'cross_sell_limit',
						'type' => 'text',
						'title' => __( 'Total number of cross sell products to show', 'templatemela-core' ),
						'default' => '5',
						//'required' => array( 'cross_sell', '=', '1' ),
					),
				),
			)
		);

		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_swatches',
				'title' => __( 'Variation Swatches', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'variation_swatches',
						'type' => 'switch',
						'title' => __( 'Enable swatches control with variations', 'templatemela-core' ),
						'help' => __( 'This allows you to display images or colors for variation choices.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'variation_label',
						'type' => 'switch',
						'title' => __( 'Show variation label above selection area.', 'templatemela-core' ),
						'help' => __( 'This will move the variation attribute label above the variation selection area.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'variation_swatches', '=', '1' ),
					),
					array(
						'id' => 'swatches_type',
						'type' => 'select',
						'title' => __( 'Choose a default swatch type', 'templatemela-core' ),
						'options' => array(
							'dropdown' => __( 'Dropdown Select Box', 'templatemela-core' ),
							'radio_box' => __( 'Radio Boxes', 'templatemela-core' ),
							'color_image' => __( 'Image and Color swatches', 'templatemela-core' ),
							'taxonomy' => __( 'Taxonomy defined', 'templatemela-core' ),
						),
						'help' => __( 'This can be overridden in each product.', 'templatemela-core' ),
						'default' => 'dropdown',
						'required' => array( 'variation_swatches', '=', '1' ),
					),
					array(
						'id' => 'swatches_label',
						'type' => 'select',
						'title' => __( 'Choose a default swatch label option', 'templatemela-core' ),
						'help' => __( 'This can be overridden in each product.', 'templatemela-core' ),
						'options' => array(
							'false' => __( 'No label', 'templatemela-core' ),
							'above' => __( 'Show above', 'templatemela-core' ),
							'below' => __( 'Show below', 'templatemela-core' ),
							'tooltip' => __( 'Show above on hover', 'templatemela-core' ),
						),
						'default' => 'false',
						'required' => array( 'variation_swatches', '=', '1' ),
					),
					array(
						'id' => 'swatches_size',
						'type' => 'select',
						'title' => __( 'Choose a default swatch size option', 'templatemela-core' ),
						'help' => __( 'This can be overridden in each product.', 'templatemela-core' ),
						'options' => array(
							'16' => __( '16x16px', 'templatemela-core' ),
							'30' => __( '30x30px', 'templatemela-core' ),
							'40' => __( '40x40px', 'templatemela-core' ),
							'50' => __( '50x50px', 'templatemela-core' ),
							'60' => __( '60x60px', 'templatemela-core' ),
							'75' => __( '75x75px', 'templatemela-core' ),
							'90' => __( '90x90px', 'templatemela-core' ),
							'120' => __( '120x120px', 'templatemela-core' ),
							'150' => __( '150x150px', 'templatemela-core' ),
						),
						'default' => '50',
						'required' => array( 'variation_swatches', '=', '1' ),
					),
					array(
						'id' => 'choose_option_text',
						'type' => 'text',
						'title' => __( 'Dropdown "Choose an option" text', 'templatemela-core' ),
						'help' => __( 'Standard: Choose an option', 'templatemela-core' ),
						'required' => array( 'variation_swatches', '=', '1' ),
					),
				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_gallery',
				'title' => __( 'Product Gallery', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'product_gallery',
						'type' => 'switch',
						'title' => __( 'Enable Product Slider Gallery', 'templatemela-core' ),
						'help' => __( 'This changes the woocommerce product image and gallery into a slider', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'ga_slider_layout_wrap',
						'responsive' => true,
						'desktop' => array(
							'id' => 'ga_slider_layout',
							'type' => 'image_select',
							'title' => __( 'Choose a gallery type', 'templatemela-core' ),
							'options' => array(
								array(
									'value' => 'above',
									'alt' => 'Thumbnails Below Image',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-above.png',
								),
								array(
									'value' => 'left',
									'alt' => 'Thumbnails beside slider on the right',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-left.png',
								),
								array(
									'value' => 'right',
									'alt' => 'Thumbnails beside slider on the left',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-right.png',
								),
								array(
									'value' => 'list',
									'alt' => 'No Thumbnails, Images in a list.',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-list.png',
								),
								array(
									'value' => 'grid',
									'alt' => 'Images in a two column grid.',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-grid.png',
								),
								array(
									'value' => 'tiles',
									'alt' => 'Images in a tiles layout.',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-tiles.png',
								),
								array(
									'value' => 'slider',
									'alt' => 'Images in a slider layout, no thumbnails.',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-slider.png',
								),
							),
							'default' => 'above',
						),
						'tablet' => array(
							'id' => 'ga_slider_layout_tablet',
							'type' => 'image_select',
							'title' => __( 'Choose a gallery type', 'templatemela-core' ),
							'options' => array(
								array(
									'value' => 'above',
									'alt' => 'Thumbnails Below Image',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-above.png',
								),
								array(
									'value' => 'left',
									'alt' => 'Thumbnails beside slider on the right',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-left.png',
								),
								array(
									'value' => 'right',
									'alt' => 'Thumbnails beside slider on the left',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-right.png',
								),
								array(
									'value' => 'list',
									'alt' => 'No Thumbnails, Images in a list.',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-list.png',
								),
								array(
									'value' => 'grid',
									'alt' => 'Images in a two column grid.',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-grid.png',
								),
								array(
									'value' => 'tiles',
									'alt' => 'Images in a tiles layout.',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-tiles.png',
								),
								array(
									'value' => 'slider',
									'alt' => 'Images in a slider layout, no thumbnails.',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-slider.png',
								),
							),
							'default' => '',
						),
						'mobile' => array(
							'id' => 'ga_slider_layout_mobile',
							'type' => 'image_select',
							'title' => __( 'Choose a gallery type', 'templatemela-core' ),
							'options' => array(
								array(
									'value' => 'above',
									'alt' => 'Thumbnails Below Image',
									'img' => TMCORE_WOO_URL . '/lib/gallery/img/gallery-type-above.png',
								),
								array(
									'value' => 'left',
									'alt' => 'Thumbnails beside slider on the left',
									'img' => TMCORE_WOO_URL . '/lib/gallery/img/gallery-type-left.png',
								),
								array(
									'value' => 'right',
									'alt' => 'Thumbnails beside slider on the right',
									'img' => TMCORE_WOO_URL . '/lib/gallery/img/gallery-type-right.png',
								),
								array(
									'value' => 'list',
									'alt' => 'No Thumbnails, Images in a list.',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-list.png',
								),
								array(
									'value' => 'grid',
									'alt' => 'Images in a two column grid.',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-grid.png',
								),
								array(
									'value' => 'tiles',
									'alt' => 'Images in a tiles layout.',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-tiles.png',
								),
								array(
									'value' => 'slider',
									'alt' => 'Images in a slider layout, no thumbnails.',
									'img' => TMCORE_WOO_URL . 'lib/gallery/img/gallery-type-slider.png',
								),
							),
							'default' => '',
						),
						'required' => array( 'product_gallery', '=', '1' ),
					),
					array(
						'id' => 'product_gallery_custom_size',
						'type' => 'switch',
						'title' => __( 'Enable Custom Size for Gallery Images', 'templatemela-core' ),
						'help' => __( 'This enables options to set custom image sizes for the product gallery.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'product_gallery', '=', '1' ),
					),
					array(
						'id' => 'ga_image_width',
						'type' => 'range',
						'title' => __( 'Product image width', 'templatemela-core' ),
						'default'   => '465',
						'min'       => '200',
						'step'      => '1',
						'max'       => '2000',
						'required' => array(
							array( 'product_gallery', '=', '1' ),
							array( 'product_gallery_custom_size', '=', '1' ),
						),
					),
					array(
						'id' => 'ga_image_ratio',
						'type' => 'select',
						'title' => __( 'Product image ratio', 'templatemela-core' ),
						'options' => array(
							'square' => __( 'Square 1:1', 'templatemela-core' ),
							'portrait' => __( 'Portrait 3:4', 'templatemela-core' ),
							'landscape' => __( 'Landscape 4:3', 'templatemela-core' ),
							'landscape32' => __( 'Landscape 3:2', 'templatemela-core' ),
							'landscape169' => __( 'Landscape 16:9', 'templatemela-core' ),
							'widelandscape' => __( 'Wide Landscape 4:2', 'templatemela-core' ),
							'custom' => __( 'Custom', 'templatemela-core' ),
						),
						'default' => 'square',
						'required' => array(
							array( 'product_gallery', '=', '1' ),
							array( 'product_gallery_custom_size', '=', '1' ),
						),
					),
					array(
						'id' => 'ga_image_height',
						'type' => 'range',
						'title' => __( 'Product image Height', 'templatemela-core' ),
						'default'       => '465',
						'min'       => '200',
						'customizer' => false,
						'step'      => '1',
						'max'       => '1200',
						'required' => array(
							array( 'product_gallery', '=', '1' ),
							array( 'product_gallery_custom_size', '=', '1' ),
							array( 'ga_image_ratio', '=', 'custom' ),
						),
					),
					array(
						'id' => 'ga_thumb_vertical_width_wrap',
						'responsive' => true,
						'required' => array(
							array( 'product_gallery', '=', '1' ),
							array( 'ga_slider_layout', '!=', 'above' ),
							array( 'ga_slider_layout', '!=', 'grid' ),
							array( 'ga_slider_layout', '!=', 'tiles' ),
							array( 'ga_slider_layout', '!=', 'list' ),
							array( 'ga_slider_layout', '!=', 'slider' ),
						),
						'desktop' => array(
							'id'       => 'ga_thumb_width',
							'type'     => 'range',
							'title'    => __( 'Thumbnail Width %', 'templatemela-core' ),
							'default'  => '20',
							'min'      => '2',	
							'step'     => '1',
							'max'      => '80',
						),
						'tablet' => array(
							'id'       => 'ga_thumb_width_tablet',
							'type'     => 'range',
							'title'    => __( 'Thumbnail Width %', 'templatemela-core' ),
							'default'  => '',
							'min'      => '2',	
							'step'     => '1',
							'max'      => '80',
						),
						'mobile' => array(
							'id'       => 'ga_thumb_width_mobile',
							'type'     => 'range',
							'title'    => __( 'Thumbnail Width %', 'templatemela-core' ),
							'default'  => '',
							'min'      => '2',	
							'step'     => '1',
							'max'      => '80',
						),
					),
					array(
						'id' => 'ga_thumb_columns_wrap',
						'responsive' => true,
						'required' => array(
							array( 'product_gallery', '=', '1' ),
							array( 'ga_slider_layout', '!=', 'grid' ),
							array( 'ga_slider_layout', '!=', 'tiles' ),
							array( 'ga_slider_layout', '!=', 'list' ),
							array( 'ga_slider_layout', '!=', 'slider' ),
						),
						'desktop' => array(
							'id'       => 'ga_thumb_columns',
							'type'     => 'range',
							'title'    => __( 'Select how many thumbnail columns are visible at a time', 'templatemela-core' ),
							'default'  => '6',
							'min'      => '2',	
							'step'     => '1',
							'max'      => '10',
						),
						'tablet' => array(
							'id'       => 'ga_thumb_columns_tablet',
							'type'     => 'range',
							'title'    => __( 'Select how many thumbnail columns are visible at a time', 'templatemela-core' ),
							'default'  => '',
							'min'      => '2',	
							'step'     => '1',
							'max'      => '10',
						),
						'mobile' => array(
							'id'       => 'ga_thumb_columns_mobile',
							'type'     => 'range',
							'title'    => __( 'Select how many thumbnail columns are visible at a time', 'templatemela-core' ),
							'default'  => '',
							'min'      => '2',	
							'step'     => '1',
							'max'      => '10',
						),
					),
					array(
						'id' => 'ga_thumb_image_ratio',
						'type' => 'select',
						'title' => __( 'Product thumbnail image ratio', 'templatemela-core' ),
						'options' => array(
							'square' => __( 'Square 1:1', 'templatemela-core' ),
							'portrait' => __( 'Portrait 3:4', 'templatemela-core' ),
							'landscape' => __( 'Landscape 4:3', 'templatemela-core' ),
							'landscape32' => __( 'Landscape 3:2', 'templatemela-core' ),
							'landscape169' => __( 'Landscape 16:9', 'templatemela-core' ),
							'widelandscape' => __( 'Wide Landscape 4:2', 'templatemela-core' ),
							'inherit' => __( 'Inherit from image', 'templatemela-core' ),
						),
						'default' => 'square',
						'required' => array(
							array( 'product_gallery', '=', '1' ),
							array( 'ga_slider_layout', '=', 'above' ),
						),
					),
					array(
						'id' => 'ga_trans_type',
						'type' => 'select',
						'title' => __( 'Slider transition', 'templatemela-core' ),
						'options' => array(
							'false' => __( 'Slide', 'templatemela-core' ),
							'true' => __( 'Fade', 'templatemela-core' ),
						),
						'default' => 'false',
						'required' => array( 'product_gallery', '=', '1' ),
					),
					array(
						'id' => 'ga_slider_transtime',
						'type' => 'range',
						'title' => __( 'Slider transition speed', 'templatemela-core' ),
						'help' => __( 'How long the transition takes, in milliseconds.', 'templatemela-core' ),
						'default'   => '500',
						'min'       => '100',
						'step'      => '100',
						'max'       => '4000',
						'required' => array( 'product_gallery', '=', '1' ),
					),
					array(
						'id' => 'ga_slider_autoplay',
						'type' => 'select',
						'title' => __( 'Slider auto play', 'templatemela-core' ),
						'options' => array(
							'false' => __( 'False', 'templatemela-core' ),
							'true' => __( 'True', 'templatemela-core' ),
						),
						'default' => 'false',
						'required' => array(
							array( 'product_gallery', '=', '1' ),
							array( 'ga_slider_layout', '!=', 'grid' ),
							array( 'ga_slider_layout', '!=', 'tiles' ),
							array( 'ga_slider_layout', '!=', 'list' ),
						),
					),
					array(
						'id' => 'ga_slider_pausetime',
						'type' => 'range',
						'title' => __( 'Slider pause time', 'templatemela-core' ),
						'help' => __( 'How long to pause on each slide, in milliseconds.', 'templatemela-core' ),
						'default'   => '7000',
						'min'       => '3000',
						'step'      => '1000',
						'max'       => '12000',
						'required' => array(
							array( 'product_gallery', '=', '1' ),
						),
					),
					array(
						'id' => 'ga_slider_auto_height',
						'title' => __( 'Adjust height to each photo?', 'templatemela-core' ),
						'type' => 'switch',
						'default' => 0,
						'required' => array(
							array( 'product_gallery', '=', '1' ),
							array( 'ga_slider_layout', '!=', 'grid' ),
							array( 'ga_slider_layout', '!=', 'tiles' ),
							array( 'ga_slider_layout', '!=', 'list' ),
							array( 'ga_slider_layout', '!=', 'left' ),
							array( 'ga_slider_layout', '!=', 'right' ),
						),
					),
					array(
						'id' => 'ga_slider_auto_height_info',
						'title' => __( 'Warning! Using adjust height with autoplay is not recommended, on mobile devices this will cause your content to move up and down when slides change.', 'templatemela-core' ),
						'type' => 'info',
						'required' => array(
							array( 'product_gallery', '=', '1' ),
							array( 'ga_slider_auto_height', '=', '1' ),
							array( 'ga_slider_autoplay', '=', 'True' ),
							array( 'ga_slider_layout', '!=', 'grid' ),
							array( 'ga_slider_layout', '!=', 'tiles' ),
							array( 'ga_slider_layout', '!=', 'list' ),
							array( 'ga_slider_layout', '!=', 'left' ),
							array( 'ga_slider_layout', '!=', 'right' ),
						),
					),
					array(
						'id' => 'ga_zoom',
						'type' => 'switch',
						'title' => __( 'Enable Product Image Hover Zoom', 'templatemela-core' ),
						'help' => __( 'This allows you to magnify product images without having to click to a lightbox. Note that slider arrows do not show with zoom on.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'product_gallery', '=', '1' ),
					),
					array(
						'id' => 'ga_zoom_type',
						'type' => 'select',
						'title' => __( 'Show image magnification on top of image or beside image?', 'templatemela-core' ),
						'options' => array(
							'window' => __( 'Magnify window is beside of image', 'templatemela-core' ),
							'inner' => __( 'Magnify window is on top of image', 'templatemela-core' ),
						),
						'default' => 'window',
						'required' => array(
							array( 'product_gallery', '=', '1' ),
							array( 'ga_zoom', '=', '1' ),
						),
					),
					array(
						'id' => 'ga_slider_arrows',
						'type' => 'select',
						'title' => __( 'Show slide arrows on product image?', 'templatemela-core' ),
						'options' => array(
							'false' => __( 'False', 'templatemela-core' ),
							'true' => __( 'True', 'templatemela-core' ),
						),
						'default' => 'false',
						'required' => array(
							array( 'product_gallery', '=', '1' ),
							array( 'ga_zoom', '!=', '1' ),
							array( 'ga_slider_layout', '!=', 'grid' ),
							array( 'ga_slider_layout', '!=', 'tiles' ),
							array( 'ga_slider_layout', '!=', 'list' ),
						),
					),
					array(
						'id' => 'ga_thumb_hover',
						'type' => 'switch',
						'title' => __( 'Enable thumbnail hover selection.', 'templatemela-core' ),
						'help' => __( 'This changes the main image when you hover over a thumbnail image.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'product_gallery', '=', '1' ),
					),
					array(
						'id' => 'product_gallery_lightbox',
						'type' => 'switch',
						'title' => __( 'Enable Lightbox', 'templatemela-core' ),
						'help' => __( 'This allows users to open a lightbox of your product images on click', 'templatemela-core' ),
						'default' => 1,
						'required' => array( 'product_gallery', '=', '1' ),
					),
					array(
						'id' => 'ga_lightbox_skin',
						'type' => 'select',
						'title' => __( 'Lightbox Style', 'templatemela-core' ),
						'options' => array(
							'dark' => __( 'Dark', 'templatemela-core' ),
							'light' => __( 'Light', 'templatemela-core' ),
						),
						'default' => 'false',
						'required' => array(
							array( 'product_gallery', '=', '1' ),
							array( 'ga_zoom', '!=', '1' ),
							array( 'ga_slider_layout', '!=', 'grid' ),
							array( 'ga_slider_layout', '!=', 'tiles' ),
							array( 'ga_slider_layout', '!=', 'list' ),
						),
					),
					array(
						'id' => 'ga_show_caption',
						'type' => 'select',
						'title' => __( 'Show Caption overlay on images', 'templatemela-core' ),
						'options' => array(
							'false' => __( 'False', 'templatemela-core' ),
							'true' => __( 'True', 'templatemela-core' ),
						),
						'default' => 'false',
						'required' => array( 'product_gallery', '=', '1' ),
					),
					array(
						'id' => 'ga_shortcode_option',
						'type' => 'switch',
						'title' => __( 'Enable meta area for shortcode override', 'templatemela-core' ),
						'help' => __( 'This adds a metabox area in each product allowing you to override the gallery with a shortcode or html content.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'product_gallery', '=', '1' ),
					),
				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_reviews',
				'title' => __( 'Advanced Reviews', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'bt_reviews',
						'type' => 'switch',
						'title' => __( 'Enable Advanced Reviews', 'templatemela-core' ),
						'help' => __( 'This allows you to change the review order as well as have titles and vote on reviews.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'bt_reviews_order',
						'type' => 'select',
						'title' => __( 'Select Review Order', 'templatemela-core' ),
						'options' => array(
							'votes_desc' => __( 'Order by most helpful with fallback newest first', 'templatemela-core' ),
							'desc' => __( 'Newest First', 'templatemela-core' ),
							'asc' => __( 'Oldest First', 'templatemela-core' ),
						),
						'default' => 'votes_desc',
						'width' => 'width:60%',
						'required' => array( 'bt_reviews', '=', '1' ),
					),
					array(
						'id' => 'bt_review_title',
						'type' => 'switch',
						'title' => __( 'Enable Review Titles', 'templatemela-core' ),
						'help' => __( 'This allows you to have titles for reviews.', 'templatemela-core' ),
						'default' => 1,
						'required' => array( 'bt_reviews', '=', '1' ),
					),
					array(
						'id' => 'bt_review_consent',
						'type' => 'switch',
						'title' => __( 'Enable Review Consent Checkbox', 'templatemela-core' ),
						'help' => __( 'This adds a consent to privacy policy checkbox', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'bt_reviews', '=', '1' ),
					),
					array(
						'id' => 'bt_reviews_multi',
						'type' => 'switch',
						'title' => __( 'When using polylang or WPML show reviews in every language.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'bt_reviews', '=', '1' ),
					),
					array(
						'id' => 'bt_review_voting',
						'type' => 'switch',
						'title' => __( 'Enable Review Voting', 'templatemela-core' ),
						'help' => __( 'This allows users to upvote reviews that are more helpful.', 'templatemela-core' ),
						'default' => 1,
						'required' => array( 'bt_reviews', '=', '1' ),
					),
					array(
						'id' => 'vote_loggedin_only',
						'type' => 'switch',
						'title' => __( 'Voters must be logged in?', 'templatemela-core' ),
						'help' => __( 'With this turned on only logged in users will be able to vote.', 'templatemela-core' ),
						'default' => 1,
						'required' => array( 'bt_reviews', '=', '1' ),
					),
					array(
						'id' => 'bt_review_overview',
						'type' => 'switch',
						'title' => __( 'Show Review Overview?', 'templatemela-core' ),
						'help' => __( 'With this turned on there will be overview of all reviews.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'bt_reviews', '=', '1' ),
					),
					array(
						'id' => 'bt_review_overview_highlight',
						'type' => 'color',
						'title' => __( 'Overview highlight color', 'templatemela-core' ),
						'default' => '#2d5c88',
						'required' => array( 'bt_reviews', '=', '1' ),
					),
					array(
						'id' => 'bt_reviews_featured',
						'type' => 'switch',
						'title' => __( 'Enabled Featured Reviews', 'templatemela-core' ),
						'help' => __( 'With this turned on you can set reviews to be featured and show at the top of your list.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'bt_reviews', '=', '1' ),
					),
					array(
						'id' => 'bt_reviews_limited',
						'type' => 'switch',
						'title' => __( 'Enabled Load More for Reviews', 'templatemela-core' ),
						'help' => __( 'With this turned on reviews will only load the inital amount and a load more button will show.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'bt_reviews', '=', '1' ),
					),
					array(
						'id' => 'bt_reviews_limited_readmore',
						'type' => 'text',
						'title' => __( 'Read More Reviews Button Text', 'templatemela-core' ),
						'help' => __( 'Default: Read More Reviews', 'templatemela-core' ),
						'required' => array(
							array( 'bt_reviews', '=', '1' ),
							array( 'bt_reviews_limited', '=', '1' ),
						),
					),
					array(
						'id'       => 'bt_reviews_limited_count',
						'type'     => 'range',
						'title'    => __( 'Load more inital and per load amount', 'templatemela-core' ),
						'default'  => '10',
						'min'      => '2',
						'step'     => '1',
						'max'      => '100',
						'required' => array(
							array( 'bt_reviews', '=', '1' ),
							array( 'bt_reviews_limited', '=', '1' ),
						),
					),
					array(
						'id' => 'bt_review_convert',
						'type' => 'raw',
						'title' => __( 'Convert previous reviews to Advanced Reviews', 'templatemela-core' ),
						'help' => __( 'This will convert all your previous reviews into advanced.', 'templatemela-core' ),
						'content'  => '<div id="base-convert-info" class="convert-info"><p class="base-settings-notice">Save with advanced reviews enabled and reload the page to show the convert button.</p></div>',
						'required' => array( 'bt_reviews', '=', '1' ),
					),
				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_brands_options',
				'title' => __( 'Product Brands', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'bt_product_brands_options',
						'type' => 'switch',
						'title' => __( 'Enable Product Brands Options', 'templatemela-core' ),
						'help' => __( 'This adds a new Taxonomy for Products', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'product_brands_singular',
						'type' => 'text',
						'title' => __( 'Singular Custom Name', 'templatemela-core' ),
						'help' => __( 'Default: Product Brand', 'templatemela-core' ),
						'required' => array( 'bt_product_brands_options', '=', '1' ),
					),
					array(
						'id' => 'product_brands_plural',
						'type' => 'text',
						'title' => __( 'Plural Custom Name', 'templatemela-core' ),
						'help' => __( 'Default: Product Brands', 'templatemela-core' ),
						'required' => array( 'bt_product_brands_options', '=', '1' ),
					),
					array(
						'id' => 'product_brands_slug',
						'type' => 'text',
						'title' => __( 'URL Custom slug', 'templatemela-core' ),
						'help' => __( 'Default: product-brands (lowercase, no spaces)', 'templatemela-core' ),
						'required' => array( 'bt_product_brands_options', '=', '1' ),
					),
					array(
						'id' => 'product_brands_output_info',
						'type' => 'info',
						'title' => __( 'Product Brands Single Output settings', 'templatemela-core' ),
						'required' => array( 'bt_product_brands_options', '=', '1' ),
					),
					array(
						'id' => 'product_brands_single_output',
						'type' => 'select',
						'title' => __( 'Single Product Page Output', 'templatemela-core' ),
						'options' => array(
							'none' => __( 'None', 'templatemela-core' ),
							'above_title' => __( 'Above Title', 'templatemela-core' ),
							'above_price' => __( 'Below Title, Above Price', 'templatemela-core' ),
							'above_excerpt' => __( 'Below Price, Above Short Description', 'templatemela-core' ),
							'above_addtocart' => __( 'Below Short Description, Above Add to cart', 'templatemela-core' ),
							'above_meta' => __( 'Below Add to cart, Above meta content', 'templatemela-core' ),
							'below_meta' => __( 'Below meta content', 'templatemela-core' ),
						),
						'default' => 'none',
						'required' => array( 'bt_product_brands_options', '=', '1' ),
					),
					array(
						'id' => 'product_brands_single_output_style',
						'type' => 'select',
						'title' => __( 'Show as text or image', 'templatemela-core' ),
						'options' => array(
							'image' => __( 'Image', 'templatemela-core' ),
							'text' => __( 'Text', 'templatemela-core' ),
						),
						'default' => 'image',
						'required' => array( 'bt_product_brands_options', '=', '1' ),
					),
					array(
						'id' => 'product_brands_single_output_width',
						'title' => __( 'Single Product Page Brand Image Width', 'templatemela-core' ),
						'type' => 'range',
						'default'   => '200',
						'min'       => '40',
						'step'      => '2',
						'max'       => '1400',
						'required' => array( 'bt_product_brands_options', '=', '1' ),
					),
					array(
						'id' => 'product_brands_single_output_cropped',
						'type' => 'switch',
						'title' => __( 'Enable to Hard Crop Image', 'templatemela-core' ),
						'help' => __( 'If enabled you can force a specific height to hard crop to.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'bt_product_brands_options', '=', '1' ),
					),
					array(
						'id' => 'product_brands_single_output_height',
						'title' => __( 'Single Product Page Brand Image Height', 'templatemela-core' ),
						'type' =>'range',
						'default'   => '200',
						'min'       => '40',
						'step'      => '2',
						'max'       => '1400',
						'required' => array(
							array( 'bt_product_brands_options', '=', '1' ),
							array( 'product_brands_single_output_cropped', '=', '1' ),
						),
					),
					array(
						'id' => 'product_brands_single_link',
						'type' => 'switch',
						'title' => __( 'Link Image to Brand Page', 'templatemela-core' ),
						'help' => __( 'Adds Link to brand archive page from image.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'bt_product_brands_options', '=', '1' ),
					),
					/* array(
						'id' => 'product_brands_archive_output_info',
						'type' => 'info',
						'title' => __( 'Product Brands Archive Output settings', 'templatemela-core' ),
						'required' => array( 'bt_product_brands_options', '=', '1' ),
					),
					array(
						'id' => 'product_brands_archive_output',
						'type' => 'select',
						'title' => __( 'Archive Page Output', 'templatemela-core' ),
						'options' => array(
							'none' => __( 'None', 'templatemela-core' ),
							'above_image' => __( 'Above image', 'templatemela-core' ),
							'above_title' => __( 'Below image, Above title', 'templatemela-core' ),
							'above_excerpt' => __( 'Below title, Above excerpt', 'templatemela-core' ),
							'above_price' => __( 'Below excerpt, Above price', 'templatemela-core' ),
							'above_addtocart' => __( 'Below price, Above add to cart', 'templatemela-core' ),
							'below_addtocart' => __( 'Below add to cart', 'templatemela-core' ),
						),
						'default' => 'none',
						'required' => array( 'bt_product_brands_options', '=', '1' ),
					),
					array(
						'id' => 'product_brands_archive_output_style',
						'type' => 'select',
						'title' => __( 'Show as text or image', 'templatemela-core' ),
						'options' => array(
							'image' => __( 'Image', 'templatemela-core' ),
							'text' => __( 'Text', 'templatemela-core' ),
						),
						'default' => 'image',
						'required' => array( 'bt_product_brands_options', '=', '1' ),
					),
					array(
						'id' => 'product_brands_archive_output_width',
						'title' => __( 'Archive Page Brand Image Width', 'templatemela-core' ),
						'type' => 'range',
						'default'   => '200',
						'min'       => '40',
						'step'      => '2',
						'max'       => '1400',
						'required' => array( 'bt_product_brands_options', '=', '1' ),
					),
					array(
						'id' => 'product_brands_archive_output_cropped',
						'type' => 'switch',
						'title' => __( 'Enable to Hard Crop Image', 'templatemela-core' ),
						'help' => __( 'If enabled you can force a specific height to hard crop to.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'bt_product_brands_options', '=', '1' ),
					),
					array(
						'id' => 'product_brands_archive_output_height',
						'title' => __( 'Archive Page Brand Image Height', 'templatemela-core' ),
						'type' => 'range',
						'default'   => '200',
						'min'       => '40',
						'step'      => '2',
						'max'       => '1400',
						'required' => array(
							array( 'bt_product_brands_options', '=', '1' ),
							array( 'product_brands_archive_output_cropped', '=', '1' ),
						),
					),
					array(
						'id' => 'product_brands_archive_link',
						'type' => 'switch',
						'title' => __( 'Link Image to Brand Page', 'templatemela-core' ),
						'help' => __( 'Adds Link to brand archive page from image.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'bt_product_brands_options', '=', '1' ),
					), */

				),
			)
		);
		/* Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_affiliate',
				'title' => __( 'Affiliate Product Options', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'bt_affiliate_options',
						'type' => 'switch',
						'title' => __( 'Enable Affiliate/External Product Options', 'templatemela-core' ),
						'help' => __( 'This gives you control to add direct links for product images and archive action buttons.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'affiliate_archive_info',
						'type' => 'info',
						'title' => __( 'Product Archive Settings', 'templatemela-core' ),
						'required' => array( 'bt_affiliate_options', '=', '1' ),
					),
					array(
						'id' => 'bt_aa_image_link',
						'type' => 'switch',
						'title' => __( 'Enable Affiliate link for Product Images', 'templatemela-core' ),
						'help' => __( 'This makes the product image link to the affilate instead of the single product page.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'bt_affiliate_options', '=', '1' ),
					),
					array(
						'id' => 'bt_aa_image_link_target',
						'type' => 'switch',
						'title' => __( 'Enable Affiliate Product Image link to opens new browser tab', 'templatemela-core' ),
						'help' => __( 'This makes the product image link open a new tab.', 'templatemela-core' ),
						'default' => 1,
						'required' => array( 'bt_aa_image_link', '=', '1' ),
					),
					array(
						'id' => 'bt_aa_title_link',
						'type' => 'switch',
						'title' => __( 'Enable Affiliate link for Product Title', 'templatemela-core' ),
						'help' => __( 'This makes the product title link to the affilate instead of the single product page.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'bt_aa_image_link', '=', '1' ),
					),
					array(
						'id' => 'bt_aa_title_link_target',
						'type' => 'switch',
						'title' => __( 'Enable Affiliate Product Title link to opens new browser tab', 'templatemela-core' ),
						'help' => __( 'This makes the product title link open a new tab.', 'templatemela-core' ),
						'default' => 1,
						'required' => array( 'bt_aa_title_link', '=', '1' ),
					),
					array(
						'id' => 'bt_aa_action_link_target',
						'type' => 'switch',
						'title' => __( 'Enable Affiliate Button link to open new browser tab', 'templatemela-core' ),
						'help' => __( 'This makes the product button link open a new tab.', 'templatemela-core' ),
						'default' => 1,
						'required' => array( 'bt_affiliate_options', '=', '1' ),
					),
					array(
						'id' => 'affiliate_single_info',
						'type' => 'info',
						'help' => __( 'Product Single Settings', 'templatemela-core' ),
						'required' => array( 'bt_affiliate_options', '=', '1' ),
					),
					array(
						'id' => 'bt_single_aa_image_link',
						'type' => 'switch',
						'title' => __( 'Enable Affiliate link for Product Images', 'templatemela-core' ),
						'help' => __( 'This makes the product image link to the affiliate instead of the lightbox.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'bt_affiliate_options', '=', '1' ),
					),
					array(
						'id' => 'bt_single_aa_image_link_target',
						'type' => 'switch',
						'title' => __( 'Enable Affiliate Product Image link to opens new browser tab', 'templatemela-core' ),
						'help' => __( 'This makes the product image link open a new tab.', 'templatemela-core' ),
						'default' => 1,
						'required' => array( 'bt_single_aa_image_link', '=', '1' ),
					),
					array(
						'id' => 'bt_single_aa_action_link_target',
						'type' => 'switch',
						'title' => __( 'Enable Affiliate Button link to open new browser tab', 'templatemela-core' ),
						'help' => __( 'This makes the product button link open a new tab.', 'templatemela-core' ),
						'default' => 1,
						'required' => array( 'bt_affiliate_options', '=', '1' ),
					),
				),
			)
		);
 */
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_add_to_cart',
				'title' => __( 'Add to Cart Text', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'bt_add_to_cart_text',
						'type' => 'switch',
						'title' => __( 'Enable Custom add to cart text', 'templatemela-core' ),
						'help' => __( 'This allows you to change the text for the add to cart buttons.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'add_to_cart_text_info',
						'type' => 'info',
						'title' => __( 'Archive Add to Cart', 'templatemela-core' ),
						'required' => array( 'bt_add_to_cart_text', '=', '1' ),
					),
					array(
						'id' => 'add_to_cart_text',
						'type' => 'text',
						'title' => __( 'Simple Product', 'templatemela-core' ),
						'help' => __( 'Default: Add to cart', 'templatemela-core' ),
						'required' => array( 'bt_add_to_cart_text', '=', '1' ),
					),
					array(
						'id' => 'variable_add_to_cart_text',
						'type' => 'text',
						'title' => __( 'Variable Product', 'templatemela-core' ),
						'help' => __( 'Default: Select options', 'templatemela-core' ),
						'required' => array( 'bt_add_to_cart_text', '=', '1' ),
					),
					array(
						'id' => 'grouped_add_to_cart_text',
						'type' => 'text',
						'title' => __( 'Grouped Product', 'templatemela-core' ),
						'help' => __( 'Default: View Products', 'templatemela-core' ),
						'required' => array( 'bt_add_to_cart_text', '=', '1' ),
					),
					array(
						'id' => 'out_add_to_cart_text',
						'type' => 'text',
						'title' => __( 'Out of Stock Product', 'templatemela-core' ),
						'help' => __( 'Default: Read More', 'templatemela-core' ),
						'required' => array( 'bt_add_to_cart_text', '=', '1' ),
					),
					array(
						'id' => 'single_add_to_cart_text_info',
						'type' => 'info',
						'title' => __( 'Single Add to Cart', 'templatemela-core' ),
						'required' => array( 'bt_add_to_cart_text', '=', '1' ),
					),
					array(
						'id' => 'single_add_to_cart_text',
						'type' => 'text',
						'title' => __( 'All Products', 'templatemela-core' ),
						'help' => __( 'Default: Add to cart', 'templatemela-core' ),
						'required' => array( 'bt_add_to_cart_text', '=', '1' ),
					),
				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_variations',
				'title' => __( 'Variation Options', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'variation_price',
						'type' => 'select',
						'title' => __( 'Variation Price Output', 'templatemela-core' ),
						'options' => array(
							'normal' => __( 'Show Price Range ($lowest - $highest)', 'templatemela-core' ),
							'lowprice' => __( 'Show lowest price only', 'templatemela-core' ),
							'highprice' => __( 'Show highest price only', 'templatemela-core' ),
						),
						'default' => 'normal',
					),
					array(
						'id' => 'before_variation_price',
						'type' => 'text',
						'title' => __( 'Archive Text Before Variation Price', 'templatemela-core' ),
						'help' => __( 'Example: From:', 'templatemela-core' ),
						'required' => array( 'variation_price', '!=', 'normal' ),
					),
					array(
						'id' => 'after_variation_price',
						'type' => 'text',
						'title' => __( 'Archive Text After Variation Price', 'templatemela-core' ),
						'help' => __( 'Example: Base Price', 'templatemela-core' ),
						'required' => array( 'variation_price', '!=', 'normal' ),
					),
				),
			)
		);
		/* Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_templates',
				'title' => __( 'Product Templates', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'product_templates',
						'type' => 'switch',
						'title' => __( 'Enable Product Templates', 'templatemela-core' ),
						'help' => __( 'This allows you to create custom product templates', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'product_templates_output_info',
						'type' => 'info',
						'title' => __( 'Find product templates under the "Products" menu item in your admin.', 'templatemela-core' ),
						'required' => array( 'product_templates', '=', '1' ),
					),
					array(
						'id' => 'product_template_notices',
						'type' => 'switch',
						'title' => __( 'Add WooCommerce notices to top of single and archive templates?', 'templatemela-core' ),
						'help' => __( 'You can manually add notices using a block, but if you are using the snackbar style notices, this is a simple way to add them.', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'product_templates', '=', '1' ),
					),
				),
			)
		); */
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_charts',
				'title' => __( 'Size Charts', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'size_charts',
						'type' => 'switch',
						'title' => __( 'Enable Size Charts', 'templatemela-core' ),
						'help' => __( 'This gives you options to add popup size charts to products.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'size_charts_output_info',
						'type' => 'info',
						'title' => __( 'Find Size Charts under the "Products" menu item in your admin.', 'templatemela-core' ),
						'required' => array( 'size_charts', '=', '1' ),
					),
				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_global_tab',
				'title' => __( 'Global Tabs', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id'       => 'bt_global_tabs',
						'type'     => 'switch',
						'title'    => __( 'Enable Global Tabs', 'templatemela-core' ),
						'help' => __( 'This allows you to create tabs and apply them globally to products', 'templatemela-core' ),
						'default'  => 0,
					),
					array(
						'id' => 'global_tabs_output_info',
						'type' => 'info',
						'title' => __( 'Find Global Tabs under the "Products" Menu item in your admin.', 'templatemela-core' ),
						'required' => array( 'bt_global_tabs', '=', '1' ),
					),
				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_snackbar_notices',
				'title' => __( 'Snackbar Style Notices', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'snackbar_notices',
						'type' => 'switch',
						'title' => __( 'Enable Snackbar Style Notices', 'templatemela-core' ),
						'help' => __( 'This changes the default notice style in woocommerce from a banner in the page content to a fixed slide up that is dismissible.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'snackbar_cart',
						'type' => 'switch',
						'title' => __( 'Enable Snackbar Style Notices for Cart Page', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'snackbar_notices', '=', '1' ),
					),
					array(
						'id' => 'snackbar_checkout',
						'type' => 'switch',
						'title' => __( 'Enable Snackbar Style Notices for Checkout Page', 'templatemela-core' ),
						'default' => 0,
						'required' => array( 'snackbar_notices', '=', '1' ),
					),
				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_notices',
				'title' => __( 'Conditional Cart Banners', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'bt_cart_notice',
						'type' => 'switch',
						'title' => __( 'Enable Cart Banners', 'templatemela-core' ),
						'help' => __( 'This gives you options to add specialized notices to the cart page to entice with specials and upsell products.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'cart_notice_output_info',
						'type' => 'info',
						'title' => __( 'Find Cart Banners under the "Woocommerce" Menu item in your admin.', 'templatemela-core' ),
						'required' => array( 'bt_cart_notice', '=', '1' ),
					),
				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_coupon_modal',
				'title' => __( 'Checkout Coupon Modal', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'bt_coupon_modal_checkout',
						'type' => 'switch',
						'title' => __( 'Enable Coupon Checkout Modal.', 'templatemela-core' ),
						'help' => __( 'This allows you to display the coupon input field as a link in the order overview and opens a modal to input coupon. Note this only works with standard checkout, not the checkout block.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'checkout_coupon_link_placement',
						'type' => 'select',
						'title' => __( 'Coupon Modal Link Placement', 'templatemela-core' ),
						'options' => array(
							'before_review' => __( 'Before Order Review', 'templatemela-core' ),
							'before_table_total' => __( 'In Order Review table before total', 'templatemela-core' ),
							'after_table_total' => __( 'In Order Review table after total', 'templatemela-core' ),
							'between_review_payment' => __( 'Between Order Review and Payment', 'templatemela-core' ),
							'after_payment' => __( 'After Payment', 'templatemela-core' ),
						),
						'default' => 'between_review_payment',
						'required' => array( 'bt_coupon_modal_checkout', '=', '1' ),
					),
					array(
						'id' => 'checkout_coupon_pre',
						'type' => 'text',
						'title' => __( 'Pre Modal Link Text', 'templatemela-core' ),
						'help' => __( 'Standard: Have a promo code?', 'templatemela-core' ),
						'default' => __( 'Have a promo code?', 'templatemela-core' ),
						'required' => array( 'bt_coupon_modal_checkout', '=', '1' ),
					),
					array(
						'id' => 'checkout_coupon_link',
						'type' => 'text',
						'title' => __( 'Modal Link Text', 'templatemela-core' ),
						'help' => __( 'Standard: Click here to enter your code.', 'templatemela-core' ),
						'default' => __( 'Click here to enter your code.', 'templatemela-core' ),
						'required' => array( 'bt_coupon_modal_checkout', '=', '1' ),
					),
					array(
						'id' => 'checkout_coupon_desc',
						'type' => 'text',
						'title' => __( 'Modal Description', 'templatemela-core' ),
						'help' => __( 'Standard: If you have a promo code, please apply it below.', 'templatemela-core' ),
						'default' => __( 'If you have a promo code, please apply it below.', 'templatemela-core' ),
						'required' => array( 'bt_coupon_modal_checkout', '=', '1' ),
					),
					array(
						'id' => 'checkout_coupon_placeholder',
						'type' => 'text',
						'title' => __( 'Input Placeholder', 'templatemela-core' ),
						'help' => __( 'Standard: Promo code', 'templatemela-core' ),
						'default' => __( 'Promo code', 'templatemela-core' ),
						'required' => array( 'bt_coupon_modal_checkout', '=', '1' ),
					),
					array(
						'id' => 'checkout_coupon_apply',
						'type' => 'text',
						'title' => __( 'Apply Button', 'templatemela-core' ),
						'help' => __( 'Standard: Apply Code', 'templatemela-core' ),
						'default' => __( 'Apply Code', 'templatemela-core' ),
						'required' => array( 'bt_coupon_modal_checkout', '=', '1' ),
					),
				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_checkout_editor',
				'title' => __( 'Checkout Editor', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'bt_checkout_editor',
						'type' => 'switch',
						'title' => __( 'Enable Checkout Fields Editor', 'templatemela-core' ),
						'help' => __( 'This gives you total control over your checkout fields and allows you to add custom fields. Note this only works with standard checkout, not the checkout block.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'checkout_editor_output_info',
						'type' => 'info',
						'title' => __( 'Find the checkout editor under the "Woocommerce" Menu item in your admin.', 'templatemela-core' ),
						'required' => array( 'bt_checkout_editor', '=', '1' ),
					),
				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_cat_desc',
				'title' => __( 'Extra Category Description', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'bt_extra_cat',
						'type' => 'switch',
						'title' => __( 'Enable Extra Category Description Box', 'templatemela-core' ),
						'help' => __( 'This gives you an extra description box for each category to allow you to place content below the products on your category page.', 'templatemela-core' ),
						'default' => 0,
					),
				),
			)
		);
		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_buynow',
				'title' => __( 'Buy Now', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'bt_extra_buynow',
						'type' => 'switch',
						'title' => __( 'Enable Buy Now Button', 'templatemela-core' ),
						'help' => __( 'This gives you an extra buy now button for each product to place and order on your product page.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'bt_extra_buynow_text_single',
						'type' => 'text',
						'title' => __( 'Buy Now Button Text', 'templatemela-core' ),
						'help' => __( 'Default: Buy now', 'templatemela-core' ),
						'default' => __( 'Buy now', 'templatemela-core' ),
						'required' => array( 'bt_extra_buynow', '=', '1' ),
					),
				),
			)
		);

		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_countdown',
				'title' => __( 'Sale Countdown', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'bt_extra_countdown',
						'type' => 'switch',
						'title' => __( 'Enable Sale Countdown', 'templatemela-core' ),
						'help' => __( 'This gives you sale timer countdown box for each product that are on sale from list or grid from widgets.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'countdown_style_global',
						'type' => 'select',
						'title' => __( 'Sale Countdown Style Global', 'templatemela-core' ),
						'options' => array(
							'style_1' => __( 'Style 1', 'templatemela-core' ),
							'style_2' => __( 'Style 2', 'templatemela-core' ),
							'style_3' => __( 'Style 3', 'templatemela-core' ),
							'style_4' => __( 'Style 4', 'templatemela-core' ),
							'style_5' => __( 'Style 5', 'templatemela-core' ),
							'style_6' => __( 'Style 6', 'templatemela-core' ),
							'style_7' => __( 'Style 7', 'templatemela-core' ),
							'style_8' => __( 'Style 8', 'templatemela-core' ),
						),
						'default' => 'style_1',
						'required' => array( 'bt_extra_countdown', '=', '1' ),
					),
					array(
						'id' => 'bt_extra_countdown_catalog',
						'type' => 'switch',
						'title' => __( 'Enable Sale Countdown for Catalog Page?', 'templatemela-core' ),
						'help' => __( 'This gives you sale timer countdown box for each product on shop page.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'bt_extra_countdown_single_product',
						'type' => 'switch',
						'title' => __( 'Enable Sale Countdown for Product Page?', 'templatemela-core' ),
						'help' => __( 'This gives you sale timer countdown box for each product.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'countdown_style_single_product',
						'type' => 'select',
						'title' => __( 'Sale Countdown Style for Product Page', 'templatemela-core' ),
						'options' => array(
							'style_1' => __( 'Style 1', 'templatemela-core' ),
							'style_2' => __( 'Style 2', 'templatemela-core' ),
							'style_3' => __( 'Style 3', 'templatemela-core' ),
							'style_4' => __( 'Style 4', 'templatemela-core' ),
							'style_5' => __( 'Style 5', 'templatemela-core' ),
							'style_6' => __( 'Style 6', 'templatemela-core' ),
							'style_7' => __( 'Style 7', 'templatemela-core' ),
							'style_8' => __( 'Style 8', 'templatemela-core' ),
						),
						'default' => 'style_1',
						'required' => array( 'bt_extra_countdown_single_product', '=', '1' ),
					),
					array(
						'id' => 'countdown_label',
						'type' => 'text',
						'title' => __( 'Countdown Label', 'templatemela-core' ),
						'default' => __( 'Hurry up ! Sale end in:', 'templatemela-core' ),
						'required' => array( 'bt_extra_countdown_single_product', '=', '1' ),
					),
				),
			)
		);

		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_extra_marketplace',
				'title' => __( 'Marketplace', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'bt_dokan_info',
						'type' => 'info',
						'title' => __( 'DOKAN : The below settings allow you to show or hide seller name.', 'templatemela-core' ),
					),
					array(
						'id' => 'bt_sold_by_text',
						'type' => 'text',
						'title' => __( 'Sold by label', 'templatemela-core' ),
						'help' => __( 'Default: Sold by:', 'templatemela-core' ),
						'default' => __( 'Sold by:', 'templatemela-core' ),
					),
					array(
						'id' => 'dokan_seller_shop_page',
						'type' => 'switch',
						'title' => __( 'Show Dokan seller name on shop page', 'templatemela-core' ),
						'help' => __( 'This shows you a seller name with a link for each product.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'dokan_seller_product_page',
						'type' => 'switch',
						'title' => __( 'Show Dokan seller name on product page', 'templatemela-core' ),
						'help' => __( 'This shows you a seller name with a link on the product page.', 'templatemela-core' ),
						'default' => 0,
					),
				),
			)
		);

		Base_Settings_Engine::set_section(
			self::OPT_NAME,
			array(
				'id' => 'bt_woo_advanced',
				'title' => __( 'Advanced Settings', 'templatemela-core' ),
				'desc' => '',
				'fields' => array(
					array(
						'id' => 'bt_lazy_load_info',
						'type' => 'info',
						'title' => __( 'Lazy Load for Product Images: The below settings allow you to enable/disable lazy load for product images.', 'templatemela-core' ),
					),
					array(
						'id' => 'lazy_load_product_images',
						'type' => 'switch',
						'title' => __( 'Show loading image before product image loads', 'templatemela-core' ),
						'help' => __( 'This will show the loading image before the product image loads.<br> Note: You may not see a lazy loading image when enabling the below responsive product image option because responsive loads small images, which load quickly.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'bt_responsive_srcset_info',
						'type' => 'info',
						'title' => __( 'Responsive Product Images: The below settings allow you to add responsive images as "srcset" for product images.', 'templatemela-core' ),
					),
					array(
						'id' => 'responsive_product_images_srcset',
						'type' => 'switch',
						'title' => __( 'Add responsive images for product images that load small images for small devices and large images for large devices.', 'templatemela-core' ),
						'help' => __( 'This will add srcset for product images.<br>Note: You may not see a lazy loading image when selecting this option because responsive loads small images, which load quickly.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'bt_skeleton_info',
						'type' => 'info',
						'title' => __( 'Skeleton Shimmer Effects: The below settings allow you to enable/disable Skeleton Shimmer Effects for products, posts and categories.', 'templatemela-core' ),
					),
					array(
						'id' => 'skeleton_shimmer',
						'type' => 'switch',
						'title' => __( 'Show skeleton loading shimmer effects before content loads', 'templatemela-core' ),
						'help' => __( 'This will show the skeleton shimmer before the content loads.<br> Note: You may not see a lazy loading image when enabling this.', 'templatemela-core' ),
						'default' => 0,
					),
					array(
						'id' => 'skeleton_shimmer_color',
						'type' => 'color',
						'title' => __( 'Skeleton shimmer background color', 'templatemela-core' ),
						'default' => '#2d5c88',
						'required' => array( 'skeleton_shimmer', '=', '1' ),
					),
					array(
						'id' => 'bt_loading_screen_info',
						'type' => 'info',
						'title' => __( 'Loading Screen: The below settings allow you to enable/disable Loading screen before website content loads.', 'templatemela-core' ),
					),
					array(
						'id' => 'loading_screen',
						'type' => 'switch',
						'title' => __( 'Show loading screen or loader before website content loads', 'templatemela-core' ),
						'help' => __( 'This will show the loading screen before the website content loads.<br> Note: You may not see a lazy loading image or shimmer effect when enabling this.', 'templatemela-core' ),
						'default' => 0,
					),

					
				),
			)
		);


	}
}
new Base_Woo_Extras_Settings();
