<?php
defined( 'ABSPATH' ) || exit;
/**
 * The widgets class.
 *
 * @since 1.0.0
 * @package TemplateMela Core
 */

/**
 * The TemplateMelaCore_Widgets class.
 */
if ( ! class_exists( 'TemplateMelaCore_Widgets' ) ) {
	class TemplateMelaCore_Widgets {

		protected static $instance = null;

		public static function instance() {
			if ( null === self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		function initialize() {
			// Init Widgets.
			add_action( 'widgets_init', [ $this, 'register_widgets' ], 11 );

			//add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_widgets_scripts' ] );
		}

		/**
		 * Register widgets.
		 *
		 * @since 1.0.0
		 * @access public
		 * @return void
		 */
		public function register_widgets() {

			require_once( TMCORE_PATH . 'includes/widgets/contact-info.php' );

			register_widget( 'TemplateMela_Widget_Contact_Info' );

			if ( class_exists( 'WooCommerce' ) ) {
				require_once( TMCORE_PATH . 'includes/widgets/woocommerce/class-wc-widget-base.php' );
				require_once( TMCORE_PATH . 'includes/widgets/woocommerce/product-badge.php' );
				require_once( TMCORE_PATH . 'includes/widgets/woocommerce/product-banner.php' );
				require_once( TMCORE_PATH . 'includes/widgets/woocommerce/product-categories-nav.php' );
				require_once( TMCORE_PATH . 'includes/widgets/woocommerce/product-tags-nav.php' );
				require_once( TMCORE_PATH . 'includes/widgets/woocommerce/product-sorting.php' );
				require_once( TMCORE_PATH . 'includes/widgets/woocommerce/product-price-filter.php' );
				require_once( TMCORE_PATH . 'includes/widgets/woocommerce/product-rating-filter.php' );
				require_once( TMCORE_PATH . 'includes/widgets/woocommerce/product-highlight-filter.php' );
				require_once( TMCORE_PATH . 'includes/widgets/woocommerce/product-layered-nav.php' );
				require_once( TMCORE_PATH . 'includes/widgets/woocommerce/products.php' );
				require_once( TMCORE_PATH . 'includes/widgets/woocommerce/linked-products.php' );

				register_widget( 'TemplateMelaCore_WP_Widget_Product_Badge' );
				register_widget( 'TemplateMelaCore_WP_Widget_Product_Banner' );
				register_widget( 'TemplateMelaCore_WP_Widget_Product_Categories_Layered_Nav' );
				register_widget( 'TemplateMelaCore_WP_Widget_Product_Tags_Layered_Nav' );
				register_widget( 'TemplateMelaCore_WP_Widget_Product_Sorting' );
				register_widget( 'TemplateMelaCore_WP_Widget_Product_Price_Filter' );
				register_widget( 'TemplateMelaCore_WP_Widget_Product_Rating_Filter' );
				register_widget( 'TemplateMelaCore_WP_Widget_Product_Highlight_Filter' );
				register_widget( 'TemplateMelaCore_WP_Widget_Product_Layered_Nav' );
				register_widget( 'TemplateMelaCore_WP_Widget_Products' );
				register_widget( 'TemplateMelaCore_WP_Widget_Linked_Products' );

			}
		}

		/**
		 * Enqueue scrips & styles for widget screen.
		 *
		 * @access public
		 */
		public function enqueue_widgets_scripts() {
			$screen = get_current_screen();

			if ( 'widgets' !== $screen->id ) {
				return;
			}

			wp_enqueue_style( 'tmcore-admin-widgets', TMCORE_URL . '/assets/admin/css/widgets.min.css' );

			wp_enqueue_media();
			wp_enqueue_script( 'tmcore-media', TMCORE_URL . '/assets/admin/js/attach.js', [ 'jquery' ], null, true );
			wp_enqueue_script( 'tmcore-admin-widgets-condition', TMCORE_URL . '/assets/admin/js/wp-widgets-condition.js', [ 'jquery' ], null, true );
		}
	}

	TemplateMelaCore_Widgets::instance()->initialize();
}
