<?php

use Elementor\Plugin;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'TemplateMelaCore_Elementor' ) ) :

	/**
	 * The TemplateMela Elementor Integration class
	 */
	class TemplateMelaCore_Elementor {
		private $suffix = '';

		public function __construct() {
			$this->suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

			add_action( 'wp', [ $this, 'register_auto_scripts_frontend' ] );
			add_action( 'elementor/init', array( $this, 'add_category' ) );
			add_action( 'wp_enqueue_scripts', [ $this, 'add_scripts' ], 15 );
			add_action( 'elementor/widgets/register', array( $this, 'include_widgets' ) );
			add_action( 'elementor/frontend/after_enqueue_scripts', [ $this, 'add_js' ] );

			// Custom Animation Scroll
			add_filter( 'elementor/controls/animations/additional_animations', [ $this, 'add_animations_scroll' ] );

			// Elementor Fix Noitice WooCommerce
			add_action( 'elementor/editor/before_enqueue_scripts', array( $this, 'woocommerce_fix_notice' ) );

			// Backend
			add_action( 'elementor/editor/after_enqueue_scripts', [ $this, 'add_scripts_editor' ] );
			add_action( 'elementor/editor/after_enqueue_styles', [ $this, 'add_style_editor' ], 99 );

			// Add Icon Custom
			add_action( 'elementor/icons_manager/native', [ $this, 'add_icons_native' ] );
			add_action( 'elementor/controls/register', [ $this, 'add_icons' ] );

			add_filter( 'elementor/fonts/additional_fonts', [ $this, 'additional_fonts' ] );
            add_action('wp_enqueue_scripts', [$this, 'elementor_kit']);

			// Add Gutenberg Style
			add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_elementor_assets' ], 9999 );

			// Only for elementor admin editor
			add_action( 'admin_action_elementor', array($this, 'register_elementor_woocommerce_hook'), 9 );

			// WooCommerce Widget refresh for Elementor Editor
			/* if( is_admin() ) {
				remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
				add_action( 'woocommerce_before_shop_loop_item_title', 'tmcore_ele_woocommerce_get_product_thumbnail', 10);
				remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
				add_action( 'woocommerce_after_shop_loop_item_title', 'tmcore_ele_woocommerce_template_loop_price', 10 );
				remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
				add_action( 'woocommerce_after_shop_loop_item', 'tmcore_ele_woocommerce_template_loop_add_to_cart', 10 );
			} */
        
		}


		public function register_elementor_woocommerce_hook() {

			remove_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_title', 10 );
			
			/* remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 ); 
			remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
			remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );
			remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_price', 10 );
			//remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
			remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
			remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 ); */
			
		}
		
		public function enqueue_elementor_assets() {
			wp_enqueue_style( 'wp-block-library' );
			wp_enqueue_style( 'wp-block-library-theme' );
			wp_enqueue_style( 'wc-block-style' );
			wp_enqueue_style( 'wc-blocks-style' );
		}
		

        public function elementor_kit() {
            $active_kit_id = Elementor\Plugin::$instance->kits_manager->get_active_id();
            Elementor\Plugin::$instance->kits_manager->frontend_before_enqueue_styles();
            $myvals        = get_post_meta($active_kit_id, '_elementor_page_settings', true);
            if (!empty($myvals)) {
                $css = '';
				if (!empty($myvals['system_colors'])) {
					$css .= isset($myvals['system_colors'][0]['color']) && $myvals['system_colors'][0]['color'] !== '' ? '--primary:' . $myvals['system_colors'][0]['color'] . ';' : '';
					$css .= isset($myvals['system_colors'][0]['color']) && $myvals['system_colors'][0]['color'] !== '' ? '--primary_hover:' . tmcore_darken_color($myvals['system_colors'][0]['color'], 1.1) . ';' : '';
					$css .= isset($myvals['system_colors'][1]['color']) && $myvals['system_colors'][1]['color'] !== '' ? '--secondary:' . $myvals['system_colors'][1]['color'] . ';' : '';
					$css .= isset($myvals['system_colors'][2]['color']) && $myvals['system_colors'][2]['color'] !== '' ? '--text:' . $myvals['system_colors'][2]['color'] . ';' : '';
					$css .= isset($myvals['system_colors'][3]['color']) && $myvals['system_colors'][3]['color'] !== '' ? '--accent:' . $myvals['system_colors'][3]['color'] . ';' : '';
				}

                $custom_color = (isset($myvals['custom_colors']) && !empty($myvals['custom_colors'])) ? $myvals['custom_colors'] : '';
                if(is_array($custom_color)) {
					foreach ($custom_color as $color) {
						$title = $color["title"];
						switch ($title) {
							case "Light":
								$css .= '--light:' . $color['color'] . ';';
								break;
							case "Dark":
								$css .= '--dark:' . $color['color'] . ';';
								break;
							case "Border":
								$css .= '--border:' . $color['color'] . ';';
								break;
							case "Background":
								$css .= '--background:' . $color['color'] . ';';
								break;
						}
					}
                }

                $var = "body{{$css}}";
                wp_add_inline_style('tmcore-style', $var);
            }
        }

		public function additional_fonts( $fonts ) {
			$fonts["Bebas Neue"] = 'googlefonts';
			$fonts['Gilroy'] = 'system';
			return $fonts;
		}

		public function add_js() {
			wp_enqueue_script( 'tmcore-elementor-frontend',  TMCORE_URL . "assets/js/elementor/elementor-frontend{$this->suffix}.js", [], TMCORE_VERSION );
		}

		public function add_style_editor() {}

		public function add_scripts_editor() {}

		public function add_scripts() {
			wp_enqueue_style( 'tmcore-elementor', TMCORE_URL . "assets/css/elementor/elementor{$this->suffix}.css", '', TMCORE_VERSION );
			wp_style_add_data( 'tmcore-elementor', 'rtl', 'replace' );
			wp_enqueue_style( 'tmcore-elementor-editor-icon',  TMCORE_URL . "assets/css/elementor/elementor-icons{$this->suffix}.css", [], TMCORE_VERSION );
		}


		public function register_auto_scripts_frontend() {
			
			wp_register_script('tmcore-elementor-brand',  TMCORE_URL . "assets/js/elementor/brand{$this->suffix}.js", array('jquery','elementor-frontend'), TMCORE_VERSION, true);
			wp_register_script('tmcore-elementor-countdown',  TMCORE_URL . "assets/js/elementor/countdown{$this->suffix}.js", array('jquery','elementor-frontend'), TMCORE_VERSION, true);
			wp_register_script('tmcore-elementor-posts-grid', TMCORE_URL . "assets/js/elementor/posts-grid{$this->suffix}.js", array('jquery','elementor-frontend'), TMCORE_VERSION, true);
			wp_register_script('tmcore-elementor-product-tab',  TMCORE_URL . "assets/js/elementor/product-tab{$this->suffix}.js", array('jquery','elementor-frontend'), TMCORE_VERSION, true);
			wp_register_script('tmcore-elementor-products',  TMCORE_URL . "assets/js/elementor/products{$this->suffix}.js", array('jquery','elementor-frontend'), TMCORE_VERSION, true);
			wp_register_script('tmcore-elementor-tabs',  TMCORE_URL . "assets/js/elementor/tabs{$this->suffix}.js", array('jquery','elementor-frontend'), TMCORE_VERSION, true);
			wp_register_script('tmcore-elementor-testimonial',  TMCORE_URL . "assets/js/elementor/testimonial{$this->suffix}.js", array('jquery','elementor-frontend'), TMCORE_VERSION, true);
			wp_register_script('tmcore-elementor-product-categories',  TMCORE_URL . "assets/js/elementor/product-categories{$this->suffix}.js", array('jquery','elementor-frontend'), TMCORE_VERSION, true);
			
        }

		public function add_category() {
			Elementor\Plugin::instance()->elements_manager->add_category(
				'tmcore-addons',
				array(
					'title' => esc_html__( 'TemplateMela Addons', 'templatemela-core' ),
					'icon'  => 'fa fa-plug',
				),
				1 );
		}

		public function add_animations_scroll( $animations ) {
			$animations['TM Animation'] = [
				'opal-move-up'    => 'Move Up',
				'opal-move-down'  => 'Move Down',
				'opal-move-left'  => 'Move Left',
				'opal-move-right' => 'Move Right',
				'opal-flip'       => 'Flip',
				'opal-helix'      => 'Helix',
				'opal-scale-up'   => 'Scale',
				'opal-am-popup'   => 'Popup',
			];

			return $animations;
		}

		/**
		 * @param $widgets_manager Elementor\Widgets_Manager
		 */
		public function include_widgets( $widgets_manager ) {
			$files = glob( TMCORE_PATH . '/includes/elementor/widgets/*.php' );
			foreach ( $files as $file ) {
				if ( file_exists( $file ) ) {
					require_once $file;
				}
			}

			//	Button
			add_action( 'elementor/element/button/section_style/after_section_end', function ( $element, $args ) {
				/** @var \Elementor\Element_Base $element */
				$element->update_control( 'button_type', [
					'options' => [
						''        => esc_html__( 'Default', 'templatemela-core' ),
						'primary' => esc_html__( 'Primary', 'templatemela-core' ),
						'info'    => esc_html__( 'Info', 'templatemela-core' ),
						'success' => esc_html__( 'Success', 'templatemela-core' ),
						'warning' => esc_html__( 'Warning', 'templatemela-core' ),
						'danger'  => esc_html__( 'Danger', 'templatemela-core' ),
					],
				] );
			}, 10, 2 );

			// Heading
			add_action( 'elementor/element/heading/section_title_style/after_section_end', function ( $element, $args ) {
				/** @var \Elementor\Element_Base $element */
				// Remove Schema
				$element->update_control( 'title_color', [
					'scheme' => [],
				] );
			}, 10, 2 );

			// Counter
			add_action( 'elementor/element/counter/section_number/after_section_end', function ( $element, $args ) {
				/** @var \Elementor\Element_Base $element */
				// Remove Schema
				$element->update_control( 'title_color', [
					'scheme' => [],
				] );
			}, 10, 2 );

			// Toggle
			add_action( 'elementor/element/toggle/section_toggle_style_title/after_section_end', function ( $element, $args ) {
				/** @var \Elementor\Element_Base $element */
				// Remove Schema
				$element->update_control( 'title_color', [
					'scheme' => [],
				] );

				$element->update_control( 'tab_active_color', [
					'scheme' => [],
				] );
			}, 10, 2 );

			// Image Box
			add_action( 'elementor/element/image-box/section_style_content/after_section_end', function ( $element, $args ) {
				/** @var \Elementor\Element_Base $element */
				// Remove Schema
				$element->update_control( 'title_color', [
					'scheme' => [],
				] );

				$element->update_control( 'title_typography', [
					'scheme' => [],
				] );

				$element->update_control( 'description_color', [
					'scheme' => [],
				] );

				$element->update_control( 'description_typography', [
					'scheme' => [],
				] );
			}, 10, 2 );

			// Gallery
			add_action( 'elementor/element/gallery/overlay/before_section_end', function ( $element, $args ) {
				/** @var \Elementor\Element_Base $element */
				$element->add_control(
					'effect_icon',
					[
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'label' => __( 'Effect Icon', 'templatemela-core' ),
						'prefix_class'	=> 'elementor-widget-gallery-icon-'
					]
				);
			}, 10, 2 );

			// Icon Box
			add_action( 'elementor/element/icon-box/section_style_content/after_section_end', function ( $element, $args ) {
				/** @var \Elementor\Element_Base $element */
				// Remove Schema
				$element->update_control( 'primary_color', [
					'scheme' => [],
				] );

				$element->update_control( 'title_color', [
					'scheme' => [],
				] );

				$element->update_control( 'title_typography', [
					'scheme' => [],
				] );

				$element->update_control( 'description_color', [
					'scheme' => [],
				] );

				$element->update_control( 'description_typography', [
					'scheme' => [],
				] );
			}, 10, 2 );

			// Icon List
			add_action( 'elementor/element/icon-list/section_text_style/after_section_end', function ( $element, $args ) {
				/** @var \Elementor\Element_Base $element */
				// Remove Schema
				$element->update_control( 'icon_color', [
					'scheme' => [],
				] );

				$element->update_control( 'text_color', [
					'scheme'    => [],
					'selectors' => [
						'{{WRAPPER}} .elementor-icon-list-items .elementor-icon-list-item .elementor-icon-list-text' => 'color: {{VALUE}};',
					],
				] );

				$element->update_control( 'text_color_hover', [
					'scheme'    => [],
					'selectors' => [
						'{{WRAPPER}} .elementor-icon-list-items .elementor-icon-list-item:hover .elementor-icon-list-text' => 'color: {{VALUE}};',
					],
				] );

				$element->update_control( 'icon_typography', [
					'scheme'    => [],
					'selectors' => '{{WRAPPER}} .elementor-icon-list-items .elementor-icon-list-item:hover .elementor-icon-list-text',
				] );

				$element->update_control( 'divider_color', [
					'scheme'  => [],
					'default' => ''
				] );

			}, 10, 2 );

			// form
            add_action( 'elementor/element/form/section_field_style/before_section_end', function ( $element, $args ) {
                $element->add_control(
                    'field_border_color_focus',
                    [
                        'label' => esc_html__( 'Border Color Focus', 'templatemela-core' ),
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .elementor-field-group:not(.elementor-field-type-upload) .elementor-field:not(.elementor-select-wrapper):focus' => 'border-color: {{VALUE}};',
                            '{{WRAPPER}} .elementor-field-group .elementor-select-wrapper select:focus' => 'border-color: {{VALUE}};',
                        ],
                    ]
                );

                $element->add_control(
                    'field_text_padding',
                    [
                        'type' => \Elementor\Controls_Manager::DIMENSIONS,
                        'label' => esc_html__( 'Padding', 'templatemela-core' ),
                        'selectors' => [
                            '{{WRAPPER}} .elementor-field-group:not(.elementor-field-type-upload):not(.elementor-field-type-recaptcha_v3):not(.elementor-field-type-recaptcha) .elementor-field:not(.elementor-select-wrapper)' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            '{{WRAPPER}} .elementor-field-group .elementor-select-wrapper select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ]
                );

                $element->add_control(
                    'field_text_margin',
                    [
                        'type' => \Elementor\Controls_Manager::DIMENSIONS,
                        'label' => esc_html__( 'Margin', 'templatemela-core' ),
                        'selectors' => [
                            '{{WRAPPER}} .elementor-field-group .elementor-field' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ]
                );

                $element->add_control(
                    'textarea_heading',
                    [
                        'type' => \Elementor\Controls_Manager::HEADING,
                        'label' => esc_html__( 'Textarea', 'templatemela-core' ),
                        'separator'	=> 'before'
                    ]
                );

                $element->add_control(
                    'textarea_color',
                    [
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'label' => esc_html__( 'Color', 'templatemela-core' ),
                        'selectors' => [
                            '{{WRAPPER}} textarea.elementor-field' => 'color: {{VALUE}} !important',
                        ],
                    ]
                );

                $element->add_control(
                    'textarea_background',
                    [
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'label' => esc_html__( 'Background', 'templatemela-core' ),
                        'selectors' => [
                            '{{WRAPPER}} textarea.elementor-field' => 'background: {{VALUE}} !important',
                        ],
                    ]
                );

                $element->add_control(
                    'textarea_border_color',
                    [
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'label' => esc_html__( 'Border Color', 'templatemela-core' ),
                        'selectors' => [
                            '{{WRAPPER}} textarea.elementor-field ' => 'border-color: {{VALUE}} !important',
                        ],
                    ]
                );

                $element->add_control(
                    'textarea_border_color_active',
                    [
                        'type' => \Elementor\Controls_Manager::COLOR,
                        'label' => esc_html__( 'Border Color Active', 'templatemela-core' ),
                        'selectors' => [
                            '{{WRAPPER}} textarea.elementor-field:focus ' => 'border-color: {{VALUE}} !important',
                        ],
                    ]
                );

                $element->add_control(
                    'textarea_border',
                    [
                        'label' => esc_html__( 'Border Width', 'templatemela-core' ),
                        'type' => \Elementor\Controls_Manager::SLIDER,
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 20,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} textarea.elementor-field' => 'border-width: {{SIZE}}{{UNIT}} !important;',
                        ],
                    ]
                );

                $element->add_control(
                    'textarea_padding',
                    [
                        'label' => esc_html__( 'Padding', 'templatemela-core' ),
                        'type' => \Elementor\Controls_Manager::DIMENSIONS,
                        'size_units' => [ 'px', 'em' ],
                        'selectors' => [
                            '{{WRAPPER}} .elementor-field-group-message textarea' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                        ],
                    ]
                );


            },10,2);

            add_action('elementor/element/form/section_steps_style/after_section_end', function($element, $args){
                $element->update_control(
                    'button_background_color',
                    [
                        'global' => [
                            'default'	=> ''
                        ]
                    ]
                );
            }, 10, 2);

		}

		public function woocommerce_fix_notice() {
			if ( class_exists( 'WooCommerce' ) ) {
				remove_action( 'woocommerce_cart_is_empty', 'woocommerce_output_all_notices', 5 );
				remove_action( 'woocommerce_shortcode_before_product_cat_loop', 'woocommerce_output_all_notices', 10 );
				remove_action( 'woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10 );
				remove_action( 'woocommerce_before_single_product', 'woocommerce_output_all_notices', 10 );
				remove_action( 'woocommerce_before_cart', 'woocommerce_output_all_notices', 10 );
				remove_action( 'woocommerce_before_checkout_form', 'woocommerce_output_all_notices', 10 );
				remove_action( 'woocommerce_account_content', 'woocommerce_output_all_notices', 10 );
				remove_action( 'woocommerce_before_customer_login_form', 'woocommerce_output_all_notices', 10 );
			}
		}

		public function add_icons( $manager ) {
            $new_icons = json_decode( '{"tmcore-icon-badge-percent":"badge-percent","tmcore-icon-adobe":"adobe","tmcore-icon-amazon":"amazon","tmcore-icon-android":"android","tmcore-icon-angular":"angular","tmcore-icon-apper":"apper","tmcore-icon-apple":"apple","tmcore-icon-atlassian":"atlassian","tmcore-icon-behance":"behance","tmcore-icon-bitbucket":"bitbucket","tmcore-icon-bitcoin":"bitcoin","tmcore-icon-bity":"bity","tmcore-icon-bluetooth":"bluetooth","tmcore-icon-btc":"btc","tmcore-icon-centos":"centos","tmcore-icon-chrome":"chrome","tmcore-icon-codepen":"codepen","tmcore-icon-cpanel":"cpanel","tmcore-icon-discord":"discord","tmcore-icon-dochub":"dochub","tmcore-icon-docker":"docker","tmcore-icon-dribbble":"dribbble","tmcore-icon-dropbox":"dropbox","tmcore-icon-drupal":"drupal","tmcore-icon-ebay":"ebay","tmcore-icon-facebook":"facebook","tmcore-icon-figma":"figma","tmcore-icon-firefox":"firefox","tmcore-icon-google-plus":"google-plus","tmcore-icon-google":"google","tmcore-icon-grunt":"grunt","tmcore-icon-gulp":"gulp","tmcore-icon-html5":"html5","tmcore-icon-jenkins":"jenkins","tmcore-icon-joomla":"joomla","tmcore-icon-link-brand":"link-brand","tmcore-icon-linkedin":"linkedin","tmcore-icon-mailchimp":"mailchimp","tmcore-icon-opencart":"opencart","tmcore-icon-paypal":"paypal","tmcore-icon-pinterest-p":"pinterest-p","tmcore-icon-reddit":"reddit","tmcore-icon-skype":"skype","tmcore-icon-slack":"slack","tmcore-icon-snapchat":"snapchat","tmcore-icon-spotify":"spotify","tmcore-icon-trello":"trello","tmcore-icon-twitter":"twitter","tmcore-icon-vimeo":"vimeo","tmcore-icon-whatsapp":"whatsapp","tmcore-icon-wordpress":"wordpress","tmcore-icon-yoast":"yoast","tmcore-icon-youtube":"youtube","tmcore-icon-clock":"clock","tmcore-icon-angle-down":"angle-down","tmcore-icon-angle-left":"angle-left","tmcore-icon-angle-right":"angle-right","tmcore-icon-angle-up":"angle-up","tmcore-icon-arrow-circle-down":"arrow-circle-down","tmcore-icon-arrow-circle-left":"arrow-circle-left","tmcore-icon-arrow-circle-right":"arrow-circle-right","tmcore-icon-arrow-circle-up":"arrow-circle-up","tmcore-icon-bars":"bars","tmcore-icon-caret-down":"caret-down","tmcore-icon-caret-left":"caret-left","tmcore-icon-caret-right":"caret-right","tmcore-icon-caret-up":"caret-up","tmcore-icon-cart-empty":"cart-empty","tmcore-icon-check-square":"check-square","tmcore-icon-chevron-circle-left":"chevron-circle-left","tmcore-icon-chevron-circle-right":"chevron-circle-right","tmcore-icon-chevron-down":"chevron-down","tmcore-icon-chevron-left":"chevron-left","tmcore-icon-chevron-right":"chevron-right","tmcore-icon-chevron-up":"chevron-up","tmcore-icon-circle":"circle","tmcore-icon-cloud-download-alt":"cloud-download-alt","tmcore-icon-comment":"comment","tmcore-icon-comments":"comments","tmcore-icon-contact":"contact","tmcore-icon-credit-card":"credit-card","tmcore-icon-dot-circle":"dot-circle","tmcore-icon-edit":"edit","tmcore-icon-envelope":"envelope","tmcore-icon-expand-alt":"expand-alt","tmcore-icon-external-link-alt":"external-link-alt","tmcore-icon-eye":"eye","tmcore-icon-file-alt":"file-alt","tmcore-icon-file-archive":"file-archive","tmcore-icon-filter":"filter","tmcore-icon-folder-open":"folder-open","tmcore-icon-folder":"folder","tmcore-icon-free_ship":"free_ship","tmcore-icon-frown":"frown","tmcore-icon-gift":"gift","tmcore-icon-grip-horizontal":"grip-horizontal","tmcore-icon-heart-fill":"heart-fill","tmcore-icon-heart":"heart","tmcore-icon-history":"history","tmcore-icon-home":"home","tmcore-icon-info-circle":"info-circle","tmcore-icon-instagram":"instagram","tmcore-icon-level-up-alt":"level-up-alt","tmcore-icon-long-arrow-alt-down":"long-arrow-alt-down","tmcore-icon-long-arrow-alt-left":"long-arrow-alt-left","tmcore-icon-long-arrow-alt-right":"long-arrow-alt-right","tmcore-icon-long-arrow-alt-up":"long-arrow-alt-up","tmcore-icon-map-marker-check":"map-marker-check","tmcore-icon-meh":"meh","tmcore-icon-minus-circle":"minus-circle","tmcore-icon-mobile-android-alt":"mobile-android-alt","tmcore-icon-money-bill":"money-bill","tmcore-icon-pencil-alt":"pencil-alt","tmcore-icon-plus-circle":"plus-circle","tmcore-icon-plus":"plus","tmcore-icon-quote":"quote","tmcore-icon-quote-left":"quote-left","tmcore-icon-quote-right":"quote-right","tmcore-icon-random":"random","tmcore-icon-reply-all":"reply-all","tmcore-icon-reply":"reply","tmcore-icon-search-plus":"search-plus","tmcore-icon-search":"search","tmcore-icon-shield-check":"shield-check","tmcore-icon-shopping-basket":"shopping-basket","tmcore-icon-shopping-cart":"shopping-cart","tmcore-icon-sign-out-alt":"sign-out-alt","tmcore-icon-smile":"smile","tmcore-icon-spinner":"spinner","tmcore-icon-square":"square","tmcore-icon-star":"star","tmcore-icon-store":"store","tmcore-icon-sync":"sync","tmcore-icon-tachometer-alt":"tachometer-alt","tmcore-icon-th-large":"th-large","tmcore-icon-th-list":"th-list","tmcore-icon-thumbtack":"thumbtack","tmcore-icon-times-circle":"times-circle","tmcore-icon-times":"times","tmcore-icon-trophy-alt":"trophy-alt","tmcore-icon-truck":"truck","tmcore-icon-user-headset":"user-headset","tmcore-icon-user-shield":"user-shield","tmcore-icon-user":"user","tmcore-icon-headphones-alt":"headphones-alt","tmcore-icon-map-marker-alt":"map-marker-alt","tmcore-icon-mitten":"mitten","tmcore-icon-paw-alt":"paw-alt","tmcore-icon-payment_1":"payment_1","tmcore-icon-payment_2":"payment_2","tmcore-icon-payment_3":"payment_3","tmcore-icon-payment_4":"payment_4","tmcore-icon-payment_5":"payment_5","tmcore-icon-payment_6":"payment_6","tmcore-icon-phone-rotary":"phone-rotary","tmcore-icon-rings-wedding":"rings-wedding","tmcore-icon-rocket":"rocket","tmcore-icon-shapes":"shapes","tmcore-icon-tire":"tire","tmcore-icon-tracking_1":"tracking_1","tmcore-icon-tracking_2":"tracking_2","tmcore-icon-tracking_3":"tracking_3","tmcore-icon-tshirt":"tshirt","tmcore-icon-tv":"tv","tmcore-icon-volleyball-ball":"volleyball-ball"}', true );
			$icons     = $manager->get_control( 'icon' )->get_settings( 'options' );
			$new_icons = array_merge(
				$new_icons,
				$icons
			);
			// Then we set a new list of icons as the options of the icon control
			$manager->get_control( 'icon' )->set_settings( 'options', $new_icons ); 
        }

		public function add_icons_native( $tabs ) {
			
			$tabs['opal-custom'] = [
				'name'          => 'tmcore-icon',
				'label'         => esc_html__( 'TM Icon', 'templatemela-core' ),
				'prefix'        => 'tmcore-icon-',
				'displayPrefix' => 'tmcore-icon-',
				'labelIcon'     => 'fab fa-font-awesome-alt',
				'ver'           => TMCORE_VERSION,
				'fetchJson'     => TMCORE_URL . '/includes/elementor/icons.json',
				'native'        => true,
			];

			return $tabs;
		}
	}

endif;

return new TemplateMelaCore_Elementor();
