<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * The main plugin class.
 *
 * @since 1.0.0
 * @package TemplateMela Core
 */

/**
 * The main templatemela-core class.
 */
class TemplateMelaCore_Popup {

	/**
	* Plugin version, used for cache-busting of style and script file references.
	*
	* @since   1.0.0
	* @var  string
	*/
	const VERSION = TMCORE_VERSION;

	/**
	 * Instance of the class.
	 *
	 * @static
	 * @access protected
	 * @since 1.0.0
	 * @var object
	 */
	protected static $instance = null;

	/**
	 * This is if it's a multisite.
	 *
	 * @var bool
	 */
	public static $multisite = false;

	/**
	 * Initialize the plugin by setting localization and loading public scripts
	 * and styles.
	 *
	 * @access private
	 * @since 1.0.0
	 */
	private function __construct() {

		if ( is_multisite() ) {
			$show_local_activation = apply_filters( 'base_activation_individual_multisites', false );
			if ( $show_local_activation ) {
				self::$multisite = false;
			} else {
				self::$multisite = true;
			}
		}

		// Hook welcome popup.
		add_action( 'base_after_wrapper', array( $this, 'load_welcome_popup' ) );
		
		// Hook exit intent popup.
		add_action( 'base_after_wrapper', array( $this, 'load_exit_popup' ) );
		
		// Hook cookie popup.
		add_action( 'base_after_wrapper', array( $this, 'load_cookie_popup' ) );
		
		// Hook trust notifications.
		add_action('base_after_wrapper', array( $this, 'load_notification_popup' ) );
	}

	/**
	 * Return an instance of this class.
	 *
	 * @static
	 * @access public
	 * @since 1.0.0
	 * @return object  A single instance of the class.
	 */
	public static function get_instance() {

		// If the single instance hasn't been set yet, set it now.
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;

	}

	/**
	 * Register welcome popup settings
	 */
	public static function load_welcome_popup() {

		// Return if preview single element		
		if ( is_singular( 'base_element' ) ) {
			return;
		}

		$shopkit_settings = get_option( 'bt_woo_extras' );
		if ( ! is_array( $shopkit_settings ) ) {
			$shopkit_settings = json_decode( $shopkit_settings, true );
		}

		$isActive = isset( $shopkit_settings['welcome_popup'] ) ? $shopkit_settings['welcome_popup'] : false;
		$popup_content = isset( $shopkit_settings['welcome_popup_content'] ) ? $shopkit_settings['welcome_popup_content'] : '' ;
		if( !empty( $popup_content ) && !empty($isActive ) ) {

			$delay = isset( $shopkit_settings['welcome_popup_delay'] ) ? $shopkit_settings['welcome_popup_delay'] : '5';
			$repeat = isset( $shopkit_settings['welcome_popup_repeat'] ) ? $shopkit_settings['welcome_popup_repeat'] : '3';
			$daysExpire = isset( $shopkit_settings['welcome_popup_expire'] ) ? $shopkit_settings['welcome_popup_expire'] : '2';
			$dismiss = isset( $shopkit_settings['welcome_popup_dismiss'] ) ? $shopkit_settings['welcome_popup_dismiss'] : esc_html__( "Don't show this popup again", 'templatemela-core' );

			echo '<div id="welcome-popup" class="popup-drawer welcome-popup" data-delay="'.$delay.'" data-repeat="'.$repeat.'" data-expire="'.$daysExpire.'" data-drawer-target-string="#welcome-popup">
				<div class="drawer-overlay" data-drawer-target-string="#welcome-popup"></div>
				<div class="drawer-inner">
					<div class="drawer-header">
						<button class="popup-toggle-close drawer-toggle" aria-label="Close Popup" data-toggle-target="#welcome-popup" data-toggle-body-class="showing-popup-drawer-from-center" aria-expanded="false">
							<span class="base-svg-iconset"><svg class="base-svg-icon base-close-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><title>Toggle Menu Close</title><path d="M5.293 6.707l5.293 5.293-5.293 5.293c-0.391 0.391-0.391 1.024 0 1.414s1.024 0.391 1.414 0l5.293-5.293 5.293 5.293c0.391 0.391 1.024 0.391 1.414 0s0.391-1.024 0-1.414l-5.293-5.293 5.293-5.293c0.391-0.391 0.391-1.024 0-1.414s-1.024-0.391-1.414 0l-5.293 5.293-5.293-5.293c-0.391-0.391-1.024-0.391-1.414 0s-0.391 1.024 0 1.414z"></path>
						</svg></span></button>
					</div>
					<div class="drawer-content">
						<div class="popup-container">'. do_shortcode($popup_content) .'</div>
					</div>
				</div>
			</div>';			
		}

		
	}


	/**
	 * Register exit popup settings
	 */
	public static function load_exit_popup() {

		// Return if preview single element		
		if ( is_singular( 'base_element' ) ) {
			return;
		}

		$shopkit_settings = get_option( 'bt_woo_extras' );
		if ( ! is_array( $shopkit_settings ) ) {
			$shopkit_settings = json_decode( $shopkit_settings, true );
		}

		$isActive = isset( $shopkit_settings['exit_popup'] ) ? $shopkit_settings['exit_popup'] : false;
		$popup_content = isset( $shopkit_settings['exit_popup_content'] ) ? $shopkit_settings['exit_popup_content'] : '' ;
		if( !empty( $popup_content ) && !empty($isActive ) ) {

			$delay = isset( $shopkit_settings['exit_popup_delay'] ) ? $shopkit_settings['exit_popup_delay'] : '7';
			$repeat = isset( $shopkit_settings['exit_popup_repeat'] ) ? $shopkit_settings['exit_popup_repeat'] : '3';
			$daysExpire = isset( $shopkit_settings['exit_popup_expire'] ) ? $shopkit_settings['exit_popup_expire'] : '1';
			$dismiss = isset( $shopkit_settings['exit_popup_dismiss'] ) ? $shopkit_settings['exit_popup_dismiss'] : esc_html__( "Don't show this popup again", 'templatemela-core' ) ;

			echo '<div id="exit-popup" class="popup-drawer exit-popup" data-delay="'.$delay.'" data-repeat="'.$repeat.'" data-expire="'.$daysExpire.'" data-drawer-target-string="#exit-popup">
				<div class="drawer-overlay" data-drawer-target-string="#exit-popup"></div>
				<div class="drawer-inner">
					<div class="drawer-header">
						<button class="popup-toggle-close drawer-toggle" aria-label="Close Popup" data-toggle-target="#exit-popup" data-toggle-body-class="showing-popup-drawer-from-center" aria-expanded="false">
							<span class="base-svg-iconset"><svg class="base-svg-icon base-close-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><title>Toggle Menu Close</title><path d="M5.293 6.707l5.293 5.293-5.293 5.293c-0.391 0.391-0.391 1.024 0 1.414s1.024 0.391 1.414 0l5.293-5.293 5.293 5.293c0.391 0.391 1.024 0.391 1.414 0s0.391-1.024 0-1.414l-5.293-5.293 5.293-5.293c0.391-0.391 0.391-1.024 0-1.414s-1.024-0.391-1.414 0l-5.293 5.293-5.293-5.293c-0.391-0.391-1.024-0.391-1.414 0s-0.391 1.024 0 1.414z"></path>
						</svg></span></button>
					</div>
					<div class="drawer-content">
						<div class="popup-container">' . do_shortcode($popup_content) . '</div>
					</div>
				</div>
			</div>';

						/* <div class="model-dismiss">
							<input id="exit_dismiss_show" type="checkbox" name="dismiss_show" autocomplete="off">
							<label for="exit_dismiss_show">
								<span>'.$dismiss.'</span>
							</label>
						</div> */
		}
	}


	/**
	 * Register cookie popup settings
	 */
	public static function load_cookie_popup() {

		// Return if preview single element		
		if ( is_singular( 'base_element' ) ) {
			return;
		}

		$shopkit_settings = get_option( 'bt_woo_extras' );
		if ( ! is_array( $shopkit_settings ) ) {
			$shopkit_settings = json_decode( $shopkit_settings, true );
		}

		$isActive = isset( $shopkit_settings['cookie_popup'] ) ? $shopkit_settings['cookie_popup'] : false;
		$popup_content = isset( $shopkit_settings['cookie_popup_content'] ) ? $shopkit_settings['cookie_popup_content'] : '' ;
		if( !empty( $popup_content ) && !empty($isActive ) ) {

			$delay = isset( $shopkit_settings['cookie_popup_delay'] ) ? $shopkit_settings['cookie_popup_delay'] : '1';
			$repeat = isset( $shopkit_settings['cookie_popup_repeat'] ) ? $shopkit_settings['cookie_popup_repeat'] : '1000';
			$daysExpire = isset( $shopkit_settings['cookie_popup_expire'] ) ? $shopkit_settings['cookie_popup_expire'] : '30';
			$position = isset( $shopkit_settings['cookie_popup_position'] ) ? $shopkit_settings['cookie_popup_position'] : 'float_right';
			$buttonText = isset( $shopkit_settings['cookie_popup_button'] ) ? $shopkit_settings['cookie_popup_button'] : 'Accept Cookies';
			
			echo '<div id="cookie-popup" class="popup-drawer cookie-popup" data-delay="'.$delay.'" data-repeat="'.$repeat.'" data-expire="'.$daysExpire.'" data-drawer-target-string="#cookie-popup">
				<div class="drawer-inner '.$position.'">
					<div class="drawer-content">
						<div class="popup-container">' . do_shortcode($popup_content) . '</div>
						<button class="popup-toggle-close drawer-toggle" aria-label="'.$buttonText.'" data-toggle-target="#cookie-popup" aria-expanded="false">'.$buttonText.'</button>
					</div>
				</div>
			</div>';
		}
	}

	public static function load_notification_popup() {

		// Return if preview single element		
		if ( is_singular( 'base_element' ) ) {
			return;
		}

		$shopkit_settings = get_option( 'bt_woo_extras' );
		if ( ! is_array( $shopkit_settings ) ) {
			$shopkit_settings = json_decode( $shopkit_settings, true );
		}

		$isActive = isset( $shopkit_settings['notification_popup'] ) ? $shopkit_settings['notification_popup'] : false;
		if( !empty($isActive ) ) {
        ?>
        <script type="text/template" id="tmc-notification-tml">
                <a href="javascript:void(0);" class="tmc-noti-close close-noti" rel="nofollow">
					<span class="base-svg-iconset">
						<svg class="base-svg-icon base-close-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><title>Toggle Menu Close</title><path d="M5.293 6.707l5.293 5.293-5.293 5.293c-0.391 0.391-0.391 1.024 0 1.414s1.024 0.391 1.414 0l5.293-5.293 5.293 5.293c0.391 0.391 1.024 0.391 1.414 0s0.391-1.024 0-1.414l-5.293-5.293 5.293-5.293c0.391-0.391 0.391-1.024 0-1.414s-1.024-0.391-1.414 0l-5.293 5.293-5.293-5.293c-0.391-0.391-1.024-0.391-1.414 0s-0.391 1.024 0 1.414z"></path></svg>
					</span>
                </a>
                <div class="noti-wrap">
                    <div class="product-image">
						<a data-url="{{product_url}}" href="{{product_url}}">
						{{product_image}}
                        </a>
					</div>
                    <div class="noti-details">
                        <div class="noti-title">
                            <span data-user="{{product_info}}" class="user-purchase">{{product_info}}</span>
                        </div>
                        <div class="product-title">
                        	<a data-url="{{product_url}}" data-title="{{product_name}}" href="{{product_url}}" target="_blank">{{product_name}}</a>
                        </div>
                        <div class="noti-bottom">
                            <div class="minutes-ago">
								<span>{{time_purchase}}</span>
                            </div>
                            <span class="text-verify">
                            <svg width="12" height="11" viewBox="0 0 12 11" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M10.5 5.03906V5.49609C10.5 6.12109 10.3828 6.70703 10.1484 7.25391C9.91406 7.80078 9.58984 8.27734 9.17578 8.68359C8.76953 9.08984 8.29297 9.41016 7.74609 9.64453C7.19922 9.87891 6.61719 9.99609 6 9.99609C5.375 9.99609 4.78906 9.87891 4.24219 9.64453C3.69531 9.41016 3.21875 9.08594 2.8125 8.67188C2.40625 8.26562 2.08594 7.78906 1.85156 7.24219C1.61719 6.69531 1.5 6.11328 1.5 5.49609C1.5 4.87109 1.61719 4.28906 1.85156 3.75C2.08594 3.20313 2.41016 2.72266 2.82422 2.30859C3.23047 1.90234 3.70703 1.58203 4.25391 1.34766C4.80078 1.11328 5.38281 0.996094 6 0.996094C6.33594 0.996094 6.65625 1.03125 6.96094 1.10156C7.27344 1.17188 7.5625 1.26562 7.82812 1.38281C7.95312 1.44531 8.07812 1.45312 8.20312 1.40625C8.33594 1.35156 8.42969 1.26172 8.48438 1.13672C8.54688 1.01172 8.55078 0.886719 8.49609 0.761719C8.44922 0.628906 8.36328 0.535156 8.23828 0.480469C7.91016 0.324219 7.55469 0.207031 7.17188 0.128906C6.79688 0.0429687 6.40625 0 6 0C5.625 0 5.25781 0.0351562 4.89844 0.105469C4.53906 0.183594 4.19141 0.292969 3.85547 0.433594C3.52734 0.566406 3.21875 0.734375 2.92969 0.9375C2.63281 1.13281 2.35938 1.35547 2.10938 1.60547C1.85938 1.85547 1.63672 2.125 1.44141 2.41406C1.24609 2.71094 1.07812 3.02344 0.9375 3.35156C0.796875 3.67969 0.6875 4.02344 0.609375 4.38281C0.539062 4.74219 0.503906 5.11328 0.503906 5.49609C0.503906 5.87109 0.539062 6.23828 0.609375 6.59766C0.6875 6.95703 0.792969 7.30469 0.925781 7.64062C1.06641 7.96875 1.23828 8.27734 1.44141 8.56641C1.63672 8.86328 1.85938 9.13672 2.10938 9.38672C2.35938 9.63672 2.62891 9.85938 2.91797 10.0547C3.21484 10.2578 3.52734 10.4258 3.85547 10.5586C4.18359 10.6992 4.52734 10.8086 4.88672 10.8867C5.24609 10.957 5.61719 10.9922 6 10.9922C6.375 10.9922 6.74219 10.957 7.10156 10.8867C7.46094 10.8086 7.80469 10.6992 8.13281 10.5586C8.46875 10.4258 8.78125 10.2578 9.07031 10.0547C9.36719 9.85938 9.64062 9.63672 9.89062 9.38672C10.1406 9.13672 10.3633 8.86719 10.5586 8.57812C10.7539 8.28125 10.9219 7.96875 11.0625 7.64062C11.2031 7.3125 11.3125 6.96875 11.3906 6.60938C11.4609 6.25 11.4961 5.87891 11.4961 5.49609V5.03906C11.4961 4.89844 11.4453 4.78125 11.3438 4.6875C11.25 4.58594 11.1367 4.53516 11.0039 4.53516C10.8633 4.53516 10.7422 4.58594 10.6406 4.6875C10.5469 4.78125 10.5 4.89844 10.5 5.03906ZM10.6523 1.14844L6 5.80078L4.85156 4.65234C4.75781 4.55078 4.64062 4.5 4.5 4.5C4.35938 4.5 4.24219 4.55078 4.14844 4.65234C4.04688 4.74609 3.99609 4.86328 3.99609 5.00391C3.99609 5.14453 4.04688 5.26172 4.14844 5.35547L5.64844 6.85547C5.74219 6.95703 5.85938 7.00781 6 7.00781C6.14062 7.00781 6.25781 6.95703 6.35156 6.85547L11.3555 1.85156C11.4492 1.75781 11.4961 1.64062 11.4961 1.5C11.4961 1.35938 11.4492 1.24219 11.3555 1.14844C11.2539 1.04688 11.1328 0.996094 10.9922 0.996094C10.8594 0.996094 10.7461 1.04688 10.6523 1.14844Z" fill="#111111"></path>
                            </svg>
                            <?php echo esc_html__('Verified', 'templatemela-core'); ?>
							</span>
                        </div>
                    </div>
                    <div class="tmc-time-countdown"><span data-progressbar="" style=""></span></div>
                </div>
        </script>
		<?php
		}
    }

}

TemplateMelaCore_Popup::get_instance();