/* global baseProWooConfig */
/**
 * File Shop-init.js.
 * Gets Shop toggle working.
 */

(function() {
	'use strict';
	window.baseProWoo = {
		/**
		 * Find the cart and open it.
		 */
		triggerCart: function() {
			var drawerCartToggle = document.querySelector('*[data-toggle-target="#cart-drawer"]' );
			// No point if no drawers.
			if ( ! drawerCartToggle ) {
				return;
			}
			// Initiate toggle.
			if (typeof window?.base?.toggleDrawer === "function") {
			window.base.toggleDrawer( drawerCartToggle );
			} else {
				var initLoadDelay = setInterval(function () {
					if (typeof window?.base?.toggleDrawer === "function") {
						window.base.toggleDrawer( drawerCartToggle );
						clearInterval(initLoadDelay);
					} else {
						console.log("No navigation toggle found");
					}
				}, 200);
			}
		},
		/**
		 * Initiate the script to toggle cart when product is added.
		 */
		initCartToggle: function() {
			jQuery( document.body ).on( 'added_to_cart', function() {
				window.baseProWoo.triggerCart();
			} );
			if ( baseProWooConfig.openCart ) {
				window.baseProWoo.triggerCart();
			}
		},
		// Initiate the menus when the DOM loads.
		init: function() {
			window.baseProWoo.initCartToggle();
		}
	}
	if ( 'loading' === document.readyState ) {
		// The DOM has not yet been loaded.
		document.addEventListener( 'DOMContentLoaded', window.baseProWoo.init );
	} else {
		// The DOM has already been loaded.
		window.baseProWoo.init();
	}
})();
