<?php
/**
 * Class for the Customizer
 *
 * @package Base
 */

namespace BasePro;

use WP_Query;
use function Base\webapp;
use function Base\get_related_posts_args;
use function wp_make_link_relative;

/**
 * Filter the archive attributes.
 *
 * @param string $attributes archive infinite attributes.
 */
function infinite_posts( $attributes = '' ) {
	global $wp_query;
	if ( $wp_query->max_num_pages > 1 ) {
		if ( ( webapp()->option( 'infinite_posts' ) && ! is_search() && 'post' === get_post_type() ) || ( webapp()->option( 'infinite_search' ) && is_search() && ! is_post_type_archive( 'product' ) ) || ( webapp()->option( 'infinite_custom' ) && ! is_search() && 'post' !== get_post_type() ) ) {
			wp_enqueue_script( 'base-infinite-scroll' );
			wp_enqueue_script( 'base-infinite-scroll-events' );
			$attributes = '{ "path": ".next.page-numbers", "append": "#archive-container .entry", "hideNav": ".pagination", "status": ".page-load-status" }';
		}
	}
	return $attributes;
}
add_filter( 'base_archive_infinite_attributes', 'BasePro\infinite_posts', 5 );

/**
 * Filter the archive attributes.
 *
 * @param string $attributes archive infinite attributes.
 */
function infinite_scroll_products( $attributes = '' ) {
	global $wp_query;
	if ( $wp_query->max_num_pages > 1 ) {
		if ( webapp()->option( 'infinite_products' ) ) {
			wp_enqueue_script( 'base-infinite-scroll' );
			wp_enqueue_script( 'base-infinite-scroll-events' );
			if (  'load-more' == webapp()->option( 'infinite_pagination_type' ) ) {
				$attributes = '{ "path": ".next.page-numbers", "append": ".woo-archive-loop .entry", "hideNav": ".woocommerce-pagination", "status": ".page-load-status", "scrollThreshold": "false", "button": ".load-more-button" }';
			} else {
			$attributes = '{ "path": ".next.page-numbers", "append": ".woo-archive-loop .entry", "hideNav": ".woocommerce-pagination", "status": ".page-load-status" }';
		}
	}
	}
	return $attributes;
}
add_filter( 'base_product_archive_infinite_attributes', 'BasePro\infinite_scroll_products', 5 );

/**
 * Output after archive loop.
 */
function infinite_scroll_html() {
	if ( ( webapp()->option( 'infinite_posts' ) && ! is_search() && 'post' === get_post_type() ) || ( webapp()->option( 'infinite_search' ) && is_search() && ! is_post_type_archive( 'product' ) ) || ( webapp()->option( 'infinite_custom' ) && ! is_search() && 'post' !== get_post_type() ) ) {
		echo '<style>.bt-loader-ellips{font-size:20px;position:relative;width:4em;height:1em;margin:10px auto}.bt-loader-ellips__dot{display:block;width:0.7em;height:0.7em;border-radius:.5em;background: var(--global-palette6);position:absolute;animation-duration:.5s;animation-timing-function:ease;animation-iteration-count:infinite}.bt-loader-ellips__dot:nth-child(1),.bt-loader-ellips__dot:nth-child(2){left:0}.bt-loader-ellips__dot:nth-child(3){left:1.5em}.bt-loader-ellips__dot:nth-child(4){left:3em}@keyframes loaderReveal{from{transform:scale(.001)}to{transform:scale(1)}}@keyframes loaderSlide{to{transform:translateX(1.5em)}}.bt-loader-ellips__dot:nth-child(1){animation-name:loaderReveal}.bt-loader-ellips__dot:nth-child(2),.bt-loader-ellips__dot:nth-child(3){animation-name:loaderSlide}.bt-loader-ellips__dot:nth-child(4){animation-name:loaderReveal;animation-direction:reverse}.page-load-status {display: none;padding-top: 20px;text-align: center;color: var(--global-palette4);}</style>';
		echo '<div class="page-load-status"><div class="bt-loader-ellips infinite-scroll-request"><span class="bt-loader-ellips__dot"></span><span class="bt-loader-ellips__dot"></span><span class="bt-loader-ellips__dot"></span><span class="bt-loader-ellips__dot"></span></div><p class="infinite-scroll-last">' . esc_html( webapp()->option( 'infinite_end_of_content' ) ) . '</p><p class="infinite-scroll-error">' . esc_html( webapp()->option( 'infinite_end_of_content' ) ) . '</p></div>';
	}
}
add_action( 'get_template_part_template-parts/content/pagination', 'BasePro\infinite_scroll_html', 50 );

/**
 * Output after archive loop.
 */
function infinite_scroll_product_html() {

	$html = '';
	$tm_settings = get_option( 'bt_woo_extras' );
	if ( ! is_array( $tm_settings ) ) {
		$tm_settings = json_decode( $tm_settings, true );
	}

	if ( isset( $tm_settings['skeleton_shimmer'] ) && $tm_settings['skeleton_shimmer'] ) {
	
		$columns = absint( wc_get_loop_prop( 'columns' ) );
		$columns_class = 'content-wrap product-archive grid-cols grid-ss-col-2 grid-sm-col-3 grid-lg-col-4';
		$loop = 6;
		if ( 1 === $columns ) {
			if ( is_main_query() && is_archive() && ! wc_get_loop_prop( 'is_shortcode' ) ) {
				$columns_class = 'content-wrap product-archive grid-cols grid-sm-col-1 grid-lg-col-1 products-list-view';
			} else {
				$columns_class = 'content-wrap product-archive grid-cols grid-sm-col-1 grid-lg-col-1';
			}
			$loop = 3;
		} elseif ( 2 === $columns ) {
			$columns_class = 'content-wrap product-archive grid-cols grid-sm-col-2 grid-lg-col-2';
			$loop = 6;
		} elseif ( 3 === $columns ) {
			$columns_class = 'content-wrap product-archive grid-cols grid-sm-col-2 grid-lg-col-3';
			$loop = 6;
		} elseif ( 4 === $columns ) {
			$columns_class = 'content-wrap product-archive grid-cols grid-ss-col-2 grid-sm-col-3 grid-lg-col-4';
			$loop = 8;
		} elseif ( 5 === $columns ) {
			$columns_class = 'content-wrap product-archive grid-cols grid-ss-col-2 grid-sm-col-3 grid-md-col-4 grid-lg-col-5';
			$loop = 10;
		} elseif ( 6 === $columns ) {
			$columns_class = 'content-wrap product-archive grid-cols grid-ss-col-2 grid-sm-col-3 grid-md-col-4 grid-lg-col-6';
			$loop = 12;
		}

		$html = '<ul class="products ajax-load '. $columns_class .'">';
		for ($x = 1; $x <= $loop; $x++) {
			$html .= '<li class="shimmer entry content-bg loop-entry product"><div class="product-thumbnail"><image width="300" height="300"/></div></li>';
		}
		$html .= '</ul>';

	}

	if ( webapp()->option( 'infinite_products' ) ) {
		echo '<style>.bt-loader-ellips{font-size:20px;position:relative;width:4em;height:1em;margin:10px auto}.bt-loader-ellips__dot{display:block;width:0.7em;height:0.7em;border-radius:.5em;background: var(--global-palette6);position:absolute;animation-duration:.5s;animation-timing-function:ease;animation-iteration-count:infinite}.bt-loader-ellips__dot:nth-child(1),.bt-loader-ellips__dot:nth-child(2){left:0}.bt-loader-ellips__dot:nth-child(3){left:1.5em}.bt-loader-ellips__dot:nth-child(4){left:3em}@keyframes loaderReveal{from{transform:scale(.001)}to{transform:scale(1)}}@keyframes loaderSlide{to{transform:translateX(1.5em)}}.bt-loader-ellips__dot:nth-child(1){animation-name:loaderReveal}.bt-loader-ellips__dot:nth-child(2),.bt-loader-ellips__dot:nth-child(3){animation-name:loaderSlide}.bt-loader-ellips__dot:nth-child(4){animation-name:loaderReveal;animation-direction:reverse}.page-load-status {display: none;padding-top: 20px;text-align: center;color: var(--global-palette4);}</style>';
		echo '<div class="page-load-status">'.$html.'<div class="bt-loader-ellips infinite-scroll-request"><span class="bt-loader-ellips__dot"></span><span class="bt-loader-ellips__dot"></span><span class="bt-loader-ellips__dot"></span><span class="bt-loader-ellips__dot"></span></div><p class="infinite-scroll-last">' . esc_html( webapp()->option( 'infinite_end_of_content' ) ) . '</p><p class="infinite-scroll-error">' . esc_html( webapp()->option( 'infinite_end_of_content' ) ) . '</p></div>';
	}
}
add_action( 'woocommerce_after_shop_loop', 'BasePro\infinite_scroll_product_html', 3 );

/**
 * Setup infinite scroll for single posts.
 */
function infinite_single_posts() {
	if ( is_single() ) {
		if ( ( webapp()->option( 'infinite_single_posts' ) && 'post' === get_post_type() ) ) {
			global $post;
			//error_log( $post->ID );
			$args  = get_related_posts_args( $post->ID );
			$slugs = array();
			$infp   = new WP_Query( apply_filters( 'base_related_posts_infinite_args', $args ) );
			if ( $infp ) :
				$num = $infp->post_count;
				if ( $num > 0 ) {
					while ( $infp->have_posts() ) :
						$infp->the_post();
						$slugs[] = wp_make_link_relative( get_permalink() );
					endwhile;
				}
			endif;
			wp_reset_postdata();
			wp_localize_script(
				'base-single-infinite-scroll',
				'baseProInfiniteConfig',
				array(
					'slugs'  => $slugs,
				)
			);
			wp_enqueue_script( 'base-single-infinite-scroll' );
		}
	}
}
//add_action( 'base_single', 'BasePro\infinite_single_posts', 100 );
