/*global base_elements_params */
;(function ( $, window ) {
	$( '.base-status-toggle' ).on( 'click', function( event ) {
		event.preventDefault();
		var $button = $( this );
		$button.find( '.spinner' ).addClass( 'is-active' );
		$.ajax( {
			type: 'POST',
			url: base_elements_params.ajax_url,
			data: {
				action           : 'base_elements_change_status',
				post_id          : $button.data( 'post-id' ),
				post_status      : $button.data( 'post-status' ),
				security         : base_elements_params.ajax_nonce
			},
			dataType: 'json',
			success: function( response ) {
				$button.find( '.spinner' ).removeClass('is-active');
				if ( response && response.success ) {
					if ( 'publish' === $button.data( 'post-status' ) ) {
						$button.removeClass( 'base-status-publish' );
						$button.addClass( 'base-status-draft' );
						$button.data( 'post-status', 'draft' );
						$button.find( '.base-status-label' ).html( base_elements_params.draft );
					} else {
						$button.removeClass( 'base-status-draft' );
						$button.addClass( 'base-status-publish' );
						$button.data( 'post-status', 'publish' );
						$button.find( '.base-status-label' ).html( base_elements_params.publish );
					}
					$button.closest( 'tr.type-base_element' ).find( '.column-title .post-state' ).hide();
				} else {
					alert( 'Failed to change post status, please reload and try again' );
					window.console.log( response );
				}
			}
		} ).fail( function( response ) {
			$button.find( '.spinner' ).removeClass('is-active');
			alert( 'Failed to change post status, please reload and try again' );
			window.console.log( response );
		} );
	} );

})( jQuery, window );
