<?php
/**
 * Template part for displaying the Footer color switch
 *
 * @package Base Pro
 */

namespace BasePro;

use function Base\webapp;
$align        = ( webapp()->sub_option( 'footer_dark_mode_align', 'desktop' ) ? webapp()->sub_option( 'footer_dark_mode_align', 'desktop' ) : 'default' );
$tablet_align = ( webapp()->sub_option( 'footer_dark_mode_align', 'tablet' ) ? webapp()->sub_option( 'footer_dark_mode_align', 'tablet' ) : 'default' );
$mobile_align = ( webapp()->sub_option( 'footer_dark_mode_align', 'mobile' ) ? webapp()->sub_option( 'footer_dark_mode_align', 'mobile' ) : 'default' );

$valign        = ( webapp()->sub_option( 'footer_dark_mode_vertical_align', 'desktop' ) ? webapp()->sub_option( 'footer_dark_mode_vertical_align', 'desktop' ) : 'default' );
$tablet_valign = ( webapp()->sub_option( 'footer_dark_mode_vertical_align', 'tablet' ) ? webapp()->sub_option( 'footer_dark_mode_vertical_align', 'tablet' ) : 'default' );
$mobile_valign = ( webapp()->sub_option( 'footer_dark_mode_vertical_align', 'mobile' ) ? webapp()->sub_option( 'footer_dark_mode_vertical_align', 'mobile' ) : 'default' );
?>
<div class="footer-widget-area widget-area site-footer-focus-item footer-dark-mode content-align-<?php echo esc_attr( $align ); ?> content-tablet-align-<?php echo esc_attr( $tablet_align ); ?> content-mobile-align-<?php echo esc_attr( $mobile_align ); ?> content-valign-<?php echo esc_attr( $valign ); ?> content-tablet-valign-<?php echo esc_attr( $tablet_valign ); ?> content-mobile-valign-<?php echo esc_attr( $mobile_valign ); ?>" data-section="base_customizer_footer_dark_mode">
	<div class="footer-widget-area-inner footer-dark-mode-inner">
		<?php
		/**
		 * Base Footer Color Switcher
		 *
		 * Hooked BasePro\footer_color_switcher
		 */
		do_action( 'base_footer_dark_mode' );
		?>
	</div>
</div><!-- data-section="footer_dark_mode" -->
