<?php
/**
 * Class for the Customizer
 *
 * @package Base
 */

namespace TemplateMela;

use function Base\webapp;

/**
 * Desktop Navigation
 */
function vertical_navigation() {
	?>
	<nav id="vertical-navigation" class="vertical-navigation header-navigation nav--toggle-sub header-navigation-style-<?php echo esc_attr( webapp()->option( 'vertical_navigation_style' ) ); ?> header-navigation-dropdown-animation-<?php echo esc_attr( webapp()->option( 'dropdown_navigation_reveal' ) ); ?>" aria-label="<?php esc_attr_e( 'Menu', 'templatemela-core' ); ?>">
		<?php if ( is_customize_preview() ) { ?>
			<div class="customize-partial-edit-shortcut base-custom-partial-edit-shortcut">
				<button aria-label="<?php esc_attr_e( 'Click to edit this element.', 'templatemela-core' ); ?>" title="<?php esc_attr_e( 'Click to edit this element.', 'templatemela-core' ); ?>" class="customize-partial-edit-shortcut-button item-customizer-focus"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M13.89 3.39l2.71 2.72c.46.46.42 1.24.03 1.64l-8.01 8.02-5.56 1.16 1.16-5.58s7.6-7.63 7.99-8.03c.39-.39 1.22-.39 1.68.07zm-2.73 2.79l-5.59 5.61 1.11 1.11 5.54-5.65zm-2.97 8.23l5.58-5.6-1.07-1.08-5.59 5.6z"></path></svg></button>
			</div>
		<?php } ?>
		<div class="vertical-navigation-header">
			<?php webapp()->print_icon( 'menu', '', false ); ?>
			<span class="vertical-navigation-title">
				<?php
					if ( has_nav_menu( 'vertical' ) ) {
					$string = get_term(get_nav_menu_locations()['vertical'], 'nav_menu')->name;
					echo esc_html($string);
					}
				?>
			</span>
		</div>
		<div class="vertical-menu-container header-menu-container" id="vertical-menu-container">
			<?php
			if ( has_nav_menu( 'vertical' ) ) {
				$args = array(
					'container' => 'ul',
					'theme_location' => 'vertical',
					'menu_id' => 'vertical-menu',
					'sub_arrows'     => true,
					'mega_support'   => true,
					'addon_support'  => true,
				);
				wp_nav_menu( $args );
			} else {
				webapp()->display_fallback_menu();
			}
			?>
		</div>
	</nav><!-- #vertical-navigation -->
	<?php
}
add_action( 'base_vertical_navigation', 'TemplateMela\vertical_navigation', 10 );


/**
 * Header Search Advanced
 */
function header_search_advanced() {
	echo '<div class="header-search-advanced header-item-search-advanced">';
	if ( is_customize_preview() ) {
		?>
		<div class="customize-partial-edit-shortcut base-custom-partial-edit-shortcut">
			<button aria-label="<?php esc_attr_e( 'Click to edit this element.', 'templatemela-core' ); ?>" title="<?php esc_attr_e( 'Click to edit this element.', 'templatemela-core' ); ?>" class="customize-partial-edit-shortcut-button item-customizer-focus"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"><path d="M13.89 3.39l2.71 2.72c.46.46.42 1.24.03 1.64l-8.01 8.02-5.56 1.16 1.16-5.58s7.6-7.63 7.99-8.03c.39-.39 1.22-.39 1.68.07zm-2.73 2.79l-5.59 5.61 1.11 1.11 5.54-5.65zm-2.97 8.23l5.58-5.6-1.07-1.08-5.59 5.6z"></path></svg></button>
		</div>
		<?php
	}
	if ( class_exists( 'woocommerce' ) && webapp()->option( 'header_search_advanced_woo' ) ) {
		//get_product_search_form();
		?>
		<form role="search" method="get" class="search-form woocommerce-product-search" action="<?php echo esc_url( home_url( '/' ) ); ?>">		
		<?php
			$input_id = wp_rand(1001,5000);
			if ( true == webapp()->option( 'header_search_advanced_categories' ) ) {

				$cat_label = ( ! empty(  webapp()->option( 'header_search_advanced_categories_label') ) ? webapp()->option( 'header_search_advanced_categories_label') : __( 'All Categories', 'templatemela-core' ) );

				$dropdown_args = array(
					'show_option_all' => $cat_label,
					'hierarchical'    => 1,
					'class'           => 'search-select',
					'echo'            => 1,
					'value_field'     => 'slug',
					'selected'        => 1,
					'id'              => 'product_cat_'.wp_rand(1,1000)
				);
				
				//$dropdown_args['parent'] = 0;
				
				// For POSTS
				//$cat_query_var = 'category';

				$dropdown_args['taxonomy'] = 'product_cat';
				$dropdown_args['name']     = 'product_cat';
				$cat_query_var             = 'product_cat';

				$cat_query = get_query_var( $cat_query_var );
				$cat_query = esc_attr( $cat_query );

				if ( ! empty( $cat_query ) ) {
					$dropdown_args['selected'] = $cat_query;
				}
				
				$placeholder = ( ! empty(  webapp()->option( 'header_search_advanced_placeholder') ) ? webapp()->option( 'header_search_advanced_placeholder') : __( 'Search&hellip;', 'templatemela-core' ) );
				
				?>
				<div class="search-category-field">
					<?php wp_dropdown_categories( $dropdown_args ); ?>
				</div>
			
			<?php  } ?>

			<?php $placeholder = ( empty(  $placeholder ) ? __( 'Search&hellip;', 'templatemela-core' ) : $placeholder  ); ?>
			<label class="screen-reader-text"
				for="woocommerce-product-search-field-<?php echo isset( $input_id ) ? absint( $input_id ) : 99; ?>"><?php esc_html_e( 'Search for:', 'templatemela-core' ); ?></label>
			
			<div class="input-container">
				<input type="search" id="woocommerce-product-search-field-<?php echo isset( $input_id ) ? absint( $input_id ) : 99; ?>"
					class="search-field"
					placeholder="<?php echo esc_attr( $placeholder ); ?>"
					value="<?php echo get_search_query(); ?>" name="s" autocomplete="off" />
				<div class="loader-container" style="display:none"><i class="loader"></i></div>
			</div>
			<button type="submit" class="search-submit <?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ); ?>">
					<span class="search-btn-icon"><?php search_advanced_icon(); ?></span>
					<?php
					$label = webapp()->option( 'header_search_advanced_label' );
					if ( ! empty( $label ) || is_customize_preview() ) {
						?>
						<span class="search-btn-text vs-lg-<?php echo ( webapp()->sub_option( 'header_search_advanced_label_visiblity', 'desktop' ) ? 'true' : 'false' ); ?> vs-md-<?php echo ( webapp()->sub_option( 'header_search_advanced_label_visiblity', 'tablet' ) ? 'true' : 'false' ); ?> vs-sm-<?php echo ( webapp()->sub_option( 'header_search_advanced_label_visiblity', 'mobile' ) ? 'true' : 'false' ); ?>"><?php echo esc_html( $label ); ?></span>
						<?php
					}
					?>
			</button>
			<input type="hidden" name="post_type" value="product"/>
		</form>
		<div class="search-results" style="display:none">
			<div class="search-data"  id="datafetch"></div>
		</div>
		<?php
	} else {
		get_search_form();
	}
	echo '</div>';
}

/**
 * Search Advanced Icon
 */
function search_advanced_icon() {
	$icon = webapp()->option( 'header_search_advanced_icon' );
	webapp()->print_icon( $icon, '', false );
}

add_action( 'base_header_search_advanced', 'TemplateMela\header_search_advanced', 10 );



/**
 * Desktop wishlist
 */
function header_wishlist() {

	if ( class_exists( 'woocommerce' ) ) {
		
		$title      = webapp()->option( 'header_wishlist_title' );
		$label      = webapp()->option( 'header_wishlist_label' );
		$show_total = webapp()->option( 'header_wishlist_show_total' );
		
		echo '<div class="header-wishlist-wrap base-header-wishlist">';
		webapp()->customizer_quick_link();
		$wishlist_contents_count = ( class_exists( 'WPCleverWoosw' ) ) ? \WPCleverWoosw::get_count() : 0 ;
		$wishlist_url = ( class_exists( 'WPCleverWoosw' ) ) ? \WPCleverWoosw::get_url() : '#' ;
				
		echo '<span class="header-wishlist-empty-check header-wishlist-is-empty-' . ( $wishlist_contents_count > 0 ? 'false' : 'true' ) . '"></span>';
		echo '<div class="header-wishlist-inner-wrap wishlist-show-label-' . ( ! empty( $label ) ? 'true' : 'false' ) . ' wishlist-style">';
		
			echo '<a href="'. esc_url( $wishlist_url ) .'"' . ( ! empty( $label ) ? '' : ' aria-label="' . esc_attr__( 'Wishlist', 'avanam' ) . '"' ) . ' class="header-wishlist-button">';
			base_woo_extras_print_icon( 'header-wishlist', '', false );
			if ( $show_total ) {
				echo '<span class="header-wishlist-total header-wishlist-is-empty-' . ( $wishlist_contents_count > 0 ? 'false' : 'true' ) . '">' . wp_kses_post( $wishlist_contents_count ) . '</span>';
			}
			if ( ! empty( $title ) || ! empty( $label ) || is_customize_preview() ) { echo '<div class="header-wishlist-content">'; }
			if ( ! empty( $title ) || is_customize_preview() ) {
				?>
				<span class="header-wishlist-title"><?php echo esc_html( $title ); ?></span>
				<?php
			}
			if ( ! empty( $label ) || is_customize_preview() ) {
				?>
				<span class="header-wishlist-label"><?php echo esc_html( $label ); ?></span>
				<?php
			}
			if ( ! empty( $title ) || ! empty( $label ) || is_customize_preview() ) { echo '</div>'; }
			echo '</a>';
		
		echo '</div>';
		echo '</div>';
	}

}
add_action( 'base_header_wishlist', 'TemplateMela\header_wishlist', 10 );