<?php
/**
 * Header Builder Options
 *
 * @package Base
 */

namespace TemplateMela;

use Base\Theme_Customizer;
use function Base\webapp;

Theme_Customizer::add_settings(
	array(
		'vertical_navigation_tabs' => array(
			'control_type' => 'base_tab_control',
			'section'      => 'vertical_navigation',
			'settings'     => false,
			'priority'     => 1,
			'input_attrs'  => array(
				'general' => array(
					'label'  => __( 'General', 'templatemela-core' ),
					'target' => 'vertical_navigation',
				),
				'design' => array(
					'label'  => __( 'Design', 'templatemela-core' ),
					'target' => 'vertical_navigation_design',
				),
				'active' => 'general',
			),
		),
		'vertical_navigation_tabs_design' => array(
			'control_type' => 'base_tab_control',
			'section'      => 'vertical_navigation_design',
			'settings'     => false,
			'priority'     => 1,
			'input_attrs'  => array(
				'general' => array(
					'label'  => __( 'General', 'templatemela-core' ),
					'target' => 'vertical_navigation',
				),
				'design' => array(
					'label'  => __( 'Design', 'templatemela-core' ),
					'target' => 'vertical_navigation_design',
				),
				'active' => 'design',
			),
		),
		'vertical_navigation_link' => array(
			'control_type' => 'base_focus_button_control',
			'section'      => 'vertical_navigation',
			'settings'     => false,
			'priority'     => 5,
			'label'        => esc_html__( 'Select Menu', 'templatemela-core' ),
			'input_attrs'  => array(
				'section' => 'menu_locations',
			),
		),

		'vertical_navigation_opened' => array(
			'control_type' => 'base_switch_control',
			'section'      => 'vertical_navigation',
			'priority'     => 6,
			'default'      => webapp()->default( 'vertical_navigation_opened' ),
			'label'        => esc_html__( 'Keep Opened on Home Page?', 'templatemela-core' ),
			'live_method'     => array(
				array(
					'type'     => 'class',
					'selector' => '.site-header-item-vertical-navigation',
					'pattern'  => 'header-navigation-layout-opened-$',
					'key'      => 'switch',
				),
			),
		),
		
		
		'info_vertical_heading_options' => array(
			'control_type' => 'base_title_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Heading Options', 'templatemela-core' ),
			'settings'     => false,
		),

		'vertical_heading_spacing' => array(
			'control_type' => 'base_range_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Heading Spacing', 'templatemela-core' ),
			'live_method'     => array(
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header',
					'property' => 'padding-left',
					'pattern'  => 'calc($ / 2)',
					'key'      => 'size',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header',
					'property' => 'padding-right',
					'pattern'  => 'calc($ / 2)',
					'key'      => 'size',
				),
			),
			'default'      => webapp()->default( 'vertical_heading_spacing' ),
			'input_attrs'  => array(
				'min'        => array(
					'px'  => 0,
					'em'  => 0,
					'rem' => 0,
					'vw'  => 0,
				),
				'max'        => array(
					'px'  => 100,
					'em'  => 12,
					'rem' => 12,
					'vw'  => 12,
				),
				'step'       => array(
					'px'  => 1,
					'em'  => 0.01,
					'rem' => 0.01,
					'vw'  => 0.01,
				),
				'units'      => array( 'px', 'em', 'rem', 'vw' ),
				'responsive' => false,
			),
		),
		'vertical_heading_vertical_spacing' => array(
			'control_type' => 'base_range_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Top and Bottom Spacing', 'templatemela-core' ),
			'live_method'     => array(
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header',
					'property' => 'padding-top',
					'pattern'  => '$',
					'key'      => 'size',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header',
					'property' => 'padding-bottom',
					'pattern'  => '$',
					'key'      => 'size',
				),
			),
			'default'      => webapp()->default( 'vertical_heading_vertical_spacing' ),
			'input_attrs'  => array(
				'min'        => array(
					'px'  => 0,
					'em'  => 0,
					'rem' => 0,
					'vh'  => 0,
				),
				'max'        => array(
					'px'  => 100,
					'em'  => 12,
					'rem' => 12,
					'vh'  => 12,
				),
				'step'       => array(
					'px'  => 1,
					'em'  => 0.01,
					'rem' => 0.01,
					'vh'  => 0.01,
				),
				'units'      => array( 'px', 'em', 'rem', 'vh' ),
				'responsive' => false,
			),
		),

		'vertical_heading_color' => array(
			'control_type' => 'base_color_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Heading Colors', 'templatemela-core' ),
			'default'      => webapp()->default( 'vertical_heading_color' ),
			'live_method'     => array(
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header',
					'property' => 'color',
					'pattern'  => '$',
					'key'      => 'color',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header:hover',
					'property' => 'color',
					'pattern'  => '$',
					'key'      => 'hover',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header:focus',
					'property' => 'color',
					'pattern'  => '$',
					'key'      => 'active',
				),
			),
			'input_attrs'  => array(
				'colors' => array(
					'color' => array(
						'tooltip' => __( 'Initial Color', 'templatemela-core' ),
						'palette' => true,
					),
					'hover' => array(
						'tooltip' => __( 'Hover Color', 'templatemela-core' ),
						'palette' => true,
					),
					'active' => array(
						'tooltip' => __( 'Active Color', 'templatemela-core' ),
						'palette' => true,
					),
				),
			),
		),
		'vertical_heading_background' => array(
			'control_type' => 'base_color_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Heading Background', 'templatemela-core' ),
			'default'      => webapp()->default( 'vertical_heading_background' ),
			'live_method'     => array(
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header',
					'property' => 'background',
					'pattern'  => '$',
					'key'      => 'color',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header:hover',
					'property' => 'background',
					'pattern'  => '$',
					'key'      => 'hover',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header:focus',
					'property' => 'background',
					'pattern'  => '$',
					'key'      => 'active',
				),
			),
			'input_attrs'  => array(
				'colors' => array(
					'color' => array(
						'tooltip' => __( 'Initial Background', 'templatemela-core' ),
						'palette' => true,
					),
					'hover' => array(
						'tooltip' => __( 'Hover Background', 'templatemela-core' ),
						'palette' => true,
					),
					'active' => array(
						'tooltip' => __( 'Active Background', 'templatemela-core' ),
						'palette' => true,
					),
				),
			),
		),

		'vertical_heading_icon_background' => array(
			'control_type' => 'base_color_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Heading Icon Background', 'templatemela-core' ),
			'default'      => webapp()->default( 'vertical_heading_icon_background' ),
			'live_method'     => array(
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header .base-svg-iconset',
					'property' => 'background',
					'pattern'  => '$',
					'key'      => 'color',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header:hover .base-svg-iconset',
					'property' => 'background',
					'pattern'  => '$',
					'key'      => 'hover',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header:focus .base-svg-iconset',
					'property' => 'background',
					'pattern'  => '$',
					'key'      => 'active',
				),
			),
			'input_attrs'  => array(
				'colors' => array(
					'color' => array(
						'tooltip' => __( 'Initial Background', 'templatemela-core' ),
						'palette' => true,
					),
					'hover' => array(
						'tooltip' => __( 'Hover Background', 'templatemela-core' ),
						'palette' => true,
					),
					'active' => array(
						'tooltip' => __( 'Active Background', 'templatemela-core' ),
						'palette' => true,
					),
				),
			),
		),

		'vertical_heading_icon_color' => array(
			'control_type' => 'base_color_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Heading Icon Colors', 'templatemela-core' ),
			'default'      => webapp()->default( 'vertical_heading_icon_color' ),
			'live_method'     => array(
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header .base-svg-iconset',
					'property' => 'color',
					'pattern'  => '$',
					'key'      => 'color',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header:hover .base-svg-iconset',
					'property' => 'color',
					'pattern'  => '$',
					'key'      => 'hover',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header:focus .base-svg-iconset',
					'property' => 'color',
					'pattern'  => '$',
					'key'      => 'active',
				),
			),
			'input_attrs'  => array(
				'colors' => array(
					'color' => array(
						'tooltip' => __( 'Initial Color', 'templatemela-core' ),
						'palette' => true,
					),
					'hover' => array(
						'tooltip' => __( 'Hover Color', 'templatemela-core' ),
						'palette' => true,
					),
					'active' => array(
						'tooltip' => __( 'Active Color', 'templatemela-core' ),
						'palette' => true,
					),
				),
			),
		),

		'vertical_heading_icon_padding' => array(
			'control_type' => 'base_range_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Icon Padding', 'templatemela-core' ),
			'live_method'     => array(
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header .base-svg-iconset',
					'property' => 'padding',
					'pattern'  => '$',
					'key'      => 'size',
				),
			),
			'default'      => webapp()->default( 'vertical_heading_icon_padding' ),
			'input_attrs'  => array(
				'min'        => array(
					'px'  => 0,
					'em'  => 0,
					'rem' => 0,
					'vw'  => 0,
				),
				'max'        => array(
					'px'  => 100,
					'em'  => 12,
					'rem' => 12,
					'vw'  => 12,
				),
				'step'       => array(
					'px'  => 1,
					'em'  => 0.01,
					'rem' => 0.01,
					'vw'  => 0.01,
				),
				'units'      => array( 'px', 'em', 'rem', 'vw' ),
				'responsive' => true,
			),
		),

		'vertical_heading_icon_size' => array(
			'control_type' => 'base_range_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Icon/Image Size', 'templatemela-core' ),
			'live_method'     => array(
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-navigation-header .base-svg-iconset',
					'property' => 'font-size',
					'pattern'  => '$',
					'key'      => 'size',
				),
			),
			'default'      => webapp()->default( 'vertical_heading_icon_size' ),
			'input_attrs'  => array(
				'min'        => array(
					'px'  => 0,
					'em'  => 0,
					'rem' => 0,
				),
				'max'        => array(
					'px'  => 100,
					'em'  => 12,
					'rem' => 12,
				),
				'step'       => array(
					'px'  => 1,
					'em'  => 0.01,
					'rem' => 0.01,
				),
				'units'      => array( 'px', 'em', 'rem' ),
				'responsive' => true,
			),
		),

		'info_vertical_navigation_options' => array(
			'control_type' => 'base_title_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Navigation Options', 'templatemela-core' ),
			'settings'     => false,
		),
		'vertical_navigation_spacing' => array(
			'control_type' => 'base_range_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Items Spacing', 'templatemela-core' ),
			'live_method'     => array(
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-menu-container > ul > li.menu-item > a',
					'property' => 'padding-left',
					'pattern'  => 'calc($ / 2)',
					'key'      => 'size',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-menu-container > ul > li.menu-item > a',
					'property' => 'padding-right',
					'pattern'  => 'calc($ / 2)',
					'key'      => 'size',
				),
			),
			'default'      => webapp()->default( 'vertical_navigation_spacing' ),
			'input_attrs'  => array(
				'min'        => array(
					'px'  => 0,
					'em'  => 0,
					'rem' => 0,
					'vw'  => 0,
				),
				'max'        => array(
					'px'  => 100,
					'em'  => 12,
					'rem' => 12,
					'vw'  => 12,
				),
				'step'       => array(
					'px'  => 1,
					'em'  => 0.01,
					'rem' => 0.01,
					'vw'  => 0.01,
				),
				'units'      => array( 'px', 'em', 'rem', 'vw' ),
				'responsive' => false,
			),
		),
		'vertical_navigation_vertical_spacing' => array(
			'control_type' => 'base_range_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Items Top and Bottom Padding', 'templatemela-core' ),
			'live_method'     => array(
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-menu-container > ul > li.menu-item > a',
					'property' => 'padding-top',
					'pattern'  => '$',
					'key'      => 'size',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-menu-container > ul > li.menu-item > a',
					'property' => 'padding-bottom',
					'pattern'  => '$',
					'key'      => 'size',
				),
			),
			'default'      => webapp()->default( 'vertical_navigation_vertical_spacing' ),
			'input_attrs'  => array(
				'min'        => array(
					'px'  => 0,
					'em'  => 0,
					'rem' => 0,
					'vh'  => 0,
				),
				'max'        => array(
					'px'  => 100,
					'em'  => 12,
					'rem' => 12,
					'vh'  => 12,
				),
				'step'       => array(
					'px'  => 1,
					'em'  => 0.01,
					'rem' => 0.01,
					'vh'  => 0.01,
				),
				'units'      => array( 'px', 'em', 'rem', 'vh' ),
				'responsive' => false,
			),
		),
		'vertical_navigation_color' => array(
			'control_type' => 'base_color_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Navigation Colors', 'templatemela-core' ),
			'default'      => webapp()->default( 'vertical_navigation_color' ),
			'live_method'     => array(
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-menu-container > ul > li.menu-item > a',
					'property' => 'color',
					'pattern'  => '$',
					'key'      => 'color',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-menu-container > ul > li.menu-item > a:hover',
					'property' => 'color',
					'pattern'  => '$',
					'key'      => 'hover',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-menu-container > ul > li.menu-item.current-menu-item > a, .vertical-navigation .vertical-menu-container > ul > li.menu-item.current_page_item > a',
					'property' => 'color',
					'pattern'  => '$',
					'key'      => 'active',
				),
			),
			'input_attrs'  => array(
				'colors' => array(
					'color' => array(
						'tooltip' => __( 'Initial Color', 'templatemela-core' ),
						'palette' => true,
					),
					'hover' => array(
						'tooltip' => __( 'Hover Color', 'templatemela-core' ),
						'palette' => true,
					),
					'active' => array(
						'tooltip' => __( 'Active Color', 'templatemela-core' ),
						'palette' => true,
					),
				),
			),
		),
		'vertical_navigation_background' => array(
			'control_type' => 'base_color_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Navigation Background', 'templatemela-core' ),
			'default'      => webapp()->default( 'vertical_navigation_background' ),
			'live_method'     => array(
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-menu-container > ul > li.menu-item > a',
					'property' => 'background',
					'pattern'  => '$',
					'key'      => 'color',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-menu-container > ul > li.menu-item > a:hover',
					'property' => 'background',
					'pattern'  => '$',
					'key'      => 'hover',
				),
				array(
					'type'     => 'css',
					'selector' => '.vertical-navigation .vertical-menu-container > ul > li.current-menu-item > a, .vertical-navigation .vertical-menu-container > ul > li.menu-item.current_page_item > a',
					'property' => 'background',
					'pattern'  => '$',
					'key'      => 'active',
				),
			),
			'input_attrs'  => array(
				'colors' => array(
					'color' => array(
						'tooltip' => __( 'Initial Background', 'templatemela-core' ),
						'palette' => true,
					),
					'hover' => array(
						'tooltip' => __( 'Hover Background', 'templatemela-core' ),
						'palette' => true,
					),
					'active' => array(
						'tooltip' => __( 'Active Background', 'templatemela-core' ),
						'palette' => true,
					),
				),
			),
		),
		'vertical_navigation_border' => array(
			'control_type' => 'base_border_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Navigation Border', 'templatemela-core' ),
			'default'      => webapp()->default( 'vertical_navigation_border' ),
			'live_method'     => array(
				array(
					'type'     => 'css_border',
					'selector' => '.vertical-navigation .vertical-menu-container > ul.menu',
					'pattern'  => '$',
					'property' => 'border',
					'pattern'  => '$',
					'key'      => 'border',
				),
			),
			'input_attrs'  => array(
				'responsive' => false,
			),
		),

		'vertical_navigation_item_border' => array(
			'control_type' => 'base_border_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Navigation Item Border Bottom', 'templatemela-core' ),
			'default'      => webapp()->default( 'vertical_navigation_item_border' ),
			'live_method'     => array(
				array(
					'type'     => 'css_border',
					'selector' => '.vertical-navigation .vertical-menu-container > ul.menu > li.menu-item',
					'pattern'  => '$',
					'property' => 'border-bottom',
					'pattern'  => '$',
					'key'      => 'border',
				),
			),
			'input_attrs'  => array(
				'responsive' => false,
			),
		),
		'vertical_navigation_typography' => array(
			'control_type' => 'base_typography_control',
			'section'      => 'vertical_navigation_design',
			'label'        => esc_html__( 'Navigation Font', 'templatemela-core' ),
			'default'      => webapp()->default( 'vertical_navigation_typography' ),
			'live_method'     => array(
				array(
					'type'     => 'css_typography',
					'selector' => '.vertical-navigation .vertical-menu-container > ul > li.menu-item a',
					'pattern'  => array(
						'desktop' => '$',
						'tablet'  => '$',
						'mobile'  => '$',
					),
					'property' => 'font',
					'key'      => 'typography',
				),
			),
			'input_attrs'  => array(
				'id'      => 'vertical_navigation_typography',
				'options' => 'no-color',
			),
		),
		'info_vertical_submenu' => array(
			'control_type' => 'base_title_control',
			'section'      => 'vertical_navigation',
			'priority'     => 20,
			'label'        => esc_html__( 'Dropdown Options', 'templatemela-core' ),
			'settings'     => false,
		),
		'vertical_dropdown_link' => array(
			'control_type' => 'base_focus_button_control',
			'section'      => 'vertical_navigation',
			'settings'     => false,
			'priority'     => 20,
			'label'        => esc_html__( 'Dropdown Options', 'templatemela-core' ),
			'input_attrs'  => array(
				'section' => 'base_customizer_dropdown_navigation',
			),
		),
	)
);

