window.addEventListener('elementor/frontend/init', function () {

    elementorFrontend.hooks.addAction('frontend/element_ready/tmcore-products-tabs.default',
    async function ($scope) {

        const id = $scope[0]?.dataset?.id;

        const tabsWrapper = `[data-id="${id}"] .elementor-tabs-wrapper`;
        const tabsContentWrapper = `[data-id="${id}"] .elementor-tabs-content-wrapper`;
        
        let tabs = document.querySelector(tabsWrapper);
        let tabContents = document.querySelector(tabsContentWrapper);
        
        const tabButtons = tabs.querySelectorAll('[role="tab"]');
        const tabPanels = tabContents.querySelectorAll('[role="tabpanel"]');

        handleInit = (event) => {
            tabPanels.forEach((panel) => {
                panel.hidden = true;
            });
            const tabPanel = tabContents.querySelector(`[data-tab="1"]`);
            tabPanel.hidden = false;
            //tabActive.hidden = false;
        }
        // tabButtons.forEach((item, index) => console.log(item.innerHTML, item.id));
        handleTabClick = (event) => {
          //alert('init');
          
          // console.log(event.currentTarget);
          // hide all tab panels
          tabPanels.forEach((panel) => {
            panel.hidden = true;
          });
          // mark all tabs as unselected
          tabButtons.forEach((tab) => {
            // tab.ariaSelected = false;
            tab.setAttribute('aria-selected', false);
            tab.classList.remove("elementor-active");
            // event.currentTarget.setAttribute('aria-selected', true);
          });
          // mark the clicked tab as selected
          event.currentTarget.setAttribute('aria-selected', true);
          event.currentTarget.classList.add("elementor-active");
          // find the assoicated tab panl and show it
          // const id = event.currentTarget.id;
          // destructure
          const { id } = event.currentTarget;
          const tabPanel = tabContents.querySelector(`[aria-labelledby="${id}"]`);
          // console.log('tabPanel:', tabPanel);
          tabPanel.hidden = false;
        };
        tabButtons.forEach((button) =>
          button.addEventListener('click', handleTabClick)
        );
    
        this.handleInit();

        const selector = `[data-id="${id}"] .splide`; // Make a string selector from the Elementor IDn
        const listWrapSelector = `[data-id="${id}"] .splide ul.products`;
        const listSelector = `[data-id="${id}"] .splide ul.products li`;

        let wooSlider = document.querySelectorAll(selector);

        if (typeof(wooSlider) != 'undefined' && wooSlider != null ) {

            const wooSliderListWrap = document.querySelectorAll(listWrapSelector);
            wooSliderListWrap.forEach(function(slidelist, index) {
                slidelist.classList.remove("grid-cols");
                slidelist.classList.add("splide__list");
            });

            const list = document.querySelectorAll(listSelector);
            list.forEach(function(slideli, index) {
                slideli.classList.add("splide__slide");
            });


            let sliderSettings = '';
            let scrollIsOne = 1;
            //let sliderAnimSpeed = 400;
            let sliderArrows = true;
            let sliderDots = true;
            let sliderDirection = "ltr";
            let isLoopOrSlide = 'slide';

            if (document.querySelector('html[dir="rtl"]')) {
                sliderDirection = "rtl";
            } else {
                sliderDirection = "ltr";
            }

            if (typeof(tabContents.dataset.settings) != 'undefined' && tabContents.dataset.settings != null ) {
                sliderSettings = JSON.parse(tabContents.dataset.settings);
            }

            if (typeof(sliderSettings) != 'undefined' && sliderSettings != null ) {

                if ( sliderSettings['loop'] == true ) {
                    isLoopOrSlide = 'loop';
                } else {
                    isLoopOrSlide = 'slide';
                }

                if (sliderSettings['navigation'] == 'both') {
                    sliderArrows = true;
                    sliderDots = true;
                } else if (sliderSettings['navigation'] == 'arrows') {
                    sliderArrows = true;
                    sliderDots = false;
                } else if (sliderSettings['navigation'] == 'dots') {
                    sliderArrows = false;
                    sliderDots = true;
                } else {
                    sliderArrows = false;
                    sliderDots = false;
                }

                wooSlider.forEach(function(allSliders, index) {
                    //slidelist.classList.add("splide__slide");
                    allSliders.classList.remove("grid-cols");
                // allSliders.classList.add("splide__list");
        
                    var splideCarousel = new Splide( allSliders, {
                        autoplay: sliderSettings['autoplay'] || false,
                        type   : isLoopOrSlide,
                        perPage: sliderSettings['items'] || 4,
                        perMove: 1,
                        interval: sliderSettings['autoplayTimeout'] || 7000,
                        speed: sliderSettings['autoplay_speed'] || 400,
                        arrows: sliderArrows || false,
                        pagination: sliderDots || false,
                        direction: sliderDirection,
                        pauseOnHover: sliderSettings['autoplayHoverPause'] || false,
                        drag: true,
                        rewind: false,
                        rewindByDrag: false,
                        //focus  : 0,
                        //omitEnd: true,
                        gap: sliderSettings['gap'],
                        grid: {
                            dimensions: [ [ sliderSettings['dimensions'] || 1 , 1 ] ],  //rows and cols
                            gap: {
                                row: sliderSettings['gap'],
                                col: sliderSettings['gap'],
                            }
                        },
                        breakpoints: {
                            540: {
                                perPage: 2,
                                perMove: scrollIsOne || 2,
                                //focus  : 0,
                                //omitEnd: true,
                            },
                            767: {
                                perPage: sliderSettings['items_mobile'] || 3,
                                perMove: scrollIsOne || sliderSettings['items_mobile'],
                                gap: sliderSettings['gap_mobile'],
                                //focus  : 0,
                                //omitEnd: true,
                                grid: {
                                    gap: {
                                        row: sliderSettings['gap_mobile'],
                                        col: sliderSettings['gap_mobile'],
                                    }
                                },
                            },
                            1024: {
                                perPage: sliderSettings['items_tablet'] || 3,
                                perMove: scrollIsOne || sliderSettings['items_tablet'],
                                gap: sliderSettings['gap_tablet'],
                                //focus  : 0,
                                //omitEnd: true,
                                grid: {
                                    gap: {
                                        row: sliderSettings['gap_tablet'],
                                        col: sliderSettings['gap_tablet'],
                                    }
                                },
                            },
                            1366: {
                                perPage: sliderSettings['items_laptop'] || 3,
                                perMove: scrollIsOne || sliderSettings['items_laptop'],
                                gap: sliderSettings['gap_laptop'],
                                //focus  : 0,
                                //omitEnd: true,
                                grid: {
                                    gap: {
                                        row: sliderSettings['gap_laptop'],
                                        col: sliderSettings['gap_laptop'],
                                    }
                                },
                            },
                        },
                    } );

                    if(sliderSettings['dimensions'] > 1){
                        splideCarousel.mount( window.splide.Extensions );
                    } else {
                        splideCarousel.mount();
                    }

                });

            } // end sliderSettings

        }

    });

});
