<?php
/**
 * Build Admin Page with settings.
 *
 * @package Base
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Build Admin Page class
 *
 * @category class
 */
class Base_Theme_Admin_Settings {

	/**
	 * Settings of this class
	 *
	 * @var array
	 */
	public static $settings = array();

	/**
	 * Instance of this class
	 *
	 * @var null
	 */
	private static $instance = null;
	/**
	 * Static var active plugins
	 *
	 * @var $active_plugins
	 */
	private static $active_plugins;

	/**
	 * This file
	 *
	 * @var string
	 */
	private $file = '';

	/**
	 * Instance Control
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	/**
	 * Class Constructor.
	 */
	public function __construct() {

		$this->file = __FILE__;

		add_action( 'admin_menu', array( $this, 'add_menu' ) );

		add_action( 'admin_enqueue_scripts', array( $this, 'scripts' ) );

		// Load the TGM Config.
		require_once dirname( $this->file ) . '/tgmpa/tgmpa-config.php';

		if ( defined( 'TMTHEME_NAME' ) ) {
			require_once dirname( $this->file ) . '/setup/vendor/autoload.php';
			require_once dirname( $this->file ) . '/setup/class-setup.php';
			require_once dirname( $this->file ) . '/setup/setup-config.php';
		}

	}

	/**
	 * Add option page menu
	 */
	public function add_menu() {

		add_menu_page(
			__( 'TemplateMela Core - Dashboard', 'templatemela-core' ),
			__( 'TemplateMela', 'templatemela-core' ),
			$this->settings_user_capabilities(),
			'templatemela',
			null,
			$this->get_icon_svg(),
			30
		);
		
		$page = add_submenu_page(
			'templatemela',
			__( 'TemplateMela - Dashboard', 'templatemela-core' ),
			__( 'Dashboard' ),
			$this->settings_user_capabilities(),
			'templatemela',
			array( $this, 'config_page' )
		);
				
	}


	/**
	 * Returns a base64 URL for the SVG for use in the menu.
	 *
	 * @param  bool $base64 Whether or not to return base64-encoded SVG.
	 * @return string
	 */
	private function get_icon_svg( $base64 = true ) {
		$svg = '<svg version="1.0" xmlns="http://www.w3.org/2000/svg" width="20.000000pt" height="20.000000pt" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet"><g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="#9ca2a7" stroke="none"><path d="M1425 4873 c-59 -13 -91 -29 -127 -61 -110 -99 -113 -252 -8 -354 28 -27 65 -51 87 -57 26 -8 475 -11 1416 -11 l1377 0 0 -323 c0 -315 -1 -324 -22 -367 -45 -87 -33 -84 -426 -91 -267 -4 -359 -9 -397 -21 -220 -66 -378 -219 -451 -438 -18 -52 -19 -119 -24 -1135 l-5 -1080 -27 -50 c-113 -212 -393 -212 -506 0 l-27 50 -5 1080 c-5 1016 -6 1083 -24 1135 -73 219 -231 372 -451 438 -38 12 -130 17 -397 21 -393 7 -381 4 -426 92 l-22 44 2 455 c2 438 1 457 -18 500 -23 50 -71 103 -116 126 -44 23 -121 29 -175 13 -65 -18 -146 -97 -164 -159 -10 -34 -13 -164 -14 -530 l0 -485 26 -82 c35 -111 80 -184 170 -274 59 -59 95 -86 160 -117 131 -64 190 -72 540 -72 337 0 349 -2 395 -69 l24 -36 0 -1012 c0 -671 4 -1038 11 -1089 26 -188 89 -314 224 -449 102 -102 168 -145 287 -186 169 -58 337 -58 506 0 119 41 185 84 287 186 135 135 198 261 224 449 7 51 11 418 11 1088 0 1009 0 1011 21 1045 12 18 38 42 60 53 36 19 60 20 346 20 274 0 317 2 392 20 121 29 212 80 301 170 89 89 134 163 169 273 l25 82 1 505 c0 403 -3 513 -14 544 -18 53 -77 115 -131 140 -45 21 -46 21 -1555 22 -830 1 -1519 0 -1530 -3z"/></g></svg> ';

		if ( $base64 ) {
			return 'data:image/svg+xml;base64,' . base64_encode( $svg );
		}

		return $svg;
	}
	/**
	 * Allow settings visibility to be changed.
	 */
	public function settings_user_capabilities() {
		$cap = apply_filters( 'templatemela_admin_settings_capability', 'manage_options' );
		return $cap;
	}

	/**
	 * Link to Install Plugins
	 */
	public function null_page() {
		return null;
	}

	/**
	 * Admin Required.
	 */
	public function theme_admin_required() {
	}

	/**
	 * Loads admin style sheets and scripts
	 */
	public function scripts() {
		wp_enqueue_style( 'templatemela-admin-dashboard', TMCORE_URL . 'admin/assets/css/admin.css', array(), TMCORE_VERSION );
		wp_enqueue_style( 'base-dashboard', get_template_directory_uri() . '/inc/dashboard/react/dash-controls.min.css', array( 'wp-components' ), TMCORE_VERSION );
		//wp_enqueue_script( 'base-admin-js', TMCORE_URL . '/admin/assets/js/admin.js', array( 'jquery-core' ), TMCORE_VERSION );
	}

	/**
	 * Loads config page
	 */
	public function config_page() {
		?>
	
		<div class="base_theme_dash_head">
			<div class="base_theme_dash_head_container">
				<div class="base_theme_dash_logo">
					<img src="<?php echo esc_attr( TMCORE_URL . 'admin/assets/images/templatemela-icon.png' ); ?>">
				</div>
				<div class="base_theme_dash_version">
					<span>
						<strong><?php echo esc_html( TMCORE_NAME );?></strong>
						<?php echo esc_html( TMCORE_VERSION ); ?>
					</span>
				</div>
			</div>
		</div>
		<div class="wrap base_theme_dash">
			<div class="base_theme_dashboard">
				<h2 class="notices" style="display:none;"></h2>
				<?php settings_errors(); ?>
				<div class="page-grid">
					<div class="base_theme_dashboard_main">
						<?php do_action( 'base_theme_dash_section_top' ); ?>
						<div class="dashboard-section tab-section components-panel">
							<div class="components-panel__body is-opened">
								<div class="tmc-dashboard-head">
								<?php if ( defined( 'TMTHEME_NAME' ) ) { ?>
									<h2>
									<span class="title"><strong><?php echo esc_html( TMTHEME_NAME );?></strong></span>
									<span class="version">( <?php echo esc_html( TMTHEME_VERSION ); ?> )</span>
									</h2>
								<?php } ?>
								</div>
								<div class="tmc-dashboard-contents">
									<?php do_action( 'tmc_dashboard_contents_left' ); ?>
									<?php do_action( 'tmc_dashboard_contents_right' ); ?>
								</div>
							</div>
						</div>
						<?php do_action( 'base_theme_dash_section_bottom' ); ?>
					</div>
					<div class="side-panel">
						<?php do_action( 'base_theme_dash_side_panel' ); ?>
						<!-- <div class="support-section sidebar-section components-panel">
							<div class="components-panel__body is-opened">
								<h2><?php //esc_html_e( 'Video Tutorials', 'templatemela-core' ); ?></h2>
								<p><?php //esc_html_e( 'Want a guide? We have video tutorials to walk you through getting started.', 'templatemela-core' ); ?></p>
								<a href="https://templatemela.com/video-tutorials" target="_blank" class="sidebar-link"><?php //esc_html_e( 'Watch Videos', 'templatemela-core' ); ?></a>
							</div>
						</div> -->
						<div class="support-section sidebar-section components-panel">
							<div class="components-panel__body is-opened">
								<h2><?php esc_html_e( 'Documentation', 'templatemela-core' ); ?></h2>
								<p><?php esc_html_e( 'Want to customize theme? We have a knowledge base full of articles to get you started with customization.', 'templatemela-core' ); ?></p>
								<a href="https://templatemela.com/documentation/wordpress/" target="_blank" class="sidebar-link"><?php esc_html_e( 'Browse Docs', 'templatemela-core' ); ?></a>
							</div>
						</div>
						<!-- <div class="support-section sidebar-section components-panel">
							<div class="components-panel__body is-opened">
								<h2><?php //esc_html_e( 'Support', 'templatemela-core' ); ?></h2>
								<p><?php //esc_html_e( 'Have a question, we are happy to help! Get in touch with our support team.', 'templatemela-core' ); ?></p>
								<a href="https://templatemela.com/support" target="_blank" class="sidebar-link"><?php //esc_html_e( 'Submit a Ticket', 'templatemela-core' ); ?></a>
							</div>
						</div> -->
					</div>
				</div>
			</div>
		</div>
		<?php
	}

}
Base_Theme_Admin_Settings::get_instance();
