<?php
/**
 * Plugin Name:  TemplateMela Core - Plugin for the TemplateMela Theme
 * Plugin URI:   #
 * Description:  This is core plugin required by the TemplateMela Theme for the core features.
 * Version:      3.2.0
 * Author:       TemplateMela
 * Author URI:   #
 * License:      GPL2
 * License URI:  https://www.gnu.org/licenses/gpl-2.0.html
 * Domain Path:  /languages
 * Text Domain:  templatemela-core
 * Requires PHP: 7.4
 *
 * @package TemplateMela Core
 */

// Block direct access to the main plugin file.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Plugin Version.
if ( ! defined( 'TMCORE_VERSION' ) ) {
	define( 'TMCORE_VERSION', '3.2.0' );
}

// Plugin Name.
if ( ! defined( 'TMCORE_NAME' ) ) {
	define( 'TMCORE_NAME', 'TemplateMela Core' );
}

// Plugin Slug.
if ( ! defined( 'TMCORE_SLUG' ) ) {
	define( 'TMCORE_SLUG', 'templatemela-core' );
}

// The main plugin file path.
if ( ! defined( 'TMCORE_PLUGIN_FILE' ) ) {
	define( 'TMCORE_PLUGIN_FILE', __FILE__ );
}

// Plugin Folder Path.
if ( ! defined( 'TMCORE_PATH' ) ) {
	define( 'TMCORE_PATH', wp_normalize_path( dirname( __FILE__ ) ) . DIRECTORY_SEPARATOR );
}

// Plugin Folder URL.
if ( ! defined( 'TMCORE_URL' ) ) {
	define( 'TMCORE_URL', plugin_dir_url( __FILE__ ) );
}

// Plugin Folder Path.
if ( ! defined( 'TMCORE_WOO_PATH' ) ) {
	define( 'TMCORE_WOO_PATH', wp_normalize_path( dirname( __FILE__ ) ) . DIRECTORY_SEPARATOR . 'includes' . DIRECTORY_SEPARATOR .'woocommerce' . DIRECTORY_SEPARATOR );
}

// Plugin Folder URL.
if ( ! defined( 'TMCORE_WOO_URL' ) ) {
	define( 'TMCORE_WOO_URL', plugin_dir_url( __FILE__ ) . 'includes/woocommerce/' );
}

// Minimum PHP version required.
if ( ! defined( 'TMCORE_MIN_PHP_VER_REQUIRED' ) ) {
	define( 'TMCORE_MIN_PHP_VER_REQUIRED', '7.4' );
}

// Minimum WP version required.
if ( ! defined( 'TMCORE_MIN_WP_VER_REQUIRED' ) ) {
	define( 'TMCORE_MIN_WP_VER_REQUIRED', '6.0' );
}

if ( ! function_exists('templatemela_check_required_theme') ) {

	function templatemela_check_required_theme() {
		$is_theme_exists = false;
		$current_theme = wp_get_theme();
		if ( get_template_directory() !== get_stylesheet_directory() ) {
			$is_theme_exists = ( 'avanam' === $current_theme->get( 'Template' ) ? true : false );
		} else {
			$is_theme_exists = ( 'Avanam' === $current_theme->get( 'Name' ) ? true : false );
		}
		return $is_theme_exists;
	}

}

/**
 * Compatibility check.
 *
 * Check that the site meets the minimum requirements for the plugin before proceeding.
 *
 * @since 1.0.0
 */
if ( version_compare( $GLOBALS['wp_version'], TMCORE_MIN_WP_VER_REQUIRED, '<' ) || version_compare( PHP_VERSION, TMCORE_MIN_PHP_VER_REQUIRED, '<' ) ) {
	require_once TMCORE_PATH . 'includes/bootstrap-compat.php';
	return;
}

if ( false == templatemela_check_required_theme() ) {
	require_once TMCORE_PATH . 'includes/bootstrap-compat.php';
}

/**
 * Bootstrap the plugin.
 *
 * @since 1.0.0
 */
require_once TMCORE_PATH . 'includes/bootstrap.php';
