<?php
/**
 * Display product reviews
 *
 * @package Base Woo Extras
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


global $product, $bt_reviews, $bt_woo_extras;

$review_stats = $bt_reviews->bt_review_stats( $product );
$average      = $bt_reviews->bt_get_average_rating( $product->get_id(), 2 );
?>

<div id="bt-reviews-overview">
	<div class="bt_reviews_stats_total">
		<h3><b style="<?php echo ( isset( $bt_woo_extras['bt_review_overview_highlight'] ) ? 'color:' . esc_attr( $bt_woo_extras['bt_review_overview_highlight'] ) . ';' : '' ); ?>"><?php echo esc_html( $average ); ?></b> <?php echo esc_html__( 'out of 5 stars', 'templatemela-core' ); ?></h3>
	</div>
	<div class="bt_review_stats_bars" style="<?php echo ( isset( $bt_woo_extras['bt_review_overview_highlight'] ) ? 'color:' . esc_attr( $bt_woo_extras['bt_review_overview_highlight'] ) . ';' : '' ); ?>">
		<?php
		for ( $i = 5; $i >= 1; $i-- ) :
			$perc = ( '0' == $review_stats['total'] ) ? 0 : floor( $review_stats[ $i ] / $review_stats['total'] * 100 );
			?>
			<div class="bt_rating_bar_row">
				<div class="bt_stars_value">
					<?php echo esc_html( $i ); ?>
					<i class="bt-reviews-icon-star-full"></i>
				</div>
				<div class="bt_rating_bar">
					<span class="bt_rating_bar_bg">
						<span class="bt_perc_rating" style="width:<?php echo esc_attr( $perc ); ?>%; <?php echo ( isset( $bt_woo_extras['bt_review_overview_highlight'] ) ? 'background-color:' . esc_attr( $bt_woo_extras['bt_review_overview_highlight'] ) . ';' : '' ); ?>">
						</span>
					</span>
				</div>
				<div class="bt_review_single_count">
					<?php echo esc_html( $review_stats[ $i ] ); ?>
				</div>
			</div>
			<?php
		endfor;
		?>
		</div>
</div>
