/* Global baseSettingsParams */
/**
 * WordPress dependencies
 */
import SettingsPanel from './settings';
import ChangelogTab from './changelog';
import StartedTab from './started';
import DashTab from './dash';
import baseTryParseJSON from './components/common/try-parse';
const { __, sprintf } = wp.i18n;
const {
	localStorage,
} = window;
import { Fragment, Component } from '@wordpress/element';
const { TabPanel, Panel, PanelBody, PanelRow, Button, Spinner } = wp.components;
 class InfoPanel extends Component {
	constructor() {
		super( ...arguments );
	}
	render() {
		const { panel, sections } = this.props;
		const subTabs = [];
		{ Object.keys( sections ).map( function( key, index ) {
			subTabs.push( {
				name: sections[ key ].id,
				title: sections[ key ].title,
				className: 'base-sections-tab-' + sections[ key ].id,
			} );
		} ) }
		const activePanel = baseTryParseJSON( localStorage.getItem( 'baseSettingsPanel' ) );
		const onTabSelect = ( tabName ) => {
			const activeTab = activePanel;
			activeTab[baseSettingsParams.opt_name] = tabName;
			localStorage.setItem( 'baseSettingsPanel', JSON.stringify( activeTab ) );
		};
		const BaseSettingsPanel = () => (
			<Fragment>
				{ 1 < subTabs.length ?
					<TabPanel
						className="base-settings-dashboard-section-tabs"
						activeClass="active-tab"
						orientation="vertical"
						initialTabName={ activePanel && activePanel[baseSettingsParams.opt_name] ? activePanel[baseSettingsParams.opt_name] : undefined }
						onSelect={ onTabSelect }
						tabs={ subTabs }
					>
						{
							( tab ) => {
								return (
									<Panel className="dashboard-section sub-tab-section">
										<PanelBody
											opened={ true }
										>
											<div className="dashboard-modules-wrapper">
												<SettingsPanel section={ sections[ tab.name ] } saveSettings={ () => this.props.saveSettings() } />
											</div>
										</PanelBody>
									</Panel>
								);
							}
						}
					</TabPanel>
				:
					<Panel className="dashboard-section sub-tab-section">
						<PanelBody
							opened={ true }
						>
							<div className="dashboard-modules-wrapper">
								<SettingsPanel section={ sections[Object.keys(sections)[0]] } saveSettings={ () => this.props.saveSettings() } />
							</div>
						</PanelBody>
					</Panel>
				}
			</Fragment>
		);
		 return (
			 <Fragment>
				{ 'settings' === panel &&  (
					<BaseSettingsPanel />
				) }
				{ 'changelog' === panel &&  (
					<ChangelogTab />
				) }
				{ 'started' === panel &&  (
					<StartedTab />
				) }
				{ 'dash' === panel &&  (
					<DashTab />
				) }
			 </Fragment>
		 );
	 }
 }

 export default InfoPanel;