/**
 * WordPress dependencies
 */
 const { __ } = wp.i18n;
 const { Fragment } = wp.element;
 const { withFilters } = wp.components;
 const { TabPanel, Panel, PanelBody } = wp.components;
 
 import baseTryParseJSON from './components/common/try-parse';
 export const DashTab = () => {
	const dash = ( baseSettingsParams.dash ? baseTryParseJSON( baseSettingsParams.dash ) : {} );
	 return (
		<Fragment>
			{ dash && (
				<div className="base-desk-help-inner">
					{ dash.title && (
						<h2>{ dash.title }</h2>
					) }
					{ dash.description && (
						<p>{ dash.description }</p>
					) }
					{ dash.video_url && (
						<div className="video-container">
							<iframe width="560" height="315" src={ dash.video_url } frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"></iframe>
						</div>
					) }
					{ dash.link_url && dash.link_text && (
						<a href={ dash.link_url } className="base-desk-button base-desk-button-second" target="_blank">{ dash.link_text }</a>
					) }
				</div>
			) }
		</Fragment>
	);
};
 
 export default withFilters( 'base_settings_dash' )( DashTab );