<?php
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'TemplateMelaCore_WP_Widget_Linked_Products' ) ) {
	class TemplateMelaCore_WP_Widget_Products extends TemplateMelaCore_Widget {

		public function __construct() {
			$this->widget_id          = 'tmcore-wp-widget-products';
			$this->widget_cssclass    = 'tmcore-wp-widget-products';
			$this->widget_name        = sprintf( '%1$s %2$s', '[TMCore]', esc_html__( 'Products', 'templatemela-core' ) );
			$this->widget_description = esc_html__( 'A list of your store\'s products.', 'templatemela-core' );
			$this->settings           = array(
				'title'        => array(
					'type'  => 'text',
					'std'   => esc_html__( 'Products', 'templatemela-core' ),
					'label' => esc_html__( 'Title', 'templatemela-core' ),
				),
				'number'       => array(
					'type'  => 'number',
					'step'  => 1,
					'min'   => 1,
					'max'   => '',
					'std'   => 5,
					'label' => esc_html__( 'Number of products to show', 'templatemela-core' ),
				),
				'source'       => array(
					'type'    => 'select',
					'std'     => '',
					'label'   => esc_html__( 'Show', 'templatemela-core' ),
					'options' => [
						'latest'       => esc_html__( 'Latest Products', 'templatemela-core' ),
						'featured'     => esc_html__( 'Featured Products', 'templatemela-core' ),
						'on_sale'      => esc_html__( 'On-sale Products', 'templatemela-core' ),
						'best_selling' => esc_html__( 'Best Selling Products', 'templatemela-core' ),
						'top_rated'    => esc_html__( 'Top Rated Products', 'templatemela-core' ),
					],
				),
				'style'        => array(
					'type'    => 'select',
					'std'     => '',
					'label'   => esc_html__( 'Style', 'templatemela-core' ),
					'options' => [
						''              => esc_html__( 'Default', 'templatemela-core' ),
						'boxed'         => esc_html__( 'Boxed', 'templatemela-core' ),
						'big-thumbnail' => esc_html__( 'Big Thumbnail', 'templatemela-core' ),
					],
				),
				'show_rating'  => array(
					'type'  => 'checkbox',
					'label' => esc_html__( 'Show Rating ?', 'templatemela-core' ),
					'std'   => 1,
				),
				/* 'show_buttons' => array(
					'type'  => 'checkbox',
					'label' => esc_html__( 'Show Add to cart?', 'templatemela-core' ),
					'std'   => 1,
				), */
			);

			parent::__construct();
		}

		/**
		 * Output widget.
		 *
		 * @param array $args     Arguments.
		 * @param array $instance Widget instance.
		 *
		 * @see WP_Widget
		 */
		public function widget( $args, $instance ) {
			/**
			 * @var WP_Query $products
			 */
			$products = $this->get_products( $args, $instance );

			if ( $products->have_posts() ) {
				$this->widget_start( $args, $instance );

				$show_rating  = $this->get_value( $instance, 'show_rating' );
				$show_buttons = $this->get_value( $instance, 'show_buttons' );
				$style        = $this->get_value( $instance, 'style' );

				$list_classes = 'product_list_widget';

				if ( ! empty( $style ) ) {
					$list_classes .= ' style-' . $style;
				}

				echo wp_kses_post( apply_filters( 'woocommerce_before_widget_product_list', '<div class="woocommerce"><ul class="' . esc_attr( $list_classes ) . '">' ) );

				$template_args = array(
					'widget_id'    => isset( $args['widget_id'] ) ? $args['widget_id'] : $this->widget_id,
					'show_rating'  => $show_rating,
					'show_buttons' => $show_buttons,
					'style'        => $style,
				);

				while ( $products->have_posts() ) : $products->the_post();
					//wc_get_template( 'custom/content-widget-product.php', $template_args );
					$this->locate_output_template( 'content-widget-product.php', $template_args );
				endwhile;
				wp_reset_postdata();

				echo wp_kses_post( apply_filters( 'woocommerce_after_widget_product_list', '</ul></div>' ) );

				$this->widget_end( $args, $instance );
			}
		}

		/**
		 * Output template.
		 *
		 * @param string $template_name the name of the template.
		 */
		public function locate_output_template( $template_name, $template_args ) {
			$template_path = 'templatemela/';
			$default_path  = TMCORE_PATH . '/includes/templates/';

			// Look within passed path within the theme - this is priority.
			$template = locate_template(
				array(
					trailingslashit( $template_path ) . $template_name,
					$template_name,
				)
			);
			// Get default template/.
			if ( ! $template ) {
				$template = $default_path . $template_name;
			}

			// Allow 3rd party plugin filter template file from their plugin.
			$filter_template = apply_filters( 'templatemela_get_template', $template, $template_name, $template_path, $default_path );

			if ( $filter_template !== $template ) {
				if ( ! file_exists( $filter_template ) ) {
					return;
				}
				$template = $filter_template;
			}

			include $template;
		}

		public function get_products( $args, $instance ) {
			global $product;

			$source = $this->get_value( $instance, 'source' );
			$limit  = $this->get_value( $instance, 'number' );

			$query_args = [
				'post_type'      => 'product',
				'posts_per_page' => $limit,
				'post_status'    => 'publish',
			];

			switch ( $source ) {
				case 'best_selling': // Woocommerce best selling items.
					$query_args['meta_key'] = 'total_sales';
					$query_args['orderby']  = 'meta_value_num';
					$query_args['order']    = 'DESC';
					break;
				case 'featured': // Woocommerce featured items.
					$query_args['tax_query'][] = [
						'taxonomy'         => 'product_visibility',
						'terms'            => 'featured',
						'field'            => 'name',
						'operator'         => 'IN',
						'include_children' => false,
					];
					break;
				case 'on_sale': // Woocommerce best selling items.
					$query_args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
					break;
				case 'top_rated': // Woocommerce top rated items.
					$query_args['meta_key'] = '_wc_average_rating';
					$query_args['orderby']  = 'meta_value_num';
					$query_args['order']    = 'DESC';
					break;
				default:
					$query_args['orderby'] = 'date';
					$query_args['order']   = 'DESC';
					break;
			}

			$products = new WP_Query( $query_args );

			return $products;
		}
	}
}
