<?php

/**
 * Elementor functions.
 *
 * @since 1.0.0
 * @package TemplateMela Core
 */

 use function Base\webapp;

 if (!defined('ABSPATH')) {
	 exit;
 } 
 

/**
  * Check Elementor data type
  *
  * @access public
  * @since 1.0.0
  */
 if ( ! function_exists( 'tmcore_elementor_check_type' ) ) {
	 function tmcore_elementor_check_type( $type = '' ) {
		 if ( $type ) {
			 $data = get_post_meta( get_the_ID(), '_elementor_data', true );
			 if ( $data ) {
				 return preg_match( '/' . $type . '/', $data );
			 }
		 }
 
		 return false;
	 }
}


if ( ! function_exists( 'tmcore_elementor_get_strftime' ) ) {
	function tmcore_elementor_get_strftime( $instance, $obj ) {
		$string = '';
		if ( $instance['show_days'] ) {
			$string .= $obj->render_countdown_item( $instance, 'label_days', 'elementor-countdown-days' );
		}
		if ( $instance['show_hours'] ) {
			$string .= $obj->render_countdown_item( $instance, 'label_hours', 'elementor-countdown-hours' );
		}
		if ( $instance['show_minutes'] ) {
			$string .= $obj->render_countdown_item( $instance, 'label_minutes', 'elementor-countdown-minutes' );
		}
		if ( $instance['show_seconds'] ) {
			$string .= $obj->render_countdown_item( $instance, 'label_seconds', 'elementor-countdown-seconds' );
		}

		return $string;
	}
}


if ( ! function_exists( 'tmcore_elementor_get_render_attribute_string' ) ) {
	function tmcore_elementor_get_render_attribute_string($element, $obj) {
		return $obj->get_render_attribute_string($element);
	}
}
if ( ! function_exists( 'tmcore_elementor_parse_text_editor' ) ) {
	function tmcore_elementor_parse_text_editor( $content, $obj ) {
		$content = apply_filters( 'widget_text', $content, $obj->get_settings() );

		$content = shortcode_unautop( $content );
		$content = do_shortcode( $content );
		$content = wptexturize( $content );

		if ( $GLOBALS['wp_embed'] instanceof \WP_Embed ) {
			$content = $GLOBALS['wp_embed']->autoembed( $content );
		}

		return $content;
	}
}



/**
 * Get the product thumbnail, or the placeholder if not set.
 *
 * @param string $size (default: 'woocommerce_thumbnail').
 * @param  array $attr Image attributes.
 * @param  bool  $placeholder True to return $placeholder if no image is found, or false to return an empty string.
 * @return string
 */
function tmcore_ele_woocommerce_get_product_thumbnail() {
    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	echo woocommerce_get_product_thumbnail();
}

/**
 * Get the product price for the loop.
 */
function tmcore_ele_woocommerce_template_loop_price() {
    wc_get_template( 'loop/price.php' );
}

/**
 * Get the add to cart template for the loop.
 *
 * @param array $args Arguments.
 */
function tmcore_ele_woocommerce_template_loop_add_to_cart( $args = array() ) {
    global $product;

    if ( $product ) {
        $defaults = array(
            'quantity'   => 1,
            'class'      => implode(
                ' ',
                array_filter(
                    array(
                        'button',
                        wc_wp_theme_get_element_class_name( 'button' ), // escaped in the template.
                        'product_type_' . $product->get_type(),
                        $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                        $product->supports( 'ajax_add_to_cart' ) && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
                    )
                )
            ),
            'attributes' => array(
                'data-product_id'  => $product->get_id(),
                'data-product_sku' => $product->get_sku(),
                'aria-label'       => $product->add_to_cart_description(),
                'rel'              => 'nofollow',
            ),
        );

        $args = apply_filters( 'woocommerce_loop_add_to_cart_args', wp_parse_args( $args, $defaults ), $product );

        if ( isset( $args['attributes']['aria-label'] ) ) {
            $args['attributes']['aria-label'] = wp_strip_all_tags( $args['attributes']['aria-label'] );
        }

        wc_get_template( 'loop/add-to-cart.php', $args );
    }
}